<?php
/*
Plugin Name: DiviSumo (Lite)
Plugin URI:  https://divisumo.com/
Description:  Ultimate Divi Toolkit
Version:     1.0.0
Author:      munirkamal
Author URI:  http://www.cakewp.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: cwp-ds
Domain Path: /languages

DiviSumo-lite is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
any later version.

DiviSumo-lite is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DiviSumo-lite. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
*/

if(!function_exists('et_pb_generate_responsive_css_custom')){
	function et_pb_generate_responsive_css_custom( $values_array, $css_selector, $css_property, $function_name, $additional_css = '' ) {
	if ( ! empty( $values_array ) ) {
		foreach( $values_array as $device => $current_value ) {
			if ( '' === $current_value ) {
				continue;
			}
  
			$declaration = '';
  
			// value can be provided as a string or array in following format - array( 'property_1' => 'value_1', 'property_2' => 'property_2', ... , 'property_n' => 'value_n' )
			if ( is_array( $current_value ) && ! empty( $current_value ) ) {
				foreach( $current_value as $this_property => $this_value ) {
					if ( '' === $this_value ) {
						continue;
					}
  
					$declaration .= sprintf(
						'%1$s: %2$s%3$s',
						$this_property,
						esc_html(  $this_value  ),
						'' !== $additional_css ? $additional_css : ';'
					);
				}
			} else {
				$declaration = sprintf(
					'%1$s: %2$s%3$s',
					$css_property,
					esc_html(  $current_value  ),
					'' !== $additional_css ? $additional_css : ';'
				);
			}
  
			if ( '' === $declaration ) {
				continue;
			}
  
			$style = array(
				'selector'    => $css_selector,
				'declaration' => $declaration,
			);
  
			if ( 'desktop_only' === $device ) {
				$style['media_query'] = ET_Builder_Element::get_media_query( 'min_width_981' );
			} elseif ( 'desktop' !== $device ) {
				$current_media_query = 'tablet' === $device ? 'max_width_980' : 'max_width_767';
				$style['media_query'] = ET_Builder_Element::get_media_query( $current_media_query );
			}
  
			ET_Builder_Element::set_style( $function_name, $style );
		}
	}
  }
  }


if ( ! function_exists( 'cwp_sumo_lite_initialize_extension' ) ):
/**
 * Creates the extension's main class instance.
 *
 * @since 1.0.0
 */
function cwp_sumo_lite_initialize_extension() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/Sumo.php';
}
add_action( 'divi_extensions_init', 'cwp_sumo_lite_initialize_extension' );
endif;



// Check if premium plugin is activated then automatically lite versition deactivate
if (!function_exists('activate_plugin')) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';	
}

if ( is_plugin_active( 'cwp-divi-sumo/divi-sumo.php' ) ):
	deactivate_plugins('divi-sumo-lite/divi-sumo-lite.php');
endif;

