/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-11-29 12:51:54 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=306 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=3908 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_auto_updates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `onoroff` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `wp_et_social_stats` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `sharing_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `network` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `media_url` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=7883 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2557 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=823 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int unsigned DEFAULT NULL,
  `orig_size` int unsigned DEFAULT NULL,
  `file_time` int unsigned DEFAULT NULL,
  `last_scan` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_update_log` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `oldVersion` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `newVersion` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `put_on_hold` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2130 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12758 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=2197 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("305", "action_scheduler/migration_hook", "complete", "2021-11-29 10:31:27", "2021-11-29 11:31:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1638181887;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1638181887;}", "1", "1", "2021-11-29 10:32:52", "2021-11-29 11:32:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("303", "wc-admin_import_customers", "complete", "2021-11-29 08:13:53", "2021-11-29 09:13:53", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1638173633;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1638173633;}", "6", "1", "2021-11-29 08:14:53", "2021-11-29 09:14:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("290", "wc-admin_import_customers", "complete", "2021-11-04 10:50:34", "2021-11-04 11:50:34", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1636023034;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1636023034;}", "6", "1", "2021-11-04 10:51:13", "2021-11-04 11:51:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("291", "woocommerce_run_update_callback", "complete", "2021-11-15 08:12:28", "2021-11-15 09:12:28", "[\"wc_admin_update_280_order_status\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1636963948;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1636963948;}", "2", "1", "2021-11-15 08:12:31", "2021-11-15 09:12:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("304", "action_scheduler/migration_hook", "complete", "2021-11-29 10:30:16", "2021-11-29 11:30:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1638181816;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1638181816;}", "1", "1", "2021-11-29 10:30:27", "2021-11-29 11:30:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("289", "ywctm_update_callback", "complete", "2021-11-04 08:08:13", "2021-11-04 09:08:13", "{\"callback\":\"ywctm_prune_old_settings\",\"args\":[]}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1636013293;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1636013293;}", "5", "1", "2021-11-04 10:49:53", "2021-11-04 11:49:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("292", "woocommerce_run_update_callback", "complete", "2021-11-15 08:12:29", "2021-11-15 09:12:29", "[\"wc_admin_update_280_db_version\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1636963949;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1636963949;}", "2", "1", "2021-11-15 08:12:31", "2021-11-15 09:12:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("293", "action_scheduler/migration_hook", "complete", "2021-11-15 08:13:29", "2021-11-15 09:13:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1636964009;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1636964009;}", "1", "1", "2021-11-15 08:13:35", "2021-11-15 09:13:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("294", "action_scheduler/migration_hook", "complete", "2021-11-15 08:14:36", "2021-11-15 09:14:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1636964076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1636964076;}", "1", "1", "2021-11-15 08:14:40", "2021-11-15 09:14:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("295", "wc-admin_import_customers", "complete", "2021-11-15 08:14:42", "2021-11-15 09:14:42", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1636964082;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1636964082;}", "6", "1", "2021-11-15 08:14:47", "2021-11-15 09:14:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("296", "woocommerce_run_update_callback", "complete", "2021-11-15 08:15:06", "2021-11-15 09:15:06", "{\"update_callback\":\"wc_update_560_create_refund_returns_page\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1636964106;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1636964106;}", "2", "1", "2021-11-15 08:16:12", "2021-11-15 09:16:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("297", "woocommerce_run_update_callback", "complete", "2021-11-15 08:15:07", "2021-11-15 09:15:07", "{\"update_callback\":\"wc_update_560_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1636964107;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1636964107;}", "2", "1", "2021-11-15 08:16:12", "2021-11-15 09:16:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("298", "wc-admin_import_customers", "complete", "2021-11-18 07:50:09", "2021-11-18 08:50:09", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637221809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637221809;}", "6", "1", "2021-11-18 07:51:32", "2021-11-18 08:51:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("299", "wc-admin_import_customers", "complete", "2021-11-19 08:47:21", "2021-11-19 09:47:21", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637311641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637311641;}", "6", "1", "2021-11-19 08:47:31", "2021-11-19 09:47:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("300", "wc-admin_import_customers", "complete", "2021-11-24 16:13:20", "2021-11-24 17:13:20", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637770400;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637770400;}", "6", "1", "2021-11-24 16:15:12", "2021-11-24 17:15:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("301", "wc-admin_import_customers", "complete", "2021-11-25 13:10:19", "2021-11-25 14:10:19", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637845819;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637845819;}", "6", "1", "2021-11-25 13:10:23", "2021-11-25 14:10:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("302", "wc-admin_import_customers", "complete", "2021-11-26 08:54:40", "2021-11-26 09:54:40", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637916880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637916880;}", "6", "1", "2021-11-26 08:55:31", "2021-11-26 09:55:31", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "ywctm-updates-end");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "ywctm-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "ywctm-updates-prune");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "wc-admin-data");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("81", "305", "action créée", "2021-11-29 10:30:27", "2021-11-29 11:30:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("79", "304", "action lancée via Async Request", "2021-11-29 10:30:27", "2021-11-29 11:30:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("83", "305", "action terminée via WP Cron", "2021-11-29 10:32:52", "2021-11-29 11:32:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("82", "305", "action lancée via WP Cron", "2021-11-29 10:32:52", "2021-11-29 11:32:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("80", "304", "action terminée via Async Request", "2021-11-29 10:30:27", "2021-11-29 11:30:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("78", "304", "action créée", "2021-11-29 10:29:16", "2021-11-29 11:29:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("76", "303", "action lancée via Async Request", "2021-11-29 08:14:53", "2021-11-29 09:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("30", "289", "action créée", "2021-10-28 08:08:13", "2021-10-28 10:08:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("77", "303", "action terminée via Async Request", "2021-11-29 08:14:53", "2021-11-29 09:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("75", "303", "action créée", "2021-11-29 08:13:48", "2021-11-29 09:13:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("34", "289", "action lancée via WP Cron", "2021-11-04 10:49:53", "2021-11-04 11:49:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("35", "289", "action terminée via WP Cron", "2021-11-04 10:49:53", "2021-11-04 11:49:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("36", "290", "action créée", "2021-11-04 10:50:29", "2021-11-04 11:50:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("37", "290", "action lancée via Async Request", "2021-11-04 10:51:13", "2021-11-04 11:51:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("38", "290", "action terminée via Async Request", "2021-11-04 10:51:13", "2021-11-04 11:51:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("39", "291", "action créée", "2021-11-15 08:12:28", "2021-11-15 09:12:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("40", "292", "action créée", "2021-11-15 08:12:28", "2021-11-15 09:12:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("41", "293", "action créée", "2021-11-15 08:12:29", "2021-11-15 09:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("42", "291", "action lancée via WP Cron", "2021-11-15 08:12:31", "2021-11-15 09:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("43", "291", "action terminée via WP Cron", "2021-11-15 08:12:31", "2021-11-15 09:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("44", "292", "action lancée via WP Cron", "2021-11-15 08:12:31", "2021-11-15 09:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("45", "292", "action terminée via WP Cron", "2021-11-15 08:12:31", "2021-11-15 09:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("46", "293", "action lancée via Async Request", "2021-11-15 08:13:35", "2021-11-15 09:13:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("47", "293", "action terminée via Async Request", "2021-11-15 08:13:35", "2021-11-15 09:13:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("48", "294", "action créée", "2021-11-15 08:13:36", "2021-11-15 09:13:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("49", "295", "action créée", "2021-11-15 08:14:37", "2021-11-15 09:14:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("50", "294", "action lancée via Async Request", "2021-11-15 08:14:40", "2021-11-15 09:14:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("51", "294", "action terminée via Async Request", "2021-11-15 08:14:40", "2021-11-15 09:14:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("52", "295", "action lancée via Async Request", "2021-11-15 08:14:47", "2021-11-15 09:14:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("53", "295", "action terminée via Async Request", "2021-11-15 08:14:47", "2021-11-15 09:14:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("54", "296", "action créée", "2021-11-15 08:15:06", "2021-11-15 09:15:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("55", "297", "action créée", "2021-11-15 08:15:06", "2021-11-15 09:15:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("56", "296", "action lancée via WP Cron", "2021-11-15 08:16:12", "2021-11-15 09:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("57", "296", "action terminée via WP Cron", "2021-11-15 08:16:12", "2021-11-15 09:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("58", "297", "action lancée via WP Cron", "2021-11-15 08:16:12", "2021-11-15 09:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("59", "297", "action terminée via WP Cron", "2021-11-15 08:16:12", "2021-11-15 09:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("60", "298", "action créée", "2021-11-18 07:50:04", "2021-11-18 08:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("61", "298", "action lancée via WP Cron", "2021-11-18 07:51:32", "2021-11-18 08:51:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("62", "298", "action terminée via WP Cron", "2021-11-18 07:51:32", "2021-11-18 08:51:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("63", "299", "action créée", "2021-11-19 08:47:16", "2021-11-19 09:47:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("64", "299", "action lancée via WP Cron", "2021-11-19 08:47:31", "2021-11-19 09:47:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("65", "299", "action terminée via WP Cron", "2021-11-19 08:47:31", "2021-11-19 09:47:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("66", "300", "action créée", "2021-11-24 16:13:15", "2021-11-24 17:13:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("67", "300", "action lancée via Async Request", "2021-11-24 16:15:11", "2021-11-24 17:15:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("68", "300", "action terminée via Async Request", "2021-11-24 16:15:12", "2021-11-24 17:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("69", "301", "action créée", "2021-11-25 13:10:14", "2021-11-25 14:10:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("70", "301", "action lancée via WP Cron", "2021-11-25 13:10:23", "2021-11-25 14:10:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("71", "301", "action terminée via WP Cron", "2021-11-25 13:10:23", "2021-11-25 14:10:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("72", "302", "action créée", "2021-11-26 08:54:35", "2021-11-26 09:54:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("73", "302", "action lancée via WP Cron", "2021-11-26 08:55:31", "2021-11-26 09:55:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("74", "302", "action terminée via WP Cron", "2021-11-26 08:55:31", "2021-11-26 09:55:31");

/* INSERT TABLE DATA: wp_auto_updates */
INSERT INTO `wp_auto_updates` VALUES("1", "plugins", "on");
INSERT INTO `wp_auto_updates` VALUES("2", "themes", "on");
INSERT INTO `wp_auto_updates` VALUES("3", "minor", "on");
INSERT INTO `wp_auto_updates` VALUES("4", "major", "");
INSERT INTO `wp_auto_updates` VALUES("5", "email", "l.chauvet@groupe-sm3i.fr");
INSERT INTO `wp_auto_updates` VALUES("6", "send", "");
INSERT INTO `wp_auto_updates` VALUES("7", "sendupdate", "");
INSERT INTO `wp_auto_updates` VALUES("8", "sendoutdated", "");
INSERT INTO `wp_auto_updates` VALUES("9", "notUpdateList", "");
INSERT INTO `wp_auto_updates` VALUES("10", "translations", "on");
INSERT INTO `wp_auto_updates` VALUES("11", "wpemails", "on");
INSERT INTO `wp_auto_updates` VALUES("12", "notUpdateListTh", "");
INSERT INTO `wp_auto_updates` VALUES("13", "html_or_text", "html");
INSERT INTO `wp_auto_updates` VALUES("14", "dbupdateemails", "");
INSERT INTO `wp_auto_updates` VALUES("15", "allow_administrator", "on");
INSERT INTO `wp_auto_updates` VALUES("16", "allow_editor", "");
INSERT INTO `wp_auto_updates` VALUES("17", "allow_author", "");
INSERT INTO `wp_auto_updates` VALUES("18", "ignore_seo", "");
INSERT INTO `wp_auto_updates` VALUES("19", "ignore_cron", "");
INSERT INTO `wp_auto_updates` VALUES("20", "advanced_info_emails", "");
INSERT INTO `wp_auto_updates` VALUES("21", "update_delay", "");
INSERT INTO `wp_auto_updates` VALUES("22", "update_delay_days", "");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "Un commentateur WordPress", "wapuu@wordpress.example", "https://wordpress.org/", "", "2021-02-22 16:20:58", "2021-02-22 15:20:58", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20211129_pontsroulantspotencepalanma", "1d2a61a40f6d5acb4149_20211129125124", "21", "2021-11-29 12:51:53", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-11-29 12:51:24\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.2\";s:9:\"VersionDB\";s:6:\"8.0.21\";s:10:\"VersionPHP\";s:5:\"7.4.9\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:1;s:4:\"Name\";s:36:\"20211129_pontsroulantspotencepalanma\";s:4:\"Hash\";s:35:\"1d2a61a40f6d5acb4149_20211129125124\";s:8:\"NameHash\";s:72:\"20211129_pontsroulantspotencepalanma_1d2a61a40f6d5acb4149_20211129125124\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:82:\"20211129_pontsroulantspotencepalanma_1d2a61a40f6d5acb4149_20211129125124_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.1\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:84:\"20211129_pontsroulantspotencepalanma_1d2a61a40f6d5acb4149_20211129125124_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:22:\"C:/wamp64/www/SODILEVE\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-11-29 12:51:24\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.2\";s:9:\"VersionDB\";s:6:\"8.0.21\";s:10:\"VersionPHP\";s:5:\"7.4.9\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20211129_pontsroulantspotencepalanma\";s:4:\"Hash\";s:35:\"1d2a61a40f6d5acb4149_20211129125124\";s:8:\"NameHash\";s:72:\"20211129_pontsroulantspotencepalanma_1d2a61a40f6d5acb4149_20211129125124\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:86:\"20211129_pontsroulantspotencepalanma_1d2a61a40f6d5acb4149_20211129125124_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:85:\"20211129_pontsroulantspotencepalanma_1d2a61a40f6d5acb4149_20211129125124_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:1;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:7:{s:26:\"wp_actionscheduler_actions\";s:2:\"17\";s:25:\"wp_actionscheduler_claims\";s:1:\"0\";s:25:\"wp_actionscheduler_groups\";s:1:\"6\";s:23:\"wp_actionscheduler_logs\";s:2:\"51\";s:15:\"wp_auto_updates\";s:2:\"22\";s:14:\"wp_commentmeta\";s:1:\"0\";s:11:\"wp_comments\";s:1:\"1\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:140:\"C:/wamp64/www/SODILEVE/wp-content/backups-dup-lite/tmp/20211129_pontsroulantspotencepalanma_1d2a61a40f6d5acb4149_20211129125124_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:31:\"C:/wamp64/www/SODILEVE/wp-admin\";i:1;s:41:\"C:/wamp64/www/SODILEVE/wp-content/uploads\";i:2;s:43:\"C:/wamp64/www/SODILEVE/wp-content/languages\";i:3;s:40:\"C:/wamp64/www/SODILEVE/wp-content/themes\";i:4;s:34:\"C:/wamp64/www/SODILEVE/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:22:\"C:/wamp64/www/SODILEVE\";i:1;s:33:\"C:/wamp64/www/SODILEVE/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:137;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://localhost/SODILEVE", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://localhost/SODILEVE", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Ponts roulants | Potence | Palan | Maintenance - SODILEVE", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Un site utilisant WordPress", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "pa.hulin@sodileve.fr", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "G\\hi", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "d F Y G\\hi", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:18:{i:0;s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:1;s:47:\"companion-auto-update/companion-auto-update.php\";i:2;s:31:\"divi-mega-pro/divi-mega-pro.php\";i:3;s:33:\"divi-sumo-lite/divi-sumo-lite.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:39:\"flip-cards-module-divi/divi-flipbox.php\";i:6;s:19:\"monarch/monarch.php\";i:7;s:45:\"post-carousel-for-dv-builder/postcarousel.php\";i:8;s:75:\"recent-posts-widget-with-thumbnails/recent-posts-widget-with-thumbnails.php\";i:9;s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";i:10;s:47:\"simple-divi-shortcode/simple_divi_shortcode.php\";i:11;s:27:\"woocommerce/woocommerce.php\";i:12;s:23:\"wordfence/wordfence.php\";i:13;s:24:\"wordpress-seo/wp-seo.php\";i:14;s:35:\"wp-fastest-cache/wpFastestCache.php\";i:15;s:23:\"wp-smushit/wp-smush.php\";i:16;s:59:\"wp-tools-divi-blog-carousel/wp-tools-divi-blog-carousel.php\";i:17;s:38:\"yith-woocommerce-catalog-mode/init.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:2:{i:0;s:66:\"C:\\wamp64\\www\\SODILEVE/wp-content/themes/twentytwentyone/style.css\";i:2;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "Divi", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "Divi", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "14", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "138", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "18", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1650956636", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("99", "wp_user_roles", "a:9:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:125:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"copy_posts\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("100", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("101", "WPLANG", "fr_FR", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_recent-posts", "a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:10;s:9:\"show_date\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:1:{i:0;s:14:\"recent-posts-3\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:19:\"et_pb_widget_area_1\";a:1:{i:0;s:37:\"recent-posts-widget-with-thumbnails-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("108", "cron", "a:33:{i:1638190345;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1638190451;a:2:{s:21:\"cau_set_schedule_mail\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"cau_outdated_notifier\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638190631;a:5:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:24:\"cau_custom_hooks_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:23:\"cau_custom_hooks_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638191720;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638192059;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638192437;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638192443;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638193505;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638193688;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1638195146;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638196037;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638198000;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1638198377;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638198378;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638199258;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638199276;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638199277;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638202505;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638202520;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638216311;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638226800;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638232031;a:1:{s:15:\"cau_log_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638237023;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}i:1638259956;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638260006;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1638268284;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638270746;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638275201;a:1:{s:40:\"fs_data_sync_wp-tools-divi-blog-carousel\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638285658;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1638427200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"811660a3ce7bbcbc958faf294b7b2666\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1638427200;}}}}i:1638457578;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1638686400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"faacbf18d8fded50a4af870b02f8982b\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1638686400;}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "nonce_key", "A0D%{w};6pIy2*)1bV7Xc9-p>XN-EE`dfE2s;K6-@B}F64/f0vZ~JK$_/#(O|,Q^", "no");
INSERT INTO `wp_options` VALUES("116", "nonce_salt", "/0Pw0rvKah=_0*03>zHLGk>W 3am|_Rv]x{*5Z$@COd}v$=3D=n[/VGHE(!{Bxfw", "no");
INSERT INTO `wp_options` VALUES("117", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("132", "auth_key", "w38@MIDF-3>ZakbBjWkkqVzxXiO>-lp_^rGA_*Z=kK}=3tR9ZPA(9F!TD_Qa-(`D", "no");
INSERT INTO `wp_options` VALUES("121", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("135", "logged_in_salt", "*|oh/CVXP|QHcBG^,E 2]^;m)89*7>S-sh8sHLA=I1J]eTEG8{Mpg4Mu1!GlfGOs", "no");
INSERT INTO `wp_options` VALUES("133", "auth_salt", "no~9BQ/I)2}kOyz`$ppz]G+?<(h$nDDL!HesqJb+_]tOUUZezxK]{CGj3vz09jX9", "no");
INSERT INTO `wp_options` VALUES("134", "logged_in_key", "=PbJfurs#p#zZO*Brx y;0z}e`}Q<3hpO[KIo-5yyRe+.]y ?P[gy%)i&xyV7rxn", "no");
INSERT INTO `wp_options` VALUES("4219", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `wp_options` VALUES("128", "theme_mods_twentytwentyone", "a:6:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:6:\"footer\";i:3;}s:16:\"background_color\";s:6:\"fecb1f\";s:29:\"respect_user_color_preference\";b:1;s:25:\"display_title_and_tagline\";b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1617198623;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:9:\"mega-menu\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("394", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("393", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("327", "https_detection_errors", "a:1:{s:20:\"https_request_failed\";a:1:{i:0;s:28:\"La demande HTTPS a échoué.\";}}", "yes");
INSERT INTO `wp_options` VALUES("392", "widget_advwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("334", "widget_maxmegamenu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("335", "megamenu_version", "2.9.3", "yes");
INSERT INTO `wp_options` VALUES("156", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("143", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("7688", "_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1638216836", "no");
INSERT INTO `wp_options` VALUES("7689", "_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1638173636", "no");
INSERT INTO `wp_options` VALUES("6627", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1638225867", "no");
INSERT INTO `wp_options` VALUES("6628", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:22:\"WordCamp Taiwan Online\";s:3:\"url\";s:33:\"https://taiwan.wordcamp.org/2021/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2021-12-11 13:00:00\";s:8:\"end_date\";s:19:\"2021-12-12 00:00:00\";s:20:\"start_unix_timestamp\";i:1639198800;s:18:\"end_unix_timestamp\";i:1639238400;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"TW\";s:8:\"latitude\";d:25.0329636;s:9:\"longitude\";d:121.5654268;}}}}", "no");
INSERT INTO `wp_options` VALUES("336", "megamenu_initial_version", "2.9.3", "yes");
INSERT INTO `wp_options` VALUES("337", "megamenu_multisite_share_themes", "false", "yes");
INSERT INTO `wp_options` VALUES("338", "megamenu_settings", "a:4:{s:6:\"prefix\";s:8:\"disabled\";s:12:\"descriptions\";s:7:\"enabled\";s:12:\"second_click\";s:2:\"go\";s:7:\"primary\";a:15:{s:7:\"enabled\";s:1:\"1\";s:5:\"event\";s:5:\"hover\";s:6:\"effect\";s:7:\"fade_up\";s:12:\"effect_speed\";s:3:\"200\";s:13:\"effect_mobile\";s:5:\"slide\";s:19:\"effect_speed_mobile\";s:3:\"200\";s:5:\"theme\";s:7:\"default\";s:12:\"second_click\";s:2:\"go\";s:16:\"mobile_behaviour\";s:8:\"standard\";s:12:\"mobile_state\";s:12:\"collapse_all\";s:12:\"descriptions\";s:7:\"enabled\";s:6:\"unbind\";s:7:\"enabled\";s:9:\"container\";s:3:\"div\";s:15:\"active_instance\";s:1:\"0\";s:6:\"prefix\";s:8:\"disabled\";}}", "yes");
INSERT INTO `wp_options` VALUES("400", "et_bfb_settings", "a:2:{s:10:\"enable_bfb\";s:2:\"on\";s:10:\"toggle_bfb\";s:2:\"on\";}", "yes");
INSERT INTO `wp_options` VALUES("503", "layout_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("403", "et_support_center_setup_done", "processed", "yes");
INSERT INTO `wp_options` VALUES("7659", "_transient_timeout_feed_6b646ba1685199dbb7a80f9d24fbfe04", "1638216832", "no");
INSERT INTO `wp_options` VALUES("7660", "_transient_feed_6b646ba1685199dbb7a80f9d24fbfe04", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n \n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:51:\"\n \n \n \n \n \n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"YITH Updates RSS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"https://yithemes.com/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"YITH Updates RSS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-us\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:20:{i:0;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"YITH WooCommerce Points and Rewards - 3.0.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-points-and-rewards.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://yithemes.com/themes/plugins/yith-woocommerce-points-and-rewards/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 25 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2089:\"\n	\n	<ul>\n                <li>New: levels and badges feature to rank and reward your customers</li>\n                <li>New: shortcodes to show a ranking of the best customers that collected most points</li>\n                <li>New: banners feature to push users to collect more points on \"My Account\" page</li>\n                <li>New: points assignment rules that replace the old settings in product and category editors</li>\n                <li>New: points redeeming rules that replace the old settings in product and category editors</li>\n                <li>New: redesign of the admin panel</li>\n                <li>New: new action \"Unban users\" inside the Customer Points &gt; Bulk Actions tab</li>\n                <li>New: Customer Points &gt; Shortcodes tab to copy the plugin shortcodes to show a list of your customers\' points</li>\n                <li>New: option to calculate points considering product price with taxes included or excluded for points assignment and points redeeming</li>\n                <li>New: extra points for the first daily login to daily reward the users whenever they log in</li>\n                <li>New: extra points for completed profile to incentivize the users to complete all their profile fields on \"My Account\" page</li>\n                <li>New: extra points for referrals to reward the users for every new user registered through their referral link</li>\n                <li>New: extra points for referrals purchase to reward the users for every purchase made by users that have been referred through their referral link</li>\n                <li>New: extra points for users who collect the most points in the week or month</li>\n                <li>New: extra points for users that achieve specific levels</li>\n                <li>New: \"minimum discount users can get\" option for the percentage discount reward conversion method</li>\n                <li>New: integration with YITH WooCommerce Membership plugin</li>\n                <li>Update: YITH plugin framework</li>\n                <li>Dev: Totally refactoring code</li>\n            </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"YITH WooCommerce Gift Cards - 3.7.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://yithemes.com/wp-content/uploads/2015/10/gift-card.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://yithemes.com/themes/plugins/yith-woocommerce-gift-cards/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 25 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1159:\"\n	\n	<ul>\n  <li>Update: YITH plugin framework</li>\n  <li>Update: updating setting strings</li>\n  <li>Fix: fixed warning when importing gift cards without date</li>\n  <li>Fix: fixed the gallery if no image are added</li>\n  <li>Fix: fixed the integration with Aelia when using the gift cards as coupons</li>\n  <li>Dev: added the correct text when removing a product from the cart using the gift this product</li>\n  <li>Dev: added new filters yith_ywgc_gift_card_post, yith_ywgc_gift_card_number and yith_ywgc_gift_card_total_balance</li>\n  <li>Dev: removed maxDate param from datepickers</li>\n  <li>Dev: make a different template for the Gift this product shortcode</li>\n  <li>Dev: removed cart and checkout conditions to load the gift card scripts</li>\n  <li>Dev: removed cart and checkout conditions to load the gift card scripts</li>\n  <li>Dev: added new hooks yith_ywgc_after_write_mpdf_html_template_pdf and yith_ywgc_after_generate_template_pdf</li>\n  <li>Dev: escaped some strings</li>\n  <li>Dev: disabled the upload feature temporarily in the gallery popup. It will be redesigned with a different library and included in the next versions.</li>\n</ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"YITH Booking and Appointment for WooCommerce - 3.0.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-booking.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://yithemes.com/themes/plugins/yith-woocommerce-booking/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Wed, 24 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1134:\"\n	\n	<ul>\n            <li>Update: YITH plugin framework</li>\n            <li>Update: language files</li>\n            <li>Fix: order search when creating booking on admin side</li>\n            <li>Fix: issue when selecting service quantity and duration in mobile, using the bookable product form widget</li>\n            <li>Fix: availability calculation when using default availability in combination with availability rules</li>\n            <li>Fix: price conversion in search form results in combination with YITH Multi Currency Switcher for WooCommerce</li>\n            <li>Tweak: fixed redirection after confirming/rejecting booking through actions in emails</li>\n            <li>Tweak: fixed calendar redirection in Vendor\'s calendar in combination with YITH WooCommerce Multi Vendor</li>\n            <li>Tweak: fixed dates set by default after clicking on search form results</li>\n            <li>Tweak: improved link in search form results to include parameters also when dates are not selected</li>\n            <li>Tweak: fixed date-picker initialization when adding a new date range to Availability rules</li>\n        </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"YITH WooCommerce EU VAT - 2.4.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-eu-vat.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://yithemes.com/themes/plugins/yith-woocommerce-eu-vat/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 23 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:333:\"\n	\n	<ul>\n            <li>Update: YITH plugin framework</li>\n            <li>Fix: fixed wrong taxes displayed on the IOSS report</li>\n            <li>Fix: Removed the shipping and fees taxes from the IOSS VAT exemption</li>\n            <li>Fix: use the shipping country to manage the IOSS instead of the billing</li>\n        </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"YITH WooCommerce Tab Manager - 1.5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-tab-manager.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://yithemes.com/themes/plugins/yith-woocommerce-tab-manager/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 18 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"\n	\n	<ul>\n                <li>New: Support for WooCommerce 5.9</li>\n                <li>Update: YITH plugin framework</li>\n            </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"YITH PayPal Express Checkout for WooCommerce - 1.7.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://yithemes.com/wp-content/uploads/2019/05/yith-paypal-express-checkout-for-woocommerce.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://yithemes.com/themes/plugins/yith-paypal-express-checkout-for-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 18 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"\n	\n	<ul>\n		    <li>New: support for WooCommerce 5.9</li>\n		    <li>Update: YITH plugin framework</li>\n		</ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"YITH Product Shipping for WooCommerce - 1.3.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://yithemes.com/wp-content/uploads/2019/05/yith-product-shipping-for-woocommerce.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://yithemes.com/themes/plugins/yith-product-shipping-for-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Sat, 13 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"\n	\n	<ul>\n				<li>New: support for WooCommerce 5.9</li>\n				<li>Update: YITH plugin framework</li>\n				<li>Fix: minor bugs</li>\n			</ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"YITH Composite Products for WooCommerce - 1.4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://yithemes.com/wp-content/uploads/2019/05/yith-composite-products-for-woocommerce.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://yithemes.com/themes/plugins/yith-woocommerce-composite-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Sat, 13 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:180:\"\n	\n	<ul>\n			<li>New: support for WooCommerce 5.9</li>\n			<li>Update: YITH plugin framework</li>\n			<li>Fix: components order by problem</li>\n			<li>Fix: minor bugs</li>\n		</ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"YITH WooCommerce Customer History - 1.5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-customer-history.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://yithemes.com/themes/plugins/yith-woocommerce-customer-history/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Sat, 13 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"\n	\n	<ul>\n				<li>New: support for WooCommerce 5.9</li>\n				<li>Update: YITH plugin framework</li>\n				<li>Fix: minor bugs</li>\n			</ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"YITH WooCommerce Share for Discounts - 1.10.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-share-for-discounts.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://yithemes.com/themes/plugins/yith-woocommerce-share-for-discounts/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Fri, 12 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"\n	\n	<ul>         \n	<li>Fix: error when sharing on LinkedIn</li>\n</ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"YITH WooCommerce Compare - 2.8.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-compare.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://yithemes.com/themes/plugins/yith-woocommerce-compare/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 11 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:312:\"\n	\n	<ul>\n            <li>New: support for WooCommerce 5.9</li>\n            <li>Update: YITH plugin framework</li>\n            <li>Fix: undefined variable when removing a product from the comparison table</li>\n            <li>Fix: link after a product has been added to the comparison table</li>\n        </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"YITH WooCommerce Frequently Bought Together - 1.11.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://yithemes.com/wp-content/uploads/2015/05/yith-woocommerce-frequently-bought.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://yithemes.com/themes/plugins/yith-woocommerce-frequently-bought-together/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 11 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"\n	\n	<ul>\n            <li>New: support for WooCommerce 5.9</li>\n            <li>Update: YITH plugin framework</li>\n        </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"YITH WooCommerce Sms Notifications - 1.9.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-sms-notifications.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://yithemes.com/themes/plugins/yith-woocommerce-sms-notifications/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 11 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"\n	\n	<ul>         \n	<li>New: support for WooCommerce 5.9</li>\n	<li>New: TextTeam provider</li>\n	<li>Update: YITH plugin framework</li>\n</ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"YITH WooCommerce Ajax Product Filter - 4.4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-ajax-product-filter.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://yithemes.com/themes/plugins/yith-woocommerce-ajax-product-filter/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 11 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:643:\"\n	\n	<ul>\n	<li>New: support for WooCommerce 5.9</li>\n	<li>Tweak: improved terms handling when use all terms option is enabled</li>\n	<li>Update: YITH Plugin Framework</li>\n	<li>Fix: filter clone button icon</li>\n	<li>Fix: checkbox not being correctly initialized after Load More action in admin</li>\n	<li>Fix: wrong description in option panel</li>\n	<li>Fix: children terms order, when Terms Order option is selected</li>\n	<li>Fix: active price range issue with zero value</li>\n	<li>Fix: retrive session during rquest parsing, and merge its query-vars to global $wp query-vars</li>\n	<li>Fix: prevent notices when no session is set</li>\n</ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"YITH WooCommerce Product Bundles - 1.7.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-product-bundles.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://yithemes.com/themes/plugins/yith-woocommerce-product-bundles/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Thu, 11 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"\n	\n	<ul>\n            <li>New: support for WooCommerce 5.9</li>\n            <li>Update: YITH plugin framework</li>\n        </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"YITH Booking and Appointment for WooCommerce - 3.0.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-booking.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://yithemes.com/themes/plugins/yith-woocommerce-booking/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Wed, 10 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:427:\"\n	\n	<ul>\n            <li>Update: language files</li>\n            <li>Tweak: prevent widget issues on mobile with different themes using z-index in sidebar</li>\n            <li>Tweak: improved date-picker style</li>\n            <li>Dev: added filter \'yith_wcbk_product_form_widget_mobile_move_to_footer\', to allow disabling the feature that moves the \'Bookable product form\' widget to the footer in mobile</li>\n        </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"YITH Dynamic Pricing per Payment Method for WooCommerce - 1.6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://yithemes.com/wp-content/uploads/2019/05/yith-dynamic-pricing-per-payment-method-for-woocommerce.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://yithemes.com/themes/plugins/yith-dynamic-pricing-per-payment-method-for-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Wed, 10 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:163:\"\n	\n	<ul>\n    <li>New: support for WooCommerce 5.9</li>\n    <li>Update: YITH plugin framework</li>\n    <li>Dev: fixed functionality in order pay page</li>\n</ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"YITH Google Product Feed for WooCommerce - 1.4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://yithemes.com/wp-content/uploads/2019/05/yith-google-product-feed-for-woocommerce.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://yithemes.com/themes/plugins/yith-google-product-feed-for-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Wed, 10 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"\n	\n	<ul>\n           <li>New: support for WooCommerce 5.9</li>\n           <li>Update: YITH plugin framework</li>\n        </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"YITH Payment Method Restrictions for WooCommerce - 1.4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://yithemes.com/wp-content/uploads/2019/05/yith-payment-method-restrictions-for-woocommerce.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://yithemes.com/themes/plugins/yith-payment-method-restrictions-for-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Wed, 10 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:212:\"\n	\n	<ul>\n            <li>New: support for WooCommerce 5.9</li>\n            <li>Update: YITH plugin framework</li>\n            <li>Dev: added new filter yith_wcpmr_default_no_billing_country</li>\n        </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:12:\"\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"YITH Multi Currency Switcher for WooCommerce - 1.2.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://yithemes.com/wp-content/uploads/2021/02/currency_switcher.svg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://yithemes.com/themes/plugins/yith-multi-currency-switcher-for-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Wed, 10 Nov 2021 00:00:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:262:\"\n	\n	<ul>\n            <li>New: support for WooCommerce 5.9</li>\n            <li>Update: YITH plugin framework</li>\n            <li>Update: language files</li>\n            <li>Dev: user\'s currency saved even when it\'s changed by query string</li>\n        </ul>\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:42:\"https://yithemes.com/latest-updates/feeds/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:20:{s:4:\"date\";s:29:\"Mon, 29 Nov 2021 08:13:52 GMT\";s:12:\"content-type\";s:22:\"text/xml;charset=UTF-8\";s:4:\"link\";s:252:\"</wp-content/themes/yithemes/assets/css/main.min.css?ver=3.9.14>; rel=preload; as=style,</wp-includes/js/jquery/jquery.min.js?ver=3.5.1>; rel=\"preload\"; as=script,</wp-content/themes/yithemes/assets/js/scripts.min.js?ver=3.9.08>; rel=preload; as=script\";s:9:\"expect-ct\";s:87:\"max-age=604800, report-uri=\"https://report-uri.cloudflare.com/cdn-cgi/beacon/expect-ct\"\";s:7:\"ki-edge\";s:6:\"v=16.6\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:19:\"x-edge-location-klb\";s:1:\"1\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:14:\"x-kinsta-cache\";s:3:\"HIT\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:13:\"cache-control\";s:13:\"max-age=10800\";s:15:\"cf-cache-status\";s:3:\"HIT\";s:3:\"age\";s:2:\"13\";s:13:\"last-modified\";s:29:\"Mon, 29 Nov 2021 08:13:39 GMT\";s:25:\"strict-transport-security\";s:44:\"max-age=15552000; includeSubDomains; preload\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"6b5a6110080b022c-CDG\";s:7:\"alt-svc\";s:91:\"h3=\":443\"; ma=86400, h3-29=\":443\"; ma=86400, h3-28=\":443\"; ma=86400, h3-27=\":443\"; ma=86400\";}}s:5:\"build\";s:14:\"20201016162008\";}", "no");
INSERT INTO `wp_options` VALUES("7431", "_transient_timeout_wc_report_orders_stats_129a7b66961eb7955dc127bcaeba336c", "1638521679", "no");
INSERT INTO `wp_options` VALUES("7432", "_transient_wc_report_orders_stats_129a7b66961eb7955dc127bcaeba336c", "a:2:{s:7:\"version\";s:10:\"1636963948\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:1:{i:0;a:6:{s:8:\"interval\";s:7:\"2021-47\";s:10:\"date_start\";s:19:\"2021-11-22 01:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-22 00:00:00\";s:8:\"date_end\";s:19:\"2021-11-26 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-26 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:4;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "no");
INSERT INTO `wp_options` VALUES("7433", "_transient_timeout_wc_report_orders_stats_b169ef46f04cc3cf828d64a7a99ead49", "1638521679", "no");
INSERT INTO `wp_options` VALUES("7434", "_transient_wc_report_orders_stats_b169ef46f04cc3cf828d64a7a99ead49", "a:2:{s:7:\"version\";s:10:\"1636963948\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:1:{i:0;a:6:{s:8:\"interval\";s:7:\"2021-47\";s:10:\"date_start\";s:19:\"2021-11-22 01:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-22 00:00:00\";s:8:\"date_end\";s:19:\"2021-11-26 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-26 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:4;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "no");
INSERT INTO `wp_options` VALUES("7435", "_transient_timeout_wc_report_products_stats_a87929dd15d55b67da11eefbb3405bfa", "1638521679", "no");
INSERT INTO `wp_options` VALUES("7436", "_transient_wc_report_products_stats_a87929dd15d55b67da11eefbb3405bfa", "a:2:{s:7:\"version\";s:10:\"1636963948\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":6:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:14:\"products_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:1:{i:0;a:6:{s:8:\"interval\";s:7:\"2021-47\";s:10:\"date_start\";s:19:\"2021-11-22 01:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-22 00:00:00\";s:8:\"date_end\";s:19:\"2021-11-26 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-26 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":6:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:14:\"products_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:4;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "no");
INSERT INTO `wp_options` VALUES("7437", "_transient_timeout_wc_report_variations_stats_01e30b8f68445afdfc030e37874aaabe", "1638521679", "no");
INSERT INTO `wp_options` VALUES("7438", "_transient_wc_report_variations_stats_01e30b8f68445afdfc030e37874aaabe", "a:2:{s:7:\"version\";s:10:\"1636963948\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":5:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:1:{i:0;a:6:{s:8:\"interval\";s:7:\"2021-47\";s:10:\"date_start\";s:19:\"2021-11-22 01:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-22 00:00:00\";s:8:\"date_end\";s:19:\"2021-11-26 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-26 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":5:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:4;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "no");
INSERT INTO `wp_options` VALUES("7439", "_transient_timeout_wc_report_orders_stats_b501fd4c6d278429ed2bd11e29050ba1", "1638521679", "no");
INSERT INTO `wp_options` VALUES("7440", "_transient_wc_report_orders_stats_b501fd4c6d278429ed2bd11e29050ba1", "a:2:{s:7:\"version\";s:10:\"1636963948\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":4:{s:11:\"net_revenue\";d:0;s:8:\"products\";i:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:26:{i:0;a:6:{s:8:\"interval\";s:10:\"2021-11-01\";s:10:\"date_start\";s:19:\"2021-11-01 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-10-31 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-01 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-01 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:1;a:6:{s:8:\"interval\";s:10:\"2021-11-02\";s:10:\"date_start\";s:19:\"2021-11-02 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-01 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-02 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-02 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:2;a:6:{s:8:\"interval\";s:10:\"2021-11-03\";s:10:\"date_start\";s:19:\"2021-11-03 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-02 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-03 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-03 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:3;a:6:{s:8:\"interval\";s:10:\"2021-11-04\";s:10:\"date_start\";s:19:\"2021-11-04 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-03 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-04 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-04 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:4;a:6:{s:8:\"interval\";s:10:\"2021-11-05\";s:10:\"date_start\";s:19:\"2021-11-05 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-04 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-05 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-05 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:5;a:6:{s:8:\"interval\";s:10:\"2021-11-06\";s:10:\"date_start\";s:19:\"2021-11-06 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-05 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-06 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-06 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:6;a:6:{s:8:\"interval\";s:10:\"2021-11-07\";s:10:\"date_start\";s:19:\"2021-11-07 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-06 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-07 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-07 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:7;a:6:{s:8:\"interval\";s:10:\"2021-11-08\";s:10:\"date_start\";s:19:\"2021-11-08 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-07 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-08 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-08 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:8;a:6:{s:8:\"interval\";s:10:\"2021-11-09\";s:10:\"date_start\";s:19:\"2021-11-09 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-08 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-09 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-09 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:9;a:6:{s:8:\"interval\";s:10:\"2021-11-10\";s:10:\"date_start\";s:19:\"2021-11-10 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-09 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-10 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-10 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:10;a:6:{s:8:\"interval\";s:10:\"2021-11-11\";s:10:\"date_start\";s:19:\"2021-11-11 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-10 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-11 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-11 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:11;a:6:{s:8:\"interval\";s:10:\"2021-11-12\";s:10:\"date_start\";s:19:\"2021-11-12 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-11 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-12 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-12 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:12;a:6:{s:8:\"interval\";s:10:\"2021-11-13\";s:10:\"date_start\";s:19:\"2021-11-13 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-12 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-13 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-13 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:13;a:6:{s:8:\"interval\";s:10:\"2021-11-14\";s:10:\"date_start\";s:19:\"2021-11-14 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-13 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-14 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-14 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:14;a:6:{s:8:\"interval\";s:10:\"2021-11-15\";s:10:\"date_start\";s:19:\"2021-11-15 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-14 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-15 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-15 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:15;a:6:{s:8:\"interval\";s:10:\"2021-11-16\";s:10:\"date_start\";s:19:\"2021-11-16 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-15 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-16 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-16 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:16;a:6:{s:8:\"interval\";s:10:\"2021-11-17\";s:10:\"date_start\";s:19:\"2021-11-17 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-16 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-17 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-17 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:17;a:6:{s:8:\"interval\";s:10:\"2021-11-18\";s:10:\"date_start\";s:19:\"2021-11-18 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-17 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-18 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-18 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:18;a:6:{s:8:\"interval\";s:10:\"2021-11-19\";s:10:\"date_start\";s:19:\"2021-11-19 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-18 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-19 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-19 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:19;a:6:{s:8:\"interval\";s:10:\"2021-11-20\";s:10:\"date_start\";s:19:\"2021-11-20 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-19 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-20 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-20 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:20;a:6:{s:8:\"interval\";s:10:\"2021-11-21\";s:10:\"date_start\";s:19:\"2021-11-21 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-20 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-21 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-21 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:21;a:6:{s:8:\"interval\";s:10:\"2021-11-22\";s:10:\"date_start\";s:19:\"2021-11-22 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-21 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-22 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-22 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:22;a:6:{s:8:\"interval\";s:10:\"2021-11-23\";s:10:\"date_start\";s:19:\"2021-11-23 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-22 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-23 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-23 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:23;a:6:{s:8:\"interval\";s:10:\"2021-11-24\";s:10:\"date_start\";s:19:\"2021-11-24 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-23 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-24 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-24 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:24;a:6:{s:8:\"interval\";s:10:\"2021-11-25\";s:10:\"date_start\";s:19:\"2021-11-25 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-24 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-25 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-25 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:25;a:6:{s:8:\"interval\";s:10:\"2021-11-26\";s:10:\"date_start\";s:19:\"2021-11-26 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-11-25 23:00:00\";s:8:\"date_end\";s:19:\"2021-11-26 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-11-26 22:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:26;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "no");
INSERT INTO `wp_options` VALUES("6298", "woocommerce_refund_returns_page_id", "785", "yes");
INSERT INTO `wp_options` VALUES("930", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("931", "default_product_cat", "21", "yes");
INSERT INTO `wp_options` VALUES("971", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("934", "woocommerce_version", "5.9.0", "yes");
INSERT INTO `wp_options` VALUES("935", "woocommerce_db_version", "5.6.0", "yes");
INSERT INTO `wp_options` VALUES("714", "dsm_theme_builder", "", "yes");
INSERT INTO `wp_options` VALUES("834", "woocommerce_currency_pos", "right", "yes");
INSERT INTO `wp_options` VALUES("715", "dsm_settings_social_media", "", "yes");
INSERT INTO `wp_options` VALUES("716", "dsm_settings_misc", "", "yes");
INSERT INTO `wp_options` VALUES("946", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"eNJdUQM9oaOTSfdx8bvqYGwzRD9Nelll\";}", "yes");
INSERT INTO `wp_options` VALUES("3548", "divimegapro_enable_cache", "1", "yes");
INSERT INTO `wp_options` VALUES("1737", "et_monarch_options", "a:170:{s:34:\"sharing_locations_manage_locations\";a:1:{i:0;s:7:\"sidebar\";}s:26:\"sharing_sidebar_icon_style\";s:5:\"slide\";s:26:\"sharing_sidebar_icon_shape\";s:9:\"rectangle\";s:35:\"sharing_sidebar_sidebar_orientation\";s:5:\"right\";s:25:\"sharing_sidebar_animation\";s:10:\"slideright\";s:22:\"sharing_sidebar_counts\";b:0;s:26:\"sharing_sidebar_counts_num\";i:0;s:21:\"sharing_sidebar_total\";b:0;s:27:\"sharing_sidebar_total_color\";s:4:\"dark\";s:27:\"sharing_sidebar_display_all\";b:0;s:23:\"sharing_sidebar_spacing\";b:0;s:22:\"sharing_sidebar_mobile\";b:0;s:29:\"sharing_sidebar_custom_colors\";b:0;s:24:\"sharing_sidebar_bg_color\";s:0:\"\";s:30:\"sharing_sidebar_bg_color_hover\";s:0:\"\";s:26:\"sharing_sidebar_icon_color\";s:0:\"\";s:32:\"sharing_sidebar_icon_color_hover\";s:0:\"\";s:26:\"sharing_sidebar_post_types\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"project\";i:3;s:7:\"product\";}s:25:\"sharing_inline_icon_style\";s:5:\"slide\";s:25:\"sharing_inline_icon_shape\";s:7:\"rounded\";s:29:\"sharing_inline_icons_location\";s:5:\"above\";s:30:\"sharing_inline_icons_alignment\";s:4:\"left\";s:25:\"sharing_inline_col_number\";s:1:\"4\";s:21:\"sharing_inline_counts\";s:1:\"1\";s:25:\"sharing_inline_counts_num\";i:0;s:20:\"sharing_inline_total\";b:0;s:28:\"sharing_inline_network_names\";s:1:\"1\";s:26:\"sharing_inline_display_all\";b:0;s:26:\"sharing_inline_outer_color\";s:4:\"dark\";s:22:\"sharing_inline_spacing\";b:0;s:21:\"sharing_inline_mobile\";b:0;s:28:\"sharing_inline_custom_colors\";b:0;s:23:\"sharing_inline_bg_color\";s:0:\"\";s:29:\"sharing_inline_bg_color_hover\";s:0:\"\";s:25:\"sharing_inline_icon_color\";s:0:\"\";s:31:\"sharing_inline_icon_color_hover\";s:0:\"\";s:25:\"sharing_inline_post_types\";a:1:{i:0;s:4:\"post\";}s:24:\"sharing_popup_icon_style\";s:5:\"slide\";s:24:\"sharing_popup_icon_shape\";s:7:\"rounded\";s:24:\"sharing_popup_title_text\";s:10:\"Share This\";s:26:\"sharing_popup_message_text\";s:34:\"Share this post with your friends!\";s:29:\"sharing_popup_icons_alignment\";s:4:\"left\";s:24:\"sharing_popup_col_number\";s:1:\"3\";s:23:\"sharing_popup_animation\";s:6:\"fadein\";s:24:\"sharing_popup_auto_popup\";s:1:\"1\";s:25:\"sharing_popup_popup_delay\";i:20;s:26:\"sharing_popup_trigger_idle\";b:0;s:26:\"sharing_popup_idle_timeout\";i:15;s:28:\"sharing_popup_trigger_bottom\";b:0;s:29:\"sharing_popup_trigger_comment\";b:0;s:28:\"sharing_popup_scroll_trigger\";b:0;s:24:\"sharing_popup_scroll_pos\";i:50;s:30:\"sharing_popup_trigger_purchase\";b:0;s:21:\"sharing_popup_cookies\";b:0;s:29:\"sharing_popup_cookie_duration\";i:1;s:20:\"sharing_popup_counts\";s:1:\"1\";s:24:\"sharing_popup_counts_num\";i:0;s:19:\"sharing_popup_total\";b:0;s:27:\"sharing_popup_network_names\";s:1:\"1\";s:25:\"sharing_popup_display_all\";b:0;s:21:\"sharing_popup_spacing\";b:0;s:20:\"sharing_popup_mobile\";b:0;s:27:\"sharing_popup_custom_colors\";b:0;s:22:\"sharing_popup_bg_color\";s:0:\"\";s:28:\"sharing_popup_bg_color_hover\";s:0:\"\";s:24:\"sharing_popup_icon_color\";s:0:\"\";s:30:\"sharing_popup_icon_color_hover\";s:0:\"\";s:24:\"sharing_popup_post_types\";a:1:{i:0;s:4:\"post\";}s:24:\"sharing_flyin_icon_style\";s:5:\"slide\";s:24:\"sharing_flyin_icon_shape\";s:7:\"rounded\";s:24:\"sharing_flyin_title_text\";s:10:\"Share This\";s:26:\"sharing_flyin_message_text\";s:34:\"Share this post with your friends!\";s:28:\"sharing_flyin_icons_location\";s:12:\"bottom_right\";s:29:\"sharing_flyin_icons_alignment\";s:4:\"left\";s:24:\"sharing_flyin_col_number\";s:1:\"2\";s:23:\"sharing_flyin_animation\";s:7:\"slideup\";s:24:\"sharing_flyin_auto_popup\";b:0;s:25:\"sharing_flyin_popup_delay\";i:20;s:26:\"sharing_flyin_trigger_idle\";b:0;s:26:\"sharing_flyin_idle_timeout\";i:15;s:28:\"sharing_flyin_trigger_bottom\";s:1:\"1\";s:29:\"sharing_flyin_trigger_comment\";b:0;s:28:\"sharing_flyin_scroll_trigger\";b:0;s:24:\"sharing_flyin_scroll_pos\";i:50;s:30:\"sharing_flyin_trigger_purchase\";b:0;s:21:\"sharing_flyin_cookies\";b:0;s:29:\"sharing_flyin_cookie_duration\";i:1;s:20:\"sharing_flyin_counts\";b:0;s:24:\"sharing_flyin_counts_num\";i:0;s:19:\"sharing_flyin_total\";b:0;s:27:\"sharing_flyin_network_names\";s:1:\"1\";s:25:\"sharing_flyin_display_all\";b:0;s:21:\"sharing_flyin_spacing\";b:0;s:20:\"sharing_flyin_mobile\";b:0;s:27:\"sharing_flyin_custom_colors\";b:0;s:22:\"sharing_flyin_bg_color\";s:0:\"\";s:28:\"sharing_flyin_bg_color_hover\";s:0:\"\";s:24:\"sharing_flyin_icon_color\";s:0:\"\";s:30:\"sharing_flyin_icon_color_hover\";s:0:\"\";s:24:\"sharing_flyin_post_types\";a:1:{i:0;s:4:\"post\";}s:24:\"sharing_media_icon_style\";s:6:\"simple\";s:24:\"sharing_media_icon_shape\";s:7:\"rounded\";s:29:\"sharing_media_icons_alignment\";s:4:\"left\";s:24:\"sharing_media_col_number\";s:4:\"auto\";s:20:\"sharing_media_counts\";b:0;s:24:\"sharing_media_counts_num\";i:0;s:19:\"sharing_media_total\";b:0;s:27:\"sharing_media_network_names\";s:1:\"1\";s:25:\"sharing_media_display_all\";b:0;s:25:\"sharing_media_outer_color\";s:4:\"dark\";s:21:\"sharing_media_spacing\";b:0;s:20:\"sharing_media_mobile\";b:0;s:27:\"sharing_media_custom_colors\";b:0;s:22:\"sharing_media_bg_color\";s:0:\"\";s:28:\"sharing_media_bg_color_hover\";s:0:\"\";s:24:\"sharing_media_icon_color\";s:0:\"\";s:30:\"sharing_media_icon_color_hover\";s:0:\"\";s:24:\"sharing_media_post_types\";a:1:{i:0;s:4:\"post\";}s:26:\"follow_networks_new_window\";s:1:\"1\";s:23:\"follow_networks_use_api\";b:0;s:24:\"follow_networks_vimeo_id\";s:0:\"\";s:28:\"follow_networks_vimeo_secret\";s:0:\"\";s:27:\"follow_networks_linkedin_id\";s:0:\"\";s:31:\"follow_networks_linkedin_secret\";s:0:\"\";s:31:\"follow_networks_twitter_api_key\";s:0:\"\";s:34:\"follow_networks_twitter_api_secret\";s:0:\"\";s:29:\"follow_networks_twitter_token\";s:0:\"\";s:36:\"follow_networks_twitter_token_secret\";s:0:\"\";s:31:\"follow_networks_youtube_api_key\";s:0:\"\";s:24:\"follow_widget_icon_style\";s:5:\"slide\";s:24:\"follow_widget_icon_shape\";s:7:\"rounded\";s:28:\"follow_widget_icons_location\";s:3:\"top\";s:24:\"follow_widget_col_number\";s:1:\"2\";s:20:\"follow_widget_counts\";s:1:\"1\";s:24:\"follow_widget_counts_num\";i:0;s:19:\"follow_widget_total\";s:1:\"1\";s:27:\"follow_widget_network_names\";s:1:\"1\";s:25:\"follow_widget_outer_color\";s:4:\"dark\";s:21:\"follow_widget_spacing\";b:0;s:20:\"follow_widget_mobile\";b:0;s:27:\"follow_widget_custom_colors\";b:0;s:22:\"follow_widget_bg_color\";s:0:\"\";s:28:\"follow_widget_bg_color_hover\";s:0:\"\";s:24:\"follow_widget_icon_color\";s:0:\"\";s:30:\"follow_widget_icon_color_hover\";s:0:\"\";s:27:\"follow_shortcode_icon_style\";s:5:\"slide\";s:27:\"follow_shortcode_icon_shape\";s:7:\"rounded\";s:31:\"follow_shortcode_icons_location\";s:3:\"top\";s:27:\"follow_shortcode_col_number\";s:4:\"auto\";s:23:\"follow_shortcode_counts\";s:1:\"1\";s:27:\"follow_shortcode_counts_num\";i:0;s:22:\"follow_shortcode_total\";s:1:\"1\";s:30:\"follow_shortcode_network_names\";s:1:\"1\";s:28:\"follow_shortcode_outer_color\";s:4:\"dark\";s:24:\"follow_shortcode_spacing\";b:0;s:23:\"follow_shortcode_mobile\";b:0;s:30:\"follow_shortcode_custom_colors\";b:0;s:25:\"follow_shortcode_bg_color\";s:0:\"\";s:31:\"follow_shortcode_bg_color_hover\";s:0:\"\";s:27:\"follow_shortcode_icon_color\";s:0:\"\";s:33:\"follow_shortcode_icon_color_hover\";s:0:\"\";s:24:\"general_main_update_freq\";i:3;s:27:\"general_main_reset_postdata\";b:0;s:24:\"general_main_facebook_id\";s:0:\"\";s:28:\"general_main_facebook_secret\";s:0:\"\";s:35:\"general_main_facebook_instagram_api\";b:0;s:45:\"general_main_facebook_instagram_business_page\";s:0:\"\";s:32:\"general_main_facebook_legacy_api\";b:0;s:23:\"general_main_custom_css\";s:0:\"\";s:33:\"sharing_networks_networks_sorting\";a:3:{s:5:\"label\";a:3:{i:0;s:34:\"https://www.facebook.com/sodileve/\";i:1;s:30:\"https://twitter.com/sodileve86\";i:2;s:43:\"https://www.linkedin.com/company/sodileve86\";}s:5:\"class\";a:3:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:8:\"linkedin\";}s:8:\"username\";a:1:{i:1;s:10:\"sodileve86\";}}}", "yes");
INSERT INTO `wp_options` VALUES("468", "et_automatic_updates_options", "a:2:{s:8:\"username\";s:6:\"Piah86\";s:7:\"api_key\";s:40:\"d80707ed485a54d03feb253ec1c6863be3e18be2\";}", "no");
INSERT INTO `wp_options` VALUES("818", "woocommerce_schema_version", "430", "yes");
INSERT INTO `wp_options` VALUES("819", "woocommerce_store_address", "4, Avenue de l\'Europe", "yes");
INSERT INTO `wp_options` VALUES("820", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("814", "schema-ActionScheduler_StoreSchema", "5.0.1635408473", "yes");
INSERT INTO `wp_options` VALUES("815", "schema-ActionScheduler_LoggerSchema", "3.0.1635408473", "yes");
INSERT INTO `wp_options` VALUES("1706", "et_support_site_id", "gaBQF9WUonG+zLjP@Y*q", "yes");
INSERT INTO `wp_options` VALUES("1715", "_transient_shipping-transient-version", "1617808911", "yes");
INSERT INTO `wp_options` VALUES("645", "quadmenu_Divi", "a:514:{s:24:\"primary-menu_information\";b:0;s:19:\"primary-menu_manual\";b:0;s:19:\"primary-menu_unwrap\";b:0;s:11:\"menu_height\";s:2:\"66\";s:21:\"minimized_menu_height\";s:2:\"40\";s:8:\"viewport\";i:0;s:16:\"divi_theme_title\";s:10:\"Divi Theme\";s:16:\"divi_navbar_logo\";a:1:{s:3:\"url\";N;}s:22:\"divi_layout_breakpoint\";i:980;s:17:\"divi_layout_width\";i:0;s:26:\"divi_layout_width_selector\";s:0:\"\";s:18:\"divi_layout_sticky\";i:0;s:25:\"divi_layout_sticky_offset\";i:0;s:24:\"divi_layout_hover_effect\";s:0:\"\";s:18:\"divi_mobile_shadow\";s:4:\"hide\";s:22:\"divi_navbar_background\";s:5:\"color\";s:28:\"divi_navbar_background_color\";s:11:\"transparent\";s:25:\"divi_navbar_background_to\";s:11:\"transparent\";s:11:\"divi_navbar\";s:0:\"\";s:18:\"divi_navbar_height\";s:2:\"80\";s:17:\"divi_navbar_width\";s:3:\"260\";s:6:\"themes\";s:42:\"~\"divi\",~\"custom_theme_3\",~\"default_theme\"\";s:6:\"styles\";b:1;s:16:\"styles_normalize\";b:1;s:14:\"styles_widgets\";b:1;s:17:\"styles_pscrollbar\";b:1;s:18:\"styles_owlcarousel\";b:1;s:12:\"styles_icons\";s:9:\"dashicons\";s:6:\"gutter\";i:30;s:15:\"screen_sm_width\";i:981;s:15:\"screen_md_width\";i:1100;s:15:\"screen_lg_width\";i:1200;s:25:\"default_theme_theme_title\";s:13:\"Default Theme\";s:20:\"default_theme_layout\";s:5:\"embed\";s:36:\"default_theme_layout_offcanvas_float\";s:5:\"right\";s:26:\"default_theme_layout_align\";s:5:\"right\";s:31:\"default_theme_layout_breakpoint\";i:768;s:26:\"default_theme_layout_width\";i:0;s:32:\"default_theme_layout_width_inner\";i:0;s:41:\"default_theme_layout_width_inner_selector\";s:0:\"\";s:29:\"default_theme_layout_lazyload\";b:0;s:28:\"default_theme_layout_current\";b:0;s:28:\"default_theme_layout_divider\";s:4:\"hide\";s:26:\"default_theme_layout_caret\";s:4:\"show\";s:28:\"default_theme_layout_classes\";s:0:\"\";s:28:\"default_theme_layout_trigger\";s:11:\"hoverintent\";s:39:\"default_theme_layout_dropdown_maxheight\";b:1;s:31:\"default_theme_navbar_background\";s:5:\"color\";s:37:\"default_theme_navbar_background_color\";s:7:\"#333333\";s:34:\"default_theme_navbar_background_to\";s:7:\"#000000\";s:35:\"default_theme_navbar_background_deg\";i:17;s:25:\"default_theme_navbar_text\";s:7:\"#aaaaaa\";s:27:\"default_theme_navbar_height\";i:60;s:26:\"default_theme_navbar_width\";i:260;s:30:\"default_theme_navbar_logo_link\";s:26:\"http://localhost/SODILEVE/\";s:25:\"default_theme_navbar_logo\";a:1:{s:3:\"url\";s:85:\"http://localhost/SODILEVE/wp-content/plugins/quadmenu/assets/frontend/images/logo.png\";}s:32:\"default_theme_navbar_logo_height\";i:25;s:28:\"default_theme_navbar_logo_bg\";s:11:\"transparent\";s:32:\"default_theme_navbar_link_margin\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:32:\"default_theme_navbar_link_radius\";a:4:{s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";}s:25:\"default_theme_navbar_link\";s:7:\"#f1f1f1\";s:28:\"default_theme_navbar_link_bg\";s:11:\"transparent\";s:31:\"default_theme_navbar_link_hover\";s:7:\"#ffffff\";s:34:\"default_theme_navbar_link_bg_hover\";s:7:\"#111111\";s:28:\"default_theme_navbar_divider\";s:21:\"rgba(255,255,255,0.5)\";s:38:\"default_theme_navbar_link_hover_effect\";s:21:\"rgba(255,255,255,0.3)\";s:30:\"default_theme_navbar_link_icon\";s:7:\"#eeeeee\";s:36:\"default_theme_navbar_link_icon_hover\";s:7:\"#ffffff\";s:34:\"default_theme_navbar_link_subtitle\";s:7:\"#eeeeee\";s:40:\"default_theme_navbar_link_subtitle_hover\";s:7:\"#ffffff\";s:32:\"default_theme_navbar_badge_color\";s:7:\"#ffffff\";s:26:\"default_theme_navbar_badge\";s:7:\"#fb88dd\";s:27:\"default_theme_navbar_button\";s:7:\"#ffffff\";s:38:\"default_theme_navbar_button_background\";s:7:\"#fb88dd\";s:33:\"default_theme_navbar_button_hover\";s:7:\"#383838\";s:44:\"default_theme_navbar_button_hover_background\";s:7:\"#eeeeee\";s:34:\"default_theme_navbar_button_radius\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"2\";s:12:\"border-right\";s:1:\"2\";s:11:\"border-left\";s:1:\"2\";s:13:\"border-bottom\";s:1:\"2\";s:12:\"border-color\";s:7:\"#000000\";}s:30:\"default_theme_navbar_scrollbar\";s:7:\"#fb88dd\";s:35:\"default_theme_navbar_scrollbar_rail\";s:7:\"#ffffff\";s:27:\"default_theme_layout_sticky\";i:0;s:34:\"default_theme_layout_sticky_offset\";i:0;s:31:\"default_theme_sticky_background\";s:16:\"rgba(0,0,0,0.95)\";s:27:\"default_theme_sticky_height\";s:2:\"60\";s:32:\"default_theme_sticky_logo_height\";s:2:\"25\";s:27:\"default_theme_mobile_shadow\";s:4:\"show\";s:34:\"default_theme_navbar_mobile_border\";s:21:\"rgba(255,255,255,0.1)\";s:32:\"default_theme_navbar_toggle_open\";s:7:\"#ffffff\";s:33:\"default_theme_navbar_toggle_close\";s:7:\"#fb88dd\";s:33:\"default_theme_mobile_link_padding\";a:4:{s:10:\"border-top\";s:2:\"15\";s:12:\"border-right\";s:2:\"30\";s:11:\"border-left\";s:2:\"30\";s:13:\"border-bottom\";s:2:\"15\";}s:32:\"default_theme_mobile_link_border\";a:4:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-color\";s:11:\"transparent\";s:12:\"border-style\";s:4:\"none\";}s:29:\"default_theme_dropdown_shadow\";s:4:\"show\";s:29:\"default_theme_dropdown_margin\";i:0;s:29:\"default_theme_dropdown_radius\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:29:\"default_theme_dropdown_border\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:33:\"default_theme_dropdown_background\";s:7:\"#ffffff\";s:27:\"default_theme_dropdown_link\";s:7:\"#444444\";s:33:\"default_theme_dropdown_link_hover\";s:7:\"#333333\";s:36:\"default_theme_dropdown_link_bg_hover\";s:7:\"#f4f4f4\";s:34:\"default_theme_dropdown_link_border\";a:4:{s:10:\"border-all\";s:1:\"1\";s:10:\"border-top\";s:1:\"1\";s:12:\"border-color\";s:7:\"#f4f4f4\";s:12:\"border-style\";s:5:\"solid\";}s:28:\"default_theme_dropdown_title\";s:7:\"#444444\";s:35:\"default_theme_dropdown_title_border\";a:4:{s:10:\"border-all\";s:1:\"1\";s:10:\"border-top\";s:1:\"1\";s:12:\"border-color\";s:7:\"#fb88dd\";s:12:\"border-style\";s:5:\"solid\";}s:32:\"default_theme_dropdown_link_icon\";s:7:\"#fb88dd\";s:38:\"default_theme_dropdown_link_icon_hover\";s:7:\"#a9a9a9\";s:36:\"default_theme_dropdown_link_subtitle\";s:7:\"#a0a0a0\";s:42:\"default_theme_dropdown_link_subtitle_hover\";s:7:\"#cccccc\";s:29:\"default_theme_dropdown_button\";s:7:\"#ffffff\";s:32:\"default_theme_dropdown_button_bg\";s:7:\"#fb88dd\";s:35:\"default_theme_dropdown_button_hover\";s:7:\"#ffffff\";s:38:\"default_theme_dropdown_button_bg_hover\";s:7:\"#000000\";s:29:\"default_theme_dropdown_tab_bg\";s:16:\"rgba(0,0,0,0.05)\";s:35:\"default_theme_dropdown_tab_bg_hover\";s:15:\"rgba(0,0,0,0.1)\";s:32:\"default_theme_dropdown_scrollbar\";s:7:\"#fb88dd\";s:37:\"default_theme_dropdown_scrollbar_rail\";s:7:\"#ffffff\";s:18:\"default_theme_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:25:\"default_theme_navbar_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:35:\"default_theme_navbar_link_transform\";s:9:\"uppercase\";s:27:\"default_theme_dropdown_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:37:\"default_theme_dropdown_link_transform\";s:4:\"none\";s:33:\"default_theme_layout_hover_effect\";s:21:\"quadmenu-hover-ripple\";s:35:\"default_theme_navbar_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:39:\"default_theme_navbar_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:35:\"default_theme_navbar_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:36:\"default_theme_navbar_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:35:\"default_theme_navbar_animation_cart\";a:2:{s:7:\"options\";s:15:\"quadmenu_bounce\";s:5:\"speed\";s:5:\"t_500\";}s:30:\"default_theme_layout_animation\";a:2:{s:7:\"options\";s:12:\"quadmenu_btt\";s:5:\"speed\";s:5:\"t_300\";}s:37:\"default_theme_dropdown_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:41:\"default_theme_dropdown_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:37:\"default_theme_dropdown_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:38:\"default_theme_dropdown_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:4:\"loop\";s:5:\"speed\";s:6:\"t_1000\";}s:11:\"divi_layout\";s:8:\"collapse\";s:27:\"divi_layout_offcanvas_float\";s:5:\"right\";s:17:\"divi_layout_align\";s:5:\"right\";s:23:\"divi_layout_width_inner\";i:0;s:32:\"divi_layout_width_inner_selector\";s:0:\"\";s:20:\"divi_layout_lazyload\";b:0;s:19:\"divi_layout_current\";b:0;s:19:\"divi_layout_divider\";s:4:\"hide\";s:17:\"divi_layout_caret\";s:4:\"show\";s:19:\"divi_layout_classes\";s:0:\"\";s:19:\"divi_layout_trigger\";s:11:\"hoverintent\";s:30:\"divi_layout_dropdown_maxheight\";b:1;s:26:\"divi_navbar_background_deg\";i:17;s:16:\"divi_navbar_text\";s:7:\"#8585bd\";s:21:\"divi_navbar_logo_link\";s:26:\"http://localhost/SODILEVE/\";s:23:\"divi_navbar_logo_height\";i:43;s:19:\"divi_navbar_logo_bg\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:19:\"rgba(255,255,255,0)\";}s:23:\"divi_navbar_link_margin\";a:7:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:3:\"0px\";s:11:\"border-left\";s:3:\"0px\";s:13:\"border-bottom\";s:3:\"0px\";s:12:\"border-color\";s:0:\"\";s:12:\"border-style\";s:0:\"\";}s:23:\"divi_navbar_link_radius\";a:6:{s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:3:\"0px\";s:13:\"border-bottom\";s:3:\"0px\";s:11:\"border-left\";s:3:\"0px\";s:12:\"border-style\";s:0:\"\";s:12:\"border-color\";s:0:\"\";}s:16:\"divi_navbar_link\";s:7:\"#666666\";s:19:\"divi_navbar_link_bg\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:19:\"rgba(255,255,255,0)\";}s:22:\"divi_navbar_link_hover\";s:7:\"#949494\";s:25:\"divi_navbar_link_bg_hover\";a:3:{s:5:\"color\";s:7:\"#111111\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:16:\"rgba(17,17,17,0)\";}s:19:\"divi_navbar_divider\";s:11:\"transparent\";s:29:\"divi_navbar_link_hover_effect\";a:3:{s:5:\"color\";s:7:\"#09e1c0\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(9,225,192,1)\";}s:21:\"divi_navbar_link_icon\";s:7:\"#09e1c0\";s:27:\"divi_navbar_link_icon_hover\";s:7:\"#7272ff\";s:25:\"divi_navbar_link_subtitle\";s:7:\"#8585bd\";s:31:\"divi_navbar_link_subtitle_hover\";s:7:\"#949494\";s:23:\"divi_navbar_badge_color\";s:7:\"#ffffff\";s:17:\"divi_navbar_badge\";s:7:\"#09e1c0\";s:18:\"divi_navbar_button\";s:7:\"#ffffff\";s:29:\"divi_navbar_button_background\";s:7:\"#fb88dd\";s:24:\"divi_navbar_button_hover\";s:7:\"#ffffff\";s:35:\"divi_navbar_button_hover_background\";s:7:\"#eeeeee\";s:25:\"divi_navbar_button_radius\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"2\";s:12:\"border-right\";s:1:\"2\";s:11:\"border-left\";s:1:\"2\";s:13:\"border-bottom\";s:1:\"2\";s:12:\"border-color\";s:7:\"#000000\";}s:21:\"divi_navbar_scrollbar\";s:7:\"#09e1c0\";s:26:\"divi_navbar_scrollbar_rail\";s:7:\"#ffffff\";s:22:\"divi_sticky_background\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:19:\"rgba(255,255,255,0)\";}s:18:\"divi_sticky_height\";s:2:\"60\";s:23:\"divi_sticky_logo_height\";s:2:\"25\";s:25:\"divi_navbar_mobile_border\";s:11:\"transparent\";s:23:\"divi_navbar_toggle_open\";s:7:\"#2ea3f2\";s:24:\"divi_navbar_toggle_close\";s:7:\"#2ea3f2\";s:24:\"divi_mobile_link_padding\";a:4:{s:10:\"border-top\";s:2:\"15\";s:12:\"border-right\";s:2:\"30\";s:11:\"border-left\";s:2:\"30\";s:13:\"border-bottom\";s:2:\"15\";}s:23:\"divi_mobile_link_border\";a:4:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-color\";s:11:\"transparent\";s:12:\"border-style\";s:4:\"none\";}s:20:\"divi_dropdown_shadow\";s:4:\"show\";s:20:\"divi_dropdown_margin\";i:5;s:20:\"divi_dropdown_radius\";a:6:{s:10:\"border-all\";s:1:\"2\";s:10:\"border-top\";s:1:\"2\";s:12:\"border-right\";s:1:\"2\";s:11:\"border-left\";s:1:\"2\";s:13:\"border-bottom\";s:1:\"2\";s:12:\"border-color\";s:7:\"#000000\";}s:20:\"divi_dropdown_border\";a:7:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:12:\"border-color\";s:7:\"#000000\";s:12:\"border-style\";s:0:\"\";}s:24:\"divi_dropdown_background\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:18:\"divi_dropdown_link\";s:7:\"#666666\";s:24:\"divi_dropdown_link_hover\";s:7:\"#949494\";s:27:\"divi_dropdown_link_bg_hover\";a:3:{s:5:\"color\";s:7:\"#f4f4f4\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(244,244,244,1)\";}s:25:\"divi_dropdown_link_border\";a:6:{s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:3:\"0px\";s:13:\"border-bottom\";s:3:\"0px\";s:11:\"border-left\";s:3:\"0px\";s:12:\"border-style\";s:4:\"none\";s:12:\"border-color\";s:7:\"#f4f4f4\";}s:19:\"divi_dropdown_title\";s:7:\"#2e2545\";s:26:\"divi_dropdown_title_border\";a:6:{s:10:\"border-top\";s:3:\"1px\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:7:\"#09e1c0\";}s:23:\"divi_dropdown_link_icon\";s:7:\"#09e1c0\";s:29:\"divi_dropdown_link_icon_hover\";s:7:\"#7272ff\";s:27:\"divi_dropdown_link_subtitle\";s:7:\"#8585bd\";s:33:\"divi_dropdown_link_subtitle_hover\";s:7:\"#949494\";s:20:\"divi_dropdown_button\";s:7:\"#ffffff\";s:23:\"divi_dropdown_button_bg\";s:7:\"#09e1c0\";s:26:\"divi_dropdown_button_hover\";s:7:\"#ffffff\";s:29:\"divi_dropdown_button_bg_hover\";s:7:\"#7272ff\";s:20:\"divi_dropdown_tab_bg\";s:16:\"rgba(0,0,0,0.05)\";s:26:\"divi_dropdown_tab_bg_hover\";s:15:\"rgba(0,0,0,0.1)\";s:23:\"divi_dropdown_scrollbar\";s:7:\"#09e1c0\";s:28:\"divi_dropdown_scrollbar_rail\";s:7:\"#ffffff\";s:9:\"divi_font\";a:8:{s:11:\"font-family\";s:9:\"Open Sans\";s:9:\"font-size\";s:4:\"14px\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:7:\"subsets\";s:0:\"\";}s:16:\"divi_navbar_font\";a:8:{s:11:\"font-family\";s:9:\"Open Sans\";s:9:\"font-size\";s:4:\"14px\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"600\";s:14:\"letter-spacing\";s:7:\"inherit\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:7:\"subsets\";s:0:\"\";}s:26:\"divi_navbar_link_transform\";s:4:\"none\";s:18:\"divi_dropdown_font\";a:8:{s:11:\"font-family\";s:9:\"Open Sans\";s:9:\"font-size\";s:4:\"14px\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"600\";s:14:\"letter-spacing\";s:7:\"inherit\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:7:\"subsets\";s:0:\"\";}s:28:\"divi_dropdown_link_transform\";s:4:\"none\";s:26:\"divi_navbar_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:30:\"divi_navbar_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:26:\"divi_navbar_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:27:\"divi_navbar_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:26:\"divi_navbar_animation_cart\";a:2:{s:7:\"options\";s:15:\"quadmenu_bounce\";s:5:\"speed\";s:5:\"t_500\";}s:21:\"divi_layout_animation\";s:12:\"quadmenu_btt\";s:28:\"divi_dropdown_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:32:\"divi_dropdown_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:28:\"divi_dropdown_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:29:\"divi_dropdown_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:4:\"loop\";s:5:\"speed\";s:6:\"t_1000\";}s:3:\"css\";s:0:\"\";s:24:\"primary-menu_integration\";b:1;s:18:\"primary-menu_theme\";s:4:\"divi\";s:26:\"secondary-menu_integration\";i:0;s:21:\"secondary-menu_unwrap\";i:0;s:20:\"secondary-menu_theme\";s:13:\"default_theme\";s:23:\"footer-menu_integration\";i:0;s:18:\"footer-menu_unwrap\";i:0;s:17:\"footer-menu_theme\";s:13:\"default_theme\";s:15:\"quadmenu_themes\";a:1:{s:14:\"custom_theme_3\";s:14:\"Custom Theme 3\";}s:26:\"custom_theme_1_theme_title\";s:14:\"Custom Theme 1\";s:21:\"custom_theme_1_layout\";s:5:\"embed\";s:37:\"custom_theme_1_layout_offcanvas_float\";s:5:\"right\";s:27:\"custom_theme_1_layout_align\";s:5:\"right\";s:32:\"custom_theme_1_layout_breakpoint\";i:768;s:27:\"custom_theme_1_layout_width\";i:0;s:33:\"custom_theme_1_layout_width_inner\";i:0;s:42:\"custom_theme_1_layout_width_inner_selector\";s:0:\"\";s:30:\"custom_theme_1_layout_lazyload\";b:0;s:29:\"custom_theme_1_layout_current\";b:0;s:29:\"custom_theme_1_layout_divider\";s:4:\"hide\";s:27:\"custom_theme_1_layout_caret\";s:4:\"show\";s:29:\"custom_theme_1_layout_classes\";s:0:\"\";s:29:\"custom_theme_1_layout_trigger\";s:11:\"hoverintent\";s:40:\"custom_theme_1_layout_dropdown_maxheight\";b:1;s:32:\"custom_theme_1_navbar_background\";s:5:\"color\";s:38:\"custom_theme_1_navbar_background_color\";s:7:\"#333333\";s:35:\"custom_theme_1_navbar_background_to\";s:7:\"#000000\";s:36:\"custom_theme_1_navbar_background_deg\";i:17;s:26:\"custom_theme_1_navbar_text\";s:7:\"#aaaaaa\";s:28:\"custom_theme_1_navbar_height\";i:60;s:27:\"custom_theme_1_navbar_width\";i:260;s:31:\"custom_theme_1_navbar_logo_link\";s:26:\"http://localhost/SODILEVE/\";s:26:\"custom_theme_1_navbar_logo\";a:1:{s:3:\"url\";s:85:\"http://localhost/SODILEVE/wp-content/plugins/quadmenu/assets/frontend/images/logo.png\";}s:33:\"custom_theme_1_navbar_logo_height\";i:25;s:29:\"custom_theme_1_navbar_logo_bg\";s:11:\"transparent\";s:33:\"custom_theme_1_navbar_link_margin\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:33:\"custom_theme_1_navbar_link_radius\";a:4:{s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";}s:26:\"custom_theme_1_navbar_link\";s:7:\"#f1f1f1\";s:29:\"custom_theme_1_navbar_link_bg\";s:11:\"transparent\";s:32:\"custom_theme_1_navbar_link_hover\";s:7:\"#ffffff\";s:35:\"custom_theme_1_navbar_link_bg_hover\";s:7:\"#111111\";s:29:\"custom_theme_1_navbar_divider\";s:21:\"rgba(255,255,255,0.5)\";s:39:\"custom_theme_1_navbar_link_hover_effect\";s:21:\"rgba(255,255,255,0.3)\";s:31:\"custom_theme_1_navbar_link_icon\";s:7:\"#eeeeee\";s:37:\"custom_theme_1_navbar_link_icon_hover\";s:7:\"#ffffff\";s:35:\"custom_theme_1_navbar_link_subtitle\";s:7:\"#eeeeee\";s:41:\"custom_theme_1_navbar_link_subtitle_hover\";s:7:\"#ffffff\";s:33:\"custom_theme_1_navbar_badge_color\";s:7:\"#ffffff\";s:27:\"custom_theme_1_navbar_badge\";s:7:\"#fb88dd\";s:28:\"custom_theme_1_navbar_button\";s:7:\"#ffffff\";s:39:\"custom_theme_1_navbar_button_background\";s:7:\"#fb88dd\";s:34:\"custom_theme_1_navbar_button_hover\";s:7:\"#383838\";s:45:\"custom_theme_1_navbar_button_hover_background\";s:7:\"#eeeeee\";s:35:\"custom_theme_1_navbar_button_radius\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"2\";s:12:\"border-right\";s:1:\"2\";s:11:\"border-left\";s:1:\"2\";s:13:\"border-bottom\";s:1:\"2\";s:12:\"border-color\";s:7:\"#000000\";}s:31:\"custom_theme_1_navbar_scrollbar\";s:7:\"#fb88dd\";s:36:\"custom_theme_1_navbar_scrollbar_rail\";s:7:\"#ffffff\";s:28:\"custom_theme_1_layout_sticky\";i:0;s:35:\"custom_theme_1_layout_sticky_offset\";i:0;s:32:\"custom_theme_1_sticky_background\";s:16:\"rgba(0,0,0,0.95)\";s:28:\"custom_theme_1_sticky_height\";s:2:\"60\";s:33:\"custom_theme_1_sticky_logo_height\";s:2:\"25\";s:28:\"custom_theme_1_mobile_shadow\";s:4:\"show\";s:35:\"custom_theme_1_navbar_mobile_border\";s:21:\"rgba(255,255,255,0.1)\";s:33:\"custom_theme_1_navbar_toggle_open\";s:7:\"#ffffff\";s:34:\"custom_theme_1_navbar_toggle_close\";s:7:\"#fb88dd\";s:34:\"custom_theme_1_mobile_link_padding\";a:4:{s:10:\"border-top\";s:2:\"15\";s:12:\"border-right\";s:2:\"30\";s:11:\"border-left\";s:2:\"30\";s:13:\"border-bottom\";s:2:\"15\";}s:33:\"custom_theme_1_mobile_link_border\";a:4:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-color\";s:11:\"transparent\";s:12:\"border-style\";s:4:\"none\";}s:30:\"custom_theme_1_dropdown_shadow\";s:4:\"show\";s:30:\"custom_theme_1_dropdown_margin\";i:0;s:30:\"custom_theme_1_dropdown_radius\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:30:\"custom_theme_1_dropdown_border\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:34:\"custom_theme_1_dropdown_background\";s:7:\"#ffffff\";s:28:\"custom_theme_1_dropdown_link\";s:7:\"#444444\";s:34:\"custom_theme_1_dropdown_link_hover\";s:7:\"#333333\";s:37:\"custom_theme_1_dropdown_link_bg_hover\";s:7:\"#f4f4f4\";s:35:\"custom_theme_1_dropdown_link_border\";a:4:{s:10:\"border-all\";s:1:\"1\";s:10:\"border-top\";s:1:\"1\";s:12:\"border-color\";s:7:\"#f4f4f4\";s:12:\"border-style\";s:5:\"solid\";}s:29:\"custom_theme_1_dropdown_title\";s:7:\"#444444\";s:36:\"custom_theme_1_dropdown_title_border\";a:4:{s:10:\"border-all\";s:1:\"1\";s:10:\"border-top\";s:1:\"1\";s:12:\"border-color\";s:7:\"#fb88dd\";s:12:\"border-style\";s:5:\"solid\";}s:33:\"custom_theme_1_dropdown_link_icon\";s:7:\"#fb88dd\";s:39:\"custom_theme_1_dropdown_link_icon_hover\";s:7:\"#a9a9a9\";s:37:\"custom_theme_1_dropdown_link_subtitle\";s:7:\"#a0a0a0\";s:43:\"custom_theme_1_dropdown_link_subtitle_hover\";s:7:\"#cccccc\";s:30:\"custom_theme_1_dropdown_button\";s:7:\"#ffffff\";s:33:\"custom_theme_1_dropdown_button_bg\";s:7:\"#fb88dd\";s:36:\"custom_theme_1_dropdown_button_hover\";s:7:\"#ffffff\";s:39:\"custom_theme_1_dropdown_button_bg_hover\";s:7:\"#000000\";s:30:\"custom_theme_1_dropdown_tab_bg\";s:16:\"rgba(0,0,0,0.05)\";s:36:\"custom_theme_1_dropdown_tab_bg_hover\";s:15:\"rgba(0,0,0,0.1)\";s:33:\"custom_theme_1_dropdown_scrollbar\";s:7:\"#fb88dd\";s:38:\"custom_theme_1_dropdown_scrollbar_rail\";s:7:\"#ffffff\";s:19:\"custom_theme_1_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:26:\"custom_theme_1_navbar_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:36:\"custom_theme_1_navbar_link_transform\";s:9:\"uppercase\";s:28:\"custom_theme_1_dropdown_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:38:\"custom_theme_1_dropdown_link_transform\";s:4:\"none\";s:34:\"custom_theme_1_layout_hover_effect\";s:21:\"quadmenu-hover-ripple\";s:36:\"custom_theme_1_navbar_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:40:\"custom_theme_1_navbar_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:36:\"custom_theme_1_navbar_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:37:\"custom_theme_1_navbar_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:36:\"custom_theme_1_navbar_animation_cart\";a:2:{s:7:\"options\";s:15:\"quadmenu_bounce\";s:5:\"speed\";s:5:\"t_500\";}s:31:\"custom_theme_1_layout_animation\";a:2:{s:7:\"options\";s:12:\"quadmenu_btt\";s:5:\"speed\";s:5:\"t_300\";}s:38:\"custom_theme_1_dropdown_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:42:\"custom_theme_1_dropdown_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:38:\"custom_theme_1_dropdown_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:39:\"custom_theme_1_dropdown_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:4:\"loop\";s:5:\"speed\";s:6:\"t_1000\";}s:26:\"custom_theme_2_theme_title\";s:14:\"Custom Theme 2\";s:21:\"custom_theme_2_layout\";s:5:\"embed\";s:37:\"custom_theme_2_layout_offcanvas_float\";s:5:\"right\";s:27:\"custom_theme_2_layout_align\";s:5:\"right\";s:32:\"custom_theme_2_layout_breakpoint\";i:768;s:27:\"custom_theme_2_layout_width\";i:0;s:33:\"custom_theme_2_layout_width_inner\";i:0;s:42:\"custom_theme_2_layout_width_inner_selector\";s:0:\"\";s:30:\"custom_theme_2_layout_lazyload\";b:0;s:29:\"custom_theme_2_layout_current\";b:0;s:29:\"custom_theme_2_layout_divider\";s:4:\"hide\";s:27:\"custom_theme_2_layout_caret\";s:4:\"show\";s:29:\"custom_theme_2_layout_classes\";s:0:\"\";s:29:\"custom_theme_2_layout_trigger\";s:11:\"hoverintent\";s:40:\"custom_theme_2_layout_dropdown_maxheight\";b:1;s:32:\"custom_theme_2_navbar_background\";s:5:\"color\";s:38:\"custom_theme_2_navbar_background_color\";s:7:\"#333333\";s:35:\"custom_theme_2_navbar_background_to\";s:7:\"#000000\";s:36:\"custom_theme_2_navbar_background_deg\";i:17;s:26:\"custom_theme_2_navbar_text\";s:7:\"#aaaaaa\";s:28:\"custom_theme_2_navbar_height\";i:60;s:27:\"custom_theme_2_navbar_width\";i:260;s:31:\"custom_theme_2_navbar_logo_link\";s:26:\"http://localhost/SODILEVE/\";s:26:\"custom_theme_2_navbar_logo\";a:1:{s:3:\"url\";s:85:\"http://localhost/SODILEVE/wp-content/plugins/quadmenu/assets/frontend/images/logo.png\";}s:33:\"custom_theme_2_navbar_logo_height\";i:25;s:29:\"custom_theme_2_navbar_logo_bg\";s:11:\"transparent\";s:33:\"custom_theme_2_navbar_link_margin\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:33:\"custom_theme_2_navbar_link_radius\";a:4:{s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";}s:26:\"custom_theme_2_navbar_link\";s:7:\"#f1f1f1\";s:29:\"custom_theme_2_navbar_link_bg\";s:11:\"transparent\";s:32:\"custom_theme_2_navbar_link_hover\";s:7:\"#ffffff\";s:35:\"custom_theme_2_navbar_link_bg_hover\";s:7:\"#111111\";s:29:\"custom_theme_2_navbar_divider\";s:21:\"rgba(255,255,255,0.5)\";s:39:\"custom_theme_2_navbar_link_hover_effect\";s:21:\"rgba(255,255,255,0.3)\";s:31:\"custom_theme_2_navbar_link_icon\";s:7:\"#eeeeee\";s:37:\"custom_theme_2_navbar_link_icon_hover\";s:7:\"#ffffff\";s:35:\"custom_theme_2_navbar_link_subtitle\";s:7:\"#eeeeee\";s:41:\"custom_theme_2_navbar_link_subtitle_hover\";s:7:\"#ffffff\";s:33:\"custom_theme_2_navbar_badge_color\";s:7:\"#ffffff\";s:27:\"custom_theme_2_navbar_badge\";s:7:\"#fb88dd\";s:28:\"custom_theme_2_navbar_button\";s:7:\"#ffffff\";s:39:\"custom_theme_2_navbar_button_background\";s:7:\"#fb88dd\";s:34:\"custom_theme_2_navbar_button_hover\";s:7:\"#383838\";s:45:\"custom_theme_2_navbar_button_hover_background\";s:7:\"#eeeeee\";s:35:\"custom_theme_2_navbar_button_radius\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"2\";s:12:\"border-right\";s:1:\"2\";s:11:\"border-left\";s:1:\"2\";s:13:\"border-bottom\";s:1:\"2\";s:12:\"border-color\";s:7:\"#000000\";}s:31:\"custom_theme_2_navbar_scrollbar\";s:7:\"#fb88dd\";s:36:\"custom_theme_2_navbar_scrollbar_rail\";s:7:\"#ffffff\";s:28:\"custom_theme_2_layout_sticky\";i:0;s:35:\"custom_theme_2_layout_sticky_offset\";i:0;s:32:\"custom_theme_2_sticky_background\";s:16:\"rgba(0,0,0,0.95)\";s:28:\"custom_theme_2_sticky_height\";s:2:\"60\";s:33:\"custom_theme_2_sticky_logo_height\";s:2:\"25\";s:28:\"custom_theme_2_mobile_shadow\";s:4:\"show\";s:35:\"custom_theme_2_navbar_mobile_border\";s:21:\"rgba(255,255,255,0.1)\";s:33:\"custom_theme_2_navbar_toggle_open\";s:7:\"#ffffff\";s:34:\"custom_theme_2_navbar_toggle_close\";s:7:\"#fb88dd\";s:34:\"custom_theme_2_mobile_link_padding\";a:4:{s:10:\"border-top\";s:2:\"15\";s:12:\"border-right\";s:2:\"30\";s:11:\"border-left\";s:2:\"30\";s:13:\"border-bottom\";s:2:\"15\";}s:33:\"custom_theme_2_mobile_link_border\";a:4:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-color\";s:11:\"transparent\";s:12:\"border-style\";s:4:\"none\";}s:30:\"custom_theme_2_dropdown_shadow\";s:4:\"show\";s:30:\"custom_theme_2_dropdown_margin\";i:0;s:30:\"custom_theme_2_dropdown_radius\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:30:\"custom_theme_2_dropdown_border\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:34:\"custom_theme_2_dropdown_background\";s:7:\"#ffffff\";s:28:\"custom_theme_2_dropdown_link\";s:7:\"#444444\";s:34:\"custom_theme_2_dropdown_link_hover\";s:7:\"#333333\";s:37:\"custom_theme_2_dropdown_link_bg_hover\";s:7:\"#f4f4f4\";s:35:\"custom_theme_2_dropdown_link_border\";a:4:{s:10:\"border-all\";s:1:\"1\";s:10:\"border-top\";s:1:\"1\";s:12:\"border-color\";s:7:\"#f4f4f4\";s:12:\"border-style\";s:5:\"solid\";}s:29:\"custom_theme_2_dropdown_title\";s:7:\"#444444\";s:36:\"custom_theme_2_dropdown_title_border\";a:4:{s:10:\"border-all\";s:1:\"1\";s:10:\"border-top\";s:1:\"1\";s:12:\"border-color\";s:7:\"#fb88dd\";s:12:\"border-style\";s:5:\"solid\";}s:33:\"custom_theme_2_dropdown_link_icon\";s:7:\"#fb88dd\";s:39:\"custom_theme_2_dropdown_link_icon_hover\";s:7:\"#a9a9a9\";s:37:\"custom_theme_2_dropdown_link_subtitle\";s:7:\"#a0a0a0\";s:43:\"custom_theme_2_dropdown_link_subtitle_hover\";s:7:\"#cccccc\";s:30:\"custom_theme_2_dropdown_button\";s:7:\"#ffffff\";s:33:\"custom_theme_2_dropdown_button_bg\";s:7:\"#fb88dd\";s:36:\"custom_theme_2_dropdown_button_hover\";s:7:\"#ffffff\";s:39:\"custom_theme_2_dropdown_button_bg_hover\";s:7:\"#000000\";s:30:\"custom_theme_2_dropdown_tab_bg\";s:16:\"rgba(0,0,0,0.05)\";s:36:\"custom_theme_2_dropdown_tab_bg_hover\";s:15:\"rgba(0,0,0,0.1)\";s:33:\"custom_theme_2_dropdown_scrollbar\";s:7:\"#fb88dd\";s:38:\"custom_theme_2_dropdown_scrollbar_rail\";s:7:\"#ffffff\";s:19:\"custom_theme_2_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:26:\"custom_theme_2_navbar_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:36:\"custom_theme_2_navbar_link_transform\";s:9:\"uppercase\";s:28:\"custom_theme_2_dropdown_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:38:\"custom_theme_2_dropdown_link_transform\";s:4:\"none\";s:34:\"custom_theme_2_layout_hover_effect\";s:21:\"quadmenu-hover-ripple\";s:36:\"custom_theme_2_navbar_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:40:\"custom_theme_2_navbar_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:36:\"custom_theme_2_navbar_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:37:\"custom_theme_2_navbar_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:36:\"custom_theme_2_navbar_animation_cart\";a:2:{s:7:\"options\";s:15:\"quadmenu_bounce\";s:5:\"speed\";s:5:\"t_500\";}s:31:\"custom_theme_2_layout_animation\";a:2:{s:7:\"options\";s:12:\"quadmenu_btt\";s:5:\"speed\";s:5:\"t_300\";}s:38:\"custom_theme_2_dropdown_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:42:\"custom_theme_2_dropdown_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:38:\"custom_theme_2_dropdown_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:39:\"custom_theme_2_dropdown_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:4:\"loop\";s:5:\"speed\";s:6:\"t_1000\";}s:26:\"custom_theme_3_theme_title\";s:14:\"Custom Theme 3\";s:21:\"custom_theme_3_layout\";s:5:\"embed\";s:37:\"custom_theme_3_layout_offcanvas_float\";s:5:\"right\";s:27:\"custom_theme_3_layout_align\";s:5:\"right\";s:32:\"custom_theme_3_layout_breakpoint\";i:768;s:27:\"custom_theme_3_layout_width\";i:0;s:33:\"custom_theme_3_layout_width_inner\";i:0;s:42:\"custom_theme_3_layout_width_inner_selector\";s:0:\"\";s:30:\"custom_theme_3_layout_lazyload\";b:0;s:29:\"custom_theme_3_layout_current\";b:0;s:29:\"custom_theme_3_layout_divider\";s:4:\"hide\";s:27:\"custom_theme_3_layout_caret\";s:4:\"show\";s:29:\"custom_theme_3_layout_classes\";s:0:\"\";s:29:\"custom_theme_3_layout_trigger\";s:11:\"hoverintent\";s:40:\"custom_theme_3_layout_dropdown_maxheight\";b:1;s:32:\"custom_theme_3_navbar_background\";s:5:\"color\";s:38:\"custom_theme_3_navbar_background_color\";s:7:\"#333333\";s:35:\"custom_theme_3_navbar_background_to\";s:7:\"#000000\";s:36:\"custom_theme_3_navbar_background_deg\";i:17;s:26:\"custom_theme_3_navbar_text\";s:7:\"#aaaaaa\";s:28:\"custom_theme_3_navbar_height\";i:60;s:27:\"custom_theme_3_navbar_width\";i:260;s:31:\"custom_theme_3_navbar_logo_link\";s:26:\"http://localhost/SODILEVE/\";s:26:\"custom_theme_3_navbar_logo\";a:1:{s:3:\"url\";s:85:\"http://localhost/SODILEVE/wp-content/plugins/quadmenu/assets/frontend/images/logo.png\";}s:33:\"custom_theme_3_navbar_logo_height\";i:25;s:29:\"custom_theme_3_navbar_logo_bg\";s:11:\"transparent\";s:33:\"custom_theme_3_navbar_link_margin\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:33:\"custom_theme_3_navbar_link_radius\";a:4:{s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";}s:26:\"custom_theme_3_navbar_link\";s:7:\"#f1f1f1\";s:29:\"custom_theme_3_navbar_link_bg\";s:11:\"transparent\";s:32:\"custom_theme_3_navbar_link_hover\";s:7:\"#ffffff\";s:35:\"custom_theme_3_navbar_link_bg_hover\";s:7:\"#111111\";s:29:\"custom_theme_3_navbar_divider\";s:21:\"rgba(255,255,255,0.5)\";s:39:\"custom_theme_3_navbar_link_hover_effect\";s:21:\"rgba(255,255,255,0.3)\";s:31:\"custom_theme_3_navbar_link_icon\";s:7:\"#eeeeee\";s:37:\"custom_theme_3_navbar_link_icon_hover\";s:7:\"#ffffff\";s:35:\"custom_theme_3_navbar_link_subtitle\";s:7:\"#eeeeee\";s:41:\"custom_theme_3_navbar_link_subtitle_hover\";s:7:\"#ffffff\";s:33:\"custom_theme_3_navbar_badge_color\";s:7:\"#ffffff\";s:27:\"custom_theme_3_navbar_badge\";s:7:\"#fb88dd\";s:28:\"custom_theme_3_navbar_button\";s:7:\"#ffffff\";s:39:\"custom_theme_3_navbar_button_background\";s:7:\"#fb88dd\";s:34:\"custom_theme_3_navbar_button_hover\";s:7:\"#383838\";s:45:\"custom_theme_3_navbar_button_hover_background\";s:7:\"#eeeeee\";s:35:\"custom_theme_3_navbar_button_radius\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"2\";s:12:\"border-right\";s:1:\"2\";s:11:\"border-left\";s:1:\"2\";s:13:\"border-bottom\";s:1:\"2\";s:12:\"border-color\";s:7:\"#000000\";}s:31:\"custom_theme_3_navbar_scrollbar\";s:7:\"#fb88dd\";s:36:\"custom_theme_3_navbar_scrollbar_rail\";s:7:\"#ffffff\";s:28:\"custom_theme_3_layout_sticky\";i:0;s:35:\"custom_theme_3_layout_sticky_offset\";i:0;s:32:\"custom_theme_3_sticky_background\";s:16:\"rgba(0,0,0,0.95)\";s:28:\"custom_theme_3_sticky_height\";s:2:\"60\";s:33:\"custom_theme_3_sticky_logo_height\";s:2:\"25\";s:28:\"custom_theme_3_mobile_shadow\";s:4:\"show\";s:35:\"custom_theme_3_navbar_mobile_border\";s:21:\"rgba(255,255,255,0.1)\";s:33:\"custom_theme_3_navbar_toggle_open\";s:7:\"#ffffff\";s:34:\"custom_theme_3_navbar_toggle_close\";s:7:\"#fb88dd\";s:34:\"custom_theme_3_mobile_link_padding\";a:4:{s:10:\"border-top\";s:2:\"15\";s:12:\"border-right\";s:2:\"30\";s:11:\"border-left\";s:2:\"30\";s:13:\"border-bottom\";s:2:\"15\";}s:33:\"custom_theme_3_mobile_link_border\";a:4:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-color\";s:11:\"transparent\";s:12:\"border-style\";s:4:\"none\";}s:30:\"custom_theme_3_dropdown_shadow\";s:4:\"show\";s:30:\"custom_theme_3_dropdown_margin\";i:0;s:30:\"custom_theme_3_dropdown_radius\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:30:\"custom_theme_3_dropdown_border\";a:6:{s:10:\"border-all\";s:1:\"0\";s:10:\"border-top\";s:1:\"0\";s:12:\"border-right\";s:1:\"0\";s:11:\"border-left\";s:1:\"0\";s:13:\"border-bottom\";s:1:\"0\";s:12:\"border-color\";s:7:\"#000000\";}s:34:\"custom_theme_3_dropdown_background\";s:7:\"#ffffff\";s:28:\"custom_theme_3_dropdown_link\";s:7:\"#444444\";s:34:\"custom_theme_3_dropdown_link_hover\";s:7:\"#333333\";s:37:\"custom_theme_3_dropdown_link_bg_hover\";s:7:\"#f4f4f4\";s:35:\"custom_theme_3_dropdown_link_border\";a:4:{s:10:\"border-all\";s:1:\"1\";s:10:\"border-top\";s:1:\"1\";s:12:\"border-color\";s:7:\"#f4f4f4\";s:12:\"border-style\";s:5:\"solid\";}s:29:\"custom_theme_3_dropdown_title\";s:7:\"#444444\";s:36:\"custom_theme_3_dropdown_title_border\";a:4:{s:10:\"border-all\";s:1:\"1\";s:10:\"border-top\";s:1:\"1\";s:12:\"border-color\";s:7:\"#fb88dd\";s:12:\"border-style\";s:5:\"solid\";}s:33:\"custom_theme_3_dropdown_link_icon\";s:7:\"#fb88dd\";s:39:\"custom_theme_3_dropdown_link_icon_hover\";s:7:\"#a9a9a9\";s:37:\"custom_theme_3_dropdown_link_subtitle\";s:7:\"#a0a0a0\";s:43:\"custom_theme_3_dropdown_link_subtitle_hover\";s:7:\"#cccccc\";s:30:\"custom_theme_3_dropdown_button\";s:7:\"#ffffff\";s:33:\"custom_theme_3_dropdown_button_bg\";s:7:\"#fb88dd\";s:36:\"custom_theme_3_dropdown_button_hover\";s:7:\"#ffffff\";s:39:\"custom_theme_3_dropdown_button_bg_hover\";s:7:\"#000000\";s:30:\"custom_theme_3_dropdown_tab_bg\";s:16:\"rgba(0,0,0,0.05)\";s:36:\"custom_theme_3_dropdown_tab_bg_hover\";s:15:\"rgba(0,0,0,0.1)\";s:33:\"custom_theme_3_dropdown_scrollbar\";s:7:\"#fb88dd\";s:38:\"custom_theme_3_dropdown_scrollbar_rail\";s:7:\"#ffffff\";s:19:\"custom_theme_3_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:26:\"custom_theme_3_navbar_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:36:\"custom_theme_3_navbar_link_transform\";s:9:\"uppercase\";s:28:\"custom_theme_3_dropdown_font\";a:5:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:9:\"font-size\";s:2:\"11\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:38:\"custom_theme_3_dropdown_link_transform\";s:4:\"none\";s:34:\"custom_theme_3_layout_hover_effect\";s:21:\"quadmenu-hover-ripple\";s:36:\"custom_theme_3_navbar_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:40:\"custom_theme_3_navbar_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:36:\"custom_theme_3_navbar_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:37:\"custom_theme_3_navbar_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:36:\"custom_theme_3_navbar_animation_cart\";a:2:{s:7:\"options\";s:15:\"quadmenu_bounce\";s:5:\"speed\";s:5:\"t_500\";}s:31:\"custom_theme_3_layout_animation\";a:2:{s:7:\"options\";s:12:\"quadmenu_btt\";s:5:\"speed\";s:5:\"t_300\";}s:38:\"custom_theme_3_dropdown_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:42:\"custom_theme_3_dropdown_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:38:\"custom_theme_3_dropdown_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:39:\"custom_theme_3_dropdown_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:4:\"loop\";s:5:\"speed\";s:6:\"t_1000\";}}", "yes");
INSERT INTO `wp_options` VALUES("438", "ast-block-templates-sites-1", "a:54:{s:8:\"id-49936\";a:12:{s:5:\"title\";s:11:\"Recipe Blog\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-homepage.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-homepage-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-homepage-400x922.jpg\";s:14:\"astra-site-url\";s:33:\"//websitedemos.net/recipe-blog-08\";s:20:\"astra-site-parent-id\";i:1858;s:15:\"astra-sites-tag\";a:5:{i:792;s:7:\"cooking\";i:787;s:6:\"dinner\";i:336;s:4:\"food\";i:793;s:11:\"food-making\";i:788;s:5:\"snack\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:37;s:4:\"blog\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-49937\";a:12:{s:5:\"title\";s:8:\"About Me\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-about-me.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-about-me-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/recipe-blog-08/wp-json/wp/v2/pages/1071\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/recipe-blog-08/about-me/\";s:15:\"astra-sites-tag\";a:1:{i:1007;s:8:\"about-me\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-49938\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-blog.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-blog-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/recipe-blog-08/wp-json/wp/v2/pages/1067\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/recipe-blog-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-49939\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/recipe-blog-08/wp-json/wp/v2/pages/1074\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/recipe-blog-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-49940\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-homepage.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/02/recipe-blog-08-homepage-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/recipe-blog-08/wp-json/wp/v2/pages/1055\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/recipe-blog-08/home/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48078\";a:12:{s:5:\"title\";s:17:\"Outdoor Adventure\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home-400x956.jpg\";s:14:\"astra-site-url\";s:39:\"//websitedemos.net/outdoor-adventure-08\";s:20:\"astra-site-parent-id\";i:1698;s:15:\"astra-sites-tag\";a:6:{i:544;s:9:\"adventure\";i:545;s:7:\"camping\";i:543;s:14:\"extreme-sports\";i:541;s:9:\"mountains\";i:542;s:4:\"park\";i:546;s:6:\"sports\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48081\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/outdoor-adventure-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48079\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-about.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/outdoor-adventure-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48083\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-services.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/8\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/outdoor-adventure-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48082\";a:12:{s:5:\"title\";s:8:\"Projects\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-projects.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-projects-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/outdoor-adventure-08/projects/\";s:15:\"astra-sites-tag\";a:1:{i:1613;s:8:\"projects\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48080\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/outdoor-adventure-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/outdoor-adventure-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/outdoor-adventure-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48348\";a:12:{s:5:\"title\";s:8:\"Mountain\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-400x983.jpg\";s:14:\"astra-site-url\";s:30:\"//websitedemos.net/mountain-08\";s:20:\"astra-site-parent-id\";i:1724;s:15:\"astra-sites-tag\";a:4:{i:692;s:8:\"business\";i:1525;s:8:\"mountain\";i:1526;s:13:\"multi-purpose\";i:535;s:6:\"nature\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48349\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-about.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/mountain-08/wp-json/wp/v2/pages/218\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/mountain-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48350\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/mountain-08/wp-json/wp/v2/pages/220\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/mountain-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48351\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/mountain-08/wp-json/wp/v2/pages/217\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:31:\"//websitedemos.net/mountain-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48352\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-services.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/mountain-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/mountain-08/wp-json/wp/v2/pages/219\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/mountain-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48121\";a:12:{s:5:\"title\";s:13:\"Organic Store\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-homepage-gb-400x1197.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/organic-shop-08\";s:20:\"astra-site-parent-id\";i:1702;s:15:\"astra-sites-tag\";a:6:{i:496;s:9:\"ecommerce\";i:369;s:7:\"natural\";i:368;s:7:\"organic\";i:967;s:13:\"product-store\";i:733;s:4:\"shop\";i:1024;s:11:\"woocommerce\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:11:\"woocommerce\";s:4:\"init\";s:27:\"woocommerce/woocommerce.php\";s:4:\"name\";s:11:\"WooCommerce\";}i:3;a:3:{s:4:\"slug\";s:29:\"woo-cart-abandonment-recovery\";s:4:\"init\";s:63:\"woo-cart-abandonment-recovery/woo-cart-abandonment-recovery.php\";s:4:\"name\";s:37:\"WooCommerce Cart Abandonment Recovery\";}}s:5:\"pages\";a:3:{s:8:\"id-48124\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/organic-shop-08/wp-json/wp/v2/pages/3610\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/organic-shop-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48122\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/organic-shop-08/wp-json/wp/v2/pages/3612\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/organic-shop-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48123\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/organic-shop-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/organic-shop-08/wp-json/wp/v2/pages/3614\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/organic-shop-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-47984\";a:12:{s:5:\"title\";s:17:\"LearnDash Academy\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1-400x1242.jpg\";s:14:\"astra-site-url\";s:39:\"//websitedemos.net/learndash-academy-08\";s:20:\"astra-site-parent-id\";i:1691;s:15:\"astra-sites-tag\";a:5:{i:462;s:7:\"courses\";i:468;s:9:\"elearning\";i:467;s:9:\"learndash\";i:460;s:8:\"learning\";i:466;s:14:\"online-courses\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:2;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:3;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47988\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-home-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/learndash-academy-08/wp-json/wp/v2/pages/25407\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/learndash-academy-08/\";s:15:\"astra-sites-tag\";a:2:{i:423;s:4:\"home\";i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47986\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-courses-1.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-courses-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/learndash-academy-08/wp-json/wp/v2/pages/25403\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:52:\"//websitedemos.net/learndash-academy-08/all-courses/\";s:15:\"astra-sites-tag\";a:2:{i:1692;s:11:\"all-courses\";i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47985\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-about-1.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-about-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/learndash-academy-08/wp-json/wp/v2/pages/25401\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/learndash-academy-08/about/\";s:15:\"astra-sites-tag\";a:2:{i:352;s:5:\"about\";i:455;s:8:\"about-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47987\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-contact-1.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/learndash-academy-08-contact-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/learndash-academy-08/wp-json/wp/v2/pages/25405\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/learndash-academy-08/contact/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:454;s:10:\"contact-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48050\";a:12:{s:5:\"title\";s:10:\"Brandstore\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-v2.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-v2-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-v2-400x1121.jpg\";s:14:\"astra-site-url\";s:32:\"//websitedemos.net/brandstore-08\";s:20:\"astra-site-parent-id\";i:1695;s:15:\"astra-sites-tag\";a:8:{i:639;s:11:\"accessories\";i:638;s:11:\"brand-store\";i:640;s:11:\"cloth-store\";i:637;s:8:\"clothing\";i:496;s:9:\"ecommerce\";i:383;s:12:\"online-store\";i:733;s:4:\"shop\";i:1024;s:11:\"woocommerce\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:3:{i:27;s:8:\"business\";i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:11:\"woocommerce\";s:4:\"init\";s:27:\"woocommerce/woocommerce.php\";s:4:\"name\";s:11:\"WooCommerce\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}i:3;a:3:{s:4:\"slug\";s:29:\"woo-cart-abandonment-recovery\";s:4:\"init\";s:63:\"woo-cart-abandonment-recovery/woo-cart-abandonment-recovery.php\";s:4:\"name\";s:37:\"WooCommerce Cart Abandonment Recovery\";}}s:5:\"pages\";a:3:{s:8:\"id-48053\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-v2.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-home-v2-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/brandstore-08/wp-json/wp/v2/pages/61\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:33:\"//websitedemos.net/brandstore-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:60;s:8:\"business\";i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48051\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-about.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/brandstore-08/wp-json/wp/v2/pages/59\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/brandstore-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:60;s:8:\"business\";i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48052\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/brandstore-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/brandstore-08/wp-json/wp/v2/pages/60\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/brandstore-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:3:{i:60;s:8:\"business\";i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47932\";a:12:{s:5:\"title\";s:19:\"Online Health Coach\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-400x1189.jpg\";s:14:\"astra-site-url\";s:41:\"//websitedemos.net/online-health-coach-08\";s:20:\"astra-site-parent-id\";i:1684;s:15:\"astra-sites-tag\";a:8:{i:462;s:7:\"courses\";i:469;s:7:\"ecourse\";i:468;s:9:\"elearning\";i:518;s:12:\"health-coach\";i:467;s:9:\"learndash\";i:460;s:8:\"learning\";i:466;s:14:\"online-courses\";i:975;s:15:\"online-learning\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:2;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:3;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47941\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/online-health-coach-08/wp-json/wp/v2/pages/24365\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/online-health-coach-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47939\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-all-courses.jpg\";s:19:\"thumbnail-image-url\";s:98:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-all-courses-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/online-health-coach-08/wp-json/wp/v2/pages/24366\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:54:\"//websitedemos.net/online-health-coach-08/all-courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47938\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-about.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/online-health-coach-08/wp-json/wp/v2/pages/24368\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/online-health-coach-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47940\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/online-health-coach-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/online-health-coach-08/wp-json/wp/v2/pages/24369\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/online-health-coach-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48431\";a:12:{s:5:\"title\";s:14:\"Simply Natural\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb-400x1268.jpg\";s:14:\"astra-site-url\";s:33:\"//websitedemos.net/plant-store-08\";s:20:\"astra-site-parent-id\";i:1732;s:15:\"astra-sites-tag\";a:6:{i:496;s:9:\"ecommerce\";i:383;s:12:\"online-store\";i:497;s:11:\"plant-store\";i:967;s:13:\"product-store\";i:733;s:4:\"shop\";i:1024;s:11:\"woocommerce\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:5:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:11:\"woocommerce\";s:4:\"init\";s:27:\"woocommerce/woocommerce.php\";s:4:\"name\";s:11:\"WooCommerce\";}i:3;a:3:{s:4:\"slug\";s:29:\"woo-cart-abandonment-recovery\";s:4:\"init\";s:63:\"woo-cart-abandonment-recovery/woo-cart-abandonment-recovery.php\";s:4:\"name\";s:37:\"WooCommerce Cart Abandonment Recovery\";}i:4;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:3:{s:8:\"id-48432\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/plant-store-08/wp-json/wp/v2/pages/119\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/plant-store-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48433\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/plant-store-08/wp-json/wp/v2/pages/120\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/plant-store-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48434\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/plant-store-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/plant-store-08/wp-json/wp/v2/pages/15\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:34:\"//websitedemos.net/plant-store-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48026\";a:12:{s:5:\"title\";s:13:\"Online Course\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-400x1449.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/online-courses-08\";s:20:\"astra-site-parent-id\";i:1694;s:15:\"astra-sites-tag\";a:6:{i:462;s:7:\"courses\";i:468;s:9:\"elearning\";i:467;s:9:\"learndash\";i:460;s:8:\"learning\";i:466;s:14:\"online-courses\";i:975;s:15:\"online-learning\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:2;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:3;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-48030\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/online-courses-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48028\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-all-courses.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-all-courses-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/14\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/online-courses-08/all-courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48027\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-about-us.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-about-us-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/12\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/online-courses-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48031\";a:12:{s:5:\"title\";s:11:\"Instructors\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-instructors.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-instructors-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/18\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/online-courses-08/instructors/\";s:15:\"astra-sites-tag\";a:1:{i:1677;s:11:\"instructors\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48032\";a:12:{s:5:\"title\";s:18:\"Pricing &#038; FAQ\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-pricing-faq.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-pricing-faq-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/20\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/online-courses-08/pricing-faq/\";s:15:\"astra-sites-tag\";a:1:{i:585;s:7:\"pricing\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48029\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/online-courses-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/online-courses-08/wp-json/wp/v2/pages/16\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/online-courses-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47896\";a:12:{s:5:\"title\";s:25:\"Online Programming Course\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home-400x1470.jpg\";s:14:\"astra-site-url\";s:42:\"//websitedemos.net/online-coding-course-08\";s:20:\"astra-site-parent-id\";i:1681;s:15:\"astra-sites-tag\";a:7:{i:462;s:7:\"courses\";i:469;s:7:\"ecourse\";i:468;s:9:\"elearning\";i:467;s:9:\"learndash\";i:466;s:14:\"online-courses\";i:975;s:15:\"online-learning\";i:1673;s:18:\"programming-course\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:2;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:3;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47900\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-coding-course-08/wp-json/wp/v2/pages/523\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/online-coding-course-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47898\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-all-courses.jpg\";s:19:\"thumbnail-image-url\";s:99:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-all-courses-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-coding-course-08/wp-json/wp/v2/pages/519\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/online-coding-course-08/all-courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47897\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-about.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-coding-course-08/wp-json/wp/v2/pages/517\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/online-coding-course-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47899\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-contact.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/online-coding-course-07-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-coding-course-08/wp-json/wp/v2/pages/521\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/online-coding-course-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48149\";a:12:{s:5:\"title\";s:10:\"Life Coach\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home-400x869.jpg\";s:14:\"astra-site-url\";s:42:\"//websitedemos.net/life-coach-sara-john-08\";s:20:\"astra-site-parent-id\";i:1704;s:15:\"astra-sites-tag\";a:5:{i:610;s:8:\"coaching\";i:608;s:8:\"guidance\";i:612;s:10:\"life-coach\";i:609;s:9:\"motivator\";i:611;s:16:\"self-improvement\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:11:\"woocommerce\";s:4:\"init\";s:27:\"woocommerce/woocommerce.php\";s:4:\"name\";s:11:\"WooCommerce\";}i:2;a:3:{s:4:\"slug\";s:29:\"woo-cart-abandonment-recovery\";s:4:\"init\";s:63:\"woo-cart-abandonment-recovery/woo-cart-abandonment-recovery.php\";s:4:\"name\";s:37:\"WooCommerce Cart Abandonment Recovery\";}i:3;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48171\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-about-1.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-about-1-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1368\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/life-coach-sara-john-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-48172\";a:12:{s:5:\"title\";s:5:\"Books\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-books.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-books-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1370\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/life-coach-sara-john-08/books/\";s:15:\"astra-sites-tag\";a:1:{i:727;s:4:\"book\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-48173\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-books.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-books-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1372\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/life-coach-sara-john-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-48174\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1376\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/life-coach-sara-john-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";s:0:\"\";}s:8:\"id-48175\";a:12:{s:5:\"title\";s:12:\"Work With Me\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-pricing.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/life-coach-sara-john-08-pricing-600x800.jpg\";s:18:\"astra-page-api-url\";s:73:\"https://websitedemos.net/life-coach-sara-john-08/wp-json/wp/v2/pages/1374\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:56:\"//websitedemos.net/life-coach-sara-john-08/work-with-me/\";s:15:\"astra-sites-tag\";a:1:{i:784;s:12:\"work-with-me\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";s:0:\"\";}}}s:8:\"id-48648\";a:12:{s:5:\"title\";s:16:\"Roofing Services\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home-400x1637.jpg\";s:14:\"astra-site-url\";s:38:\"//websitedemos.net/roofing-services-08\";s:20:\"astra-site-parent-id\";i:1754;s:15:\"astra-sites-tag\";a:5:{i:1630;s:18:\"commercial-roofing\";i:1629;s:19:\"residential-roofing\";i:1633;s:11:\"roof-repair\";i:1631;s:16:\"roof-replacement\";i:1632;s:16:\"roofing-services\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48651\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/296\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/roofing-services-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48649\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-about.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/297\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/roofing-services-08/about-us/\";s:15:\"astra-sites-tag\";a:2:{i:352;s:5:\"about\";i:455;s:8:\"about-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48653\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-services.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/298\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/roofing-services-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48652\";a:12:{s:5:\"title\";s:8:\"Projects\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-projects.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-projects-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/299\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/roofing-services-08/projects/\";s:15:\"astra-sites-tag\";a:3:{i:444;s:9:\"portfolio\";i:1613;s:8:\"projects\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48650\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/roofing-services-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/roofing-services-08/wp-json/wp/v2/pages/300\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/roofing-services-08/contact-us/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:377;s:12:\"get-in-touch\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47672\";a:12:{s:5:\"title\";s:15:\"Diagnostics Lab\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home-400x2475.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/diagnostics-lab-08\";s:20:\"astra-site-parent-id\";i:1657;s:15:\"astra-sites-tag\";a:6:{i:1756;s:10:\"blood-bank\";i:337;s:6:\"clinic\";i:1757;s:15:\"diagnostics-lab\";i:1640;s:10:\"laboratory\";i:603;s:7:\"medical\";i:1755;s:16:\"medical-research\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-47675\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/242\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/diagnostics-lab-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47673\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-about.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/247\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/diagnostics-lab-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47676\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-services.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/252\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/diagnostics-lab-08/services/\";s:15:\"astra-sites-tag\";a:2:{i:425;s:8:\"services\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47677\";a:12:{s:5:\"title\";s:11:\"Testimonial\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-reviews.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-reviews-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/254\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/diagnostics-lab-08/testimonial/\";s:15:\"astra-sites-tag\";a:2:{i:1615;s:7:\"reviews\";i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47674\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/lab-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/diagnostics-lab-08/wp-json/wp/v2/pages/256\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/diagnostics-lab-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48061\";a:12:{s:5:\"title\";s:21:\"Online Cooking Course\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-400x1154.jpg\";s:14:\"astra-site-url\";s:43:\"//websitedemos.net/online-cooking-course-08\";s:20:\"astra-site-parent-id\";i:1696;s:15:\"astra-sites-tag\";a:6:{i:462;s:7:\"courses\";i:468;s:9:\"elearning\";i:467;s:9:\"learndash\";i:460;s:8:\"learning\";i:466;s:14:\"online-courses\";i:975;s:15:\"online-learning\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:8:\"sfwd-lms\";s:4:\"init\";s:21:\"sfwd-lms/sfwd_lms.php\";s:4:\"name\";s:13:\"LearnDash LMS\";}i:2;a:3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"init\";s:47:\"learndash-course-grid/learndash_course_grid.php\";s:4:\"name\";s:27:\"LearnDash LMS - Course Grid\";}i:3;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48065\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/online-cooking-course-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/online-cooking-course-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48063\";a:12:{s:5:\"title\";s:11:\"All Courses\";s:18:\"featured-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-all-courses.jpg\";s:19:\"thumbnail-image-url\";s:100:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-all-courses-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-cooking-course-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:56:\"//websitedemos.net/online-cooking-course-08/all-courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48062\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-about.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-cooking-course-08/wp-json/wp/v2/pages/11\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/online-cooking-course-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48064\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:96:\"https://websitedemos.net/wp-content/uploads/2020/10/online-cooking-course-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/online-cooking-course-08/wp-json/wp/v2/pages/12\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:52:\"//websitedemos.net/online-cooking-course-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48447\";a:12:{s:5:\"title\";s:21:\"Women Empowerment NGO\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-400x1508.jpg\";s:14:\"astra-site-url\";s:39:\"//websitedemos.net/women-empowerment-08\";s:20:\"astra-site-parent-id\";i:1735;s:15:\"astra-sites-tag\";a:3:{i:625;s:7:\"charity\";i:1592;s:3:\"ngo\";i:1591;s:17:\"women-empowerment\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:36;s:5:\"other\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-48448\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-about-us.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-about-us-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/357\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/women-empowerment-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48449\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/442\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/women-empowerment-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48450\";a:12:{s:5:\"title\";s:6:\"Events\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-events.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-events-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/418\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/women-empowerment-08/events/\";s:15:\"astra-sites-tag\";a:1:{i:409;s:5:\"event\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48451\";a:12:{s:5:\"title\";s:7:\"Gallery\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-gallery.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-gallery-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/426\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/women-empowerment-08/gallery/\";s:15:\"astra-sites-tag\";a:1:{i:461;s:7:\"gallery\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48452\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/297\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/women-empowerment-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48453\";a:12:{s:5:\"title\";s:10:\"What We Do\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-what-we-do.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/women-empowerment-08-what-we-do-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/women-empowerment-08/wp-json/wp/v2/pages/403\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/women-empowerment-08/what-we-do/\";s:15:\"astra-sites-tag\";a:1:{i:628;s:10:\"what-we-do\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48671\";a:12:{s:5:\"title\";s:12:\"Tech Startup\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home-400x1256.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/tech-startup-08\";s:20:\"astra-site-parent-id\";i:1758;s:15:\"astra-sites-tag\";a:7:{i:1761;s:11:\"application\";i:745;s:12:\"organization\";i:1762;s:16:\"software-company\";i:1760;s:13:\"software-firm\";i:1665;s:7:\"startup\";i:1759;s:13:\"tech-business\";i:1763;s:12:\"tech-startup\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48672\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-about.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/tech-startup-08/wp-json/wp/v2/pages/248\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/tech-startup-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48673\";a:12:{s:5:\"title\";s:8:\"Features\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-features.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-features-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/tech-startup-08/wp-json/wp/v2/pages/249\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/tech-startup-08/features/\";s:15:\"astra-sites-tag\";a:1:{i:453;s:8:\"features\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48674\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/tech-startup-08/wp-json/wp/v2/pages/247\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/tech-startup-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48675\";a:12:{s:5:\"title\";s:4:\"Plan\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-plan.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/tech-startup-08-plan-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/tech-startup-08/wp-json/wp/v2/pages/250\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/tech-startup-08/plan/\";s:15:\"astra-sites-tag\";a:2:{i:1663;s:4:\"plan\";i:585;s:7:\"pricing\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48611\";a:12:{s:5:\"title\";s:8:\"Musician\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-400x1735.jpg\";s:14:\"astra-site-url\";s:30:\"//websitedemos.net/musician-08\";s:20:\"astra-site-parent-id\";i:1752;s:15:\"astra-sites-tag\";a:5:{i:339;s:6:\"artist\";i:969;s:8:\"musician\";i:1572;s:9:\"performer\";i:1571;s:6:\"singer\";i:1573;s:8:\"vocalist\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-48612\";a:12:{s:5:\"title\";s:6:\"Albums\";s:18:\"featured-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-albums.jpg\";s:19:\"thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-albums-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/437\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/musician-08/albums/\";s:15:\"astra-sites-tag\";a:2:{i:1565;s:6:\"albums\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48617\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/296\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:31:\"//websitedemos.net/musician-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48613\";a:12:{s:5:\"title\";s:9:\"Biography\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-biography.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-biography-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/408\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/musician-08/biography/\";s:15:\"astra-sites-tag\";a:2:{i:352;s:5:\"about\";i:1566;s:9:\"biography\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48614\";a:12:{s:5:\"title\";s:8:\"Concerts\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-concerts.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-concerts-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/432\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/musician-08/concerts/\";s:15:\"astra-sites-tag\";a:1:{i:755;s:7:\"concert\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48616\";a:12:{s:5:\"title\";s:7:\"Gallery\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-gallery.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-gallery-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/443\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/musician-08/gallery/\";s:15:\"astra-sites-tag\";a:2:{i:461;s:7:\"gallery\";i:444;s:9:\"portfolio\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48615\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/musician-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/musician-08/wp-json/wp/v2/pages/451\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/musician-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48519\";a:12:{s:5:\"title\";s:12:\"Elderly Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home-400x1558.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/elderly-care-08\";s:20:\"astra-site-parent-id\";i:1744;s:15:\"astra-sites-tag\";a:5:{i:1598;s:24:\"assisted-living-facility\";i:1596;s:10:\"elder-home\";i:1595;s:11:\"elders-care\";i:1594;s:12:\"old-age-home\";i:1597;s:15:\"retirement-home\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48523\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/elderly-care-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48520\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-about.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/elderly-care-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48524\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-services.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/8\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/elderly-care-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48522\";a:12:{s:5:\"title\";s:10:\"Facilities\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-facilities.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-facilities-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/elderly-care-08/facilities/\";s:15:\"astra-sites-tag\";a:1:{i:1599;s:10:\"facilities\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48521\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/elderly-care-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/elderly-care-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/elderly-care-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47723\";a:12:{s:5:\"title\";s:12:\"Horticulture\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-400x1517.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/horticulture-08\";s:20:\"astra-site-parent-id\";i:1669;s:15:\"astra-sites-tag\";a:4:{i:1601;s:11:\"agriculture\";i:1603;s:13:\"farm-products\";i:632;s:7:\"farming\";i:1602;s:12:\"horticulture\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-47725\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/5\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/horticulture-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47726\";a:12:{s:5:\"title\";s:8:\"Our Farm\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-our-farm.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-our-farm-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/horticulture-08/our-farm/\";s:15:\"astra-sites-tag\";a:2:{i:1737;s:4:\"farm\";i:1736;s:8:\"our-farm\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47727\";a:12:{s:5:\"title\";s:11:\"Our Produce\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-our-produce.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-our-produce-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/horticulture-08/our-produce/\";s:15:\"astra-sites-tag\";a:1:{i:1606;s:12:\"our-products\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47728\";a:12:{s:5:\"title\";s:12:\"Testimonials\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-testimonials.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-testimonials-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/8\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/horticulture-08/testimonials/\";s:15:\"astra-sites-tag\";a:3:{i:1738;s:9:\"feedbacks\";i:432;s:6:\"review\";i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47724\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-contact-us.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/horticulture-08-contact-us-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/horticulture-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/horticulture-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48472\";a:12:{s:5:\"title\";s:13:\"e-book Author\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-400x1471.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/ebook-author-08\";s:20:\"astra-site-parent-id\";i:1739;s:15:\"astra-sites-tag\";a:4:{i:724;s:6:\"author\";i:727;s:4:\"book\";i:748;s:5:\"ebook\";i:725;s:6:\"writer\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48473\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-about.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/252\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/ebook-author-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48474\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-contact-page.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-contact-page-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/258\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/ebook-author-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48475\";a:12:{s:5:\"title\";s:7:\"e-Books\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-e-books.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-e-books-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/254\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/ebook-author-08/e-books/\";s:15:\"astra-sites-tag\";a:2:{i:1740;s:5:\"books\";i:748;s:5:\"ebook\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48476\";a:12:{s:5:\"title\";s:6:\"Events\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-events.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-events-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/256\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/ebook-author-08/events/\";s:15:\"astra-sites-tag\";a:1:{i:1569;s:6:\"events\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48477\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/ebook-author-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/ebook-author-08/wp-json/wp/v2/pages/250\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/ebook-author-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47979\";a:12:{s:5:\"title\";s:14:\"BBQ Restaurant\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home-400x1566.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/bbq-restaurant-08\";s:20:\"astra-site-parent-id\";i:1690;s:15:\"astra-sites-tag\";a:10:{i:566;s:14:\"bbq-restaurant\";i:562;s:6:\"bistro\";i:972;s:4:\"club\";i:560;s:7:\"cuisine\";i:561;s:6:\"eatery\";i:336;s:4:\"food\";i:350;s:5:\"hotel\";i:559;s:6:\"outlet\";i:335;s:10:\"restaurant\";i:970;s:6:\"restro\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47982\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/bbq-restaurant-08/wp-json/wp/v2/pages/531\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/bbq-restaurant-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47980\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-about.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/bbq-restaurant-08/wp-json/wp/v2/pages/533\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/bbq-restaurant-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:455;s:8:\"about-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47983\";a:12:{s:5:\"title\";s:4:\"Menu\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-menu.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-menu-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/bbq-restaurant-08/wp-json/wp/v2/pages/535\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/bbq-restaurant-08/menu/\";s:15:\"astra-sites-tag\";a:2:{i:1579;s:9:\"food-menu\";i:565;s:4:\"menu\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47981\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/bbq-restaurant-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/bbq-restaurant-08/wp-json/wp/v2/pages/537\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/bbq-restaurant-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48631\";a:12:{s:5:\"title\";s:15:\"Yoga Instructor\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home-400x1394.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/yoga-instructor-08\";s:20:\"astra-site-parent-id\";i:1753;s:15:\"astra-sites-tag\";a:7:{i:499;s:7:\"fitness\";i:976;s:14:\"gym-instructor\";i:849;s:11:\"health-yoga\";i:1020;s:8:\"personal\";i:395;s:15:\"yoga-instructor\";i:397;s:11:\"yoga-studio\";i:398;s:12:\"yoga-trainer\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48635\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/51\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/yoga-instructor-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48632\";a:12:{s:5:\"title\";s:8:\"About Me\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-about-me.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-about-me-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/52\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/yoga-instructor-08/about-me/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48633\";a:12:{s:5:\"title\";s:7:\"Classes\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-classes.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-classes-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/53\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/yoga-instructor-08/classes/\";s:15:\"astra-sites-tag\";a:1:{i:557;s:7:\"classes\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48636\";a:12:{s:5:\"title\";s:12:\"Publications\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-publications.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-publications-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/54\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/yoga-instructor-08/publications/\";s:15:\"astra-sites-tag\";a:1:{i:558;s:11:\"publication\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48634\";a:12:{s:5:\"title\";s:7:\"Get Fit\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-get-fit.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/yoga-instructor-08-get-fit-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/yoga-instructor-08/wp-json/wp/v2/pages/55\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/yoga-instructor-08/get-fit/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:377;s:12:\"get-in-touch\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48591\";a:12:{s:5:\"title\";s:15:\"Cosmetics Store\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home-400x1625.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/cosmetics-store-08\";s:20:\"astra-site-parent-id\";i:1748;s:15:\"astra-sites-tag\";a:7:{i:1023;s:6:\"beauty\";i:1465;s:15:\"beauty-products\";i:1466;s:17:\"cosmetic-products\";i:1464;s:14:\"cosmetic-store\";i:1463;s:9:\"cosmetics\";i:496;s:9:\"ecommerce\";i:1024;s:11:\"woocommerce\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48594\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/cosmetics-store-08/wp-json/wp/v2/pages/542\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/cosmetics-store-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48592\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-about.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/cosmetics-store-08/wp-json/wp/v2/pages/545\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/cosmetics-store-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48595\";a:12:{s:5:\"title\";s:12:\"Testinomials\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-testinomials.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-testinomials-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/cosmetics-store-08/wp-json/wp/v2/pages/544\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/cosmetics-store-08/testinomials/\";s:15:\"astra-sites-tag\";a:1:{i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48593\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/cosmetics-store-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/cosmetics-store-08/wp-json/wp/v2/pages/546\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/cosmetics-store-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48318\";a:12:{s:5:\"title\";s:12:\"Nutritionist\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01-400x1626.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/nutritionist-08\";s:20:\"astra-site-parent-id\";i:1722;s:15:\"astra-sites-tag\";a:6:{i:753;s:9:\"dietitian\";i:1726;s:15:\"nutrition-coach\";i:1727;s:18:\"nutrition-coaching\";i:1725;s:17:\"nutrition-trainer\";i:754;s:12:\"nutritionist\";i:1454;s:16:\"personal-trainer\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48321\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-home01-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/nutritionist-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48319\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-about.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/134\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/nutritionist-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48322\";a:12:{s:5:\"title\";s:8:\"Programs\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-program.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-program-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/164\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/nutritionist-08/164-2/\";s:15:\"astra-sites-tag\";a:1:{i:989;s:8:\"programs\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48323\";a:12:{s:5:\"title\";s:15:\"Success Stories\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-success-stories.jpg\";s:19:\"thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-success-stories-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/180\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/nutritionist-08/success-stories/\";s:15:\"astra-sites-tag\";a:3:{i:432;s:6:\"review\";i:990;s:15:\"success-stories\";i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48320\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/nutritionist-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/nutritionist-08/wp-json/wp/v2/pages/196\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/nutritionist-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-49726\";a:12:{s:5:\"title\";s:12:\"Entrepreneur\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2021/01/home-entrepreneur-gb.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/01/home-entrepreneur-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/01/home-entrepreneur-gb-400x1076.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/entrepreneur-08\";s:20:\"astra-site-parent-id\";i:1847;s:15:\"astra-sites-tag\";a:7:{i:795;s:10:\"contractor\";i:1848;s:12:\"entrepreneur\";i:796;s:9:\"executive\";i:801;s:7:\"founder\";i:798;s:7:\"manager\";i:799;s:9:\"organizer\";i:804;s:8:\"promoter\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-49727\";a:12:{s:5:\"title\";s:8:\"About Me\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2021/01/about-entrepreneur-gb.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2021/01/about-entrepreneur-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/entrepreneur-08/wp-json/wp/v2/pages/25265\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/entrepreneur-08/about-me/\";s:15:\"astra-sites-tag\";a:1:{i:1007;s:8:\"about-me\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-49728\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2021/01/blog-entrepreneur-gb.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/01/blog-entrepreneur-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/entrepreneur-08/wp-json/wp/v2/pages/25266\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/entrepreneur-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-49729\";a:12:{s:5:\"title\";s:10:\"Contact Me\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2021/01/contact-entrepreneur-gb.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2021/01/contact-entrepreneur-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/entrepreneur-08/wp-json/wp/v2/pages/25267\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/entrepreneur-08/contact-me/\";s:15:\"astra-sites-tag\";a:1:{i:1009;s:10:\"contact-me\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-49730\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2021/01/home-entrepreneur-gb.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2021/01/home-entrepreneur-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/entrepreneur-08/wp-json/wp/v2/pages/25264\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/entrepreneur-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48076\";a:12:{s:5:\"title\";s:24:\"Personal Fitness Trainer\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage-400x1695.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/fitness-trainer-08\";s:20:\"astra-site-parent-id\";i:1697;s:15:\"astra-sites-tag\";a:9:{i:502;s:8:\"exercise\";i:499;s:7:\"fitness\";i:506;s:19:\"functional-training\";i:500;s:3:\"gym\";i:504;s:11:\"gym-trainer\";i:399;s:8:\"one-page\";i:463;s:11:\"single-page\";i:503;s:7:\"trainer\";i:501;s:8:\"work-out\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:1:{s:8:\"id-48077\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/fitness-trainer-gb-homepage-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/fitness-trainer-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/fitness-trainer-08/\";s:15:\"astra-sites-tag\";a:3:{i:423;s:4:\"home\";i:814;s:8:\"homepage\";i:463;s:11:\"single-page\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:1:{i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48490\";a:12:{s:5:\"title\";s:14:\"Animal Welfare\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home-400x1536.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/animal-welfare-08\";s:20:\"astra-site-parent-id\";i:1741;s:15:\"astra-sites-tag\";a:7:{i:625;s:7:\"charity\";i:735;s:6:\"donate\";i:1013;s:8:\"donation\";i:624;s:10:\"foundation\";i:1482;s:6:\"givewp\";i:745;s:12:\"organization\";i:1012;s:7:\"welfare\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:36;s:5:\"other\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:4:\"give\";s:4:\"init\";s:13:\"give/give.php\";s:4:\"name\";s:22:\"Give - Donation Plugin\";}i:2;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:3;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48493\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1026\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/animal-welfare-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48491\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-about.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1027\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/animal-welfare-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48494\";a:12:{s:5:\"title\";s:17:\"See All Campaigns\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-campaigns.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-campaigns-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1028\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/animal-welfare-08/see-all-campaigns/\";s:15:\"astra-sites-tag\";a:1:{i:1479;s:9:\"campaigns\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:4:\"give\";s:4:\"init\";s:13:\"give/give.php\";s:4:\"name\";s:22:\"Give - Donation Plugin\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48495\";a:12:{s:5:\"title\";s:17:\"Star Contributors\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-contributors.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-contributors-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1029\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:55:\"//websitedemos.net/animal-welfare-08/star-contributors/\";s:15:\"astra-sites-tag\";a:2:{i:1014;s:10:\"contribute\";i:1481;s:11:\"star-donors\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:4:\"give\";s:4:\"init\";s:13:\"give/give.php\";s:4:\"name\";s:22:\"Give - Donation Plugin\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48492\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/animal-welfare-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:67:\"https://websitedemos.net/animal-welfare-08/wp-json/wp/v2/pages/1030\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/animal-welfare-08/contact/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:454;s:10:\"contact-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:139;s:5:\"other\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48442\";a:12:{s:5:\"title\";s:14:\"Dentist Clinic\";s:18:\"featured-image-url\";s:66:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08.jpg\";s:19:\"thumbnail-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08-400x1411.jpg\";s:14:\"astra-site-url\";s:29:\"//websitedemos.net/dentist-08\";s:20:\"astra-site-parent-id\";i:1733;s:15:\"astra-sites-tag\";a:3:{i:338;s:6:\"dental\";i:623;s:7:\"dentist\";i:1734;s:14:\"dentist-clinic\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:1:{s:8:\"id-48443\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:66:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08.jpg\";s:19:\"thumbnail-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/dentist-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/dentist-08/wp-json/wp/v2/pages/409\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:30:\"//websitedemos.net/dentist-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47862\";a:12:{s:5:\"title\";s:11:\"Pet Sitting\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-home-gb.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-home-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-home-gb-400x1242.jpg\";s:14:\"astra-site-url\";s:33:\"//websitedemos.net/pet-sitting-08\";s:20:\"astra-site-parent-id\";i:1680;s:15:\"astra-sites-tag\";a:5:{i:374;s:8:\"pet-care\";i:372;s:11:\"pet-minding\";i:371;s:11:\"pet-sitting\";i:373;s:12:\"pet-training\";i:1687;s:11:\"pet-walking\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47864\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-home-gb.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-home-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/pet-sitting-08/wp-json/wp/v2/pages/506\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:34:\"//websitedemos.net/pet-sitting-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47866\";a:12:{s:5:\"title\";s:10:\"Who We Are\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/pet-sitting-08/wp-json/wp/v2/pages/508\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/pet-sitting-08/who-we-are/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47865\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-services-gb.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-services-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/pet-sitting-08/wp-json/wp/v2/pages/509\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/pet-sitting-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47863\";a:12:{s:5:\"title\";s:12:\"Get In Touch\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-sitting-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/pet-sitting-08/wp-json/wp/v2/pages/510\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/pet-sitting-08/get-in-touch/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-22317\";a:12:{s:5:\"title\";s:12:\"Photographer\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2019/06/photographer-07-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2019/06/photographer-07-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2019/06/photographer-07-home-400x1964.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/photographer-08\";s:20:\"astra-site-parent-id\";i:75;s:15:\"astra-sites-tag\";a:9:{i:513;s:6:\"camera\";i:482;s:7:\"fashion\";i:515;s:4:\"lens\";i:510;s:9:\"modelling\";i:511;s:12:\"photographer\";i:509;s:11:\"photography\";i:444;s:9:\"portfolio\";i:514;s:11:\"videography\";i:512;s:13:\"wedding-shoot\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:37;s:4:\"blog\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}s:5:\"pages\";a:3:{s:8:\"id-22320\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2019/06/photographer-07-home.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2019/06/photographer-07-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/photographer-08/wp-json/wp/v2/pages/8\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/photographer-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-22318\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2019/06/photographer-07-about.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2019/06/photographer-07-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:63:\"https://websitedemos.net/photographer-08/wp-json/wp/v2/pages/26\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/photographer-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-22319\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2019/06/photographer-07-blogpage.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2019/06/photographer-07-blogpage-600x800.jpg\";s:18:\"astra-page-api-url\";s:64:\"https://websitedemos.net/photographer-08/wp-json/wp/v2/pages/267\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/photographer-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48300\";a:12:{s:5:\"title\";s:15:\"Custom Printing\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/custom-printing-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/custom-printing-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/custom-printing-homepage-gb-400x1150.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/custom-printing-08\";s:20:\"astra-site-parent-id\";i:1719;s:15:\"astra-sites-tag\";a:6:{i:400;s:15:\"custom-printing\";i:496;s:9:\"ecommerce\";i:881;s:12:\"mug-printing\";i:967;s:13:\"product-store\";i:405;s:16:\"t-shirt-printing\";i:1024;s:11:\"woocommerce\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:38;s:9:\"ecommerce\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:5:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:11:\"woocommerce\";s:4:\"init\";s:27:\"woocommerce/woocommerce.php\";s:4:\"name\";s:11:\"WooCommerce\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}i:3;a:3:{s:4:\"slug\";s:29:\"woo-cart-abandonment-recovery\";s:4:\"init\";s:63:\"woo-cart-abandonment-recovery/woo-cart-abandonment-recovery.php\";s:4:\"name\";s:37:\"WooCommerce Cart Abandonment Recovery\";}i:4;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}}s:5:\"pages\";a:3:{s:8:\"id-48303\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/custom-printing-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/custom-printing-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/custom-printing-08/wp-json/wp/v2/pages/2089\";s:12:\"dynamic-page\";s:3:\"yes\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/custom-printing-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48301\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/custom-printing-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/custom-printing-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/custom-printing-08/wp-json/wp/v2/pages/2161\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/custom-printing-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48302\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/custom-printing-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/custom-printing-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/custom-printing-08/wp-json/wp/v2/pages/2162\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/custom-printing-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:64;s:9:\"ecommerce\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48391\";a:12:{s:5:\"title\";s:29:\"Windows &#038; Doors Services\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-400x1366.jpg\";s:14:\"astra-site-url\";s:39:\"//websitedemos.net/windows-and-doors-08\";s:20:\"astra-site-parent-id\";i:1730;s:15:\"astra-sites-tag\";a:2:{i:436;s:8:\"interior\";i:442;s:26:\"windows-and-doors-services\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-48395\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/windows-and-doors-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/windows-and-doors-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48392\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-about.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/windows-and-doors-08/wp-json/wp/v2/pages/13\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/windows-and-doors-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48397\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-services.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/windows-and-doors-08/wp-json/wp/v2/pages/15\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/windows-and-doors-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48396\";a:12:{s:5:\"title\";s:9:\"Portfolio\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-portfolio.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-portfolio-600x800.jpg\";s:18:\"astra-page-api-url\";s:68:\"https://websitedemos.net/windows-and-doors-08/wp-json/wp/v2/pages/12\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/windows-and-doors-08/portfolio/\";s:15:\"astra-sites-tag\";a:1:{i:444;s:9:\"portfolio\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48394\";a:12:{s:5:\"title\";s:4:\"FAQs\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-faqs.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-faqs-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/windows-and-doors-08/wp-json/wp/v2/pages/171\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/windows-and-doors-08/faqs/\";s:15:\"astra-sites-tag\";a:1:{i:426;s:3:\"faq\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48393\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/windows-and-doors-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/windows-and-doors-08/wp-json/wp/v2/pages/180\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/windows-and-doors-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48580\";a:12:{s:5:\"title\";s:8:\"Car Wash\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-home.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-home-400x1350.jpg\";s:14:\"astra-site-url\";s:30:\"//websitedemos.net/car-wash-08\";s:20:\"astra-site-parent-id\";i:1747;s:15:\"astra-sites-tag\";a:7:{i:1749;s:9:\"bike-care\";i:1750;s:9:\"bike-wash\";i:588;s:8:\"car-care\";i:587;s:13:\"car-detailing\";i:1751;s:15:\"car-maintenance\";i:586;s:8:\"car-wash\";i:1021;s:14:\"local-business\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48583\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-home.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/car-wash-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:31:\"//websitedemos.net/car-wash-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48584\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-services.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/car-wash-08/wp-json/wp/v2/pages/11\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/car-wash-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48581\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-about.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/car-wash-08/wp-json/wp/v2/pages/5\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/car-wash-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48585\";a:12:{s:5:\"title\";s:9:\"Wash Menu\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-wash-menu.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-wash-menu-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/car-wash-08/wp-json/wp/v2/pages/13\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/car-wash-08/wash-menu/\";s:15:\"astra-sites-tag\";a:3:{i:585;s:7:\"pricing\";i:761;s:9:\"wash-menu\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48582\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/car-wash-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/car-wash-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/car-wash-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48208\";a:12:{s:5:\"title\";s:7:\"Plumber\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-home.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-home-400x1348.jpg\";s:14:\"astra-site-url\";s:29:\"//websitedemos.net/plumber-08\";s:20:\"astra-site-parent-id\";i:1706;s:15:\"astra-sites-tag\";a:6:{i:1712;s:19:\"commercial-plumbing\";i:439;s:14:\"local-services\";i:507;s:7:\"plumber\";i:508;s:8:\"plumbing\";i:1711;s:18:\"remolding-services\";i:1710;s:20:\"residential-plumbing\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}i:2;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}}s:5:\"pages\";a:6:{s:8:\"id-48212\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-home.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/plumber-08/wp-json/wp/v2/pages/34\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:30:\"//websitedemos.net/plumber-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48209\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-about.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/plumber-08/wp-json/wp/v2/pages/29\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:36:\"//websitedemos.net/plumber-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48213\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-services.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/plumber-08/wp-json/wp/v2/pages/30\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/plumber-08/services/\";s:15:\"astra-sites-tag\";a:2:{i:425;s:8:\"services\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48214\";a:12:{s:5:\"title\";s:12:\"Testimonials\";s:18:\"featured-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-reviews.jpg\";s:19:\"thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-reviews-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/plumber-08/wp-json/wp/v2/pages/31\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/plumber-08/testimonials/\";s:15:\"astra-sites-tag\";a:2:{i:432;s:6:\"review\";i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48211\";a:12:{s:5:\"title\";s:3:\"FAQ\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-faq.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-faq-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/plumber-08/wp-json/wp/v2/pages/32\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:34:\"//websitedemos.net/plumber-08/faq/\";s:15:\"astra-sites-tag\";a:2:{i:426;s:3:\"faq\";i:1476;s:26:\"frequently-asked-questions\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48210\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/plumber-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/plumber-08/wp-json/wp/v2/pages/33\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/plumber-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48398\";a:12:{s:5:\"title\";s:18:\"Garden Maintenance\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:95:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-homepage-gb-400x1180.jpg\";s:14:\"astra-site-url\";s:40:\"//websitedemos.net/garden-maintenance-08\";s:20:\"astra-site-parent-id\";i:1731;s:15:\"astra-sites-tag\";a:7:{i:416;s:11:\"garden-care\";i:421;s:18:\"garden-maintenance\";i:420;s:9:\"gardening\";i:422;s:11:\"landscaping\";i:417;s:9:\"lawn-care\";i:419;s:8:\"planting\";i:418;s:12:\"weed-control\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-48402\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/garden-maintenance-08/wp-json/wp/v2/pages/31\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/garden-maintenance-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48399\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/garden-maintenance-08/wp-json/wp/v2/pages/32\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/garden-maintenance-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48404\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-services-gb.jpg\";s:19:\"thumbnail-image-url\";s:94:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-services-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/garden-maintenance-08/wp-json/wp/v2/pages/33\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/garden-maintenance-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48403\";a:12:{s:5:\"title\";s:8:\"Projects\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-project-gb.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-project-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/garden-maintenance-08/wp-json/wp/v2/pages/35\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:50:\"//websitedemos.net/garden-maintenance-08/projects/\";s:15:\"astra-sites-tag\";a:1:{i:1613;s:8:\"projects\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48401\";a:12:{s:5:\"title\";s:3:\"FAQ\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-faq-gb.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-faq-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/garden-maintenance-08/wp-json/wp/v2/pages/37\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/garden-maintenance-08/faq/\";s:15:\"astra-sites-tag\";a:1:{i:426;s:3:\"faq\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48400\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/garden-maintenance-contact-gb.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/garden-maintenance-08/wp-json/wp/v2/pages/36\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/garden-maintenance-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48188\";a:12:{s:5:\"title\";s:17:\"Interior Designer\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-homepage-gb-400x712.jpg\";s:14:\"astra-site-url\";s:39:\"//websitedemos.net/interior-designer-08\";s:20:\"astra-site-parent-id\";i:1705;s:15:\"astra-sites-tag\";a:6:{i:435;s:12:\"architecture\";i:436;s:8:\"interior\";i:434;s:15:\"interior-design\";i:422;s:11:\"landscaping\";i:1022;s:12:\"professional\";i:437;s:6:\"zoning\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:6:{s:8:\"id-48191\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/interior-designer-08/wp-json/wp/v2/pages/688\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/interior-designer-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48189\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/interior-designer-08/wp-json/wp/v2/pages/689\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/interior-designer-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48193\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-service-gb.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-service-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/interior-designer-08/wp-json/wp/v2/pages/690\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/interior-designer-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48192\";a:12:{s:5:\"title\";s:8:\"Projects\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-projects-gb.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-projects-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/interior-designer-08/wp-json/wp/v2/pages/691\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/interior-designer-08/projects/\";s:15:\"astra-sites-tag\";a:1:{i:424;s:7:\"project\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48194\";a:12:{s:5:\"title\";s:12:\"Testimonials\";s:18:\"featured-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-testimonials-gb.jpg\";s:19:\"thumbnail-image-url\";s:97:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-testimonials-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/interior-designer-08/wp-json/wp/v2/pages/692\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:53:\"//websitedemos.net/interior-designer-08/testimonials/\";s:15:\"astra-sites-tag\";a:1:{i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48190\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-designer-contact-gb.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/interior-designer-08/wp-json/wp/v2/pages/693\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/interior-designer-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48703\";a:12:{s:5:\"title\";s:15:\"Growth Marketer\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-home.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-home-400x1291.jpg\";s:14:\"astra-site-url\";s:39:\"//websitedemos.net/content-marketing-08\";s:20:\"astra-site-parent-id\";i:1764;s:15:\"astra-sites-tag\";a:3:{i:470;s:17:\"content-marketing\";i:472;s:6:\"growth\";i:471;s:8:\"strategy\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48706\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-home.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/content-marketing-08/wp-json/wp/v2/pages/25247\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/content-marketing-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48704\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-about.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/content-marketing-08/wp-json/wp/v2/pages/25248\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/content-marketing-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48707\";a:12:{s:5:\"title\";s:12:\"Testimonials\";s:18:\"featured-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-testimonials.jpg\";s:19:\"thumbnail-image-url\";s:97:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-testimonials-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/content-marketing-08/wp-json/wp/v2/pages/25249\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:53:\"//websitedemos.net/content-marketing-08/testimonials/\";s:15:\"astra-sites-tag\";a:1:{i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48705\";a:12:{s:5:\"title\";s:7:\"Hire Me\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-hire-me.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/11/content-marketing-07-hire-me-600x800.jpg\";s:18:\"astra-page-api-url\";s:71:\"https://websitedemos.net/content-marketing-08/wp-json/wp/v2/pages/25250\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/content-marketing-08/hire-me/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:773;s:7:\"hire-me\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48530\";a:12:{s:5:\"title\";s:11:\"Barber Shop\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-home.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-home-400x1585.jpg\";s:14:\"astra-site-url\";s:33:\"//websitedemos.net/barber-shop-08\";s:20:\"astra-site-parent-id\";i:1745;s:15:\"astra-sites-tag\";a:6:{i:478;s:6:\"barber\";i:474;s:8:\"grooming\";i:477;s:9:\"hair-care\";i:984;s:9:\"hairstyle\";i:982;s:11:\"hairstylist\";i:1021;s:14:\"local-business\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48535\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-home.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/barber-shop-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:34:\"//websitedemos.net/barber-shop-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48531\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-about.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/barber-shop-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/barber-shop-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48532\";a:12:{s:5:\"title\";s:7:\"Barbers\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-team.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-team-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/barber-shop-08/wp-json/wp/v2/pages/11\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/barber-shop-08/barbers/\";s:15:\"astra-sites-tag\";a:2:{i:478;s:6:\"barber\";i:486;s:4:\"team\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48534\";a:12:{s:5:\"title\";s:7:\"Gallery\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-gallery.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-gallery-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/barber-shop-08/wp-json/wp/v2/pages/12\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/barber-shop-08/gallery/\";s:15:\"astra-sites-tag\";a:2:{i:461;s:7:\"gallery\";i:451;s:4:\"work\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48533\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/barber-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:62:\"https://websitedemos.net/barber-shop-08/wp-json/wp/v2/pages/13\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/barber-shop-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48132\";a:12:{s:5:\"title\";s:15:\"Sierra Industry\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-home-400x1136.jpg\";s:14:\"astra-site-url\";s:37:\"//websitedemos.net/sierra-industry-08\";s:20:\"astra-site-parent-id\";i:1703;s:15:\"astra-sites-tag\";a:4:{i:985;s:7:\"factory\";i:492;s:8:\"industry\";i:490;s:13:\"manufacturing\";i:489;s:10:\"production\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48135\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/sierra-industry-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/sierra-industry-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48133\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-about.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/sierra-industry-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/sierra-industry-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48134\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/sierra-industry-08/wp-json/wp/v2/pages/12\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/sierra-industry-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48136\";a:12:{s:5:\"title\";s:8:\"Products\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-products.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-products-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/sierra-industry-08/wp-json/wp/v2/pages/10\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/sierra-industry-08/products/\";s:15:\"astra-sites-tag\";a:1:{i:540;s:8:\"products\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48137\";a:12:{s:5:\"title\";s:8:\"Projects\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-projects.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-industry-08-projects-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/sierra-industry-08/wp-json/wp/v2/pages/11\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/sierra-industry-08/projects/\";s:15:\"astra-sites-tag\";a:1:{i:1613;s:8:\"projects\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48103\";a:12:{s:5:\"title\";s:13:\"Sierra Nature\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-home.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-home-400x1149.jpg\";s:14:\"astra-site-url\";s:35:\"//websitedemos.net/sierra-nature-08\";s:20:\"astra-site-parent-id\";i:1701;s:15:\"astra-sites-tag\";a:6:{i:538;s:6:\"forest\";i:537;s:13:\"national-park\";i:535;s:6:\"nature\";i:534;s:11:\"nature-park\";i:539;s:9:\"sanctuary\";i:536;s:10:\"wilderness\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48104\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-about.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/sierra-nature-08/wp-json/wp/v2/pages/962\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/sierra-nature-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48105\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/sierra-nature-08/wp-json/wp/v2/pages/968\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/sierra-nature-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48106\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-home.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/sierra-nature-08/wp-json/wp/v2/pages/960\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:36:\"//websitedemos.net/sierra-nature-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48107\";a:12:{s:5:\"title\";s:8:\"Projects\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-projects.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-projects-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/sierra-nature-08/wp-json/wp/v2/pages/966\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/sierra-nature-08/projects/\";s:15:\"astra-sites-tag\";a:1:{i:1613;s:8:\"projects\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48108\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-services.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/sierra-nature-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/sierra-nature-08/wp-json/wp/v2/pages/964\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/sierra-nature-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-47957\";a:12:{s:5:\"title\";s:18:\"Italian Restaurant\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-home.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-home-400x1330.jpg\";s:14:\"astra-site-url\";s:40:\"//websitedemos.net/italian-restaurant-08\";s:20:\"astra-site-parent-id\";i:1689;s:15:\"astra-sites-tag\";a:10:{i:562;s:6:\"bistro\";i:972;s:4:\"club\";i:560;s:7:\"cuisine\";i:561;s:6:\"eatery\";i:336;s:4:\"food\";i:350;s:5:\"hotel\";i:563;s:18:\"italian-restaurant\";i:559;s:6:\"outlet\";i:335;s:10:\"restaurant\";i:970;s:6:\"restro\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47960\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-home.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/italian-restaurant-08/wp-json/wp/v2/pages/56\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/italian-restaurant-08/\";s:15:\"astra-sites-tag\";a:2:{i:423;s:4:\"home\";i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47961\";a:12:{s:5:\"title\";s:4:\"Menu\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-menu.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-menu-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/italian-restaurant-08/wp-json/wp/v2/pages/54\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/italian-restaurant-08/menu/\";s:15:\"astra-sites-tag\";a:2:{i:1579;s:9:\"food-menu\";i:565;s:4:\"menu\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47958\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-about.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/italian-restaurant-08/wp-json/wp/v2/pages/53\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/italian-restaurant-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47959\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/italian-restaurant-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/italian-restaurant-08/wp-json/wp/v2/pages/55\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/italian-restaurant-08/contact/\";s:15:\"astra-sites-tag\";a:2:{i:415;s:7:\"contact\";i:454;s:10:\"contact-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48496\";a:12:{s:5:\"title\";s:20:\"Interior Design Firm\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-home.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-home-400x1295.jpg\";s:14:\"astra-site-url\";s:35:\"//websitedemos.net/interior-firm-08\";s:20:\"astra-site-parent-id\";i:1742;s:15:\"astra-sites-tag\";a:6:{i:435;s:12:\"architecture\";i:436;s:8:\"interior\";i:434;s:15:\"interior-design\";i:422;s:11:\"landscaping\";i:1022;s:12:\"professional\";i:437;s:6:\"zoning\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48499\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-home.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/interior-firm-08/wp-json/wp/v2/pages/1224\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:36:\"//websitedemos.net/interior-firm-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48500\";a:12:{s:5:\"title\";s:9:\"Portfolio\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-portfolio.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-portfolio-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/interior-firm-08/wp-json/wp/v2/pages/1182\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/interior-firm-08/portfolio/\";s:15:\"astra-sites-tag\";a:1:{i:444;s:9:\"portfolio\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48497\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-about.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/interior-firm-08/wp-json/wp/v2/pages/1184\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/interior-firm-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48501\";a:12:{s:5:\"title\";s:12:\"Testimonials\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-testimonials.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-testimonials-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/interior-firm-08/wp-json/wp/v2/pages/1186\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/interior-firm-08/testimonials/\";s:15:\"astra-sites-tag\";a:1:{i:433;s:12:\"testimonials\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48498\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/interior-firm-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/interior-firm-08/wp-json/wp/v2/pages/1188\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/interior-firm-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48342\";a:12:{s:5:\"title\";s:5:\"Coach\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-home.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-home-400x1239.jpg\";s:14:\"astra-site-url\";s:27:\"//websitedemos.net/coach-08\";s:20:\"astra-site-parent-id\";i:1723;s:15:\"astra-sites-tag\";a:5:{i:610;s:8:\"coaching\";i:608;s:8:\"guidance\";i:612;s:10:\"life-coach\";i:609;s:9:\"motivator\";i:611;s:16:\"self-improvement\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48347\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-home.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:57:\"https://websitedemos.net/coach-08/wp-json/wp/v2/pages/389\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:28:\"//websitedemos.net/coach-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48343\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:70:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-about.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:57:\"https://websitedemos.net/coach-08/wp-json/wp/v2/pages/391\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:34:\"//websitedemos.net/coach-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48346\";a:12:{s:5:\"title\";s:6:\"e-Book\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-e-book.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-e-book-600x800.jpg\";s:18:\"astra-page-api-url\";s:57:\"https://websitedemos.net/coach-08/wp-json/wp/v2/pages/393\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/coach-08/e-book/\";s:15:\"astra-sites-tag\";a:1:{i:748;s:5:\"ebook\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48345\";a:12:{s:5:\"title\";s:7:\"Courses\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-courses.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-courses-600x800.jpg\";s:18:\"astra-page-api-url\";s:57:\"https://websitedemos.net/coach-08/wp-json/wp/v2/pages/395\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:36:\"//websitedemos.net/coach-08/courses/\";s:15:\"astra-sites-tag\";a:1:{i:462;s:7:\"courses\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48344\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/coach-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:57:\"https://websitedemos.net/coach-08/wp-json/wp/v2/pages/397\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:36:\"//websitedemos.net/coach-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48231\";a:12:{s:5:\"title\";s:20:\"Motivational Speaker\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08-400x1050.jpg\";s:14:\"astra-site-url\";s:42:\"//websitedemos.net/motivational-speaker-08\";s:20:\"astra-site-parent-id\";i:1708;s:15:\"astra-sites-tag\";a:3:{i:1545;s:21:\"inspirational-speaker\";i:855;s:20:\"motivational-speaker\";i:1709;s:7:\"speaker\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:37;s:4:\"blog\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-48235\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/motivational-speaker-08/wp-json/wp/v2/pages/624\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/motivational-speaker-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48232\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08-about.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/motivational-speaker-08/wp-json/wp/v2/pages/626\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/motivational-speaker-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48233\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08-blog.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08-blog-600x800.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/motivational-speaker-08/wp-json/wp/v2/pages/628\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/motivational-speaker-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48234\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/motivational-speaker-08-contact.jpg\";s:18:\"astra-page-api-url\";s:72:\"https://websitedemos.net/motivational-speaker-08/wp-json/wp/v2/pages/630\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:51:\"//websitedemos.net/motivational-speaker-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48562\";a:12:{s:5:\"title\";s:28:\"Gardening &#038; Landscaping\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-home.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-home-400x1623.jpg\";s:14:\"astra-site-url\";s:30:\"//websitedemos.net/gardener-08\";s:20:\"astra-site-parent-id\";i:1746;s:15:\"astra-sites-tag\";a:7:{i:416;s:11:\"garden-care\";i:421;s:18:\"garden-maintenance\";i:420;s:9:\"gardening\";i:422;s:11:\"landscaping\";i:417;s:9:\"lawn-care\";i:419;s:8:\"planting\";i:418;s:12:\"weed-control\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48566\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-home.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/gardener-08/wp-json/wp/v2/pages/5\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:31:\"//websitedemos.net/gardener-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48563\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-about.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/gardener-08/wp-json/wp/v2/pages/7\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/gardener-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48567\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-services.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:58:\"https://websitedemos.net/gardener-08/wp-json/wp/v2/pages/9\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/gardener-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48565\";a:12:{s:5:\"title\";s:7:\"Gallery\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-gallery.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-gallery-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/gardener-08/wp-json/wp/v2/pages/11\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/gardener-08/gallery/\";s:15:\"astra-sites-tag\";a:1:{i:461;s:7:\"gallery\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48564\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/gardener-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/gardener-08/wp-json/wp/v2/pages/13\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/gardener-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48225\";a:12:{s:5:\"title\";s:12:\"Construction\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-homepage-gb-400x1648.jpg\";s:14:\"astra-site-url\";s:34:\"//websitedemos.net/construction-08\";s:20:\"astra-site-parent-id\";i:1707;s:15:\"astra-sites-tag\";a:6:{i:435;s:12:\"architecture\";i:979;s:7:\"company\";i:484;s:12:\"construction\";i:436;s:8:\"interior\";i:812;s:6:\"office\";i:485;s:11:\"real-estate\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48228\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/construction-08/wp-json/wp/v2/pages/1815\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/construction-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48226\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/construction-08/wp-json/wp/v2/pages/1816\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/construction-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48230\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-services-gb.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-services-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/construction-08/wp-json/wp/v2/pages/1817\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/construction-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48229\";a:12:{s:5:\"title\";s:8:\"Projects\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-projects-gb.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-projects-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/construction-08/wp-json/wp/v2/pages/1818\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/construction-08/projects/\";s:15:\"astra-sites-tag\";a:1:{i:1613;s:8:\"projects\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48227\";a:12:{s:5:\"title\";s:10:\"Contact Us\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/construction-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:65:\"https://websitedemos.net/construction-08/wp-json/wp/v2/pages/1819\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/construction-08/contact-us/\";s:15:\"astra-sites-tag\";a:1:{i:454;s:10:\"contact-us\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48374\";a:12:{s:5:\"title\";s:16:\"Co-Working Space\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-homepage-gb-400x1274.jpg\";s:14:\"astra-site-url\";s:38:\"//websitedemos.net/co-working-space-08\";s:20:\"astra-site-parent-id\";i:1729;s:15:\"astra-sites-tag\";a:5:{i:692;s:8:\"business\";i:694;s:16:\"co-working-place\";i:695;s:13:\"collaboration\";i:1453;s:15:\"coworking-space\";i:691;s:10:\"work-place\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48375\";a:12:{s:5:\"title\";s:8:\"About Us\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-about-gb.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-about-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/co-working-space-08/wp-json/wp/v2/pages/1131\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:48:\"//websitedemos.net/co-working-space-08/about-us/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48376\";a:12:{s:5:\"title\";s:9:\"Amenities\";s:18:\"featured-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-amenities-gb.jpg\";s:19:\"thumbnail-image-url\";s:93:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-amenities-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/co-working-space-08/wp-json/wp/v2/pages/1132\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:49:\"//websitedemos.net/co-working-space-08/amenities/\";s:15:\"astra-sites-tag\";a:1:{i:777;s:9:\"amenities\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48377\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-contact-gb.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-contact-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/co-working-space-08/wp-json/wp/v2/pages/1133\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/co-working-space-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48378\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:92:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/co-working-space-08/wp-json/wp/v2/pages/8\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:39:\"//websitedemos.net/co-working-space-08/\";s:15:\"astra-sites-tag\";a:1:{i:814;s:8:\"homepage\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48379\";a:12:{s:5:\"title\";s:7:\"Pricing\";s:18:\"featured-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-pricing-gb.jpg\";s:19:\"thumbnail-image-url\";s:91:\"https://websitedemos.net/wp-content/uploads/2020/10/co-working-space-pricing-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:69:\"https://websitedemos.net/co-working-space-08/wp-json/wp/v2/pages/1134\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:47:\"//websitedemos.net/co-working-space-08/pricing/\";s:15:\"astra-sites-tag\";a:1:{i:585;s:7:\"pricing\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48297\";a:12:{s:5:\"title\";s:18:\"Wedding Invitation\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/wedding-invitation-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/wedding-invitation-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/wedding-invitation-home-400x1596.jpg\";s:14:\"astra-site-url\";s:29:\"//websitedemos.net/wedding-08\";s:20:\"astra-site-parent-id\";i:1716;s:15:\"astra-sites-tag\";a:5:{i:699;s:10:\"invitation\";i:746;s:13:\"one-page-site\";i:463;s:11:\"single-page\";i:697;s:7:\"wedding\";i:1457;s:18:\"wedding-invitation\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:1:{i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:1:{s:8:\"id-48298\";a:12:{s:5:\"title\";s:18:\"Wedding Invitation\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/wedding-invitation-home.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/wedding-invitation-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:57:\"https://websitedemos.net/wedding-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:30:\"//websitedemos.net/wedding-08/\";s:15:\"astra-sites-tag\";a:3:{i:423;s:4:\"home\";i:1718;s:7:\"onepage\";i:1457;s:18:\"wedding-invitation\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:1:{i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48263\";a:12:{s:5:\"title\";s:13:\"Makeup Artist\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-400x1312.jpg\";s:14:\"astra-site-url\";s:35:\"//websitedemos.net/makeup-artist-08\";s:20:\"astra-site-parent-id\";i:1713;s:15:\"astra-sites-tag\";a:6:{i:579;s:14:\"bridal-make-up\";i:477;s:9:\"hair-care\";i:575;s:11:\"hair-styles\";i:982;s:11:\"hairstylist\";i:577;s:13:\"makeup-artist\";i:1728;s:13:\"makeup-studio\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48266\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/makeup-artist-08/wp-json/wp/v2/pages/1299\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:36:\"//websitedemos.net/makeup-artist-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48264\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-about.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/makeup-artist-08/wp-json/wp/v2/pages/1300\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/makeup-artist-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48268\";a:12:{s:5:\"title\";s:8:\"Services\";s:18:\"featured-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-services.jpg\";s:19:\"thumbnail-image-url\";s:89:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-services-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/makeup-artist-08/wp-json/wp/v2/pages/1301\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:45:\"//websitedemos.net/makeup-artist-08/services/\";s:15:\"astra-sites-tag\";a:1:{i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48267\";a:12:{s:5:\"title\";s:9:\"Portfolio\";s:18:\"featured-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-portfolio.jpg\";s:19:\"thumbnail-image-url\";s:90:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-portfolio-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/makeup-artist-08/wp-json/wp/v2/pages/1302\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:46:\"//websitedemos.net/makeup-artist-08/portfolio/\";s:15:\"astra-sites-tag\";a:1:{i:444;s:9:\"portfolio\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48265\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:88:\"https://websitedemos.net/wp-content/uploads/2020/10/makeup-artist-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/makeup-artist-08/wp-json/wp/v2/pages/1303\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:44:\"//websitedemos.net/makeup-artist-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48269\";a:12:{s:5:\"title\";s:17:\"Cleaning Services\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-home.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-home-400x1345.jpg\";s:14:\"astra-site-url\";s:29:\"//websitedemos.net/cleaner-08\";s:20:\"astra-site-parent-id\";i:1714;s:15:\"astra-sites-tag\";a:7:{i:680;s:8:\"cleaning\";i:679;s:17:\"cleaning-services\";i:673;s:19:\"commercial-cleaning\";i:674;s:17:\"domestic-cleaning\";i:1407;s:13:\"house-keeping\";i:676;s:11:\"maintenance\";i:677;s:7:\"washing\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:5:{s:8:\"id-48273\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-home.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/cleaner-08/wp-json/wp/v2/pages/1696\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:30:\"//websitedemos.net/cleaner-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48270\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-about.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/cleaner-08/wp-json/wp/v2/pages/1352\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:36:\"//websitedemos.net/cleaner-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48274\";a:12:{s:5:\"title\";s:11:\"Residential\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-residential.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-residential-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/cleaner-08/wp-json/wp/v2/pages/1348\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/cleaner-08/residential/\";s:15:\"astra-sites-tag\";a:1:{i:776;s:20:\"residential-cleaning\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48271\";a:12:{s:5:\"title\";s:10:\"Commercial\";s:18:\"featured-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-commercial.jpg\";s:19:\"thumbnail-image-url\";s:85:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-commercial-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/cleaner-08/wp-json/wp/v2/pages/1350\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/cleaner-08/commercial/\";s:15:\"astra-sites-tag\";a:1:{i:673;s:19:\"commercial-cleaning\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-48272\";a:12:{s:5:\"title\";s:7:\"Contact\";s:18:\"featured-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-contact.jpg\";s:19:\"thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/cleaner-08-contact-600x800.jpg\";s:18:\"astra-page-api-url\";s:60:\"https://websitedemos.net/cleaner-08/wp-json/wp/v2/pages/1354\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:38:\"//websitedemos.net/cleaner-08/contact/\";s:15:\"astra-sites-tag\";a:1:{i:415;s:7:\"contact\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-48093\";a:12:{s:5:\"title\";s:13:\"Hotel and BnB\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/hotel-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/hotel-homepage-gb-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/hotel-homepage-gb-400x1573.jpg\";s:14:\"astra-site-url\";s:27:\"//websitedemos.net/hotel-08\";s:20:\"astra-site-parent-id\";i:1700;s:15:\"astra-sites-tag\";a:8:{i:560;s:7:\"cuisine\";i:336;s:4:\"food\";i:350;s:5:\"hotel\";i:712;s:5:\"lodge\";i:711;s:5:\"motel\";i:399;s:8:\"one-page\";i:714;s:6:\"resort\";i:463;s:11:\"single-page\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:27;s:8:\"business\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:1:{s:8:\"id-48094\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/hotel-homepage-gb.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/hotel-homepage-gb-600x800.jpg\";s:18:\"astra-page-api-url\";s:55:\"https://websitedemos.net/hotel-08/wp-json/wp/v2/pages/6\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:28:\"//websitedemos.net/hotel-08/\";s:15:\"astra-sites-tag\";a:3:{i:423;s:4:\"home\";i:814;s:8:\"homepage\";i:463;s:11:\"single-page\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:60;s:8:\"business\";i:61;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}s:8:\"id-47942\";a:12:{s:5:\"title\";s:8:\"Pet Care\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-care-08-home.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-care-08-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-care-08-home-400x1006.jpg\";s:14:\"astra-site-url\";s:30:\"//websitedemos.net/pet-care-08\";s:20:\"astra-site-parent-id\";i:1685;s:15:\"astra-sites-tag\";a:7:{i:1688;s:8:\"pet-blog\";i:374;s:8:\"pet-care\";i:1686;s:13:\"pet-care-blog\";i:372;s:11:\"pet-minding\";i:371;s:11:\"pet-sitting\";i:373;s:12:\"pet-training\";i:1687;s:11:\"pet-walking\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:37;s:4:\"blog\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:3:{s:8:\"id-47945\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-care-08-home.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-care-08-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/pet-care-08/wp-json/wp/v2/pages/1040\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:31:\"//websitedemos.net/pet-care-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47943\";a:12:{s:5:\"title\";s:8:\"About Me\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-care-08-about.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-care-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/pet-care-08/wp-json/wp/v2/pages/1042\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:40:\"//websitedemos.net/pet-care-08/about-me/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47944\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-care-08-blog.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/10/pet-care-08-blog-600x800.jpg\";s:18:\"astra-page-api-url\";s:61:\"https://websitedemos.net/pet-care-08/wp-json/wp/v2/pages/1044\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:36:\"//websitedemos.net/pet-care-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-47918\";a:12:{s:5:\"title\";s:11:\"Travel Blog\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-home.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-home-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-home-400x1337.jpg\";s:14:\"astra-site-url\";s:28:\"//websitedemos.net/travel-08\";s:20:\"astra-site-parent-id\";i:1682;s:15:\"astra-sites-tag\";a:5:{i:480;s:4:\"blog\";i:430;s:7:\"tourism\";i:427;s:6:\"travel\";i:750;s:11:\"travel-blog\";i:1683;s:14:\"travel-blogger\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:37;s:4:\"blog\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:4:{s:8:\"id-47922\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-home.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-home-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/travel-08/wp-json/wp/v2/pages/1718\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:29:\"//websitedemos.net/travel-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47920\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-blog.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-blog-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/travel-08/wp-json/wp/v2/pages/1722\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:34:\"//websitedemos.net/travel-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}s:8:\"id-47919\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-about.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/travel-08/wp-json/wp/v2/pages/1720\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:35:\"//websitedemos.net/travel-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47921\";a:12:{s:5:\"title\";s:11:\"Destination\";s:18:\"featured-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-destination.jpg\";s:19:\"thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/travel-destination-600x800.jpg\";s:18:\"astra-page-api-url\";s:59:\"https://websitedemos.net/travel-08/wp-json/wp/v2/pages/1724\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:41:\"//websitedemos.net/travel-08/destination/\";s:15:\"astra-sites-tag\";a:2:{i:785;s:11:\"destination\";i:425;s:8:\"services\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}}}}}s:8:\"id-48304\";a:12:{s:5:\"title\";s:20:\"Health &amp; Fitness\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/health-fitness-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/health-fitness-08-600x800.jpg\";s:28:\"fullpage-thumbnail-image-url\";s:82:\"https://websitedemos.net/wp-content/uploads/2020/10/health-fitness-08-400x1372.jpg\";s:14:\"astra-site-url\";s:36:\"//websitedemos.net/health-fitness-08\";s:20:\"astra-site-parent-id\";i:1720;s:15:\"astra-sites-tag\";a:4:{i:499;s:7:\"fitness\";i:521;s:12:\"fitness-blog\";i:1721;s:11:\"health-blog\";i:519;s:14:\"healthy-living\";}s:16:\"astra-sites-type\";s:4:\"free\";s:23:\"astra-site-page-builder\";s:9:\"gutenberg\";s:19:\"astra-site-category\";a:2:{i:37;s:4:\"blog\";i:39;s:4:\"free\";}s:16:\"required-plugins\";a:3:{i:0;a:3:{s:4:\"slug\";s:13:\"astra-widgets\";s:4:\"init\";s:31:\"astra-widgets/astra-widgets.php\";s:4:\"name\";s:13:\"Astra Widgets\";}i:1;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:2;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:5:\"pages\";a:3:{s:8:\"id-48307\";a:12:{s:5:\"title\";s:4:\"Home\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/10/health-fitness-08.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/10/health-fitness-08-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/health-fitness-08/wp-json/wp/v2/pages/910\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:37:\"//websitedemos.net/health-fitness-08/\";s:15:\"astra-sites-tag\";a:1:{i:423;s:4:\"home\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48306\";a:12:{s:5:\"title\";s:4:\"Blog\";s:18:\"featured-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/10/health-fitness-08-blog.jpg\";s:19:\"thumbnail-image-url\";s:86:\"https://websitedemos.net/wp-content/uploads/2020/10/health-fitness-08-blog-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/health-fitness-08/wp-json/wp/v2/pages/914\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:42:\"//websitedemos.net/health-fitness-08/blog/\";s:15:\"astra-sites-tag\";a:1:{i:480;s:4:\"blog\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-48305\";a:12:{s:5:\"title\";s:5:\"About\";s:18:\"featured-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/10/health-fitness-08-about.jpg\";s:19:\"thumbnail-image-url\";s:87:\"https://websitedemos.net/wp-content/uploads/2020/10/health-fitness-08-about-600x800.jpg\";s:18:\"astra-page-api-url\";s:66:\"https://websitedemos.net/health-fitness-08/wp-json/wp/v2/pages/912\";s:12:\"dynamic-page\";s:2:\"no\";s:14:\"astra-page-url\";s:43:\"//websitedemos.net/health-fitness-08/about/\";s:15:\"astra-sites-tag\";a:1:{i:352;s:5:\"about\";}s:15:\"site-pages-type\";s:4:\"free\";s:23:\"site-pages-page-builder\";s:9:\"gutenberg\";s:19:\"site-pages-category\";a:0:{}s:26:\"site-pages-parent-category\";a:2:{i:61;s:4:\"free\";i:74;s:4:\"blog\";}s:16:\"required-plugins\";a:2:{i:0;a:3:{s:4:\"slug\";s:9:\"gutenberg\";s:4:\"init\";s:23:\"gutenberg/gutenberg.php\";s:4:\"name\";s:9:\"Gutenberg\";}i:1;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}}}}", "no");
INSERT INTO `wp_options` VALUES("341", "_transient_timeout_megamenu_css_version", "4769396009", "no");
INSERT INTO `wp_options` VALUES("342", "_transient_megamenu_css_version", "2.9.3", "no");
INSERT INTO `wp_options` VALUES("343", "_transient_timeout_megamenu_css_last_updated", "4769396009", "no");
INSERT INTO `wp_options` VALUES("344", "_transient_megamenu_css_last_updated", "1615796009", "no");
INSERT INTO `wp_options` VALUES("396", "et_safe_mode_plugins_allowlist", "a:8:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:27:\"ari-adminer/ari-adminer.php\";i:5;s:31:\"query-monitor/query-monitor.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}", "yes");
INSERT INTO `wp_options` VALUES("397", "et_support_center_installed", "true", "yes");
INSERT INTO `wp_options` VALUES("398", "et_images_temp_folder", "C:\\wamp64\\www\\SODILEVE/wp-content/uploads/et_temp", "yes");
INSERT INTO `wp_options` VALUES("399", "et_schedule_clean_images_last_time", "1637770388", "yes");
INSERT INTO `wp_options` VALUES("7855", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-5.8.2.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-5.8.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.8.2\";s:7:\"version\";s:5:\"5.8.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.6\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1638190154;s:15:\"version_checked\";s:5:\"5.8.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("7874", "_transient_timeout_et_core_path", "1638276599", "no");
INSERT INTO `wp_options` VALUES("7645", "_transient_timeout_wpseo_total_unindexed_posts", "1638260030", "no");
INSERT INTO `wp_options` VALUES("402", "et_pb_builder_options", "a:2:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("173", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"pa.hulin@sodileve.fr\";s:7:\"version\";s:5:\"5.8.2\";s:9:\"timestamp\";i:1636961125;}", "no");
INSERT INTO `wp_options` VALUES("5692", "ywctm_apply_users", "all", "yes");
INSERT INTO `wp_options` VALUES("3074", "et_pb_contact_form_7e512c5b1caf95eb74dec97fcfef4281", "off", "yes");
INSERT INTO `wp_options` VALUES("181", "nav_menu_options", "a:1:{s:8:\"auto_add\";a:1:{i:0;i:25;}}", "yes");
INSERT INTO `wp_options` VALUES("2769", "widget_recent-posts-widget-with-thumbnails", "a:2:{i:2;a:39:{s:5:\"title\";s:0:\"\";s:11:\"default_url\";s:98:\"http://localhost/SODILEVE/wp-content/plugins/recent-posts-widget-with-thumbnails/default_thumb.gif\";s:16:\"thumb_dimensions\";s:6:\"custom\";s:12:\"category_ids\";a:1:{i:0;i:0;}s:14:\"excerpt_length\";i:55;s:12:\"number_posts\";i:10;s:17:\"post_title_length\";i:1000;s:12:\"thumb_height\";i:75;s:11:\"thumb_width\";i:75;s:17:\"hide_current_post\";b:0;s:17:\"only_sticky_posts\";b:0;s:17:\"hide_sticky_posts\";b:0;s:10:\"hide_title\";b:0;s:17:\"keep_aspect_ratio\";b:0;s:11:\"keep_sticky\";b:0;s:12:\"only_1st_img\";b:0;s:12:\"random_order\";b:0;s:11:\"show_author\";b:0;s:15:\"show_categories\";b:0;s:20:\"show_comments_number\";b:0;s:9:\"show_date\";b:0;s:12:\"show_excerpt\";b:0;s:14:\"ignore_excerpt\";b:0;s:27:\"ignore_post_content_excerpt\";b:0;s:16:\"set_more_as_link\";b:0;s:11:\"try_1st_img\";b:0;s:11:\"use_default\";b:0;s:16:\"use_default_only\";b:0;s:15:\"open_new_window\";b:1;s:21:\"print_post_categories\";b:0;s:17:\"set_cats_as_links\";b:0;s:14:\"use_inline_css\";b:0;s:10:\"use_no_css\";b:0;s:14:\"hide_alt_texts\";b:0;s:10:\"show_thumb\";b:1;s:12:\"author_label\";s:2:\"By\";s:12:\"excerpt_more\";s:6:\" […]\";s:14:\"category_label\";s:2:\"In\";s:9:\"thumb_alt\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("3942", "duplicate_post_blacklist", "", "yes");
INSERT INTO `wp_options` VALUES("3943", "duplicate_post_types_enabled", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "yes");
INSERT INTO `wp_options` VALUES("190", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("391", "widget_adsensewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("192", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("193", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:36:\"wp-tools-divi-blog-carousel/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:5:\"2.3.2\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1617884763;s:11:\"plugin_path\";s:59:\"wp-tools-divi-blog-carousel/wp-tools-divi-blog-carousel.php\";}}s:7:\"abspath\";s:23:\"C:\\wamp64\\www\\SODILEVE/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:59:\"wp-tools-divi-blog-carousel/wp-tools-divi-blog-carousel.php\";s:8:\"sdk_path\";s:36:\"wp-tools-divi-blog-carousel/freemius\";s:7:\"version\";s:5:\"2.3.2\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1617884763;}}", "yes");
INSERT INTO `wp_options` VALUES("194", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("195", "fs_accounts", "a:15:{s:21:\"id_slug_type_path_map\";a:3:{i:4892;a:3:{s:4:\"slug\";s:12:\"block-slider\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:23:\"block-slider/plugin.php\";}i:2539;a:3:{s:4:\"slug\";s:21:\"miguras-divi-enhancer\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:30:\"miguras-divi-enhancer/main.php\";}i:4156;a:3:{s:4:\"slug\";s:27:\"wp-tools-divi-blog-carousel\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:59:\"wp-tools-divi-blog-carousel/wp-tools-divi-blog-carousel.php\";}}s:11:\"plugin_data\";a:3:{s:12:\"block-slider\";a:23:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:23:\"block-slider/plugin.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1614069425;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.3.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"1.1.2\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:9:\"localhost\";s:9:\"server_ip\";s:3:\"::1\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1614069425;s:7:\"version\";s:5:\"1.1.2\";}s:15:\"prev_is_premium\";b:0;s:14:\"has_trial_plan\";b:1;s:22:\"install_sync_timestamp\";i:1614086218;s:19:\"keepalive_timestamp\";i:1614086218;s:20:\"activation_timestamp\";i:1614069434;s:14:\"sync_timestamp\";i:1614069446;s:15:\"is_whitelabeled\";b:0;s:9:\"beta_data\";a:2:{s:7:\"is_beta\";b:0;s:7:\"version\";s:5:\"1.1.2\";}s:16:\"uninstall_reason\";O:8:\"stdClass\":3:{s:2:\"id\";s:2:\"13\";s:4:\"info\";s:0:\"\";s:12:\"is_anonymous\";b:0;}}s:21:\"miguras-divi-enhancer\";a:22:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:30:\"miguras-divi-enhancer/main.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1617812001;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.4.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"5.0.5\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:9:\"localhost\";s:9:\"server_ip\";s:3:\"::1\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1617812001;s:7:\"version\";s:5:\"5.0.5\";}s:15:\"prev_is_premium\";b:0;s:30:\"is_extensions_tracking_allowed\";b:1;s:14:\"has_trial_plan\";b:0;s:22:\"install_sync_timestamp\";i:1617873710;s:19:\"keepalive_timestamp\";i:1617873710;s:20:\"activation_timestamp\";i:1617812009;s:14:\"sync_timestamp\";i:1617864389;s:16:\"uninstall_reason\";O:8:\"stdClass\":3:{s:2:\"id\";s:2:\"10\";s:4:\"info\";s:0:\"\";s:12:\"is_anonymous\";b:0;}}s:27:\"wp-tools-divi-blog-carousel\";a:25:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:59:\"wp-tools-divi-blog-carousel/wp-tools-divi-blog-carousel.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1617884763;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.3.2\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"1.2.0\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:9:\"localhost\";s:9:\"server_ip\";s:3:\"::1\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1617884763;s:7:\"version\";s:5:\"1.2.0\";}s:15:\"prev_is_premium\";b:0;s:30:\"is_extensions_tracking_allowed\";b:1;s:14:\"has_trial_plan\";b:1;s:22:\"install_sync_timestamp\";i:1638190088;s:19:\"keepalive_timestamp\";i:1638190088;s:20:\"activation_timestamp\";i:1617884768;s:14:\"sync_timestamp\";i:1638190088;s:15:\"is_whitelabeled\";b:0;s:9:\"sync_cron\";O:8:\"stdClass\":5:{s:7:\"version\";s:5:\"1.2.0\";s:7:\"blog_id\";i:0;s:11:\"sdk_version\";s:5:\"2.3.2\";s:9:\"timestamp\";i:1617884797;s:2:\"on\";b:1;}s:9:\"beta_data\";a:2:{s:7:\"is_beta\";b:0;s:7:\"version\";s:5:\"1.2.0\";}s:21:\"trial_promotion_shown\";i:1638174237;}}s:13:\"file_slug_map\";a:3:{s:23:\"block-slider/plugin.php\";s:12:\"block-slider\";s:30:\"miguras-divi-enhancer/main.php\";s:21:\"miguras-divi-enhancer\";s:59:\"wp-tools-divi-blog-carousel/wp-tools-divi-blog-carousel.php\";s:27:\"wp-tools-divi-blog-carousel\";}s:7:\"plugins\";a:3:{s:12:\"block-slider\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:38:\"WordPress Slider Plugin - Block Slider\";s:4:\"slug\";s:12:\"block-slider\";s:12:\"premium_slug\";s:20:\"block-slider-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:23:\"block-slider/plugin.php\";s:7:\"version\";s:5:\"1.1.2\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:3:\"Pro\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_7ae0c8f55e8e50153a0296efc09a5\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"4892\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:21:\"miguras-divi-enhancer\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:13:\"DIVI Enhancer\";s:4:\"slug\";s:21:\"miguras-divi-enhancer\";s:12:\"premium_slug\";s:29:\"miguras-divi-enhancer-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:30:\"miguras-divi-enhancer/main.php\";s:7:\"version\";s:5:\"5.0.5\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_38e4349d274180e479a9982a0aef2\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"2539\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:27:\"wp-tools-divi-blog-carousel\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:27:\"WP Tools Divi Blog Carousel\";s:4:\"slug\";s:27:\"wp-tools-divi-blog-carousel\";s:12:\"premium_slug\";s:35:\"wp-tools-divi-blog-carousel-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:59:\"wp-tools-divi-blog-carousel/wp-tools-divi-blog-carousel.php\";s:7:\"version\";s:5:\"1.2.0\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:7:\"Premium\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_0a2a7e7d89f1d3fa4d73e1ae70754\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"4156\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"59ca7dc04ebeb4715a62c3532702528b\";s:5:\"plans\";a:3:{s:12:\"block-slider\";a:2:{i:0;O:14:\"FS_Plugin_Plan\":21:{s:9:\"plugin_id\";s:8:\"NDg5Mg==\";s:4:\"name\";s:8:\"ZnJlZQ==\";s:5:\"title\";s:8:\"RnJlZQ==\";s:11:\"description\";N;s:17:\"is_free_localhost\";s:4:\"MQ==\";s:17:\"is_block_features\";s:4:\"MQ==\";s:12:\"license_type\";s:4:\"MA==\";s:16:\"is_https_support\";s:0:\"\";s:12:\"trial_period\";N;s:23:\"is_require_subscription\";s:0:\"\";s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";s:0:\"\";s:11:\"is_featured\";s:0:\"\";s:2:\"id\";s:8:\"Nzg2Nw==\";s:7:\"updated\";N;s:7:\"created\";s:28:\"MjAxOS0xMC0yNiAxMTowOTo1Mw==\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:14:\"FS_Plugin_Plan\":21:{s:9:\"plugin_id\";s:8:\"NDg5Mg==\";s:4:\"name\";s:4:\"cHJv\";s:5:\"title\";s:4:\"UHJv\";s:11:\"description\";N;s:17:\"is_free_localhost\";s:4:\"MQ==\";s:17:\"is_block_features\";s:0:\"\";s:12:\"license_type\";s:4:\"MA==\";s:16:\"is_https_support\";s:0:\"\";s:12:\"trial_period\";s:4:\"MTQ=\";s:23:\"is_require_subscription\";s:0:\"\";s:10:\"support_kb\";s:40:\"aHR0cHM6Ly93cGJsb2Nrc2xpZGVyLmNvbS9kb2Nz\";s:13:\"support_forum\";N;s:13:\"support_email\";s:28:\"c3VwcG9ydF9ic0BjYWtld3AuY29t\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";s:0:\"\";s:11:\"is_featured\";s:4:\"MQ==\";s:2:\"id\";s:8:\"Nzg2OA==\";s:7:\"updated\";s:28:\"MjAyMC0xMi0xNiAxMTowMzo0Nw==\";s:7:\"created\";s:28:\"MjAxOS0xMC0yNiAxMjoxMDowNg==\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:21:\"miguras-divi-enhancer\";a:1:{i:0;O:14:\"FS_Plugin_Plan\":21:{s:9:\"plugin_id\";s:8:\"MjUzOQ==\";s:4:\"name\";s:8:\"ZnJlZQ==\";s:5:\"title\";s:8:\"RnJlZQ==\";s:11:\"description\";s:12:\"RnJlZSBQbGFu\";s:17:\"is_free_localhost\";s:4:\"MQ==\";s:17:\"is_block_features\";s:4:\"MQ==\";s:12:\"license_type\";s:4:\"MA==\";s:16:\"is_https_support\";s:0:\"\";s:12:\"trial_period\";N;s:23:\"is_require_subscription\";s:0:\"\";s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";s:0:\"\";s:11:\"is_featured\";s:0:\"\";s:2:\"id\";s:8:\"Mzk5Mg==\";s:7:\"updated\";s:28:\"MjAxOS0wMS0xNiAyMTo0MDo1OQ==\";s:7:\"created\";s:28:\"MjAxOC0wOS0xMCAwNDo0OToxOQ==\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:27:\"wp-tools-divi-blog-carousel\";a:2:{i:0;O:14:\"FS_Plugin_Plan\":21:{s:9:\"plugin_id\";s:8:\"NDE1Ng==\";s:4:\"name\";s:8:\"ZnJlZQ==\";s:5:\"title\";s:8:\"RnJlZQ==\";s:11:\"description\";N;s:17:\"is_free_localhost\";s:4:\"MQ==\";s:17:\"is_block_features\";s:4:\"MQ==\";s:12:\"license_type\";s:4:\"MA==\";s:16:\"is_https_support\";s:0:\"\";s:12:\"trial_period\";N;s:23:\"is_require_subscription\";s:0:\"\";s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";s:0:\"\";s:11:\"is_featured\";s:0:\"\";s:2:\"id\";s:8:\"NjczOQ==\";s:7:\"updated\";N;s:7:\"created\";s:28:\"MjAxOS0wNy0yMiAwNTozOTowOA==\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:14:\"FS_Plugin_Plan\":21:{s:9:\"plugin_id\";s:8:\"NDE1Ng==\";s:4:\"name\";s:12:\"cHJlbWl1bQ==\";s:5:\"title\";s:12:\"UHJlbWl1bQ==\";s:11:\"description\";N;s:17:\"is_free_localhost\";s:4:\"MQ==\";s:17:\"is_block_features\";s:4:\"MQ==\";s:12:\"license_type\";s:4:\"MA==\";s:16:\"is_https_support\";s:0:\"\";s:12:\"trial_period\";s:4:\"Nw==\";s:23:\"is_require_subscription\";s:0:\"\";s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";s:0:\"\";s:11:\"is_featured\";s:4:\"MQ==\";s:2:\"id\";s:8:\"Njc0MA==\";s:7:\"updated\";s:28:\"MjAxOS0wNy0yOSAxMjowNDozMg==\";s:7:\"created\";s:28:\"MjAxOS0wNy0yMiAwNTozOToyNQ==\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}s:14:\"active_plugins\";O:8:\"stdClass\":3:{s:9:\"timestamp\";i:1638190088;s:3:\"md5\";s:32:\"6d0df0cb925e6f596c3ad69e89cd0fa3\";s:7:\"plugins\";a:17:{s:19:\"monarch/monarch.php\";a:5:{s:4:\"slug\";s:7:\"monarch\";s:7:\"version\";s:6:\"1.4.14\";s:5:\"title\";s:14:\"Monarch Plugin\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:45:\"post-carousel-for-dv-builder/postcarousel.php\";a:5:{s:4:\"slug\";s:28:\"post-carousel-for-dv-builder\";s:7:\"version\";s:3:\"1.3\";s:5:\"title\";s:28:\"Post Carousel for DV Builder\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";a:5:{s:4:\"slug\";s:19:\"shortcodes-ultimate\";s:7:\"version\";s:5:\"5.9.8\";s:5:\"title\";s:19:\"Shortcodes Ultimate\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:47:\"simple-divi-shortcode/simple_divi_shortcode.php\";a:5:{s:4:\"slug\";s:21:\"simple-divi-shortcode\";s:7:\"version\";s:3:\"1.0\";s:5:\"title\";s:21:\"Simple Divi Shortcode\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:38:\"yith-woocommerce-catalog-mode/init.php\";a:5:{s:4:\"slug\";s:29:\"yith-woocommerce-catalog-mode\";s:7:\"version\";s:6:\"2.0.11\";s:5:\"title\";s:29:\"YITH WooCommerce Catalog Mode\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:33:\"divi-sumo-lite/divi-sumo-lite.php\";a:5:{s:4:\"slug\";s:14:\"divi-sumo-lite\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"title\";s:15:\"DiviSumo (Lite)\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:59:\"wp-tools-divi-blog-carousel/wp-tools-divi-blog-carousel.php\";a:5:{s:4:\"slug\";s:27:\"wp-tools-divi-blog-carousel\";s:7:\"version\";s:5:\"1.2.0\";s:5:\"title\";s:27:\"WP Tools Divi Blog Carousel\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:39:\"flip-cards-module-divi/divi-flipbox.php\";a:18:{s:20:\"WC requires at least\";s:0:\"\";s:15:\"WC tested up to\";s:0:\"\";s:3:\"Woo\";s:0:\"\";s:4:\"Name\";s:26:\"Flip Cards Module For Divi\";s:9:\"PluginURI\";s:45:\"http://www.learnhowwp.com/divi-flipbox-plugin\";s:7:\"Version\";s:5:\"0.9.3\";s:11:\"Description\";s:116:\"This plugin adds a Flipbox Modules in the Divi Builder which allows you to create flip cards on your website easily.\";s:6:\"Author\";s:14:\"learnhowwp.com\";s:9:\"AuthorURI\";s:25:\"http://www.learnhowwp.com\";s:10:\"TextDomain\";s:16:\"lwp-divi-flipbox\";s:10:\"DomainPath\";s:10:\"/languages\";s:7:\"Network\";b:0;s:10:\"RequiresWP\";s:0:\"\";s:11:\"RequiresPHP\";s:0:\"\";s:5:\"Title\";s:26:\"Flip Cards Module For Divi\";s:10:\"AuthorName\";s:14:\"learnhowwp.com\";s:9:\"is_active\";b:1;s:4:\"slug\";s:22:\"flip-cards-module-divi\";}s:75:\"recent-posts-widget-with-thumbnails/recent-posts-widget-with-thumbnails.php\";a:5:{s:4:\"slug\";s:35:\"recent-posts-widget-with-thumbnails\";s:7:\"version\";s:5:\"7.0.3\";s:5:\"title\";s:35:\"Recent Posts Widget With Thumbnails\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:31:\"divi-mega-pro/divi-mega-pro.php\";a:5:{s:4:\"slug\";s:13:\"divi-mega-pro\";s:7:\"version\";s:7:\"1.9.1.1\";s:5:\"title\";s:13:\"Divi Mega Pro\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:47:\"companion-auto-update/companion-auto-update.php\";a:5:{s:4:\"slug\";s:21:\"companion-auto-update\";s:7:\"version\";s:5:\"3.8.2\";s:5:\"title\";s:21:\"Companion Auto Update\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:23:\"wp-smushit/wp-smush.php\";a:5:{s:4:\"slug\";s:10:\"wp-smushit\";s:7:\"version\";s:5:\"3.9.2\";s:5:\"title\";s:5:\"Smush\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:23:\"wordfence/wordfence.php\";a:5:{s:4:\"slug\";s:9:\"wordfence\";s:7:\"version\";s:5:\"7.5.6\";s:5:\"title\";s:18:\"Wordfence Security\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:35:\"wp-fastest-cache/wpFastestCache.php\";a:5:{s:4:\"slug\";s:16:\"wp-fastest-cache\";s:7:\"version\";s:5:\"0.9.5\";s:5:\"title\";s:16:\"WP Fastest Cache\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:24:\"wordpress-seo/wp-seo.php\";a:5:{s:4:\"slug\";s:13:\"wordpress-seo\";s:7:\"version\";s:4:\"17.5\";s:5:\"title\";s:9:\"Yoast SEO\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}s:27:\"woocommerce/woocommerce.php\";a:19:{s:20:\"WC requires at least\";s:0:\"\";s:15:\"WC tested up to\";s:0:\"\";s:3:\"Woo\";s:0:\"\";s:4:\"Name\";s:11:\"WooCommerce\";s:9:\"PluginURI\";s:24:\"https://woocommerce.com/\";s:7:\"Version\";s:5:\"5.9.0\";s:11:\"Description\";s:63:\"An eCommerce toolkit that helps you sell anything. Beautifully.\";s:6:\"Author\";s:10:\"Automattic\";s:9:\"AuthorURI\";s:23:\"https://woocommerce.com\";s:10:\"TextDomain\";s:11:\"woocommerce\";s:10:\"DomainPath\";s:16:\"/i18n/languages/\";s:7:\"Network\";b:0;s:10:\"RequiresWP\";s:3:\"5.6\";s:11:\"RequiresPHP\";s:3:\"7.0\";s:9:\"UpdateURI\";s:0:\"\";s:5:\"Title\";s:11:\"WooCommerce\";s:10:\"AuthorName\";s:10:\"Automattic\";s:9:\"is_active\";b:1;s:4:\"slug\";s:11:\"woocommerce\";}s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";a:5:{s:4:\"slug\";s:23:\"all-in-one-wp-migration\";s:7:\"version\";s:4:\"7.50\";s:5:\"title\";s:23:\"All-in-One WP Migration\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}}}s:11:\"all_plugins\";O:8:\"stdClass\":3:{s:9:\"timestamp\";i:1638190088;s:3:\"md5\";s:32:\"3a90e11b8e8ad244d1e6a57618c0a180\";s:7:\"plugins\";a:20:{s:19:\"monarch/monarch.php\";a:5:{s:4:\"slug\";s:7:\"monarch\";s:7:\"version\";s:6:\"1.4.14\";s:5:\"title\";s:14:\"Monarch Plugin\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:45:\"post-carousel-for-dv-builder/postcarousel.php\";a:5:{s:4:\"slug\";s:28:\"post-carousel-for-dv-builder\";s:7:\"version\";s:3:\"1.3\";s:5:\"title\";s:28:\"Post Carousel for DV Builder\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:43:\"shortcodes-ultimate/shortcodes-ultimate.php\";a:6:{s:4:\"slug\";s:19:\"shortcodes-ultimate\";s:7:\"version\";s:5:\"5.9.8\";s:5:\"title\";s:19:\"Shortcodes Ultimate\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:7:\"Version\";s:6:\"5.11.1\";}s:47:\"simple-divi-shortcode/simple_divi_shortcode.php\";a:5:{s:4:\"slug\";s:21:\"simple-divi-shortcode\";s:7:\"version\";s:3:\"1.0\";s:5:\"title\";s:21:\"Simple Divi Shortcode\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:63:\"ultimate-addons-for-gutenberg/ultimate-addons-for-gutenberg.php\";a:6:{s:4:\"slug\";s:29:\"ultimate-addons-for-gutenberg\";s:7:\"version\";s:6:\"1.22.1\";s:5:\"title\";s:29:\"Ultimate Addons for Gutenberg\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:7:\"Version\";s:6:\"1.25.1\";}s:20:\"we-blocks/plugin.php\";a:6:{s:4:\"slug\";s:9:\"we-blocks\";s:7:\"version\";s:5:\"1.3.1\";s:5:\"title\";s:70:\"WE Blocks - Posts, Image, Testimonial And Logo Slider Gutenberg Blocks\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:7:\"Version\";s:5:\"1.3.2\";}s:27:\"woocommerce/woocommerce.php\";a:6:{s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:5:\"5.1.0\";s:5:\"title\";s:11:\"WooCommerce\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:7:\"Version\";s:5:\"5.9.0\";}s:38:\"yith-woocommerce-catalog-mode/init.php\";a:6:{s:4:\"slug\";s:29:\"yith-woocommerce-catalog-mode\";s:7:\"version\";s:6:\"2.0.11\";s:5:\"title\";s:29:\"YITH WooCommerce Catalog Mode\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:7:\"Version\";s:5:\"2.3.0\";}s:33:\"divi-sumo-lite/divi-sumo-lite.php\";a:5:{s:4:\"slug\";s:14:\"divi-sumo-lite\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"title\";s:15:\"DiviSumo (Lite)\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:39:\"flip-cards-module-divi/divi-flipbox.php\";a:6:{s:4:\"slug\";s:22:\"flip-cards-module-divi\";s:7:\"version\";s:5:\"0.9.3\";s:5:\"title\";s:26:\"Flip Cards Module For Divi\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:7:\"Version\";s:5:\"0.9.4\";}s:59:\"wp-tools-divi-blog-carousel/wp-tools-divi-blog-carousel.php\";a:5:{s:4:\"slug\";s:27:\"wp-tools-divi-blog-carousel\";s:7:\"version\";s:5:\"1.2.0\";s:5:\"title\";s:27:\"WP Tools Divi Blog Carousel\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:75:\"recent-posts-widget-with-thumbnails/recent-posts-widget-with-thumbnails.php\";a:6:{s:4:\"slug\";s:35:\"recent-posts-widget-with-thumbnails\";s:7:\"version\";s:5:\"7.0.3\";s:5:\"title\";s:35:\"Recent Posts Widget With Thumbnails\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:7:\"Version\";s:5:\"7.1.1\";}s:31:\"divi-mega-pro/divi-mega-pro.php\";a:5:{s:4:\"slug\";s:13:\"divi-mega-pro\";s:7:\"version\";s:7:\"1.9.1.1\";s:5:\"title\";s:13:\"Divi Mega Pro\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:30:\"caldera-forms/caldera-core.php\";a:5:{s:4:\"slug\";s:13:\"caldera-forms\";s:7:\"version\";s:5:\"1.9.5\";s:5:\"title\";s:13:\"Caldera Forms\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:47:\"companion-auto-update/companion-auto-update.php\";a:5:{s:4:\"slug\";s:21:\"companion-auto-update\";s:7:\"version\";s:5:\"3.8.2\";s:5:\"title\";s:21:\"Companion Auto Update\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:23:\"wp-smushit/wp-smush.php\";a:5:{s:4:\"slug\";s:10:\"wp-smushit\";s:7:\"version\";s:5:\"3.9.2\";s:5:\"title\";s:5:\"Smush\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:23:\"wordfence/wordfence.php\";a:6:{s:4:\"slug\";s:9:\"wordfence\";s:7:\"version\";s:5:\"7.5.6\";s:5:\"title\";s:18:\"Wordfence Security\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:7:\"Version\";s:5:\"7.5.7\";}s:35:\"wp-fastest-cache/wpFastestCache.php\";a:5:{s:4:\"slug\";s:16:\"wp-fastest-cache\";s:7:\"version\";s:5:\"0.9.5\";s:5:\"title\";s:16:\"WP Fastest Cache\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:24:\"wordpress-seo/wp-seo.php\";a:6:{s:4:\"slug\";s:13:\"wordpress-seo\";s:7:\"version\";s:4:\"17.5\";s:5:\"title\";s:9:\"Yoast SEO\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:7:\"Version\";s:4:\"17.6\";}s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";a:5:{s:4:\"slug\";s:23:\"all-in-one-wp-migration\";s:7:\"version\";s:4:\"7.50\";s:5:\"title\";s:23:\"All-in-One WP Migration\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}}}s:10:\"all_themes\";O:8:\"stdClass\":3:{s:9:\"timestamp\";i:1638190088;s:3:\"md5\";s:32:\"96fe5109fff94153a6596e2752d92232\";s:6:\"themes\";a:4:{s:14:\"twentynineteen\";a:5:{s:4:\"slug\";s:14:\"twentynineteen\";s:7:\"version\";s:3:\"2.1\";s:5:\"title\";s:15:\"Twenty Nineteen\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:12:\"twentytwenty\";a:5:{s:4:\"slug\";s:12:\"twentytwenty\";s:7:\"version\";s:3:\"1.8\";s:5:\"title\";s:13:\"Twenty Twenty\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:15:\"twentytwentyone\";a:5:{s:4:\"slug\";s:15:\"twentytwentyone\";s:7:\"version\";s:3:\"1.4\";s:5:\"title\";s:17:\"Twenty Twenty-One\";s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;}s:4:\"Divi\";a:5:{s:4:\"slug\";s:4:\"Divi\";s:7:\"version\";s:6:\"4.14.1\";s:5:\"title\";s:4:\"Divi\";s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;}}}s:5:\"sites\";a:3:{s:12:\"block-slider\";O:7:\"FS_Site\":25:{s:7:\"site_id\";s:8:\"87224372\";s:9:\"plugin_id\";s:4:\"4892\";s:7:\"user_id\";s:7:\"4424181\";s:5:\"title\";s:57:\"Ponts roulants | Potence | Palan | Maintenance - SODILEVE\";s:3:\"url\";s:25:\"http://localhost/SODILEVE\";s:7:\"version\";s:5:\"1.1.2\";s:8:\"language\";s:5:\"fr-FR\";s:7:\"charset\";s:5:\"UTF-8\";s:16:\"platform_version\";s:5:\"5.6.2\";s:11:\"sdk_version\";s:5:\"2.3.1\";s:28:\"programming_language_version\";s:6:\"7.3.21\";s:7:\"plan_id\";s:4:\"7867\";s:10:\"license_id\";N;s:13:\"trial_plan_id\";N;s:10:\"trial_ends\";N;s:10:\"is_premium\";b:0;s:15:\"is_disconnected\";b:1;s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:10:\"public_key\";s:32:\"pk_e02fa6186ea8e051ede7b1e5b75cf\";s:10:\"secret_key\";s:32:\"sk_oP%?L>yLs}d(8K=EZ>=e}z@EP3<-t\";s:2:\"id\";s:7:\"6747199\";s:7:\"updated\";s:19:\"2021-02-23 13:07:49\";s:7:\"created\";s:19:\"2021-02-23 08:37:14\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:21:\"miguras-divi-enhancer\";O:7:\"FS_Site\":25:{s:7:\"site_id\";s:8:\"87224372\";s:9:\"plugin_id\";s:4:\"2539\";s:7:\"user_id\";s:7:\"4424181\";s:5:\"title\";s:57:\"Ponts roulants | Potence | Palan | Maintenance - SODILEVE\";s:3:\"url\";s:25:\"http://localhost/SODILEVE\";s:7:\"version\";s:5:\"5.0.5\";s:8:\"language\";s:5:\"fr-FR\";s:7:\"charset\";s:5:\"UTF-8\";s:16:\"platform_version\";s:3:\"5.7\";s:11:\"sdk_version\";s:5:\"2.4.1\";s:28:\"programming_language_version\";s:5:\"7.4.9\";s:7:\"plan_id\";s:4:\"3992\";s:10:\"license_id\";N;s:13:\"trial_plan_id\";N;s:10:\"trial_ends\";N;s:10:\"is_premium\";b:0;s:15:\"is_disconnected\";b:0;s:9:\"is_active\";b:0;s:14:\"is_uninstalled\";b:0;s:10:\"public_key\";s:32:\"pk_b8b8867bb7b05f6a50e158baec84c\";s:10:\"secret_key\";s:32:\"sk_61>0RtW;]3GHU0}XoG33^>(e0b3;x\";s:2:\"id\";s:7:\"7090280\";s:7:\"updated\";s:19:\"2021-04-08 09:21:36\";s:7:\"created\";s:19:\"2021-04-07 16:13:30\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:27:\"wp-tools-divi-blog-carousel\";O:7:\"FS_Site\":25:{s:7:\"site_id\";s:8:\"87224372\";s:9:\"plugin_id\";s:4:\"4156\";s:7:\"user_id\";s:7:\"4424181\";s:5:\"title\";s:57:\"Ponts roulants | Potence | Palan | Maintenance - SODILEVE\";s:3:\"url\";s:25:\"http://localhost/SODILEVE\";s:7:\"version\";s:5:\"1.2.0\";s:8:\"language\";s:5:\"fr-FR\";s:7:\"charset\";s:5:\"UTF-8\";s:16:\"platform_version\";s:3:\"5.7\";s:11:\"sdk_version\";s:5:\"2.3.2\";s:28:\"programming_language_version\";s:5:\"7.4.9\";s:7:\"plan_id\";s:4:\"6739\";s:10:\"license_id\";N;s:13:\"trial_plan_id\";N;s:10:\"trial_ends\";N;s:10:\"is_premium\";b:0;s:15:\"is_disconnected\";b:0;s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;s:10:\"public_key\";s:32:\"pk_ba356cf19db1a7cbb449f7a5e5b5d\";s:10:\"secret_key\";s:32:\"sk_sam=ZP8TaT[O}r7td>up;P14?8&A7\";s:2:\"id\";s:7:\"7096689\";s:7:\"updated\";N;s:7:\"created\";s:19:\"2021-04-08 12:26:09\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:5:\"users\";a:1:{i:4424181;O:7:\"FS_User\":13:{s:5:\"email\";s:20:\"pa.hulin@sodileve.fr\";s:5:\"first\";s:9:\"adminsodi\";s:4:\"last\";s:0:\"\";s:11:\"is_verified\";b:0;s:7:\"is_beta\";b:0;s:11:\"customer_id\";N;s:5:\"gross\";i:0;s:10:\"public_key\";s:32:\"pk_f6f0e2bc7a5394b77805ef9f12960\";s:10:\"secret_key\";s:32:\"sk_e+FXF!Lz^}_];PCIMQcSm}D61t7QW\";s:2:\"id\";s:7:\"4424181\";s:7:\"updated\";N;s:7:\"created\";s:19:\"2021-02-23 08:37:13\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:23:\"user_id_license_ids_map\";a:2:{i:4892;a:1:{i:4424181;a:0:{}}i:4156;a:1:{i:4424181;a:0:{}}}s:12:\"all_licenses\";a:2:{i:4892;a:0:{}i:4156;a:0:{}}s:7:\"updates\";a:2:{i:4892;N;i:4156;N;}s:13:\"admin_notices\";a:3:{s:12:\"block-slider\";a:0:{}s:21:\"miguras-divi-enhancer\";a:0:{}s:27:\"wp-tools-divi-blog-carousel\";a:1:{s:15:\"trial_promotion\";a:8:{s:7:\"message\";s:438:\"Hey! Que pensez-vous de <b>WP Tools Divi Blog Carousel</b> ? Testez nos formidable fonctionnalités premium avec 7 jours d\'essai gratuit. Pas besoin de carte bancaire!  <a style=\"margin-left: 10px; vertical-align: super;\" href=\"http://localhost/SODILEVE/wp-admin/admin.php?billing_cycle=annual&trial=true&page=wp-tools-divi-blog-carousel-pricing\"><button class=\"button button-primary\">Commencer l\'essai gratuit &nbsp;&#10140;</button></a>\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:9:\"promotion\";s:6:\"sticky\";b:1;s:2:\"id\";s:15:\"trial_promotion\";s:10:\"manager_id\";s:27:\"wp-tools-divi-blog-carousel\";s:6:\"plugin\";s:27:\"WP Tools Divi Blog Carousel\";s:10:\"wp_user_id\";N;}}}}", "yes");
INSERT INTO `wp_options` VALUES("196", "fs_gdpr", "a:1:{s:2:\"u1\";a:2:{s:8:\"required\";b:0;s:18:\"show_opt_in_notice\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("197", "fs_api_cache", "a:5:{s:45:\"get:/v1/users/4424181/plugins/4156/plans.json\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:5:\"plans\";a:2:{i:0;O:14:\"FS_Plugin_Plan\":21:{s:9:\"plugin_id\";s:4:\"4156\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:2:\"id\";s:4:\"6739\";s:7:\"updated\";N;s:7:\"created\";s:19:\"2019-07-22 05:39:08\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:14:\"FS_Plugin_Plan\":21:{s:9:\"plugin_id\";s:4:\"4156\";s:4:\"name\";s:7:\"premium\";s:5:\"title\";s:7:\"Premium\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";i:7;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"6740\";s:7:\"updated\";s:19:\"2019-07-29 12:04:32\";s:7:\"created\";s:19:\"2019-07-22 05:39:25\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}s:7:\"created\";i:1636028837;s:9:\"timestamp\";i:1636115237;}s:56:\"get:/v1/users/4424181.json?plugin_id=4156&fields=is_beta\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":2:{s:2:\"id\";s:7:\"4424181\";s:7:\"is_beta\";b:0;}s:7:\"created\";i:1638173616;s:9:\"timestamp\";i:1638260016;}s:65:\"get:/v1/users/4424181/plugins/4156/licenses.json?is_enriched=true\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:8:\"licenses\";a:0:{}}s:7:\"created\";i:1636028837;s:9:\"timestamp\";i:1636115237;}s:73:\"get:/v1/installs/7096689/updates/latest.json?is_premium=false&readme=true\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":19:{s:9:\"plugin_id\";s:4:\"4156\";s:12:\"developer_id\";s:4:\"4541\";s:4:\"slug\";N;s:12:\"premium_slug\";s:35:\"wp-tools-divi-blog-carousel-premium\";s:7:\"version\";s:5:\"1.2.0\";s:11:\"sdk_version\";s:5:\"2.3.2\";s:25:\"requires_platform_version\";s:5:\"4.9.8\";s:20:\"tested_up_to_version\";s:5:\"5.4.2\";s:8:\"has_free\";b:1;s:11:\"has_premium\";b:1;s:12:\"release_mode\";s:8:\"released\";s:5:\"limit\";N;s:7:\"uniques\";i:32;s:2:\"id\";s:5:\"19572\";s:7:\"created\";s:19:\"2020-07-19 05:50:38\";s:7:\"updated\";s:19:\"2021-04-06 18:16:07\";s:11:\"is_released\";b:0;s:3:\"url\";s:387:\"https://api.freemius.com/v1/installs/7096689/updates/19572.zip?is_premium=false&authorization=FSLA+7096689%3AHrBFtY01cH1XKJxP2uF2pdyPteWdzA87binXohGm80g51D6d0j34ZGjTVsev1I1VPCB8fDxkmQkcsGsB8khfPu7Ecs0GI9QA-wAWnktM8buf7qmSNjRAuVVVhdy7sMgnozLqu_bk9NbrzVa781SUpf3jCgNqNUuPA_fN_fGi_prMYCGujGA6idvLOsYhk2y6k5YihRAnzztGw1dl8ydjwoDA5yPQ7qMkbF4q53SuA9IeqZipnUO5LRvTA0kt7kWkyfJb8GfswWTxNMmnR-d04g\";s:6:\"readme\";O:8:\"stdClass\":11:{s:4:\"name\";s:27:\"WP Tools Divi Blog Carousel\";s:4:\"slug\";s:27:\"wp-tools-divi-blog-carousel\";s:4:\"tags\";O:8:\"stdClass\":3:{s:4:\"divi\";s:4:\"divi\";s:14:\"image carousel\";s:14:\"image carousel\";s:11:\"divi module\";s:11:\"divi module\";}s:8:\"requires\";s:5:\"4.9.8\";s:6:\"tested\";s:5:\"5.4.2\";s:10:\"stable_tag\";s:5:\"1.2.0\";s:8:\"sections\";O:8:\"stdClass\":5:{s:11:\"description\";s:2262:\"<p>The <strong>WP Tools Divi Blog Carousel</strong> plugin provides a divi module for cycling through blog or post items.</p>\n\n<blockquote>\n  <p>Show your featured blog posts on a carousel using the <strong>Divi Blog Carousel</strong> module.</p>\n</blockquote>\n\n<p>This plugin requires <a href=\"http://bit.ly/2xcicxw\">Divi Theme</a> (Affiliate link) be installed and activated.</p>\n\n<p><strong>WP Tools Divi Blog Carousel</strong> module provides following functionality.</p>\n\n<ul>\n<li>Full visual builder and backend builder support.</li>\n<li>Select unlimited number of blogs for the carousel. Order blog items with drag and drop.</li>\n<li>Set number of blog item per slide for desktop view. (Premium version allows you to set the items on tablet and mobile view)</li>\n<li>Dot navigation (Set the ability to show/hide and apply color in premium version)</li>\n<li>Arrow navigation (Set the ability to show/hide and apply color in premium version)</li>\n</ul>\n\n<p>== Premium version features</p>\n\n<p><a href=\"https://wptools.app/wordpress-plugin/divi-blog-carousel/?utm_source=wp&amp;utm_medium=plugin-page&amp;utm_campaign=divi-blog-carousel&amp;utm_content=description\">Premium plugin</a></p>\n\n<ul>\n<li><strong>Full visual builder</strong> and back-end builder support.</li>\n<li>Add <strong>unlimited number of blogs</strong>. Set the blog order with drag and drop.</li>\n<li>Set the number of visible blogs for desktop, tablet and mobile view. <strong>Make your carousel fully responsive</strong>.</li>\n<li>Ability to set a slide as default.</li>\n<li>Set <strong>carousel motion settings</strong> like infinite loops, auto-play, play speed and hover events.</li>\n<li>Toggle dot/arrow <strong>carousel navigation</strong> and set their colors.</li>\n<li>Ability to set <strong>rounded corners for slide</strong>.</li>\n<li>Ability to apply <strong>border style to slide</strong>.</li>\n<li>Ability to apply <strong>box shadow to slide</strong>.</li>\n<li>Ability to set padding for slide.</li>\n<li>Custom css for\n\n<ul>\n<li>Slide</li>\n<li>Blog Image</li>\n<li>Blog Title</li>\n<li>Arrow navigation and pseudo <code>:before</code></li>\n<li>Dot navigation and pseudo <code>:before</code></li>\n<li>Active dot navigation and pseudo <code>:before</code></li>\n</ul></li>\n</ul>\";s:12:\"installation\";s:226:\"<ol>\n<li>Goto your <code>WordPress Admin &gt; Plugins &gt; Add New</code></li>\n<li>Search for <code>wp-tools-divi-blog-carousel</code>. </li>\n<li>Install and activate plugin (with the author as <code>wpt00ls</code>)</li>\n</ol>\";s:3:\"faq\";s:110:\"<h4>Are there are any dependencies for this plugin</h4>\n\n<p>No, there are no dependencies for this plugin.</p>\";s:9:\"changelog\";s:600:\"<h4>1.2.0</h4>\n\n<ul>\n<li>Added compatibility for Divi 4.5.1+</li>\n<li>Compatible with WordPress 5.4.2</li>\n</ul>\n\n<h4>1.1.0</h4>\n\n<ul>\n<li>Updated freemius SDK to 2.3.2</li>\n<li>Moved settings from <code>WP Tools</code> to <code>Divi</code>. Removed parent <code>WP Tools</code> settings page.</li>\n<li>Fixed advanced/toggle options in divi module for wp.org version.</li>\n<li>Tested for WordPress 5.4</li>\n</ul>\n\n<h4>1.0.1</h4>\n\n<ul>\n<li>Added 7 day free trial</li>\n</ul>\n\n<h4>1.0.0</h4>\n\n<ul>\n<li>Created free version for wordpress.org==</li>\n<li>Created premium version for freemius.com</li>\n</ul>\";s:11:\"screenshots\";s:0:\"\";}s:14:\"upgrade_notice\";b:0;s:11:\"donate_link\";s:21:\" https://wptools.app/\";s:7:\"version\";s:5:\"1.2.0\";s:13:\"download_link\";s:387:\"https://api.freemius.com/v1/installs/7096689/updates/19572.zip?is_premium=false&authorization=FSLA+7096689%3AHrBFtY01cH1XKJxP2uF2pdyPteWdzA87binXohGm80g51D6d0j34ZGjTVsev1I1VPCB8fDxkmQkcsGsB8khfPu7Ecs0GI9QA-wAWnktM8buf7qmSNjRAuVVVhdy7sMgnozLqu_bk9NbrzVa781SUpf3jCgNqNUuPA_fN_fGi_prMYCGujGA6idvLOsYhk2y6k5YihRAnzztGw1dl8ydjwoDA5yPQ7qMkbF4q53SuA9IeqZipnUO5LRvTA0kt7kWkyfJb8GfswWTxNMmnR-d04g\";}}s:7:\"created\";i:1617884797;s:9:\"timestamp\";i:1617888397;}s:68:\"get:/v1/users/4424181/plugins/4156/payments.json?include_addons=true\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:8:\"payments\";a:0:{}}s:7:\"created\";i:1617884797;s:9:\"timestamp\";i:1617971197;}}", "no");
INSERT INTO `wp_options` VALUES("390", "widget_aboutmewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("205", "smart_post_show_version", "2.2.5", "yes");
INSERT INTO `wp_options` VALUES("206", "smart_post_show_db_version", "2.2.5", "yes");
INSERT INTO `wp_options` VALUES("207", "smart_post_show_first_version", "2.2.5", "yes");
INSERT INTO `wp_options` VALUES("208", "smart_post_show_activation_date", "1614089438", "yes");
INSERT INTO `wp_options` VALUES("209", "sp_post_carousel_settings", "a:12:{s:19:\"pcp_delete_all_data\";b:0;s:13:\"pcp_swiper_js\";b:1;s:14:\"pcp_swiper_css\";b:1;s:19:\"pcp_fontawesome_css\";b:1;s:13:\"accessibility\";b:1;s:18:\"prev_slide_message\";s:14:\"Previous slide\";s:18:\"next_slide_message\";s:10:\"Next slide\";s:19:\"first_slide_message\";s:23:\"This is the first slide\";s:18:\"last_slide_message\";s:22:\"This is the last slide\";s:25:\"pagination_bullet_message\";s:21:\"Go to slide {{index}}\";s:14:\"pcp_custom_css\";s:0:\"\";s:13:\"pcp_custom_js\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("210", "smart_post_show_review_notice_dismiss", "a:2:{s:4:\"time\";i:1614085839;s:9:\"dismissed\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("211", "wp_carousel_free_version", "2.1.16", "yes");
INSERT INTO `wp_options` VALUES("212", "wp_carousel_free_db_version", "2.1.16", "yes");
INSERT INTO `wp_options` VALUES("213", "sp_wpcp_settings", "a:5:{s:20:\"wpcf_delete_all_data\";b:0;s:22:\"wpcp_enqueue_slick_css\";b:1;s:19:\"wpcp_enqueue_fa_css\";b:1;s:13:\"wpcp_slick_js\";b:1;s:15:\"wpcp_custom_css\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("214", "sp_wp_carousel_free_review_notice_dismiss", "a:2:{s:4:\"time\";i:1614086123;s:9:\"dismissed\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("200", "_site_transient_timeout_locked_1", "1929429436", "no");
INSERT INTO `wp_options` VALUES("201", "_site_transient_locked_1", "1", "no");
INSERT INTO `wp_options` VALUES("7779", "_transient_timeout_as-post-store-dependencies-met", "1638268155", "no");
INSERT INTO `wp_options` VALUES("7780", "_transient_as-post-store-dependencies-met", "yes", "no");
INSERT INTO `wp_options` VALUES("1624", "woocommerce_tracker_last_send", "1637770516", "yes");
INSERT INTO `wp_options` VALUES("395", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("381", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("224", "widget_wplp_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("226", "wplp_jufeedback_version", "1.0.0", "yes");
INSERT INTO `wp_options` VALUES("227", "wplp_db_version", "4.0.2", "yes");
INSERT INTO `wp_options` VALUES("228", "has_views_count_post_meta_key", "1", "yes");
INSERT INTO `wp_options` VALUES("389", "et_divi", "a:168:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:30:\"et_flush_rewrite_rules_library\";s:6:\"4.14.1\";s:31:\"divi_previous_installed_version\";s:6:\"4.13.1\";s:29:\"divi_latest_installed_version\";s:6:\"4.14.1\";s:27:\"divi_skip_font_subset_force\";b:1;s:27:\"et_pb_clear_templates_cache\";b:1;s:23:\"builder_custom_defaults\";O:8:\"stdClass\":0:{}s:33:\"customizer_settings_migrated_flag\";b:1;s:34:\"builder_custom_defaults_unmigrated\";b:0;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:22:\"builder_global_presets\";O:8:\"stdClass\":0:{}s:29:\"custom_defaults_migrated_flag\";b:1;s:15:\"divi_1_3_images\";s:7:\"checked\";s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:12:\"divi_favicon\";s:0:\"\";s:19:\"product_tour_status\";a:1:{i:1;s:3:\"off\";}s:24:\"footer_widget_text_color\";s:7:\"#ffffff\";s:24:\"footer_widget_link_color\";s:7:\"#ffffff\";s:12:\"boxed_layout\";b:0;s:13:\"content_width\";i:1309;s:12:\"gutter_width\";i:3;s:12:\"accent_color\";s:7:\"#000000\";s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:20:\"et_fb_pref_view_mode\";s:7:\"desktop\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:42:\"et_fb_pref_quick_actions_always_start_with\";s:7:\"nothing\";s:44:\"et_fb_pref_quick_actions_show_recent_queries\";s:3:\"off\";s:39:\"et_fb_pref_quick_actions_recent_queries\";s:0:\"\";s:40:\"et_fb_pref_quick_actions_recent_category\";s:0:\"\";s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:0:\"\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:911;s:33:\"et_fb_pref_modal_dimension_height\";i:574;s:27:\"et_fb_pref_modal_position_x\";i:425;s:27:\"et_fb_pref_modal_position_y\";i:137;s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:36:\"et_fb_pref_lv_modal_dimension_height\";i:619;s:35:\"et_fb_pref_lv_modal_dimension_width\";i:382;s:30:\"et_fb_pref_lv_modal_position_x\";i:27;s:30:\"et_fb_pref_lv_modal_position_y\";i:76;s:34:\"et_fb_pref_responsive_tablet_width\";i:768;s:35:\"et_fb_pref_responsive_tablet_height\";i:0;s:33:\"et_fb_pref_responsive_phone_width\";i:400;s:34:\"et_fb_pref_responsive_phone_height\";i:0;s:35:\"et_fb_pref_responsive_minimum_width\";i:320;s:35:\"et_fb_pref_responsive_maximum_width\";i:980;s:18:\"divi_color_palette\";s:63:\"#000000|#ffffff|#fecb1f|#e09900|#edf000|#7cda24|#0c71c3|#8300e9\";s:9:\"divi_logo\";s:89:\"http://localhost/SODILEVE/wp-content/uploads/2021/03/Logo_SODILEVE_Pont-roulant-palan.png\";s:14:\"divi_fixed_nav\";s:5:\"false\";s:26:\"divi_gallery_layout_enable\";s:5:\"false\";s:15:\"divi_grab_image\";s:5:\"false\";s:15:\"divi_blog_style\";s:5:\"false\";s:12:\"divi_sidebar\";s:16:\"et_right_sidebar\";s:22:\"divi_shop_page_sidebar\";s:16:\"et_right_sidebar\";s:23:\"divi_show_facebook_icon\";s:2:\"on\";s:22:\"divi_show_twitter_icon\";s:2:\"on\";s:21:\"divi_show_google_icon\";s:2:\"on\";s:24:\"divi_show_instagram_icon\";s:2:\"on\";s:18:\"divi_show_rss_icon\";s:2:\"on\";s:17:\"divi_facebook_url\";s:34:\"https://www.facebook.com/sodileve/\";s:16:\"divi_twitter_url\";s:30:\"https://twitter.com/sodileve86\";s:15:\"divi_google_url\";s:1:\"#\";s:18:\"divi_instagram_url\";s:37:\"https://www.instagram.com/sodileve86/\";s:12:\"divi_rss_url\";s:0:\"\";s:34:\"divi_woocommerce_archive_num_posts\";i:9;s:17:\"divi_catnum_posts\";i:6;s:21:\"divi_archivenum_posts\";i:5;s:20:\"divi_searchnum_posts\";i:5;s:17:\"divi_tagnum_posts\";i:5;s:16:\"divi_date_format\";s:5:\"j/M/Y\";s:16:\"divi_use_excerpt\";s:2:\"on\";s:26:\"divi_responsive_shortcodes\";s:2:\"on\";s:33:\"divi_gf_enable_all_character_sets\";s:5:\"false\";s:16:\"divi_back_to_top\";s:2:\"on\";s:18:\"divi_smooth_scroll\";s:2:\"on\";s:25:\"divi_disable_translations\";s:5:\"false\";s:29:\"divi_enable_responsive_images\";s:2:\"on\";s:27:\"divi_minify_combine_scripts\";s:2:\"on\";s:26:\"divi_minify_combine_styles\";s:2:\"on\";s:15:\"divi_custom_css\";s:0:\"\";s:21:\"divi_enable_dropdowns\";s:2:\"on\";s:14:\"divi_home_link\";s:5:\"false\";s:15:\"divi_sort_pages\";s:10:\"post_title\";s:15:\"divi_order_page\";s:3:\"asc\";s:22:\"divi_tiers_shown_pages\";i:3;s:32:\"divi_enable_dropdowns_categories\";s:2:\"on\";s:21:\"divi_categories_empty\";s:2:\"on\";s:27:\"divi_tiers_shown_categories\";i:3;s:13:\"divi_sort_cat\";s:4:\"name\";s:14:\"divi_order_cat\";s:3:\"asc\";s:20:\"divi_disable_toptier\";s:5:\"false\";s:27:\"et_pb_post_type_integration\";a:5:{s:4:\"post\";s:2:\"on\";s:4:\"page\";s:2:\"on\";s:7:\"project\";s:2:\"on\";s:7:\"product\";s:2:\"on\";s:13:\"divi_mega_pro\";s:2:\"on\";}s:21:\"et_pb_static_css_file\";s:3:\"off\";s:19:\"et_pb_css_in_footer\";s:3:\"off\";s:25:\"et_pb_product_tour_global\";s:2:\"on\";s:24:\"et_enable_classic_editor\";s:3:\"off\";s:14:\"divi_postinfo2\";a:0:{}s:22:\"divi_show_postcomments\";s:5:\"false\";s:15:\"divi_thumbnails\";s:2:\"on\";s:20:\"divi_page_thumbnails\";s:5:\"false\";s:23:\"divi_show_pagescomments\";s:5:\"false\";s:14:\"divi_postinfo1\";a:0:{}s:21:\"divi_thumbnails_index\";s:2:\"on\";s:19:\"divi_seo_home_title\";s:5:\"false\";s:25:\"divi_seo_home_description\";s:5:\"false\";s:22:\"divi_seo_home_keywords\";s:5:\"false\";s:23:\"divi_seo_home_canonical\";s:5:\"false\";s:23:\"divi_seo_home_titletext\";s:0:\"\";s:29:\"divi_seo_home_descriptiontext\";s:0:\"\";s:26:\"divi_seo_home_keywordstext\";s:0:\"\";s:18:\"divi_seo_home_type\";s:27:\"BlogName | Blog description\";s:22:\"divi_seo_home_separate\";s:3:\" | \";s:21:\"divi_seo_single_title\";s:5:\"false\";s:27:\"divi_seo_single_description\";s:5:\"false\";s:24:\"divi_seo_single_keywords\";s:5:\"false\";s:25:\"divi_seo_single_canonical\";s:5:\"false\";s:27:\"divi_seo_single_field_title\";s:9:\"seo_title\";s:33:\"divi_seo_single_field_description\";s:15:\"seo_description\";s:30:\"divi_seo_single_field_keywords\";s:12:\"seo_keywords\";s:20:\"divi_seo_single_type\";s:21:\"Post title | BlogName\";s:24:\"divi_seo_single_separate\";s:3:\" | \";s:24:\"divi_seo_index_canonical\";s:5:\"false\";s:26:\"divi_seo_index_description\";s:5:\"false\";s:19:\"divi_seo_index_type\";s:24:\"Category name | BlogName\";s:23:\"divi_seo_index_separate\";s:3:\" | \";s:28:\"divi_integrate_header_enable\";s:2:\"on\";s:26:\"divi_integrate_body_enable\";s:2:\"on\";s:31:\"divi_integrate_singletop_enable\";s:2:\"on\";s:34:\"divi_integrate_singlebottom_enable\";s:2:\"on\";s:21:\"divi_integration_head\";s:0:\"\";s:21:\"divi_integration_body\";s:0:\"\";s:27:\"divi_integration_single_top\";s:0:\"\";s:30:\"divi_integration_single_bottom\";s:0:\"\";s:15:\"divi_468_enable\";s:5:\"false\";s:14:\"divi_468_image\";s:0:\"\";s:12:\"divi_468_url\";s:0:\"\";s:16:\"divi_468_adsense\";s:0:\"\";s:28:\"et_fb_pref_limited_view_mode\";s:9:\"wireframe\";s:35:\"et_fb_pref_limited_modal_preference\";s:7:\"default\";s:32:\"et_fb_pref_limited_toolbar_click\";s:5:\"false\";s:34:\"et_fb_pref_limited_toolbar_desktop\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_grid\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_hover\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_phone\";s:4:\"true\";s:33:\"et_fb_pref_limited_toolbar_tablet\";s:4:\"true\";s:36:\"et_fb_pref_limited_toolbar_wireframe\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_zoom\";s:4:\"true\";s:32:\"et_pb_woocommerce_product_layout\";s:16:\"et_right_sidebar\";s:29:\"et_pb_woocommerce_page_layout\";s:21:\"et_build_from_scratch\";s:16:\"et_global_colors\";a:1:{s:41:\"gcid-b2ba6f99-8577-4166-9535-0d331c33a476\";a:2:{s:5:\"color\";s:7:\"#ff0000\";s:6:\"active\";s:3:\"yes\";}}}", "yes");
INSERT INTO `wp_options` VALUES("257", "quadmenu_twentytwentyone", "a:116:{s:8:\"last_tab\";s:0:\"\";s:8:\"viewport\";s:1:\"1\";s:6:\"styles\";s:1:\"1\";s:16:\"styles_normalize\";s:1:\"1\";s:14:\"styles_widgets\";s:1:\"1\";s:17:\"styles_pscrollbar\";s:1:\"1\";s:18:\"styles_owlcarousel\";s:1:\"1\";s:12:\"styles_icons\";s:9:\"dashicons\";s:19:\"primary_integration\";s:1:\"1\";s:14:\"primary_unwrap\";s:1:\"1\";s:13:\"primary_theme\";s:13:\"default_theme\";s:18:\"footer_integration\";s:1:\"1\";s:13:\"footer_unwrap\";s:1:\"1\";s:12:\"footer_theme\";s:13:\"default_theme\";s:6:\"gutter\";s:2:\"30\";s:15:\"screen_sm_width\";s:3:\"768\";s:15:\"screen_md_width\";s:3:\"992\";s:15:\"screen_lg_width\";s:4:\"1200\";s:25:\"default_theme_theme_title\";s:13:\"Default Theme\";s:20:\"default_theme_layout\";s:5:\"embed\";s:36:\"default_theme_layout_offcanvas_float\";s:5:\"right\";s:26:\"default_theme_layout_align\";s:5:\"right\";s:31:\"default_theme_layout_breakpoint\";s:3:\"768\";s:26:\"default_theme_layout_width\";s:1:\"0\";s:32:\"default_theme_layout_width_inner\";s:1:\"0\";s:41:\"default_theme_layout_width_inner_selector\";s:0:\"\";s:29:\"default_theme_layout_lazyload\";s:0:\"\";s:28:\"default_theme_layout_current\";s:0:\"\";s:28:\"default_theme_layout_divider\";s:4:\"hide\";s:26:\"default_theme_layout_caret\";s:4:\"show\";s:28:\"default_theme_layout_classes\";s:0:\"\";s:28:\"default_theme_layout_trigger\";s:11:\"hoverintent\";s:39:\"default_theme_layout_dropdown_maxheight\";s:1:\"1\";s:31:\"default_theme_navbar_background\";s:5:\"color\";s:37:\"default_theme_navbar_background_color\";s:7:\"#333333\";s:34:\"default_theme_navbar_background_to\";s:7:\"#000000\";s:35:\"default_theme_navbar_background_deg\";s:2:\"17\";s:25:\"default_theme_navbar_text\";s:7:\"#aaaaaa\";s:27:\"default_theme_navbar_height\";s:2:\"60\";s:26:\"default_theme_navbar_width\";s:3:\"260\";s:30:\"default_theme_navbar_logo_link\";s:26:\"http://localhost/SODILEVE/\";s:25:\"default_theme_navbar_logo\";a:9:{s:3:\"url\";s:85:\"http://localhost/SODILEVE/wp-content/plugins/quadmenu/assets/frontend/images/logo.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:32:\"default_theme_navbar_logo_height\";s:2:\"25\";s:28:\"default_theme_navbar_logo_bg\";s:11:\"transparent\";s:32:\"default_theme_navbar_link_margin\";a:6:{s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:3:\"0px\";s:13:\"border-bottom\";s:3:\"0px\";s:11:\"border-left\";s:3:\"0px\";s:12:\"border-style\";s:0:\"\";s:12:\"border-color\";s:7:\"#000000\";}s:32:\"default_theme_navbar_link_radius\";a:6:{s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:3:\"0px\";s:13:\"border-bottom\";s:3:\"0px\";s:11:\"border-left\";s:3:\"0px\";s:12:\"border-style\";s:0:\"\";s:12:\"border-color\";s:0:\"\";}s:25:\"default_theme_navbar_link\";s:7:\"#f1f1f1\";s:28:\"default_theme_navbar_link_bg\";s:11:\"transparent\";s:31:\"default_theme_navbar_link_hover\";s:7:\"#ffffff\";s:34:\"default_theme_navbar_link_bg_hover\";s:7:\"#111111\";s:28:\"default_theme_navbar_divider\";s:21:\"rgba(255,255,255,0.5)\";s:38:\"default_theme_navbar_link_hover_effect\";s:21:\"rgba(255,255,255,0.3)\";s:30:\"default_theme_navbar_link_icon\";s:7:\"#eeeeee\";s:36:\"default_theme_navbar_link_icon_hover\";s:7:\"#ffffff\";s:34:\"default_theme_navbar_link_subtitle\";s:7:\"#eeeeee\";s:40:\"default_theme_navbar_link_subtitle_hover\";s:7:\"#ffffff\";s:32:\"default_theme_navbar_badge_color\";s:7:\"#ffffff\";s:26:\"default_theme_navbar_badge\";s:7:\"#fb88dd\";s:27:\"default_theme_navbar_button\";s:7:\"#ffffff\";s:38:\"default_theme_navbar_button_background\";s:7:\"#fb88dd\";s:33:\"default_theme_navbar_button_hover\";s:7:\"#383838\";s:44:\"default_theme_navbar_button_hover_background\";s:7:\"#eeeeee\";s:34:\"default_theme_navbar_button_radius\";a:6:{s:10:\"border-top\";s:3:\"2px\";s:12:\"border-right\";s:3:\"2px\";s:13:\"border-bottom\";s:3:\"2px\";s:11:\"border-left\";s:3:\"2px\";s:12:\"border-style\";s:0:\"\";s:12:\"border-color\";s:7:\"#000000\";}s:30:\"default_theme_navbar_scrollbar\";s:7:\"#fb88dd\";s:35:\"default_theme_navbar_scrollbar_rail\";s:7:\"#ffffff\";s:27:\"default_theme_layout_sticky\";s:1:\"0\";s:34:\"default_theme_layout_sticky_offset\";s:1:\"0\";s:31:\"default_theme_sticky_background\";s:16:\"rgba(0,0,0,0.95)\";s:27:\"default_theme_sticky_height\";s:2:\"60\";s:32:\"default_theme_sticky_logo_height\";s:2:\"25\";s:27:\"default_theme_mobile_shadow\";s:4:\"show\";s:34:\"default_theme_navbar_mobile_border\";s:21:\"rgba(255,255,255,0.1)\";s:32:\"default_theme_navbar_toggle_open\";s:7:\"#ffffff\";s:33:\"default_theme_navbar_toggle_close\";s:7:\"#fb88dd\";s:33:\"default_theme_mobile_link_padding\";a:6:{s:10:\"border-top\";s:4:\"15px\";s:12:\"border-right\";s:4:\"30px\";s:13:\"border-bottom\";s:4:\"15px\";s:11:\"border-left\";s:4:\"30px\";s:12:\"border-style\";s:0:\"\";s:12:\"border-color\";s:0:\"\";}s:32:\"default_theme_mobile_link_border\";a:6:{s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:4:\"none\";s:12:\"border-color\";s:11:\"transparent\";}s:29:\"default_theme_dropdown_shadow\";s:4:\"show\";s:29:\"default_theme_dropdown_margin\";s:1:\"0\";s:29:\"default_theme_dropdown_radius\";a:6:{s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:3:\"0px\";s:13:\"border-bottom\";s:3:\"0px\";s:11:\"border-left\";s:3:\"0px\";s:12:\"border-style\";s:0:\"\";s:12:\"border-color\";s:7:\"#000000\";}s:29:\"default_theme_dropdown_border\";a:6:{s:10:\"border-top\";s:3:\"0px\";s:12:\"border-right\";s:3:\"0px\";s:13:\"border-bottom\";s:3:\"0px\";s:11:\"border-left\";s:3:\"0px\";s:12:\"border-style\";s:0:\"\";s:12:\"border-color\";s:7:\"#000000\";}s:33:\"default_theme_dropdown_background\";s:7:\"#ffffff\";s:27:\"default_theme_dropdown_link\";s:7:\"#444444\";s:33:\"default_theme_dropdown_link_hover\";s:7:\"#333333\";s:36:\"default_theme_dropdown_link_bg_hover\";s:7:\"#f4f4f4\";s:34:\"default_theme_dropdown_link_border\";a:6:{s:10:\"border-top\";s:3:\"1px\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:7:\"#f4f4f4\";}s:28:\"default_theme_dropdown_title\";s:7:\"#444444\";s:35:\"default_theme_dropdown_title_border\";a:6:{s:10:\"border-top\";s:3:\"1px\";s:12:\"border-right\";s:0:\"\";s:13:\"border-bottom\";s:0:\"\";s:11:\"border-left\";s:0:\"\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-color\";s:7:\"#fb88dd\";}s:32:\"default_theme_dropdown_link_icon\";s:7:\"#fb88dd\";s:38:\"default_theme_dropdown_link_icon_hover\";s:7:\"#a9a9a9\";s:36:\"default_theme_dropdown_link_subtitle\";s:7:\"#a0a0a0\";s:42:\"default_theme_dropdown_link_subtitle_hover\";s:7:\"#cccccc\";s:29:\"default_theme_dropdown_button\";s:7:\"#ffffff\";s:32:\"default_theme_dropdown_button_bg\";s:7:\"#fb88dd\";s:35:\"default_theme_dropdown_button_hover\";s:7:\"#ffffff\";s:38:\"default_theme_dropdown_button_bg_hover\";s:7:\"#000000\";s:29:\"default_theme_dropdown_tab_bg\";s:16:\"rgba(0,0,0,0.05)\";s:35:\"default_theme_dropdown_tab_bg_hover\";s:15:\"rgba(0,0,0,0.1)\";s:32:\"default_theme_dropdown_scrollbar\";s:7:\"#fb88dd\";s:37:\"default_theme_dropdown_scrollbar_rail\";s:7:\"#ffffff\";s:18:\"default_theme_font\";a:8:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:6:\"normal\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:2:\"11\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:25:\"default_theme_navbar_font\";a:8:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:6:\"normal\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:2:\"11\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:35:\"default_theme_navbar_link_transform\";s:9:\"uppercase\";s:27:\"default_theme_dropdown_font\";a:8:{s:11:\"font-family\";s:27:\"Verdana, Geneva, sans-serif\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:6:\"normal\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:2:\"11\";s:14:\"letter-spacing\";s:7:\"inherit\";}s:37:\"default_theme_dropdown_link_transform\";s:4:\"none\";s:33:\"default_theme_layout_hover_effect\";s:21:\"quadmenu-hover-ripple\";s:35:\"default_theme_navbar_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:39:\"default_theme_navbar_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:35:\"default_theme_navbar_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:36:\"default_theme_navbar_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:35:\"default_theme_navbar_animation_cart\";a:2:{s:7:\"options\";s:15:\"quadmenu_bounce\";s:5:\"speed\";s:5:\"t_500\";}s:30:\"default_theme_layout_animation\";a:2:{s:7:\"options\";s:12:\"quadmenu_btt\";s:5:\"speed\";s:5:\"t_300\";}s:37:\"default_theme_dropdown_animation_text\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:41:\"default_theme_dropdown_animation_subtitle\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:37:\"default_theme_dropdown_animation_icon\";a:3:{s:7:\"options\";s:0:\"\";s:6:\"action\";s:5:\"hover\";s:5:\"speed\";s:6:\"t_1000\";}s:38:\"default_theme_dropdown_animation_badge\";a:3:{s:7:\"options\";s:14:\"quadmenu_swing\";s:6:\"action\";s:4:\"loop\";s:5:\"speed\";s:6:\"t_1000\";}s:3:\"css\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("255", "redux_version_upgraded_from", "3.6.18", "yes");
INSERT INTO `wp_options` VALUES("256", "widget_quadmenu_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("258", "quadmenu_twentytwentyone-transients", "a:2:{s:14:\"changed_values\";a:2:{s:18:\"footer_integration\";s:1:\"0\";s:13:\"footer_unwrap\";s:1:\"0\";}s:9:\"last_save\";i:1615795686;}", "yes");
INSERT INTO `wp_options` VALUES("259", "quadmenu_twentytwentyone_locations", "a:3:{s:7:\"primary\";a:1:{s:4:\"name\";s:14:\"Menu principal\";}s:6:\"footer\";a:1:{s:4:\"name\";s:15:\"Menu secondaire\";}s:12:\"quadmenu_dev\";a:1:{s:4:\"name\";s:12:\"QuadMenu Dev\";}}", "yes");
INSERT INTO `wp_options` VALUES("271", "carousel_slider_version", "1.10.0", "yes");
INSERT INTO `wp_options` VALUES("272", "widget_widget_carousel_slider", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:11:\"carousel_id\";i:65;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("273", "carousel_slider_settings", "a:1:{s:12:\"load_scripts\";s:9:\"optimized\";}", "yes");
INSERT INTO `wp_options` VALUES("379", "current_theme", "Divi", "yes");
INSERT INTO `wp_options` VALUES("380", "theme_mods_Divi", "a:7:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:12:\"primary-menu\";i:24;s:14:\"secondary-menu\";i:3;}s:18:\"custom_css_post_id\";i:119;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";s:16:\"background_color\";s:6:\"fecb1f\";s:13:\"et_pb_widgets\";a:2:{s:5:\"areas\";a:1:{s:19:\"et_pb_widget_area_1\";s:15:\"ZoneWidgetSODI1\";}s:6:\"number\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("277", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("278", "gutenberg_version_migration", "9.8.0", "yes");
INSERT INTO `wp_options` VALUES("382", "et_pb_cache_notice", "a:1:{s:5:\"4.9.2\";s:6:\"ignore\";}", "yes");
INSERT INTO `wp_options` VALUES("404", "et_account_status", "active", "no");
INSERT INTO `wp_options` VALUES("387", "et_core_version", "4.14.1", "yes");
INSERT INTO `wp_options` VALUES("282", "__uagb_do_redirect", "", "yes");
INSERT INTO `wp_options` VALUES("283", "uagb-version", "1.22.1", "yes");
INSERT INTO `wp_options` VALUES("287", "_transient_health-check-site-status-result", "{\"good\":15,\"recommended\":5,\"critical\":0}", "yes");
INSERT INTO `wp_options` VALUES("439", "ast-block-templates-site-requests", "1", "no");
INSERT INTO `wp_options` VALUES("440", "ast-block-templates-blocks-1", "a:65:{s:8:\"id-47413\";a:9:{s:5:\"title\";s:7:\"FAQ 3GW\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/09/faq-gb-3w-1.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/09/faq-gb-3w-1-400x275.jpg\";s:3:\"url\";s:46:\"https://websitedemos.net/astra-blocks/faq-3gw/\";s:3:\"tag\";a:2:{i:822;s:3:\"faq\";i:821;s:26:\"frequently-asked-questions\";}s:8:\"category\";i:1001;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47355\";a:9:{s:5:\"title\";s:16:\"Testimonials 1GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-1w-1.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-1w-1-400x172.jpg\";s:3:\"url\";s:55:\"https://websitedemos.net/astra-blocks/testimonials-1gw/\";s:3:\"tag\";a:1:{i:844;s:11:\"testimonial\";}s:8:\"category\";i:830;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47436\";a:9:{s:5:\"title\";s:8:\"Hero 3GW\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-3w-1.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-3w-1-400x214.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/hero-3gw/\";s:3:\"tag\";a:1:{i:817;s:4:\"hero\";}s:8:\"category\";i:831;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47437\";a:9:{s:5:\"title\";s:8:\"Hero 4GW\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-4w-1.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-4w-1-400x218.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/hero-4gw/\";s:3:\"tag\";a:1:{i:817;s:4:\"hero\";}s:8:\"category\";i:831;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47433\";a:9:{s:5:\"title\";s:16:\"Testimonials 4GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-4w-1.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-4w-1-400x144.jpg\";s:3:\"url\";s:55:\"https://websitedemos.net/astra-blocks/testimonials-4gw/\";s:3:\"tag\";a:1:{i:844;s:11:\"testimonial\";}s:8:\"category\";i:830;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47438\";a:9:{s:5:\"title\";s:8:\"Hero 5GB\";s:18:\"featured-image-url\";s:66:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-5w.jpg\";s:19:\"thumbnail-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-5w-400x168.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/hero-5gb/\";s:3:\"tag\";a:1:{i:817;s:4:\"hero\";}s:8:\"category\";i:831;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:4:\"dark\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47445\";a:9:{s:5:\"title\";s:16:\"Testimonials 5GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-5w-1.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-5w-1-400x134.jpg\";s:3:\"url\";s:55:\"https://websitedemos.net/astra-blocks/testimonials-5gw/\";s:3:\"tag\";a:1:{i:844;s:11:\"testimonial\";}s:8:\"category\";i:830;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47439\";a:9:{s:5:\"title\";s:8:\"Hero 6GB\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-6b-1.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-6b-1-400x204.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/hero-6gb/\";s:3:\"tag\";a:1:{i:817;s:4:\"hero\";}s:8:\"category\";i:831;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:4:\"dark\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47449\";a:9:{s:5:\"title\";s:16:\"Testimonials 6GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-6w-1.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-6w-1-400x156.jpg\";s:3:\"url\";s:55:\"https://websitedemos.net/astra-blocks/testimonials-6gw/\";s:3:\"tag\";a:1:{i:844;s:11:\"testimonial\";}s:8:\"category\";i:830;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47527\";a:9:{s:5:\"title\";s:12:\"Services 5GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-5w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-5w-1-400x283.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/services-5gw/\";s:3:\"tag\";a:1:{i:953;s:8:\"services\";}s:8:\"category\";i:952;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47419\";a:9:{s:5:\"title\";s:12:\"Features 1GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-1w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-1w-1-400x225.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/features-1gw/\";s:3:\"tag\";a:1:{i:920;s:8:\"features\";}s:8:\"category\";i:919;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47434\";a:9:{s:5:\"title\";s:8:\"Hero 1GW\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-1w-1.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-1w-1-400x220.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/hero-1gw/\";s:3:\"tag\";a:1:{i:817;s:4:\"hero\";}s:8:\"category\";i:831;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47424\";a:9:{s:5:\"title\";s:12:\"Features 6GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-6w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-6w-1-400x243.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/features-6gw/\";s:3:\"tag\";a:1:{i:920;s:8:\"features\";}s:8:\"category\";i:919;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47423\";a:9:{s:5:\"title\";s:12:\"Features 5GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-5w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-5w-1-400x300.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/features-5gw/\";s:3:\"tag\";a:1:{i:920;s:8:\"features\";}s:8:\"category\";i:919;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47360\";a:9:{s:5:\"title\";s:16:\"Testimonials 2GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-2w-1.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-2w-1-400x166.jpg\";s:3:\"url\";s:55:\"https://websitedemos.net/astra-blocks/testimonials-2gw/\";s:3:\"tag\";a:1:{i:844;s:11:\"testimonial\";}s:8:\"category\";i:830;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47380\";a:9:{s:5:\"title\";s:11:\"Contact 2GW\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-2w.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-2w-400x231.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/contact-2gw/\";s:3:\"tag\";a:1:{i:823;s:7:\"contact\";}s:8:\"category\";i:1416;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:1:{i:0;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}}s:8:\"id-47412\";a:9:{s:5:\"title\";s:7:\"FAQ 2GW\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/09/faq-gb-2w-2.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/09/faq-gb-2w-2-400x298.jpg\";s:3:\"url\";s:46:\"https://websitedemos.net/astra-blocks/faq-2gw/\";s:3:\"tag\";a:2:{i:822;s:3:\"faq\";i:821;s:26:\"frequently-asked-questions\";}s:8:\"category\";i:1001;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47411\";a:9:{s:5:\"title\";s:7:\"FAQ 1GW\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/09/faq-gb-1w-2.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/09/faq-gb-1w-2-400x263.jpg\";s:3:\"url\";s:46:\"https://websitedemos.net/astra-blocks/faq-1gw/\";s:3:\"tag\";a:2:{i:822;s:3:\"faq\";i:821;s:26:\"frequently-asked-questions\";}s:8:\"category\";i:1001;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47420\";a:9:{s:5:\"title\";s:12:\"Features 2GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-2w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-2w-1-400x265.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/features-2gw/\";s:3:\"tag\";a:1:{i:920;s:8:\"features\";}s:8:\"category\";i:919;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47421\";a:9:{s:5:\"title\";s:12:\"Features 3GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-3w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-3w-1-400x264.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/features-3gw/\";s:3:\"tag\";a:1:{i:920;s:8:\"features\";}s:8:\"category\";i:919;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47427\";a:9:{s:5:\"title\";s:16:\"Testimonials 3GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-3w-1.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/testimonials-gb-3w-1-400x126.jpg\";s:3:\"url\";s:55:\"https://websitedemos.net/astra-blocks/testimonials-3gw/\";s:3:\"tag\";a:1:{i:844;s:11:\"testimonial\";}s:8:\"category\";i:830;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47422\";a:9:{s:5:\"title\";s:12:\"Features 4GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-4w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/features-gb-4w-1-400x172.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/features-4gw/\";s:3:\"tag\";a:1:{i:920;s:8:\"features\";}s:8:\"category\";i:919;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47459\";a:9:{s:5:\"title\";s:8:\"Team 1GW\";s:18:\"featured-image-url\";s:66:\"https://websitedemos.net/wp-content/uploads/2020/09/team-gb-1w.jpg\";s:19:\"thumbnail-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/09/team-gb-1w-400x250.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/team-1gw/\";s:3:\"tag\";a:1:{i:927;s:4:\"team\";}s:8:\"category\";i:829;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47472\";a:9:{s:5:\"title\";s:8:\"Team 2GW\";s:18:\"featured-image-url\";s:66:\"https://websitedemos.net/wp-content/uploads/2020/09/team-gb-2w.jpg\";s:19:\"thumbnail-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/09/team-gb-2w-400x167.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/team-2gw/\";s:3:\"tag\";a:1:{i:927;s:4:\"team\";}s:8:\"category\";i:829;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47474\";a:9:{s:5:\"title\";s:8:\"Team 3GW\";s:18:\"featured-image-url\";s:66:\"https://websitedemos.net/wp-content/uploads/2020/09/team-gb-3w.jpg\";s:19:\"thumbnail-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/09/team-gb-3w-400x192.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/team-3gw/\";s:3:\"tag\";a:1:{i:927;s:4:\"team\";}s:8:\"category\";i:829;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47522\";a:9:{s:5:\"title\";s:12:\"Services 3GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-3w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-3w-1-400x219.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/services-3gw/\";s:3:\"tag\";a:1:{i:953;s:8:\"services\";}s:8:\"category\";i:952;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47518\";a:9:{s:5:\"title\";s:12:\"Services 1GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-1w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-1w-1-400x197.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/services-1gw/\";s:3:\"tag\";a:1:{i:953;s:8:\"services\";}s:8:\"category\";i:952;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47496\";a:9:{s:5:\"title\";s:14:\"Statistics 4GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-4w.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-4w-400x186.jpg\";s:3:\"url\";s:53:\"https://websitedemos.net/astra-blocks/statistics-4gw/\";s:3:\"tag\";a:1:{i:924;s:10:\"statistics\";}s:8:\"category\";i:1096;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47492\";a:9:{s:5:\"title\";s:14:\"Statistics 3GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-3w.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-3w-400x97.jpg\";s:3:\"url\";s:53:\"https://websitedemos.net/astra-blocks/statistics-3gw/\";s:3:\"tag\";a:1:{i:924;s:10:\"statistics\";}s:8:\"category\";i:1096;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47489\";a:9:{s:5:\"title\";s:14:\"Statistics 2GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-2w.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-2w-400x156.jpg\";s:3:\"url\";s:53:\"https://websitedemos.net/astra-blocks/statistics-2gw/\";s:3:\"tag\";a:1:{i:924;s:10:\"statistics\";}s:8:\"category\";i:1096;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47498\";a:9:{s:5:\"title\";s:14:\"Statistics 5GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-5w.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-5w-400x141.jpg\";s:3:\"url\";s:53:\"https://websitedemos.net/astra-blocks/statistics-5gw/\";s:3:\"tag\";a:1:{i:924;s:10:\"statistics\";}s:8:\"category\";i:1096;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47524\";a:9:{s:5:\"title\";s:12:\"Services 4GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-4w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-4w-1-400x155.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/services-4gw/\";s:3:\"tag\";a:1:{i:953;s:8:\"services\";}s:8:\"category\";i:952;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47478\";a:9:{s:5:\"title\";s:8:\"Team 4GW\";s:18:\"featured-image-url\";s:66:\"https://websitedemos.net/wp-content/uploads/2020/09/team-gb-4w.jpg\";s:19:\"thumbnail-image-url\";s:74:\"https://websitedemos.net/wp-content/uploads/2020/09/team-gb-4w-400x228.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/team-4gw/\";s:3:\"tag\";a:1:{i:927;s:4:\"team\";}s:8:\"category\";i:829;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47520\";a:9:{s:5:\"title\";s:12:\"Services 2GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-2w-1.jpg\";s:19:\"thumbnail-image-url\";s:80:\"https://websitedemos.net/wp-content/uploads/2020/09/services-gb-2w-1-400x229.jpg\";s:3:\"url\";s:51:\"https://websitedemos.net/astra-blocks/services-2gw/\";s:3:\"tag\";a:1:{i:953;s:8:\"services\";}s:8:\"category\";i:952;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47435\";a:9:{s:5:\"title\";s:8:\"Hero 2GW\";s:18:\"featured-image-url\";s:68:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-2w-1.jpg\";s:19:\"thumbnail-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/hero-gb-2w-1-400x219.jpg\";s:3:\"url\";s:47:\"https://websitedemos.net/astra-blocks/hero-2gw/\";s:3:\"tag\";a:1:{i:817;s:4:\"hero\";}s:8:\"category\";i:831;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47482\";a:9:{s:5:\"title\";s:14:\"Statistics 1GW\";s:18:\"featured-image-url\";s:72:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-1w.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/09/statistics-gb-1w-400x96.jpg\";s:3:\"url\";s:53:\"https://websitedemos.net/astra-blocks/statistics-1gw/\";s:3:\"tag\";a:1:{i:924;s:10:\"statistics\";}s:8:\"category\";i:1096;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47392\";a:9:{s:5:\"title\";s:18:\"Call To Action 1GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-1w.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-1w-400x132.jpg\";s:3:\"url\";s:57:\"https://websitedemos.net/astra-blocks/call-to-action-1gw/\";s:3:\"tag\";a:1:{i:819;s:14:\"call-to-action\";}s:8:\"category\";i:832;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47394\";a:9:{s:5:\"title\";s:18:\"Call To Action 2GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-2w.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-2w-400x123.jpg\";s:3:\"url\";s:57:\"https://websitedemos.net/astra-blocks/call-to-action-2gw/\";s:3:\"tag\";a:1:{i:819;s:14:\"call-to-action\";}s:8:\"category\";i:832;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47397\";a:9:{s:5:\"title\";s:18:\"Call To Action 3GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-3w.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-3w-400x158.jpg\";s:3:\"url\";s:57:\"https://websitedemos.net/astra-blocks/call-to-action-3gw/\";s:3:\"tag\";a:1:{i:819;s:14:\"call-to-action\";}s:8:\"category\";i:832;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47399\";a:9:{s:5:\"title\";s:18:\"Call To Action 4GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-4w.jpg\";s:19:\"thumbnail-image-url\";s:83:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-4w-400x82.jpg\";s:3:\"url\";s:57:\"https://websitedemos.net/astra-blocks/call-to-action-4gw/\";s:3:\"tag\";a:1:{i:819;s:14:\"call-to-action\";}s:8:\"category\";i:832;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47404\";a:9:{s:5:\"title\";s:18:\"Call To Action 6GW\";s:18:\"featured-image-url\";s:76:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-6w.jpg\";s:19:\"thumbnail-image-url\";s:84:\"https://websitedemos.net/wp-content/uploads/2020/09/call-to-action-gb-6w-400x143.jpg\";s:3:\"url\";s:57:\"https://websitedemos.net/astra-blocks/call-to-action-6gw/\";s:3:\"tag\";a:1:{i:819;s:14:\"call-to-action\";}s:8:\"category\";i:832;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47378\";a:9:{s:5:\"title\";s:11:\"Contact 1GW\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-1w.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-1w-400x230.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/contact-1gw/\";s:3:\"tag\";a:1:{i:823;s:7:\"contact\";}s:8:\"category\";i:1416;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47383\";a:9:{s:5:\"title\";s:11:\"Contact 3GW\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-3w.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-3w-400x257.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/contact-3gw/\";s:3:\"tag\";a:1:{i:823;s:7:\"contact\";}s:8:\"category\";i:1416;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47385\";a:9:{s:5:\"title\";s:11:\"Contact 4GW\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-4w.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-4w-400x238.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/contact-4gw/\";s:3:\"tag\";a:1:{i:823;s:7:\"contact\";}s:8:\"category\";i:1416;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47389\";a:9:{s:5:\"title\";s:11:\"Contact 5GB\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-5b.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/09/contact-gb-5b-400x218.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/contact-5gb/\";s:3:\"tag\";a:1:{i:823;s:7:\"contact\";}s:8:\"category\";i:1416;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:4:\"dark\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47366\";a:9:{s:5:\"title\";s:11:\"Clients 3GW\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/09/clients-gb-3w.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/09/clients-gb-3w-400x160.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/clients-3gw/\";s:3:\"tag\";a:1:{i:1090;s:7:\"clients\";}s:8:\"category\";i:1091;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47373\";a:9:{s:5:\"title\";s:11:\"Clients 4GW\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/09/clients-gb-4w.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/09/clients-gb-4w-400x183.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/clients-4gw/\";s:3:\"tag\";a:1:{i:1090;s:7:\"clients\";}s:8:\"category\";i:1091;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47362\";a:9:{s:5:\"title\";s:11:\"Clients 2GW\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/09/clients-gb-2w.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/09/clients-gb-2w-400x112.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/clients-2gw/\";s:3:\"tag\";a:1:{i:1090;s:7:\"clients\";}s:8:\"category\";i:1091;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47356\";a:9:{s:5:\"title\";s:11:\"Clients 1GW\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/09/clients-gb-1w.jpg\";s:19:\"thumbnail-image-url\";s:77:\"https://websitedemos.net/wp-content/uploads/2020/09/clients-gb-1w-400x103.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/clients-1gw/\";s:3:\"tag\";a:1:{i:1090;s:7:\"clients\";}s:8:\"category\";i:1091;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47337\";a:9:{s:5:\"title\";s:9:\"About 2GW\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-2w.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-2w-400x230.jpg\";s:3:\"url\";s:48:\"https://websitedemos.net/astra-blocks/about-2gw/\";s:3:\"tag\";a:1:{i:818;s:5:\"about\";}s:8:\"category\";i:825;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47352\";a:9:{s:5:\"title\";s:9:\"About 7GB\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-7b.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-7b-400x234.jpg\";s:3:\"url\";s:48:\"https://websitedemos.net/astra-blocks/about-7gb/\";s:3:\"tag\";a:1:{i:818;s:5:\"about\";}s:8:\"category\";i:825;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:4:\"dark\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47343\";a:9:{s:5:\"title\";s:9:\"About 4GW\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-4w.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-4w-400x206.jpg\";s:3:\"url\";s:48:\"https://websitedemos.net/astra-blocks/about-4gw/\";s:3:\"tag\";a:1:{i:818;s:5:\"about\";}s:8:\"category\";i:825;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47333\";a:9:{s:5:\"title\";s:9:\"About 1GW\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-1w.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-1w-400x151.jpg\";s:3:\"url\";s:48:\"https://websitedemos.net/astra-blocks/about-1gw/\";s:3:\"tag\";a:1:{i:818;s:5:\"about\";}s:8:\"category\";i:825;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47350\";a:9:{s:5:\"title\";s:9:\"About 6GW\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-6w.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-6w-400x167.jpg\";s:3:\"url\";s:48:\"https://websitedemos.net/astra-blocks/about-6gw/\";s:3:\"tag\";a:1:{i:818;s:5:\"about\";}s:8:\"category\";i:825;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47339\";a:9:{s:5:\"title\";s:9:\"About 3GW\";s:18:\"featured-image-url\";s:67:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-3w.jpg\";s:19:\"thumbnail-image-url\";s:75:\"https://websitedemos.net/wp-content/uploads/2020/09/about-gb-3w-400x216.jpg\";s:3:\"url\";s:48:\"https://websitedemos.net/astra-blocks/about-3gw/\";s:3:\"tag\";a:1:{i:818;s:5:\"about\";}s:8:\"category\";i:825;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47457\";a:9:{s:5:\"title\";s:11:\"Heading 4GW\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-4w-1.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-4w-1-400x109.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/heading-4gw/\";s:3:\"tag\";a:1:{i:1093;s:7:\"heading\";}s:8:\"category\";i:1094;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47471\";a:9:{s:5:\"title\";s:13:\"Portfolio 5GW\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-5w-1.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-5w-1-400x272.jpg\";s:3:\"url\";s:52:\"https://websitedemos.net/astra-blocks/portfolio-5gw/\";s:3:\"tag\";a:1:{i:1426;s:9:\"portfolio\";}s:8:\"category\";i:1425;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47456\";a:9:{s:5:\"title\";s:11:\"Heading 3GW\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-3w-1.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-3w-1-400x105.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/heading-3gw/\";s:3:\"tag\";a:1:{i:1093;s:7:\"heading\";}s:8:\"category\";i:1094;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47470\";a:9:{s:5:\"title\";s:13:\"Portfolio 4GW\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-4w-1.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-4w-1-400x196.jpg\";s:3:\"url\";s:52:\"https://websitedemos.net/astra-blocks/portfolio-4gw/\";s:3:\"tag\";a:1:{i:1426;s:9:\"portfolio\";}s:8:\"category\";i:1425;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47469\";a:9:{s:5:\"title\";s:13:\"Portfolio 3GW\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-3w-1.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-3w-1-400x382.jpg\";s:3:\"url\";s:52:\"https://websitedemos.net/astra-blocks/portfolio-3gw/\";s:3:\"tag\";a:1:{i:1426;s:9:\"portfolio\";}s:8:\"category\";i:1425;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47468\";a:9:{s:5:\"title\";s:13:\"Portfolio 2GW\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-2w-1.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-2w-1-400x230.jpg\";s:3:\"url\";s:52:\"https://websitedemos.net/astra-blocks/portfolio-2gw/\";s:3:\"tag\";a:1:{i:1426;s:9:\"portfolio\";}s:8:\"category\";i:1425;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47467\";a:9:{s:5:\"title\";s:13:\"Portfolio 1GW\";s:18:\"featured-image-url\";s:73:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-1w-1.jpg\";s:19:\"thumbnail-image-url\";s:81:\"https://websitedemos.net/wp-content/uploads/2020/09/portfolio-gb-1w-1-400x242.jpg\";s:3:\"url\";s:52:\"https://websitedemos.net/astra-blocks/portfolio-1gw/\";s:3:\"tag\";a:1:{i:1426;s:9:\"portfolio\";}s:8:\"category\";i:1425;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47458\";a:9:{s:5:\"title\";s:11:\"Heading 5GW\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-5w-1.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-5w-1-400x107.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/heading-5gw/\";s:3:\"tag\";a:1:{i:1093;s:7:\"heading\";}s:8:\"category\";i:1094;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47455\";a:9:{s:5:\"title\";s:11:\"Heading 2GW\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-2w-1.jpg\";s:19:\"thumbnail-image-url\";s:79:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-2w-1-400x107.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/heading-2gw/\";s:3:\"tag\";a:1:{i:1093;s:7:\"heading\";}s:8:\"category\";i:1094;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}s:8:\"id-47454\";a:9:{s:5:\"title\";s:11:\"Heading 1GW\";s:18:\"featured-image-url\";s:71:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-1w-1.jpg\";s:19:\"thumbnail-image-url\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/09/heading-gb-1w-1-400x87.jpg\";s:3:\"url\";s:50:\"https://websitedemos.net/astra-blocks/heading-1gw/\";s:3:\"tag\";a:1:{i:1093;s:7:\"heading\";}s:8:\"category\";i:1094;s:12:\"page-builder\";s:9:\"gutenberg\";s:6:\"filter\";s:5:\"light\";s:16:\"required-plugins\";a:0:{}}}", "no");
INSERT INTO `wp_options` VALUES("441", "ast-block-templates-block-requests", "1", "no");
INSERT INTO `wp_options` VALUES("442", "ast_block_templates_fresh_site", "no", "no");
INSERT INTO `wp_options` VALUES("467", "et_google_api_settings", "a:3:{s:7:\"api_key\";s:0:\"\";s:26:\"enqueue_google_maps_script\";s:2:\"on\";s:16:\"use_google_fonts\";s:2:\"on\";}", "yes");
INSERT INTO `wp_options` VALUES("3944", "duplicate_post_show_original_column", "0", "yes");
INSERT INTO `wp_options` VALUES("3945", "duplicate_post_show_original_in_post_states", "0", "yes");
INSERT INTO `wp_options` VALUES("1734", "widget_monarchwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("813", "action_scheduler_hybrid_store_demarkation", "277", "yes");
INSERT INTO `wp_options` VALUES("821", "woocommerce_store_city", "Chasseneuil-du-Poitou", "yes");
INSERT INTO `wp_options` VALUES("822", "woocommerce_default_country", "FR", "yes");
INSERT INTO `wp_options` VALUES("823", "woocommerce_store_postcode", "86360", "yes");
INSERT INTO `wp_options` VALUES("940", "action_scheduler_lock_async-request-runner", "1638190331", "yes");
INSERT INTO `wp_options` VALUES("939", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `wp_options` VALUES("3926", "duplicate_post_copytitle", "1", "yes");
INSERT INTO `wp_options` VALUES("3927", "duplicate_post_copydate", "0", "yes");
INSERT INTO `wp_options` VALUES("3928", "duplicate_post_copystatus", "0", "yes");
INSERT INTO `wp_options` VALUES("3929", "duplicate_post_copyslug", "0", "yes");
INSERT INTO `wp_options` VALUES("3930", "duplicate_post_copyexcerpt", "1", "yes");
INSERT INTO `wp_options` VALUES("3931", "duplicate_post_copycontent", "1", "yes");
INSERT INTO `wp_options` VALUES("3932", "duplicate_post_copythumbnail", "1", "yes");
INSERT INTO `wp_options` VALUES("3933", "duplicate_post_copytemplate", "1", "yes");
INSERT INTO `wp_options` VALUES("3934", "duplicate_post_copyformat", "1", "yes");
INSERT INTO `wp_options` VALUES("3935", "duplicate_post_copyauthor", "0", "yes");
INSERT INTO `wp_options` VALUES("646", "quadmenu_Divi-transients", "a:2:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1617718168;}", "yes");
INSERT INTO `wp_options` VALUES("647", "quadmenu_Divi_locations", "a:4:{s:12:\"primary-menu\";a:1:{s:4:\"name\";s:14:\"Menu Principal\";}s:14:\"secondary-menu\";a:1:{s:4:\"name\";s:15:\"Menu secondaire\";}s:11:\"footer-menu\";a:1:{s:4:\"name\";s:20:\"Menu du pied de page\";}s:12:\"quadmenu_dev\";a:1:{s:4:\"name\";s:12:\"QuadMenu Dev\";}}", "yes");
INSERT INTO `wp_options` VALUES("824", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("825", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("826", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("827", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("828", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("829", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("941", "woocommerce_admin_notices", "a:1:{i:1;s:20:\"no_secure_connection\";}", "yes");
INSERT INTO `wp_options` VALUES("661", "quadmenu_Divi_themes", "a:1:{s:14:\"custom_theme_3\";s:14:\"Custom Theme 3\";}", "yes");
INSERT INTO `wp_options` VALUES("831", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("832", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("833", "woocommerce_currency", "EUR", "yes");
INSERT INTO `wp_options` VALUES("830", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("713", "dsm_general", "a:3:{s:25:\"dsm_use_scheduled_content\";s:2:\"on\";s:21:\"dsm_use_header_footer\";s:2:\"on\";s:17:\"dsm_use_shortcode\";s:2:\"on\";}", "yes");
INSERT INTO `wp_options` VALUES("835", "woocommerce_price_thousand_sep", "", "yes");
INSERT INTO `wp_options` VALUES("836", "woocommerce_price_decimal_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("837", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `wp_options` VALUES("838", "woocommerce_shop_page_id", "278", "yes");
INSERT INTO `wp_options` VALUES("839", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("840", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("841", "woocommerce_placeholder_image", "277", "yes");
INSERT INTO `wp_options` VALUES("842", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("843", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("844", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("845", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("846", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("847", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("848", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("849", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("850", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("851", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("852", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("853", "woocommerce_stock_email_recipient", "pa.hulin@sodileve.fr", "no");
INSERT INTO `wp_options` VALUES("854", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("855", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("856", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("857", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("858", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("859", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("860", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("861", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("862", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("863", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("864", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("865", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("866", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("867", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("868", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("869", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("870", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("871", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("872", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("873", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("874", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("875", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("876", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("877", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("878", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wp_options` VALUES("879", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("880", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("881", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("882", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("883", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("884", "woocommerce_registration_privacy_policy_text", "Vos données personnelles seront utilisées pour vous accompagner au cours de votre visite du site web, gérer l’accès à votre compte, et pour d’autres raisons décrites dans notre [privacy_policy].", "yes");
INSERT INTO `wp_options` VALUES("885", "woocommerce_checkout_privacy_policy_text", "Vos données personnelles seront utilisées pour le traitement de votre commande, vous accompagner au cours de votre visite du site web, et pour d’autres raisons décrites dans notre [privacy_policy].", "yes");
INSERT INTO `wp_options` VALUES("886", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("887", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("888", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("889", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("890", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("891", "woocommerce_email_from_name", "Ponts roulants | Potence | Palan | Maintenance &#8211; SODILEVE", "no");
INSERT INTO `wp_options` VALUES("892", "woocommerce_email_from_address", "pa.hulin@sodileve.fr", "no");
INSERT INTO `wp_options` VALUES("893", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("894", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("895", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("896", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("897", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("898", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("899", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("900", "woocommerce_cart_page_id", "279", "no");
INSERT INTO `wp_options` VALUES("901", "woocommerce_checkout_page_id", "280", "no");
INSERT INTO `wp_options` VALUES("902", "woocommerce_myaccount_page_id", "281", "no");
INSERT INTO `wp_options` VALUES("903", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("904", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("905", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("906", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("907", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("908", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("909", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("910", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("911", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("912", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("913", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("914", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("915", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("916", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("917", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("918", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("919", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("920", "woocommerce_allow_tracking", "yes", "no");
INSERT INTO `wp_options` VALUES("921", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("922", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("923", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_options` VALUES("924", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("925", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("926", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"produit\";s:13:\"category_base\";s:17:\"categorie-produit\";s:8:\"tag_base\";s:17:\"etiquette-produit\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("927", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("928", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("947", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("948", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("949", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("950", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("951", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("952", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("953", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("954", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("955", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("956", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("957", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("958", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("959", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("963", "woocommerce_admin_install_timestamp", "1617719237", "yes");
INSERT INTO `wp_options` VALUES("969", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:1;s:3:\"all\";i:1;s:8:\"approved\";s:1:\"1\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("967", "wc_remote_inbox_notifications_specs", "a:30:{s:27:\"stripe_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"stripe_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:380:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/stripe/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#apple-pay\">enable Apple Pay with Stripe</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"stripe_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}s:27:\"square_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"square_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:393:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/woocommerce-square/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#section-14\">enable Apple Pay with Square</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"square_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}}}}s:26:\"wcpay_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"wcpay_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:338:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/payments/apple-pay/\">enable Apple Pay with WooCommerce Payments</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"wcpay_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}s:27:\"new_in_app_marketplace_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"new_in_app_marketplace_2021\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Customize your store with extensions\";s:7:\"content\";s:164:\"Check out our NEW Extensions tab to see our favorite extensions for customizing your store, and discover the most popular extensions in the WooCommerce Marketplace.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"browse_extensions\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Browse extensions\";}}s:3:\"url\";s:15:\"&page=wc-addons\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.7\";}}}s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:259:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store\'s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:42:\"https://woocommerce.com/products/wayflyer/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:45:\"https://woocommerce.com/woocommerce-shipping/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:30:\"wc_shipping_mobile_app_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:69:\"Print and manage your shipping labels with the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:30:\"Get the WooCommerce Mobile App\";}}s:3:\"url\";s:31:\"https://woocommerce.com/mobile/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}s:37:\"ecomm-need-help-setting-up-your-store\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"ecomm-need-help-setting-up-your-store\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Need help setting up your Store?\";s:7:\"content\";s:350:\"Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"set-up-concierge\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Schedule free session\";}}s:3:\"url\";s:34:\"https://wordpress.com/me/concierge\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:255:\"WooCommerce Shipping & Tax helps get your store “ready to sell” as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:32:\"ecomm-unique-shopping-experience\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"ecomm-unique-shopping-experience\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"For a shopping experience as unique as your customers\";s:7:\"content\";s:274:\"Product Add-Ons allow your customers to personalize products while they’re shopping on your online store. No more follow-up email requests—customers get what they want, before they’re done checking out. Learn more about this extension that comes included in your plan.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"learn-more-ecomm-unique-shopping-experience\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:71:\"https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:37:\"wc-admin-getting-started-in-ecommerce\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-getting-started-in-ecommerce\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Getting Started in eCommerce - webinar\";s:7:\"content\";s:174:\"We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"watch-the-webinar\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Watch the webinar\";}}s:3:\"url\";s:28:\"https://youtu.be/V_2XtCOyZ7o\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:12:\"setup_client\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:4:\"none\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:10:\"up-to-2500\";}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:461:\"That\'s huge! You\'re well on your way to building a successful online store — now it’s time to think about how you\'ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:171:\"It\'s crucial to get your store\'s checkout as smooth as possible to avoid losing sales. Let\'s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:78:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:39:\"wc-admin-first-five-things-to-customize\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-admin-first-five-things-to-customize\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"The first 5 things to customize in your store\";s:7:\"content\";s:173:\"Deciding what to start with first is tricky. To help you properly prioritize, we\'ve put together this short list of the first few things you should customize in WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/first-things-customize-woocommerce/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:2;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:5:\"value\";s:9:\"NOT EMPTY\";s:7:\"default\";s:9:\"NOT EMPTY\";s:9:\"operation\";s:2:\"!=\";}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:56:\"https://woocommerce.com/products/google-listings-and-ads\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:736:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site\'s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:5:\"rules\";a:0:{}}s:30:\"wcpay-promo-2021-6-incentive-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-1\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:702:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies.\n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a>\n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:25:\"get-woo-commerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"1\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"3\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"5\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"7\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"9\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"11\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:30:\"wcpay-promo-2021-6-incentive-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-2\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:702:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies.\n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a>\n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"get-woocommerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"2\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"4\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"6\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"8\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"10\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"12\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:440:\"Heads up! There\'s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:513:\"We\'ve developed a whole new <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension for WooCommerce</a> that combines the best features of our many PayPal extensions into just one extension.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br/><br/>Start using our latest PayPal today to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:38:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"We\'re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:134:\"We\'d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}}", "no");
INSERT INTO `wp_options` VALUES("968", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":3:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;s:17:\"new_product_count\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("970", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("7665", "_transient_timeout_feed_mod_40a89299829082877949471eeb1c21e3", "1638216832", "no");
INSERT INTO `wp_options` VALUES("7666", "_transient_feed_mod_40a89299829082877949471eeb1c21e3", "1638173632", "no");
INSERT INTO `wp_options` VALUES("7455", "et_pb_contact_form_a90dd70a19729f295919b1ef21541d3f", "on", "yes");
INSERT INTO `wp_options` VALUES("7690", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1638216837", "no");
INSERT INTO `wp_options` VALUES("7691", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"Gutenberg Times: Gutenberg Changelog #56 – Gutenberg 12.0, WordPress 5.9 Release Schedule, Navigation Block and Site Editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=19715\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-56-gutenberg-12-wordpress-5-9-ryan-welcher/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6547:\"<p>Co-hosts, Birgit Pauli-Haack and Grzegorz Ziolkowski discuss with Ryan Welcher the Gutenberg 12.0 release, the updated WordPress 5.9 Release Schedule and a lot more.</p>\n\n\n\n<ul><li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li><li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li><li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li><li>Production:&nbsp;<a href=\"https://paulisystems.net/wordpress-consulting\">Pauli Systems</a></li></ul>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-56-Gutenberg-12-wordpress-5.9-Ryan-Welcher#shownotes\">Show Notes </a>/ <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-56-Gutenberg-12-wordpress-5.9-Ryan-Welcher#transcript\">Transcript</a></p>\n\n\n\n<span id=\"more-19715\"></span>\n\n\n\n<p><strong>Subscribe to the&nbsp;<a href=\"https://gutenbergtimes.com/podcast/\">Gutenberg Changelog</a>&nbsp;podcast via your favorite podcast apps!</strong><br />🎙️&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg?mc_cid=4b6c9f88fe\">Spotify</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\">Google</a>&nbsp;|&nbsp;<a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\">iTunes</a>&nbsp;|&nbsp;<a href=\"https://pca.st/podcast/f8445ec0-7508-0137-f267-1d245fc5f9cf\">PocketCasts</a>&nbsp;|&nbsp;<a href=\"https://www.stitcher.com/show/gutenberg-changelog\">Stitcher</a>&nbsp;|<br />🎙️&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\">Pod Bean</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast\">RSS Feed</a>&nbsp;</p>\n\n\n\n<p class=\"has-large-font-size\" id=\"shownotes\"><strong>Show Notes </strong></p>\n\n\n\n<h2 id=\"ryan-welcher-developer-advocate-sponsored-by-automattic\"><a href=\"https://twitter.com/ryanwelcher\"><strong>Ryan Welcher</strong></a>, Developer advocate, sponsored by Automattic. </h2>\n\n\n\n<ul><li><a href=\"https://www.twitch.tv/ryanwelchercodes\">Twitch Live Streams @ ryanwelchercodes</a></li><li><a href=\"https://github.com/WordPress/gutenberg-examples\">Gutenberg Examples Repository at GitHub</a></li><li><a href=\"https://ryanwelcher.com/\">Website &amp; Blog </a></li></ul>\n\n\n\n<h2 id=\"community-contributions\">Community Contributions</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/11/24/wordpress-development-environment/\">WordPress development environment</a> by Marcus Kasmierczak</p>\n\n\n\n<h2 id=\"wordpress-5-9-updated-schedule\"><strong>WordPress 5.9 updated Schedule</strong></h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/5-9/\">Updated Release Schedule for 5.9 </a></li><li><a href=\"https://make.wordpress.org/core/2021/11/22/wordpress-5-9-revised-release-schedule/\"><strong>WordPress 5.9 Revised Release Schedule</strong></a> by Core release lead <strong>Tonya Mork</strong></li><li><a href=\"https://nomad.blog/2021/11/23/why-i-voted-to-delay-wordpress-5-9/\"><strong>Why I voted to delay WordPress 5.9</strong></a> by <strong>Anne McCarthy</strong>, release co-lead for testing</li><li><a href=\"https://wptavern.com/wordpress-5-9-revised-release-date-confirmed-for-january-25-2022\"><strong>WordPress 5.9 Revised Release Date Confirmed for January 25, 2022</strong></a>, <strong>Sarah Gooding</strong>, WPTavern</li><li><a href=\"https://wordpress.org/news/2021/11/a-look-at-wordpress-5-9/\"><strong>A Look at WordPress 5.9</strong></a> with the newly published video via WordPress News. </li><li>Video: <a href=\"https://www.youtube.com/watch?v=r59aR1tmY6k&t=75s\"><strong>Exploring WordPress 5.9: Block theme flows, Styling, Patterns Explorer, &amp; more</strong></a></li></ul>\n\n\n\n<h2 id=\"gutenberg-12-0\">Gutenberg 12.0</h2>\n\n\n\n<p><strong><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v12.0.0\">Find the full changelog on GitHub</a></strong>  </p>\n\n\n\n<ul><li>Block Styles Previews (<a href=\"https://github.com/WordPress/gutenberg/pull/34522\">34522</a>),</li><li>Featured Image block Visual Enhancement in the Site Editor (<a href=\"https://github.com/WordPress/gutenberg/pull/36517\">36517</a>), </li><li>the Site Editor Welcome Guide (<a href=\"https://github.com/WordPress/gutenberg/pull/36172\">36172</a>) and </li><li>the updates to the JSON schemas for <a href=\"https://schemas.wp.org/trunk/block.json\"><strong>block.json</strong></a> and <strong><a href=\"https://schemas.wp.org/trunk/theme.json\">theme.json</a></strong>. </li><li><a href=\"https://github.com/WordPress/gutenberg/discussions/categories/developer-experience\">GitHub discussions on Developer Experience</a>.</li></ul>\n\n\n\n<p><a href=\"https://www.twitch.tv/videos/1214655583\">Gutenberg plugin v12.0.0 Release Party with Ryan Welcher</a></p>\n\n\n\n<h2 id=\"what-s-discussed-and-in-active-development\">What&#8217;s discussed and in active development</h2>\n\n\n\n<ul><li>Pull Request by Ryan Welcher related to ordering slotfill/panel: <a href=\"https://github.com/WordPress/gutenberg/pull/16384\">Plugin sorting via priority property in registerPlugin</a></li><li><a href=\"https://github.com/WordPress/gutenberg/pull/28273\">Enable React Fast Refresh for block development</a> coming to @wordpress/scripts by Grzegorz Ziolkowski</li><li><a href=\"https://www.godaddy.com/garage/gutenberg-how-to-test-the-latest-updates/\">Gutenberg: How to test the latest updates</a> w/ Birgit Pauli-Haack, Andy Fragen and George Mamadashvili via GoDaddy Pro</li></ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-container-61a377cb2765a wp-block-group\"><div class=\"wp-block-group__inner-container\">\n<ul><li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li><li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gziolo\">@gziolo </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li><li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li><li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li></ul>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Is in the works</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 27 Nov 2021 23:33:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Gutenberg Times: Rendering WooCommerce Blocks, Hold the Phone, WTF is FSE? and more — Weekend Edition #194\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=19686\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://gutenbergtimes.com/rendering-woocommerce-blocks-hold-the-phone-wtf-is-fse-and-more-weekend-edition-194/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16501:\"<p>Howdy, </p>\n\n\n\n<p>For my US American friends, I am sending Happy Thanksgiving greetings! I hope y&#8217;all had a Happy Turkey Day! 🦃 🍗 You probably won&#8217;t get to read this until Monday or even later next week. Hopefully, the Black-Friday-Cyber-Monday offerings turn out well for you. </p>\n\n\n\n<p>I am so grateful that you let me drop a weekend edition into your inbox every week. And thank you for the thoughtful notes, questions, ideas, and product updates.  Keep &#8217;em coming. It is you for whom I build the Gutenberg Times, and it has been an ongoing joy and wonderful adventure! </p>\n\n\n\n<p>I am also grateful for everyone working on Gutenberg and on WordPress. The contributors and the Community at large has been a home to me in a world more and more divided.  I have been hurting through these two years of no in-person meetings, longing to see my friends again,  so I hope to meet you&#8217;all soon at a future WordCamp! </p>\n\n\n\n<p>That&#8217;s it for now. Y&#8217;all have a great weekend! </p>\n\n\n\n<p>Yours,💕<br />Birgit </p>\n\n\n\n\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#updates-on-wordpress-5-9\">Updates on WordPress 5.9 </a><ul><li><a href=\"https://gutenbergtimes.com/feed/#new-schedule-for-january-25-2022-release\">New schedule for January 25, 2022 release</a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#gutenberg-12-0-x-released\">Gutenberg 12.0.x released</a></li><li><a href=\"https://gutenbergtimes.com/feed/#developing-custom-blocks\">Developing Custom Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#full-site-editing-and-themes\">Full-Site Editing and Themes</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#fse-program-testing-call-1\">FSE Program Testing Call #1</a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#wordpress-events\">WordPress Events</a></li></ul></div>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2 id=\"updates-on-wordpress-5-9\">Updates on WordPress 5.9 </h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2021/11/a-look-at-wordpress-5-9/\"><strong>A Look at WordPress 5.9</strong></a> with the newly published video via WordPress News. </p>\n\n\n\n<p>You can also take a longer discovery journey with <strong>Anne McCarthy</strong> on video <a href=\"https://www.youtube.com/watch?v=r59aR1tmY6k&t=75s\"><strong>Exploring WordPress 5.9: Block theme flows, Styling, Patterns Explorer, &amp; more</strong></a></p>\n\n\n\n<h3 id=\"new-schedule-for-january-25-2022-release\">New schedule for January 25, 2022 release</h3>\n\n\n\n<p class=\"has-drop-cap\">After a few features were deemed not-quite ready, the WordPress release team held intense discussions about the feature freeze and the release schedule of WordPress 5.9.  Beta 1 was supposed to be released on November 16th. </p>\n\n\n\n<p>After careful weighing a few aspects of contributor sanity, user expectations, and technical details, the release team decided to punt Beta 1 for two weeks and release it on November 30th, 2021. Because of the Holidays mostly in America and Europe, these two weeks delay resulted into a six-weeks postponement of the final release, now scheduled for January 25th, 2021. </p>\n\n\n\n<p>Core release lead <strong>Tonya Mork</strong> has the details about the  <a href=\"https://make.wordpress.org/core/2021/11/22/wordpress-5-9-revised-release-schedule/\"><strong>WordPress 5.9 Revised Release Schedule</strong></a></p>\n\n\n\n<p><strong>Anne McCarthy</strong>, release co-lead for testing, wrote in <a href=\"https://nomad.blog/2021/11/23/why-i-voted-to-delay-wordpress-5-9/\"><strong>Why I voted to delay WordPress 5.9</strong></a>, her hope &#8220;is to bring you all along for the decision-making process and to demystify how this decision came to be.&nbsp;&#8220;</p>\n\n\n\n<p><strong>Sarah Gooding </strong>over the WPTavern posted: <a href=\"https://wptavern.com/wordpress-5-9-revised-release-date-confirmed-for-january-25-2022\"><strong>WordPress 5.9 Revised Release Date Confirmed for January 25, 2022</strong></a>.</p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  </p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<h2 id=\"gutenberg-12-0-x-released\">Gutenberg 12.0.x released</h2>\n\n\n\n<p class=\"has-drop-cap\">Grzegorz Ziolkowski and I asked Ryan Welcher to be our guest for the Gutenberg Changelog episode 56. As he also worked on the release of this version, we heard first hand what the experience is like. </p>\n\n\n\n<p>Most contributors worked on the final touches for the WordPress 5.9 Beta 1 Feature Freeze, there are no big new features expected in this version. This version is more about the small details that end up making a big difference in the overall user experience. </p>\n\n\n\n<p>The most exciting updates: </p>\n\n\n\n<ul><li>Block Styles Previews (<a href=\"https://github.com/WordPress/gutenberg/pull/34522\">34522</a>),</li><li>Featured Image block Visual Enhancement in the Site Editor (<a href=\"https://github.com/WordPress/gutenberg/pull/36517\">36517</a>), </li><li>the Site Editor Welcome Guide (<a href=\"https://github.com/WordPress/gutenberg/pull/36172\">36172</a>) and </li><li>the updates to the JSON schemas for <a href=\"https://schemas.wp.org/trunk/block.json\"><strong>block.json</strong></a> and <strong><a href=\"https://schemas.wp.org/trunk/theme.json\">theme.json</a></strong>. </li></ul>\n\n\n\n<p>The changelog  has a new section called <strong>Developer Experience.</strong> It lists the PRs that are relevant to WordPress extenders (plugin &amp; theme developers and developers working in agencies) as well as core contributors. It goes along with the <a href=\"https://github.com/WordPress/gutenberg/discussions/categories/developer-experience\">GitHub Discussion</a> Category with the same name.</p>\n\n\n\n<p><strong><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v12.0.0\">Find the full changelog on GitHub</a></strong>  </p>\n\n\n\n\n<p><em>A huge thank You to Álvaro Gómez Velasco who mentioned the Gutenberg Changelog as one of his <a href=\"https://mrfoxtalbot.wordpress.com/2021/11/25/my-favorite-podcasts-2021-edition/\"><strong>Favorite podcasts in 2021</strong></a>.</em></p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><a href=\"https://twitter.com/bph\">&#8220;</a><a href=\"https://gutenbergtimes.com/feed/podcast\">Gutenberg Changelog</a>&nbsp;podcast is the best way to keep up with changes in Gutenberg, the WordPress Block Editor. The show is very on point, full of useful content and they have some great guests too.&#8221;</p><cite>Álvaro Gómez Velasco</cite></blockquote>\n\n\n\n<p><strong>Subscribe to the&nbsp;<a href=\"https://gutenbergtimes.com/podcast/\">Gutenberg Changelog</a>&nbsp;podcast </strong><br />🎙️&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg?mc_cid=4b6c9f88fe\">Spotify</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\">Google</a>&nbsp;|&nbsp;<a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\">iTunes</a>&nbsp;|&nbsp;<a href=\"https://pca.st/podcast/f8445ec0-7508-0137-f267-1d245fc5f9cf\">PocketCasts</a>&nbsp;|&nbsp;<a href=\"https://www.stitcher.com/show/gutenberg-changelog\">Stitcher</a>&nbsp;|<br />🎙️&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\">Pod Bean</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast\">RSS Feed</a>&nbsp;</p>\n\n\n\n\n<h2 id=\"developing-custom-blocks\">Developing Custom Blocks</h2>\n\n\n\n<p id=\"developing-custom-blocks\"><strong><a href=\"https://twitter.com/AlexStandiford\">Alex Standiford</a></strong> published a 2-hours course to teach developer how to <a href=\"https://www.wpdev.academy/course/build-a-block-from-other-blocks/\"><strong>build a Block from other Blocks</strong></a>. He wrote: &#8220;You’ll learn how to build a WordPress block using existing WordPress blocks. This allows you to pre-build commonly used block patterns and drastically simplify the block editing experience, even with the most advanced page layouts.&#8221; </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/laras126\"><strong>Lara Sc henck</strong></a> shared on her blog how to <a href=\"https://notlaura.com/gutenberg-snippet-retrieve-taxonomy-terms-with-compose-withselect-and-getentityrecords/\"><strong>Retrieve taxonomy terms with compose, withSelect, and getEntityRecords</strong></a>, using the built-in @wordpress/data packages. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/ryanwelcher\">Ryan Welcher</a> </strong>continues building a <a href=\"https://www.twitch.tv/videos/1215549420\"><strong>Poll Block on his Twitch Live Stream</strong></a>. Last week, he started on the block. This week, he decided to abandons the original approach and rebuild it with the &lt;InnerBlocks/&gt; that is part of the WordPress scripts and takes care of the &#8220;CRUD stuff&#8221;. Check it out!  </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In his article, <strong>Nadir Seghir</strong>, code wrangler at Automattic, explains <a href=\"https://developer.woocommerce.com/2021/11/15/how-does-woocommerce-blocks-render-interactive-blocks-in-the-frontend/\"><strong>how  WooCommerce Blocks plugin renders interactive blocks in the&nbsp;frontend</strong></a>. The gist of it? Both, PHP and React component read the HTML data attributes. It&#8217;s of course more complicated than this. Follow along! </p>\n\n\n\n<h2 id=\"full-site-editing-and-themes\">Full-Site Editing and Themes</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/JS_Zao\">Justin Sainton</a> </strong>takes his readers along on his journey to <a href=\"https://zao.is/blog/2021/11/22/building-the-new-pagely-com/\"><strong>Building the New website of the hosting company Pagely</strong></a>, recently sold to GoDaddy. He writes about what excites him about the new way of building themes. He explains what FSE is and how to get started with great list of resources. In his Bad &amp; Ugly section, Sainton  &#8220;found things to be painful or otherwise confusing.&#8221; He puts a lot of work in getting to the actionable details. Readers beware the post is over 4,500 words.  </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>If you want to contribute and stay on the bleeding edge of the development of Full-site Editing, Design Tool, Global Styles and block Themes, <a href=\"https://twitter.com/jeffikus\"><strong>Jeffrey Pearce</strong></a> posted the<a href=\"https://make.wordpress.org/themes/2021/11/26/gutenberg-themes-week-of-november-22nd-2021/\"><strong> Gutenberg + Themes 74th weekly round-up</strong></a> of approximately 40 theme related open issues and PRs. He also shares released merged features and updates as well as overview issues that are a great resource to keep up with the development. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total\" /></p>\n\n\n\n\n<h3 id=\"fse-program-testing-call-1\">FSE Program Testing Call #1</h3>\n\n\n\n<p>The deadline for Call for Testing #11 Comments has been extended to December 7th, 2021. <a href=\"https://make.wordpress.org/test/2021/11/08/fse-program-testing-call-11-site-editing-safari/\"><strong>FSE Program Testing Call #11: Site Editing Safari</strong></a> There won&#8217;t be any zebras, rhinos and giraffes, though. </p>\n\n\n\n<p>If you prefer an Italian version of the call for testing, <a href=\"https://twitter.com/succoallapera\"><strong>Piermario Orecchioni</strong></a> published the translation: <a href=\"https://it.wordpress.org/team/2021/11/25/chiamata-per-il-test-del-programma-fse-11-un-safari-nella-modifica-di-un-sito/\"><strong>ESF Program Test Call # 11: A Site Editing Safari</strong></a>. </p>\n\n\n\n<p><a href=\"https://twitter.com/atachibana\"><strong>Akira Tashibana</strong> </a>posted the Japanese version of the FSE Call for testing #11 <a href=\"https://ja.wordpress.org/team/2021/11/12/2381/\"><strong>FSE プログラムのテスト募集 #11: サイト編集の探索</strong></a></p>\n\n\n\n<p><strong><a href=\"https://twitter.com/cdils\">Carrie Dils</a> </strong>prepared a <a href=\"https://carriedils.com/local-import-for-wordpress-5-8-x-beta-testing/\">one file import for LocalWP</a> to have an easy way to set up a test environment for the FSE Call for Testing. </p>\n\n\n\n<h2 id=\"wordpress-events\">WordPress Events</h2>\n\n\n\n<p><strong>December 11 + 12, 2021</strong> <br /><a href=\"https://taiwan.wordcamp.org/2021/\"><strong>WordCamp Taiwan</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>December 14th, 2021 &#8211; 5:00 pm ET / 22:00 UTC</strong> <br /><strong><a href=\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\">WordPress News</a></strong> <br /><strong>State of The Word w/ Matt Mullenweg</strong> + Q &amp; A</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>February 4+5, 2022 <br /><a href=\"https://birmingham.wordcamp.org/2022/\">WordCamp Birmingham, AL</a></strong> <br />Call for Sponsors and Speakers are open now. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>March 4th, 2022 all day <br /><a href=\"https://www.wordfest.live/2022/march/\">WordFest 2022</a></strong> <br />a 24-hour festival of WordPress. <a href=\"https://www.wordfest.live/2022/march/call-for-speakers/\">Call for Speakers is open</a>. Deadline Dec 6th, 2021. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-drop-cap\">On the<a href=\"https://wpcalendar.io/online/\">&nbsp;<strong>Calendar for WordPress Online Events</strong>&nbsp;</a>site, you can browse a list of the upcoming WordPress Events, around the world, including WordCamps,  WooCommerce, Elementor, Divi Builder and Beaver Builder meetups.</p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n\n\n<p><a href=\"https://www.flickr.com/photos/13998657@N02/18526571462\" target=\"_blank\" rel=\"noreferrer noopener\"></a><a href=\"https://www.flickr.com/photos/51035555243@N01/38744499\" target=\"_blank\" rel=\"noreferrer noopener\"></a>Featured image: <a href=\"https://www.flickr.com/photos/21524575@N05/2301648783\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;office block in sutton&#8221;</a>&nbsp;by&nbsp;<a href=\"https://www.flickr.com/photos/21524575@N05\" target=\"_blank\" rel=\"noreferrer noopener\">Mr Tigggs</a>&nbsp;is licensed under&nbsp;<a href=\"https://creativecommons.org/licenses/by/2.0/?ref=openverse&atype=rich\" target=\"_blank\" rel=\"noreferrer noopener\">CC BY 2.0</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Nov 2021 22:09:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Post Status: Post Status Excerpt (No. 34) — Developer Overload: Physical and Mental Health\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=89989\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://poststatus.com/excerpt/34/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3530:\"<h2>&#8220;I prioritized my mental health over my physical health until I realized it was all the same thing.&#8221;</h2>\n\n\n\n<p class=\"has-drop-cap\">In this episode of Post Status Excerpt, David chats with Cory about taking care of your physical and mental health and how these factor into &#8220;Developer Overload.&#8221; Far too often (especially younger) professionals do not prioritize their health so they can work or do more in a day — until it comes back to bite them.</p>\n\n\n\n<p><strong>Also: </strong>David shares that getting up early in the morning works for him and encourages people who have a hard time managing things in the morning to give it a shot — early mornings are usually quiet for many people, both in the place they live and the clients and employees they communicate with during the day.</p>\n\n\n\n\n\n\n\n<p class=\"has-background\">Every week <strong><a href=\"https://poststatus.com/podcast/the-excerpt/\">Post Status Excerpt</a></strong> will brief you on important WordPress news — in about 15 minutes or less! Learn what\'s new in WordPress in a flash. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/26a1.png\" alt=\"⚡\" class=\"wp-smiley\" /><br /><br />You can listen to <a href=\"https://poststatus.com/podcast/the-excerpt/\">past episodes</a> of <strong>The Excerpt</strong>, <a href=\"https://poststatus.com/category/post-status-podcasts/\">browse all our podcasts</a>, and don’t forget to subscribe on <a href=\"https://open.spotify.com/show/1m3xwXbe0MG5BzFVPtB0A7\">Spotify</a>, Amazon Music, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://castro.fm/podcast/c53552c6-1ee0-4fc4-9de4-08ed6bf1ee4d\">Castro</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://player.fm/series/wordpress-post-status-podcasts\">Player.fm</a>, <a href=\"https://pca.st/05rR\">Pocket Casts</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or by <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h3 id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul><li><a href=\"https://twitter.com/dimensionmedia\" target=\"_blank\" rel=\"noreferrer noopener\">David Bisset (Twitter)</a></li><li><a href=\"http://twitter.com/nathaningram\">Cory Miller</a><a href=\"http://twitter.com/corymiller303\"> (Twitter)</a></li><li><a href=\"https://twitter.com/post_status\" target=\"_blank\" rel=\"noreferrer noopener\">Post Status (Twitter)</a></li></ul>\n\n\n\n<h3><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/sandhills\" target=\"_blank\" rel=\"noreferrer noopener sponsored nofollow\">Bluehost</a></h3>\n\n\n\n<p>Everything your website needs — from start-up to success story — is at Bluehost. Whether you\'re looking to create a website, blog, or online store, Bluehost will get you started with an all-in-one website platform tailored to your specific needs. Get a free domain name in your first year, free 24/7 lifetime support, and total design freedom with WordPress at Bluehost.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 25 Nov 2021 04:00:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WordPress.org blog: Watch State of the Word at a Watch Party with your WordPress Friends\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11641\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wordpress.org/news/2021/11/watch-state-of-the-word-at-a-watch-party-with-your-wordpress-friends/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7241:\"<p><a href=\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\">State of the Word 2021</a> is just around the corner!&nbsp;</p>\n\n\n\n<p>Although attending State of the Word in person would be ideal, not all WordPress community members get to enjoy the experience of attending the speech live with friends.&nbsp;</p>\n\n\n\n<p>This year, as State of the Word is streamed live for the second time, we want to restore that in person camaraderie through State of the Word watch parties for WordPress Community members around the world.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><strong>We encourage WordPress meetup organizers and community members worldwide to (safely) host State of the Word 2021 watch parties —</strong><a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/\"><strong>read this handbook to learn more</strong></a><strong>.</strong></p></blockquote>\n\n\n\n<h2 id=\"why-organize-a-watch-party\">Why organize a watch party?&nbsp;</h2>\n\n\n\n<ul><li>If you are a <a href=\"https://meetup.com/pro/wordpress\">WordPress meetup</a> organizer, many folks in your meetup may be unaware of the State of the Word, and a watch party could be a great opportunity to introduce or remind them.</li><li>As meetup organizers slowly bid goodbye to a tough year, the watch party could be an excellent opportunity to revitalize your group, especially if you haven’t had many events this year.</li><li>Along with your Meetup group members, you get a platform to ask questions directly to Matt Mullenweg.</li><li>And last but not least, even if you are not a Meetup Organizer, a watch party can be the perfect opportunity to reconnect and have a blast with your WordPress friends!</li></ul>\n\n\n\n<h2 id=\"how-do-i-organize-a-state-of-the-word-watch-party\">How do I organize a State of the Word watch party?</h2>\n\n\n\n<p>You can choose to host a watch party online or in person. Check out <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/#schedule-a-state-of-the-word-watch-party-for-your-meetup\">our handbook</a> for detailed instructions on how to schedule an event (including event templates).</p>\n\n\n\n<div class=\"wp-block-columns\">\n<div class=\"wp-block-column\">\n<h3 id=\"online\">Online</h3>\n\n\n\n<p>The simplest way to organize an online watch party is to schedule an online event for your WordPress group and add the State of the Word YouTube streaming link directly on Meetup.com. Alternatively, you can schedule an online meeting using tools like Zoom and broadcast the live stream over there by screen sharing––thereby facilitating better engagement. </p>\n\n\n\n<div class=\"wp-container-61a081661c3d5 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/#organizing-an-online-watch-party\" target=\"_blank\" rel=\"noreferrer noopener\">Organize an Online Watch Party</a></div>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-column\">\n<h3 id=\"in-person\">In Person</h3>\n\n\n\n<p>If your region meets <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/2021-returning-to-in-person-meetups/\">the guidelines for in person events</a> (if vaccines and testing are freely available), you can organize an in person watch party event (for fully vaccinated OR recently tested OR recently recovered folks) for your WordPress Meetup! Group members can hang out together (following local safety guidelines of course) and watch State of the Word live.</p>\n\n\n\n<div class=\"wp-container-61a081661c6b0 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/#organizing-an-in-person-watch-party\" target=\"_blank\" rel=\"noreferrer noopener\">Plan an In person Watch Party</a></div>\n</div>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong>NOTE:</strong> If State of the Word is happening at an odd hour in your timezone, you can still organize a watch party by organizing a replay of live stream, at a date/time that is convenient for your group.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>If your Local WordPress Meetup is organizing an in person watch party, <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/request-swag-for-in-person-watch-parties/\"><strong>fill out this form</strong></a><strong> so that we can ship some swag for your group to celebrate!</strong><br />Deadline: November 30, 2021</p></blockquote>\n\n\n\n<h2 id=\"what-else-do-i-need-to-know-about-organizing-a-state-of-the-word-watch-party\">What else do I need to know about organizing a State of the Word watch party?</h2>\n\n\n\n<p>Excited? To help you get started, we’ve put together a few resources:</p>\n\n\n\n<ul><li><strong>Check out this </strong><a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/\"><strong>handbook</strong></a><strong> for detailed instructions on how to organize a watch party, </strong>be it online or in person.</li><li>Looking for a Zoom Pro account to host your online watch party?&nbsp;<a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/getting-started/special-virtual-events-zoom-request/\">Request a community zoom pro account</a>&nbsp;for your event right away!</li><li>We have prepared some <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/email-templates-for-state-of-the-word/\">email templates</a> that Meetup Organizers can use to spread the word in their Meetup groups.</li><li>Don’t forget to share on social media about your watch party events using the hashtag <strong>#StateOfTheWord</strong> so we can join in on the fun!</li></ul>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><strong>NOTE: </strong> The guidelines in this post are primarily aimed at WordPress Meetup organizers. <strong>However, you do not need to be a Meetup organizer to schedule a watch party!</strong> You can simply hang out together with your friends online or in person (while following local safety guidelines) and catch the event live!</p></blockquote>\n\n\n\n<p>If you are planning a watch party for State of the Word, and have questions, please drop us an email to: <a href=\"mailto:support@wordcamp.org\">support@wordcamp.org</a> if you have any questions. We are happy to help you in the best way possible.</p>\n\n\n\n<p><em>The following folks contributed to this post: <a href=\"https://profiles.wordpress.org/anjanavasan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>anjanavasan</a> <a href=\"https://profiles.wordpress.org/eidolonnight/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>eidolonnight</a> <em><a href=\"https://profiles.wordpress.org/evarlese/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>evarlese</a></em></em> <em>and <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Nov 2021 18:30:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WordPress Foundation: Give Back to Open Source this Giving Tuesday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpressfoundation.org/?p=202833\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wordpressfoundation.org/news/2021/give-back-to-open-source-this-giving-tuesday/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3907:\"<p>Giving Tuesday is a global, non-profit movement that encourages people, organizations, and companies around the world to give, collaborate and celebrate generosity.</p>\n\n\n\n<p>Hosted on the first Tuesday following Thanksgiving in the United States, this year the charitable giving event will be taking place on <strong>November 30, 2021</strong>.</p>\n\n\n\n<p>With Giving Tuesday around the corner, many in the world are thinking about giving back. If you’re one of them, consider this opportunity to give back to open source.</p>\n\n\n\n<p>2021 and the pandemic brought a lot of changes to the world, including the open source community. And the year wasn’t without its challenges.</p>\n\n\n\n<p>Open source developers worldwide <a href=\"https://www.statista.com/statistics/912378/worldwide-open-source-professional-challenges-in-work/\" target=\"_blank\" rel=\"noreferrer noopener\">still face roadblocks</a>, from “lack of training opportunities” to “getting management buy-in for open source.”</p>\n\n\n\n<p>This is why the WordPress Foundation exists.</p>\n\n\n\n<h2 id=\"how-does-the-wordpress-foundation-support-open-source\">How does the WordPress Foundation support open source?</h2>\n\n\n\n<p>As a non-profit organization, our <a href=\"https://wordpressfoundation.org/\">work</a> is to ensure that open source software gets the support it needs. The funds we raise go toward ensuring free access to the projects we promote, protecting the WordPress trademark, and funding multiple programs aligned with our mission.</p>\n\n\n\n<p><strong>Some of the programs the WordPress Foundation supports include</strong>:</p>\n\n\n\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://wordpress.tv/\" target=\"_blank\">Video documentation</a> of WordCamp and WordPress meetup events.</li><li>“<a href=\"https://wordpressfoundation.org/tag/intro-to-open-source/\">Intro to Open Source</a>” workshops that increase awareness and understanding of the open web and open source in regions around the world that have relatively less participation.</li><li><a rel=\"noreferrer noopener\" href=\"https://doaction.org/\" target=\"_blank\">Charity hackathons</a> where developers come together and volunteer to build websites for nonprofit organizations around the world.</li><li><a rel=\"noreferrer noopener\" href=\"https://learn.wordpress.org/workshops/\" target=\"_blank\">Workshops</a>, both live and recorded, on how to use and develop for the WordPress platform.</li><li>School mentorship programs to encourage interest in WordPress and open source development from a young age.</li><li>Improving documentation about how to use and develop for, and contribute to the WordPress project.</li></ul>\n\n\n\n<p>But this is just the beginning. With your help, we can strengthen our support for these programs and fund many more exciting open source projects.</p>\n\n\n\n<a href=\"https://i0.wp.com/wordpressfoundation.org/content/uploads/2018/08/capetown.jpg?ssl=1\"><img /></a>Volunteers from do_action Cape Town 2018 working on charity websites\n\n\n\n<h2 id=\"how-can-you-help-this-giving-tuesday\">How can you help this Giving Tuesday?</h2>\n\n\n\n<p>The future is open source, and whether you’re a believer or part of the open source community, you can play a part in helping build this foundation for generations to come.</p>\n\n\n\n<p><strong>This Giving Tuesday, consider donating to the WordPress Foundation so we can work together toward a future that’s built on open source.</strong></p>\n\n\n\n<p>You can choose to donate annually or make a one-time donation. Every gift counts!</p>\n\n\n\n<div class=\"wp-container-61a48897140e0 wp-block-buttons\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-white-color has-text-color has-background\" href=\"https://wordpressfoundation.org/donate/\"><strong>Donate to the WordPress Foundation</strong></a></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-text-align-left\">Thank you for supporting our mission!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Nov 2021 16:05:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Anjana Vasan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"HeroPress: Tales Of A Serial Contributor – Histórias de um colaborador em série\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=4283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"https://heropress.com/essays/tales-of-a-serial-contributor/#utm_source=rss&utm_medium=rss&utm_campaign=tales-of-a-serial-contributor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:31833:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2021/11/112321-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I believe that the great advantage and differential of WordPress ... is its community.\" /><p><a href=\"https://heropress.com/feed/#portuguese\"><span class=\"css-901oao css-16my406 r-poiln3 r-bcqeeo r-qvutc0\">O texto também está disponível em português do Brasil.</span></a></p>\n<p>Hey! My name is Daniel Kossmann. I&#8217;ve been WordPress user since 2009, one of the organizers of the Curitiba community, creator of the weekly newsletter called PainelWP, and a regular writer about WP in my blog. This is my before and after story from joining the WordPress community in Brazil. Happy reading!</p>\n<h2>First contacts with the internet</h2>\n<p>Since I was a kid I was very fond of computers and video games, but the internet opened a whole new world for me. I was so fascinated that at eleven years, around 1998, reading tutorials and analyzing HTML codes I created my first website on James Bond, of whom I was a big fan. In those first years, even though my parents didn&#8217;t quite understand what I was doing and why I was spending so much time in front of the computer, they backed me up by purchasing books and computers.</p>\n<p>Little by little I learned more about programming and developing my systems in ASP and only then PHP. Since there weren&#8217;t so many websites teaching programming, I created a series of websites that taught others how to create websites and add small functionalities for them, like counters, login area, blinking text, &#8230;. At that time, I even created a content management system, that could receive contributions through a form and automatically published them every day at a given time, with a countdown timer in the website telling visitors when the next update would occur. This may be seen as trivial today, but at that time it was very uncommon. Those were really fun days, where I spent several nights learning new things and talking to other people who had the same interest in IRC on the deceased Brasnet network. If you are curious to learn more, check out <a href=\"https://belohorizonte.wordcamp.org/2016/daniel-kossmann-ferraz-automacao/\">my interview at WordCamp Belo Horizonte 2016</a> (content in Portuguese).</p>\n<h2>First contact with WordPress</h2>\n<p>When the time came to choose my undergraduate, there was no doubt that it would be something related to computers. So I chose a Computer Science degree from Federal University from Parana (UFPR). During college, I also wanted to dabble in other fields, so I decided to create a blog in which to write movie reviews. Looking for a platform in which to easily publish texts, so I wouldn&#8217;t have to worry about coding because I already was doing this every day at school, I discovered WordPress. It didn&#8217;t take long and, in 2009, I launched my first public blog about movies, which after one year became <a href=\"https://www.interrogacao.com.br/\"><i>interrogAção</i></a> (content in portuguese), a cultural hub on cinema, literature, and comics, with collaborators from several cities in Brazil. As in the case with my first tutorial websites and IRC conversations, many of these people I only knew virtually, but we had an intense contact while exchanging know-how.</p>\n<p>Even though my focus was more on content creation and editorializing, I began to learn more about how to create themes and features in WordPress to customize the website. In one of these researches, I found out that an event focused on WP was going to happen in my city. Even not knowing a lot about the platform, I decided to attend and learn more.</p>\n<h2>First contact with the community</h2>\n<p>The event was <a href=\"https://curitiba.wordcamp.org/2010/\">WordCamp Curitiba 2010</a> (content in portuguese) and I still remember how amazed I was at it being so cheap, I think it was R$60 or less, offering so many souvenirs and snacks. Other tech events I had attended had always charged more than double and hadn&#8217;t offered half of these things.</p>\n<p>The talks were amazing, and everyone was always very kind and available. I was so excited about everything that I promised myself that I would volunteer during the next edition and also try to be a speaker. As I didn&#8217;t know anyone at the event, I challenged myself to talk with at least three people — I was extremely shy back then. Since then two of them have become lifelong friends.</p>\n<p>At the end of the event, I found out that there was an after-party called WordCana (a joke with the word &#8220;cana&#8221;, from sugarcane, that is used to make distilled spirit). Even though I didn&#8217;t drink alcohol, I decided to go and it was awesome! There, I got to know the event&#8217;s speakers, organizers and attendees. Everyone talking as equals. And the fact that I didn&#8217;t drink alcohol didn&#8217;t change at all my interaction with them.</p>\n<h2>From attendee to WordCamp organizer</h2>\n<p>The promise I had made during that event came true! Less than two years later, I was helping to organize the next edition, <a href=\"https://curitiba.wordcamp.org/2012/\">WordCamp Curitiba 2012</a> (content in portuguese), which was where I also gave <a href=\"https://wordpress.tv/2012/10/11/daniel-kossmann-ferramentas-livres-para-desenvolvimento-wordpress/\">my first public talk</a> (content in portuguese). I was still very shy and, during the talk, I was so nervous that I couldn&#8217;t hold the microphone near my mouth. Because of that, even though it was a small room, people were having a hard time listening to my voice. Nevertheless, it was an important overcoming experience that has kept me desiring to improve my public speaking skills for future talks to this day.</p>\n<h2>From user to entrepreneur</h2>\n<p>Since I was a kid I had dreamt about opening my own company. Therefore, when I graduated in 2011, as I have always liked creating websites, I had little doubts about my next step: creating a web development company. I named it Spirallab, because of my passion for spirals and imagining turning it into a creative project lab. In the beginning, I didn&#8217;t define a direction and I worked with various systems and programming languages. Soon I realized that giving maintenance to these different solutions was a lot of work. So I opted to use a single platform, WordPress, due to its ease of use for my clients and the possibility to create various types of websites.</p>\n<p>This decision allowed me to dive even deeper into the system, making better and faster-to-deliver solutions for my clients. As time went by, I also increased my services within the platform, adding support, maintenance, courses, consulting and optimized hosting for WordPress, which at that time was extremely hard to find. This allowed for a broader client range. It also enabled us to specialize in the platform, getting to better know all of its facets.</p>\n<p>Even being a small company, never going beyond four people, I made sure to find ways to contribute to the WordPress community. After all, I managed to support my business without paying a single cent to use the platform. That is why I sponsored several WordCamps and meetups. This created a curious situation: Spirallab&#8217;s name was side by side with other sponsors that had 10 to 50 times its size. I wondered why there weren&#8217;t more companies doing the same. The sponsorship quotas started with a very low price tag, sometimes R$250. Considering the annual revenue of a company that uses WP as its main solution, I believe that this cost or investment could be easily included in its annual budget. I wish more companies, regardless of their size, would do that.</p>\n<p>Besides that, I&#8217;ve talked at several meetups and WordCamps, where I shared what I learned in my day-to-day life. It was always and still is a big pleasure to be able to make these contributions. During the events, I gave away some stickers from my company that had an illustration of a digital alchemist (a kind of modern wizard). Because of that, and my looks (long hair and beard), I ended up being nicknamed the WordPress Wizard.</p>\n<p>Eight years after Spirallab&#8217;s foundation, I decided to close the company&#8217;s activities and start a new chapter at <a href=\"https://www.pipefy.com/\">Pipefy</a> in 2019, where I currently work as a WordPress Development Coordinator.</p>\n<h2>The return of Curitiba&#8217;s WordPress Community</h2>\n<p>After WordCamp 2012, Curitiba&#8217;s community became inactive. But the urge to continue with the events stayed with me. It took me three years to take the first step. So I got in touch with other people from the Brazilian community that I had met at WordCamp, to find out what was needed to restart the meetings, which are called meetups, in Curitiba. Coincidentally, I found out three people who wanted to do the same and we started planning the event through Slack, a text chat software. In less than a month, we organized the <a href=\"https://www.meetup.com/pt-BR/wpcuritiba/events/224130389/\">first event</a>, on August 5, 2015. The most curious thing was that we were able to do all of the planning virtually, and only met for the first time in person on the day of the event.</p>\n<p>Due to the speed in which we were able to organize this event, it may seem that we already had experience with this type of organization, but in fact, we didn&#8217;t have much, if any. So the first thing we asked ourselves was, &#8220;What would be nice to have included in the event if we were attendees?&#8221;. And two things stood out: having food and fun. So we ordered food (pizza, for convenience) and we tried to make something funner and without many formalities. We didn&#8217;t want to have those events where hardly anyone talks to anyone and after the talk, everyone leaves like they&#8217;re running away from something.</p>\n<p>Keeping anyone from feeling lost, we made a brief presentation with slides at the beginning of the meetup, explaining what the event was and how it was organized, asking everyone to introduce themselves. This structure was maintained during all future events. Little by little, we carried out several experiments, such as a section where everyone could share news, themes, or plugin tips, or a classified section, where people could say if they were looking for or offering a particular service. Among the organizers, we always pre-arranged tips to be shared, in order to encourage others to participate. At first, few people engaged, but over time, they ended up becoming an important part of the event.</p>\n<p>As I was extremely shy, getting in front of people to introduce the meetup was not easy.</p>\n<blockquote><p>I was very nervous and ended up speaking very low, even stuttering a little. I wanted to change that and knew that the only way was to practice. I believe the meetup is a great place for this, as it is a small group of people with a common interest: learning.</p></blockquote>\n<p>This makes everyone more receptive, creating a safe environment to participate in a variety of ways.</p>\n<p>By the way, this is something very important to me: making the events an environment where everyone feels welcome and safe to ask questions and share experiences. Therefore, I always welcome new participants and encourage them to participate and talk to other people. Sometimes I retell the story of my first WordCamp, where I challenged myself to talk to three strangers.</p>\n<p>Nowadays, although I&#8217;m still a reserved person, I&#8217;m not so shy anymore and can speak in public without as much difficulty. Because of this personal achievement, whenever possible, I encourage others to give their first talk and also share all the tips I used, and still use, to make better presentations. I get very happy when I see people overcoming these challenges and growing personally and professionally. Despite having changed a lot, I still set a personal challenge to always do something to take me out of my comfort zone in each and every talk. Sometimes it doesn&#8217;t have the expected effect, but at least I have one more funny story to tell.</p>\n<p>It&#8217;s been more than six years since the first meetup (there was even a <a href=\"https://www.youtube.com/watch?v=vhYqoPaRsPo\">commemorative video</a>) and throughout this time the WordPress community in Curitiba has held monthly events. I confess that it is not easy to maintain this consistency, but it is very rewarding!</p>\n<h2>From developer to WordPress content creator</h2>\n<p>I&#8217;ve always enjoyed reading technology newsletters, but there weren&#8217;t any specific to WordPress in Brazil. After much contemplation (and procrastination) I decided to create a newsletter that prioritized the spreading of content in Portuguese. And, on June 22, 2019, I published the Zero edition of <a href=\"https://www.painelwp.com.br/\">PainelWP</a> (content in portuguese). Since then, I&#8217;ve searched and published the main news, tutorials, tips, events, and WordPress jobs weekly. My main goal with the newsletter is to inspire more people to create content about WP in Portuguese.</p>\n<p>As I learn a lot from reading tutorials and articles, this year (2021), I also started writing content regularly about WordPress on <a href=\"https://www.danielkossmann.com/category/wordpress/\">my blog</a> (content in portuguese). One of the publications I&#8217;m doing on behalf of PainelWP is to write about <a href=\"https://developer.wordpress.org/reference/functions/\">how to use WordPress&#8217;s native PHP functions</a> (content in portuguese), with code examples. Writing regularly is quite challenging, but it&#8217;s very rewarding and I learn a lot. I recommend creating a blog and posting on it regularly to all professionals who want to improve their knowledge. One idea is to keep a record of what you are learning on the blog.</p>\n<p>In addition, all of this is published under the <a href=\"https://creativecommons.org/licenses/by-sa/4.0/deed.en\">Creative Commons BY-SA license</a>, almost an equivalent of free software license for content. I chose this license because it makes it easy for content to be shared and used, like the WordPress source code.</p>\n<h2>The Importance of the WordPress Community</h2>\n<p>I believe that the great advantage and differential of WordPress, in addition to the numerous plugins and themes available, is its community. Because it&#8217;s an open platform and makes it easy to create websites, it attracts people with very different technical levels and backgrounds. This diversity helps create an open space for exchange, where everyone has something different to teach.</p>\n<p>This creates a connection both online and in person. It&#8217;s very satisfying to meet people in person at community events. From these encounters, I&#8217;ve made several lasting friendships. These contacts also have helped me a lot professionally. I&#8217;ve received several job referrals from them and I&#8217;ve also referred several people.</p>\n<p>An important tip I&#8217;ve learned in the WordPress community is: every time you&#8217;re in a conversation circle during events, leave a free space for a new person to join the circle. This format is also called <a href=\"https://ericholscher.com/blog/2017/aug/2/pacman-rule-conferences/\">the Pac-Man Rule</a>.</p>\n<p>If you&#8217;re not yet part of the WordPress community, I recommend looking for a meetup in your city, or nearby, to join. There are also several community meetings online now, which is a great opportunity to exchange knowledge with people from other cities. Hope you&#8217;ve enjoyed my story and see you at the next meetup or WordCamp!</p>\n<h1 id=\"portuguese\">Histórias de um colaborador em série</h1>\n<p>Oi! Meu nome é Daniel Kossmann. Utilizo WordPress desde 2009, sou um dos organizadores da Comunidade de WordPress de Curitiba, criador da newsletter semanal PainelWP e escrevo regularmente sobre WP em meu blog pessoal. Esta é a minha história antes e depois de começar a participar da comunidade do WordPress do Brasil. Boa leitura!</p>\n<h2>Primeiros contatos com a internet</h2>\n<p>Desde criança já gostava bastante de computadores e videogames, mas a internet abriu um mundo totalmente novo para mim. Fiquei tão fascinado que aos 11 anos, por volta de 1998, lendo tutoriais e analisando códigos HTML criei o meu primeiro site (sobre James Bond, eu era um grande fã). Nesses primeiros anos, apesar de meus pais não entenderem direito o que eu fazia e porque passava tantas horas em frente ao computador, eles me apoiaram comprando livros e computadores.</p>\n<p>Aos poucos fui aprendendo mais sobre programação e criando meus próprios sistemas em ASP e depois em PHP. Como existiam poucos sites em português que ensinavam programação, criei vários sites que ensinavam outras pessoas a criarem sites e adicionar pequenas funcionalidades neles (como contadores, áreas de login, textos piscando, …). Nesta época, também cheguei a criar meu próprio gerenciador de conteúdo, que aceitava o envio de conteúdo por colaboradores através de um formulário e fazia a publicação automaticamente todos os dias em um determinado horário (com um contador no site avisando quando seria a próxima atualização). Isto pode parecer bem trivial hoje em dia, mas naquele tempo ainda não era nada comum. Esta foi uma época bem divertida, onde passei várias madrugadas aprendendo coisas novas e conversando com outras pessoas que tinham o mesmo interesse no IRC, na falecida rede Brasnet. Se você ficou curioso para saber sobre essa época, veja a <a href=\"https://belohorizonte.wordcamp.org/2016/daniel-kossmann-ferraz-automacao/\">entrevista que o WordCamp Belo Horizonte 2016 fez comigo</a>.</p>\n<h2>Primeiros contatos com o WordPress</h2>\n<p>Quando chegou a hora de escolher um curso superior, não tinha dúvidas que seria algo relacionado à computação. Então entrei no curso de Ciência da Computação na Universidade Federal do Paraná (UFPR). Durante a faculdade, também queria experimentar outras áreas e decidi criar um blog para escrever críticas de filmes. Procurando por uma plataforma que fosse fácil de publicar textos para que eu não tivesse que me preocupar com códigos (já via isso todo dia no meu curso), descobri o WordPress. Não demorou muito e em 2009 criei meu primeiro blog público sobre cinema, que depois de um ano se transformou no <a href=\"https://www.interrogacao.com.br/\">interrogAção</a>, um portal cultural sobre cinema, literatura e quadrinhos, com colaboradores de várias cidades do Brasil. Assim como nos meus primeiros sites de tutoriais, e conversas do IRC, muitas dessas pessoas eu só conhecia virtualmente, mas tínhamos um contato intenso de troca de conhecimento.</p>\n<p>Apesar do meu foco estar mais voltado para criação e editoração de conteúdo, comecei a aprender mais sobre como funcionava a criação de temas e funcionalidades no WordPress para poder personalizar o site. Em uma dessas pesquisas, descobri que iria acontecer um evento só sobre o WP na minha cidade. Mesmo não sabendo ainda muito sobre o sistema, decidi me inscrever para poder aprender mais.</p>\n<h2>Primeiro contato com a comunidade</h2>\n<p>O evento era o <a href=\"https://curitiba.wordcamp.org/2010/\">WordCamp Curitiba 2010</a> e ainda lembro do quanto fiquei impressionado por ele ser tão barato (acho que foi R$60 ou menos), oferecer tantos brindes e ter lanches. Os outros eventos de tecnologia que havia participado sempre custaram mais que o dobro e não ofereciam nem metade dessas coisas.</p>\n<p>As palestras foram ótimas e todo mundo era sempre muito gentil e disponível. Fiquei tão empolgado com tudo, que prometi para mim mesmo que iria ajudar na próxima edição e também tentar palestrar nela. Como não conhecia ninguém no evento, defini como desafio pessoal falar com pelo menos três pessoas (eu era extremamente tímido). Duas delas acabaram se tornando amizades de longa data.</p>\n<p>No final do evento, descobri que haveria uma continuação chamada WordCana. Mesmo não gostando de beber, decidi ir e foi sensacional! Lá, conheci mais de perto os palestrantes, organizadores e participantes do evento. Todos falando de igual para igual. E o fato de não beber, não influenciou em nada minha interação com as outras pessoas.</p>\n<h2>De participante para organizador do WordCamp</h2>\n<p>A promessa que fiz durante o evento deu certo! Menos de dois anos depois, estava ajudando a organizar a próxima edição, o <a href=\"https://curitiba.wordcamp.org/2012/\">WordCamp Curitiba 2012</a>. Nele também fiz <a href=\"https://wordpress.tv/2012/10/11/daniel-kossmann-ferramentas-livres-para-desenvolvimento-wordpress/\">minha primeira palestra pública</a>. Eu continuava sendo muito tímido e durante a palestra, fiquei tão nervoso que não conseguia deixar o microfone perto da boca. Por conta disso, mesmo em uma sala pequena, as pessoas tiveram dificuldades para me escutar. Mesmo assim, foi uma importante experiência de superação, que me ajudou a continuar querendo melhorar minhas habilidades de falar em público em futuras palestras.</p>\n<h2>De usuário para empreendedor</h2>\n<p>Desde criança sonhava em abrir minha própria empresa e como gostava de criar sites, quando me formei em 2011, não tive muitas dúvidas sobre qual seria meu próximo passo: abrir uma empresa que desenvolve soluções para a internet. Chamei ela de Spirallab, por conta da minha paixão por espirais e pensando em torná-la um laboratório para projetos criativos. No início não defini muito um foco e trabalhei com vários sistemas e linguagens de programação diferentes. Aos poucos percebi que a manutenção dessas diferentes soluções estava ficando muito trabalhosa. Decidi que deveria utilizar apenas uma única plataforma e escolhi o WordPress, porque era fácil de ser utilizado pelo cliente e permitia a criação de diversos tipos de sites.</p>\n<p>Esta decisão me permitiu aprofundar muito mais no sistema, fazendo com que criasse soluções melhores e mais rápidas de entregar para meus clientes. Conforme o tempo foi passando, também aumentei as opções de serviços oferecidos em volta da plataforma: suporte, manutenção, hospedagem otimizada para WordPress (na época era extremamente difícil achar algo assim), cursos e consultorias. Isto permitiu uma diversificação maior de clientes. Também possibilitou uma especialização na plataforma, conhecendo todos os aspectos que a envolviam.</p>\n<p>Mesmo sendo uma empresa pequena (nunca passou de 4 pessoas), fiz questão de encontrar maneiras de contribuir com a comunidade do WordPress. Afinal, eu estava conseguindo sustentar o negócio sem precisar pagar nenhum centavo para utilizar a plataforma. Por isso ajudei a patrocinar vários WordCamps e meetups. Isso criava uma situação curiosa: o nome da Spirallab ficava ao lado de outros patrocinadores que tinham 10 ou 50 vezes o tamanho dela. Ficava então me perguntando porque não haviam mais empresas fazendo o mesmo. As cotas desses patrocínios iniciavam com um valor bem baixo (muitas vezes em R$250). Se formos considerar o faturamento de uma empresa que utiliza o WP como solução principal, acredito que este custo (ou investimento) poderia ser facilmente adicionado ao planejamento anual. Gostaria muito que mais empresas, independente do tamanho, fizessem isso.</p>\n<p>Além disso, palestrei em vários meetups e WordCamps, onde compartilhei o que havia aprendido no meu dia a dia. Sempre foi (e ainda é) uma satisfação muito grande poder fazer estas contribuições. Durante os eventos eu distribuía um adesivo da minha empresa que tinha a ilustração de um alquimista digital (uma espécie de mago moderno). Por conta disto, e do meu visual (cabelo comprido e barba), acabei ganhando o apelido de o Mago do WordPress.</p>\n<p>Oito anos depois da fundação da Spirallab, decidi encerrar as atividades da empresa e iniciei um novo capítulo na <a href=\"https://www.pipefy.com/\">Pipefy</a> em 2019, onde trabalho atualmente como coordenador de desenvolvimento WordPress.</p>\n<h2>O retorno da Comunidade de WordPress de Curitiba</h2>\n<p>Depois do WordCamp 2012, a Comunidade de Curitiba ficou inativa. Mas a vontade de continuar com os eventos continuou na minha cabeça. Demorei três anos para dar o primeiro passo. Então entrei em contato com outras pessoas da comunidade brasileira que tinha conhecido no WordCamp, para saber o que era necessário para voltar a fazer os encontros (também chamados de <i>meetups</i>) em Curitiba. Por coincidência, descobri que mais três pessoas estavam querendo fazer o mesmo e começamos a planejar o evento através do Slack (software de bate papo em texto). Em menos de um mês, organizamos o <a href=\"https://www.meetup.com/pt-BR/wpcuritiba/events/224130389/\">primeiro evento, no dia 5 de agosto de 2015</a>. O mais interessante foi que conseguimos fazer tudo isso virtualmente. Só no dia do evento que nós nos encontramos pessoalmente pela primeira vez.</p>\n<p>Pela velocidade que conseguimos organizar este evento, pode parecer que já tínhamos experiência neste tipo de organização, mas na verdade não tínhamos muita (ou nenhuma) experiência como organizadores. Por isso, a primeira coisa que nos perguntamos foi: o que seria legal ter, caso fossemos participantes? E duas coisas se destacaram: ter comida e ser divertido. Então pedimos comida (pizza, pela praticidade) e tentamos fazer algo mais divertido e sem formalidades. Não queríamos aqueles eventos onde quase ninguém fala com ninguém e depois da palestra todos vão embora como se estivessem fugindo de algo.</p>\n<p>Para que ninguém se sentisse perdido, no início do meetup fizemos uma breve apresentação com slides, explicando o que é o evento e como ele é organizado, pedindo para cada um se apresentar. Essa estrutura se manteve durante todos os próximos eventos. Aos poucos fomos fazendo vários experimentos. Desde uma seção onde todos podiam compartilhar uma notícia, dica de tema ou plugin, até um espaço para classificados, onde as pessoas poderiam dizer se procuravam ou ofereciam determinado serviço. Entre os organizadores, sempre combinamos previamente dicas para serem compartilhadas, de forma a estimular outras pessoas a participarem. No começo poucas pessoas participavam, mas com o tempo, estes momentos acabaram se tornando uma parte importante do evento.</p>\n<p>Como eu era extremamente tímido, ficar em frente a várias pessoas para apresentar o meetup não era nada fácil. Ficava muito nervoso e acabava falando bem baixo, até gaguejando um pouco. Queria mudar isso e sabia que o único jeito era praticar. Acredito que o meetup é uma ótima oportunidade para isto, por ser um grupo pequeno de pessoas com um interesse em comum: aprender. Isso faz com que todos sejam mais receptivos, criando um ambiente seguro para participar de várias formas.</p>\n<p>Aliás, isto é algo muito importante para mim: tornar os eventos um ambiente onde todas as pessoas se sintam bem vindas e seguras para fazerem perguntas e compartilharem experiências. Por isso, sempre dou boas vindas para os novos participantes e os incentivo a participarem e conversarem com outras pessoas do evento. Às vezes, conto a história do meu primeiro WordCamp, onde me desafiei a conversar com três pessoas desconhecidas.</p>\n<p>Hoje em dia, apesar de continuar sendo uma pessoa mais quieta, não sou mais tão tímido e consigo falar em público sem tanta dificuldade. Por conta desta superação pessoal, sempre que possível, incentivo outras pessoas a darem sua primeira palestra e também compartilho todas as dicas que utilizei (e ainda utilizo) para fazer melhores apresentações. Fico muito feliz quando vejo pessoas superando essas dificuldades e crescendo pessoalmente e profissionalmente. Apesar de ter mudado muita coisa, ainda utilizo como desafio pessoal fazer sempre algo para me tirar da zona de conforto em cada palestra (às vezes não tem o efeito esperado, mas pelo menos tenho mais uma história engraçada para contar).</p>\n<p>Já se passaram mais de seis anos desde o primeiro meetup (teve até um <a href=\"https://www.youtube.com/watch?v=vhYqoPaRsPo\">vídeo comemorativo</a>) e desde lá a comunidade de WordPress de Curitiba faz eventos mensalmente. Confesso que não é nada fácil manter essa consistência, mas é muito gratificante!</p>\n<h2>De desenvolvedor para criador de conteúdo sobre WordPress</h2>\n<p>Sempre gostei muito de ler newsletters sobre tecnologia, mas não havia nenhuma específica de WordPress no Brasil. Depois de muito contemplar (e procrastinar), decidi criar uma newsletter que priorizasse a divulgação de conteúdo em português. E, em 22 de junho de 2019, publiquei a edição zero do <a href=\"https://www.painelwp.com.br/\">PainelWP</a>. Desde lá, semanalmente procuro e divulgo as principais notícias, tutoriais, dicas, eventos e vagas de WordPress. Meu principal objetivo com a newsletter é inspirar mais pessoas a criarem conteúdo sobre WP em português.</p>\n<p>Como aprendo muito lendo tutoriais e artigos, também comecei a escrever regularmente este ano (2021) no <a href=\"https://www.danielkossmann.com/category/wordpress/\">meu blog conteúdo sobre WordPress</a>. Uma das publicações que estou fazendo por conta do PainelWP é escrever semanalmente sobre como utilizar <a href=\"https://developer.wordpress.org/reference/functions/\">funções nativas em PHP do WordPress</a>, com exemplos de códigos. Escrever regularmente é bem desafiador, mas é muito gratificante e aprendo bastante. Recomendo a todos os profissionais que querem aprimorar seus conhecimentos, criar um blog e postar regularmente. Uma ideia é manter um registro do que você está aprendendo no blog.</p>\n<p>Além disso, tudo isso é publicado sob a <a href=\"https://creativecommons.org/licenses/by-sa/4.0/deed.pt_BR\">licença Creative Commons BY-SA</a>, quase um equivalente do software livre para conteúdo. Escolhi esta licença pois facilita que o conteúdo seja compartilhado e utilizado, assim como o código fonte do WordPress.</p>\n<h2>A importância da comunidade de WordPress</h2>\n<p>Acredito que a grande vantagem e diferencial do WordPress, além dos inúmeros plugins e temas disponíveis, é a sua comunidade. Por ser uma plataforma aberta e facilitar a criação de sites, ele atrai pessoas com vários níveis técnicos e históricos muito diferentes. Esta diversificação ajuda a criar um espaço aberto para trocas, onde cada um tem algo diferente para ensinar.</p>\n<p>Isto cria uma conexão que se dá tanto online quanto presencialmente. É muito gratificante encontrar pessoas pessoalmente em eventos da comunidade. A partir desses encontros, fiz várias amizades duradouras. Estes contatos também me ajudaram bastante profissionalmente. Já recebi várias indicações para serviços a partir deles e também já indiquei várias pessoas.</p>\n<p>Uma dica importante que aprendi na comunidade de WordPress é: toda vez que estiver em uma roda de conversa durante os eventos, deixe um espaço livre para que uma nova pessoa possa se juntar à roda. Este formato também é chamado de <a href=\"https://ericholscher.com/blog/2017/aug/2/pacman-rule-conferences/\">regra do Pac-Man</a>.</p>\n<p>Se você ainda não faz parte da comunidade de WordPress, recomendo procurar um meetup na sua cidade (ou próximo dela) para participar. Também há várias comunidades fazendo encontros online agora, que são uma ótima oportunidade de trocar conhecimento com pessoas de outras cidades. Espero que você tenha gostado da minha história e nos vemos no próximo meetup ou WordCamp!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Nov 2021 11:00:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Daniel Kossmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: WordPress, Blogging, and the Things We Are Thankful For\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=126085\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"https://wptavern.com/wordpress-blogging-and-the-things-we-are-thankful-for?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-blogging-and-the-things-we-are-thankful-for\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4246:\"<p class=\"has-drop-cap\">On Saturday, one side of my family held our pre-Thanksgiving reunion. It had been two years since we were able to do it. I offered to host this year when our previous venue&rsquo;s loss threatened to sideline the event for yet another year. Needless to say, I was exhausted by the time my last cousin and his wife got in the car and drove off toward their home in south Alabama.</p>\n\n\n\n<p>Sunday, the day after, was the first relaxing day I had taken in weeks. But, I am not one for spending the entire day dedicated to watching TV &mdash; except when <em>Squid Game</em> was released.</p>\n\n\n\n<p>Dusting off my rarely-used personal blog, I began to pen an update post on my National Novel Writing Month progress. Instead of actually doing that, at least until later in the night, I looked over years of published blog posts.</p>\n\n\n\n<p>There is a rich history there, at least to me. My blog is a journal of my personal memories going back to 2003. For 18 years, I have been writing something, spitting out words into what can sometimes feel like an endless void. That na&iuml;ve 19-year-old kid who was just setting foot into the online world was not thinking he would still be doing the same thing all these years later. He was just blogging. It was one part an extension of the angst-ridden notebooks he had filled as a teen. It was another part of a new and exciting journey.</p>\n\n\n\n<p>For around an hour or so, I simply clicked and read and clicked and read. It is an extraordinary time to be alive, to take part in this moment in history where anyone from all over the world could live those same memories with me. And I can read their blogs. I can read about their hopes and dreams, view galleries of their pets, or catch up on their goals for the new year.</p>\n\n\n\n<p>This is one of the reasons I subscribe to people&rsquo;s personal blog feeds more so than news or development sites. At the end of the day, everything we do here is about people.</p>\n\n\n\n<p>I took a deep dive through my archives, caught up with some fun moments I had shared with the world, and read over some of my old WordPress development tutorials. I even scanned through my obsession with Marie Kond&#333;s tidying rules.</p>\n\n\n\n<p>I was only disappointed that there were many moments that I decided not to share. I perused some of the notes from unpublished drafts of various instances of #WPDrama, discussions where I decided to keep my thoughts to myself rather than rock the boat. I skipped over headlines for books I had read but never reviewed. I remembered some life-changing moments that I never bothered to even write a draft about.</p>\n\n\n\n<p>Aside from reminiscing over the past half of my life, I realized that my blog is older than many people who are just starting their own blogging journeys. WordPress, which also <a href=\"https://wptavern.com/happy-18th-birthday-wordpress\">turned 18 this year</a>, is older than its next generation of users.</p>\n\n\n\n<p>I also realized that I simply enjoy blogging. I had never given it much thought before &mdash; the <em>why</em> behind my continued participation in this artform. Perhaps it is because I have something I want to say from time to time. Maybe it is simply therapeutic. In the end, it might not matter. However, I am grateful that we have platforms like WordPress that allow us all to do it, regardless of our reasons.</p>\n\n\n\n<p>As we close shop for the week for some much-needed rest, I am making a note to read through the bookmarked blog posts I have not gotten around to (thank you to everyone who has shared). I want to dive into the backlog of personal blogs I have yet to catch up on. I always check out every Tavern commenter&rsquo;s website when they leave a URL in the form. I do not always get around to them immediately, but I have found many blogs that I genuinely enjoy reading this way.</p>\n\n\n\n<p>Heading into this year&rsquo;s U.S. Thanksgiving holiday, I am reminded of how fortunate I am to be a part of the WordPress community. It is a living, breathing ecosystem that has always remained true to its blogging roots. The platform allows millions of people to share their voices while owning their content.  That alone is something worth being thankful for.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Nov 2021 00:05:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: WordPress 5.9 Revised Release Date Confirmed for January 25, 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=126003\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:193:\"https://wptavern.com/wordpress-5-9-revised-release-date-confirmed-for-january-25-2022?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-5-9-revised-release-date-confirmed-for-january-25-2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4210:\"<p>Last week WordPress 5.9&rsquo;s release leads found a consensus for <a href=\"https://wptavern.com/wordpress-5-9-delayed-until-january-2022\">delaying the release</a> after missing the deadlines for Beta 1 due to significant blockers. At that time they proposed a schedule for moving forward, and that is now <a href=\"https://make.wordpress.org/core/5-9/\">confirmed</a>. Beta 1 is planned for November 30, 2021, with subsequent betas in December. RC 1 is scheduled for January 4, 2022, and the official release is anticipated on January 25.</p>\n\n\n\n<p>For the past decade, Matt Mullenweg&rsquo;s <a href=\"https://make.wordpress.org/core/2010/04/20/deadlines-are-not-arbritrary-theyre-a/\">deadlines are not arbitrary</a> philosophy has guided core development, preventing  releases from being delayed by the desire to squeeze in one more feature:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Deadlines are not arbitrary, they&rsquo;re a promise we make to ourselves and our users that helps us rein in the endless possibilities of things that could be a part of every release. </p></blockquote>\n\n\n\n<p>Deadlines make it possible for agencies, product developers, and hosting companies with millions of WordPress customers, to prepare for upcoming releases in a predictable way that ultimately enables more sites to update regularly. The situation with WordPress 5.9 is unique, because the effort involves shipping a set of interdependent features that also provide the foundation for a new way of theming.</p>\n\n\n\n<p>&ldquo;As the FSE features are very closely intertwined, removing some of its pieces would risk making the release unstable,&rdquo; 5.9 Core Tech Lead Tonya Mork said in a <a href=\"https://make.wordpress.org/core/2021/11/22/wordpress-5-9-revised-release-schedule/\">post</a> announcing the new schedule. &ldquo;To avoid delivering a sub-optimal experience, moving fixes to a 5.9 minor or 6.0 was ruled out.&rdquo;</p>\n\n\n\n<p>Mork said the team considered punting full-site editing (FSE) and the Twenty Twenty-Two theme that depends on it to 6.0 but saw more benefit in shipping the collection of features sooner.</p>\n\n\n\n<p>&ldquo;The 6.0 release isn&rsquo;t due until April 2022&mdash;too long for the community to wait for them,&rdquo; Mork said. &ldquo;After processing this<a href=\"http://github.com/WordPress/gutenberg/issues/36556\">&nbsp;list of issues</a>,&nbsp;Core&nbsp;Editor team saw the features could ship in 5.9 with the revised schedule.&rdquo;&nbsp;</p>\n\n\n\n<p>Anne McCarthy, who is co-leading testing for the release, is in the trenches with FSE and wrote a <a href=\"https://nomad.blog/2021/11/23/why-i-voted-to-delay-wordpress-5-9/\">summary</a> of why she was proponent of delaying in this instance. She cited improved sustainability for contributors, and the value of users getting access to the whole suite of FSE features rather than smaller pieces, as factors in the decision.</p>\n\n\n\n<p>&ldquo;More specifically, if we were to push everything to 6.0, this would delay the Twenty Twenty-Two theme, hold back the launch of block themes in general, and delay a ton of user value in exploring ways to edit all parts of a site,&rdquo; McCarthy said.</p>\n\n\n\n<p>The decision to delay 5.9 to January 2022 has been met with positive feedback from all sides, and many following the progress have expressed their appreciation of the team&rsquo;s transparency throughout the decision-making process. It&rsquo;s reassuring to see the release leads acting in the interest of users and contributors, instead of forcing something half-baked forward. </p>\n\n\n\n<p>In the meantime, if you want a sneak peak of some newer features coming in 5.9, check out the video the release team <a href=\"https://wordpress.org/news/2021/11/a-look-at-wordpress-5-9/\">published</a> today. It showcases the amazing flexibility of the upcoming Twenty Twenty-Two theme and how much more you can do with WordPress without having to change to a different theme. If you want to be part of the team making FSE better for everyone, jump in and <a href=\"https://make.wordpress.org/test/tag/fse-testing-call/\">start testing</a> the new features ahead of the beta release.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Nov 2021 23:20:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WordPress.org blog: A Look at WordPress 5.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11625\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/news/2021/11/a-look-at-wordpress-5-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2465:\"<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>WordPress 5.9 is expected to be a ground-breaking release. It will introduce the next generation of themes with <a href=\"https://make.wordpress.org/core/2021/10/06/introducing-twenty-twenty-two/\">Twenty Twenty-Two</a> joining the fun and over 30 theme blocks to build all parts of your site. <a href=\"https://make.wordpress.org/core/5-9/\">In anticipation of the January 25th release</a>, we hope you enjoy this sneak peek of 5.9.</p>\n\n\n\n<p>New design tools will allow you to create exactly what you want, from adding filters to all your images to fine-tuning the border radius on all your buttons. With WordPress 5.9 providing more design control along with streamlined access to patterns, you can easily change the entire look and feel of your site without switching themes<strong>.</strong></p>\n\n\n\n<p>No matter what you’re editing, whether it&#8217;s crafting a new post or working on a header, improvements to List View make it simple to navigate content regardless of complexity. More improvements and features for everyone are to come in this release and we can&#8217;t wait to see what you create with WordPress 5.9! </p>\n\n\n\n<h2 id=\"stay-tuned\">Stay Tuned</h2>\n\n\n\n<p>Stay tuned for more updates as the date draws near. If you want to help, the best thing you can do is <a href=\"https://make.wordpress.org/core/handbook/testing/beta-testing/\">test everything</a>! For all the details, <a href=\"https://make.wordpress.org/core/2021/11/22/wordpress-5-9-revised-release-schedule/\">check out this Make Core post</a>.</p>\n\n\n\n<p><em>Video props: <a href=\"https://profiles.wordpress.org/annezazu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>annezazu</a> (also co-wrote the post) <a href=\"https://profiles.wordpress.org/michaelpick/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>michaelpick</a> <a href=\"https://profiles.wordpress.org/matveb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>matveb</a> <a href=\"https://profiles.wordpress.org/beafialho/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>beafialho</a> <a href=\"https://profiles.wordpress.org/javiarce/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>javiarce</a> <a href=\"https://profiles.wordpress.org/critterverse/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>critterverse</a> <a href=\"https://profiles.wordpress.org/joen/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joen</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Nov 2021 21:02:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Kelly Hoffman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WPTavern: GoDaddy Data Breach Exposes 1.2 Million Active and Inactive Managed WordPress Hosting Accounts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125998\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:253:\"https://wptavern.com/godaddy-data-breach-exposes-1-2-million-active-and-inactive-managed-wordpress-hosting-accounts?utm_source=rss&utm_medium=rss&utm_campaign=godaddy-data-breach-exposes-1-2-million-active-and-inactive-managed-wordpress-hosting-accounts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3389:\"<p>In a disclosure to the U.S. Securities and Exchange Commission (SEC) that was <a href=\"https://www.sec.gov/Archives/edgar/data/1609711/000160971121000122/gddyblogpostnov222021.htm\">published today</a>, GoDaddy announced a data security breach impacting its WordPress managed hosting customers. The company discovered unauthorized third-party access to its hosting environment on November 17, 2021, through an exploited vulnerability.</p>\n\n\n\n<p>GoDaddy&rsquo;s initial investigations show the attacker gained access using a compromised password beginning on September 6, 2021. Nearly every sensitive data point associated with hosting a WordPress website was compromised, including customer email addresses, admin passwords, sFTP and database credentials, and SSL private keys. GoDaddy published the following summary of data the attacker had access to for more than two months:</p>\n\n\n\n<ul><li>Up to 1.2 million active and inactive Managed WordPress customers had their email address and customer number exposed. The exposure of email addresses presents risk of phishing attacks.</li><li>The original WordPress Admin password that was set at the time of provisioning was exposed. If those credentials were still in use, we reset those passwords.</li><li>For active customers, sFTP and database usernames and passwords were exposed. We reset both passwords.</li><li>For a subset of active customers, the SSL private key was exposed. We are in the process of issuing and installing new certificates for those customers.</li></ul>\n\n\n\n<p>GoDaddy has more than 20 million customers but only the managed WordPress hosting accounts were affected by this breach. Looking further into the incident, <a href=\"https://www.wordfence.com/blog/2021/11/godaddy-breach-plaintext-passwords/\">Wordfence claims that GoDaddy was storing sFTP credentials as plaintext</a>, although GoDaddy has not officially confirmed it:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>GoDaddy stored sFTP passwords in such a way that the plaintext versions of the passwords could be retrieved, rather than storing salted hashes of these passwords, or providing public key authentication, which are both industry best practices.</p><p>We confirmed this by accessing the user interface for GoDaddy Managed Hosting and were able to view our own password&hellip;When using public-key authentication or salted hashes, it is not possible to view your own password like this because the hosting provider simply does not have it.</p></blockquote>\n\n\n\n<p>GoDaddy&rsquo;s stock tumbled after the SEC disclosure got picked up by major news organizations, finishing down&nbsp;5.25%. The company <a href=\"http://previous%20incidents:%20https://twitter.com/lenraleigh/status/1462974068588789769\">emailed its customers</a> to notify them that their accounts may have been compromised during the two months when the attacker had unauthorized access.</p>\n\n\n\n<img />\n\n\n\n<p>The incident has damaged customers&rsquo; trust and puts developers and agencies in an uncomfortable position if they are required to notify their customers about the breach. Impacted site owners will need to watch for malware, suspicious activity, and potential phishing attacks.</p>\n\n\n\n<p>Godaddy says it has already taken steps to further secure its provisioning system and is continuing its investigation with the help of an IT forensics firm and law enforcement.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Nov 2021 04:55:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: How Do Post Formats Fit Into a Block Theme World?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125982\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:161:\"https://wptavern.com/how-do-post-formats-fit-into-a-block-theme-world?utm_source=rss&utm_medium=rss&utm_campaign=how-do-post-formats-fit-into-a-block-theme-world\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5899:\"<p class=\"has-drop-cap\">Over the weekend, Nick Bohle asked Ellen Bauer of Elma Studio <a href=\"https://twitter.com/nickbohle/status/1462231308697018373\">how post formats fit into the block-theming world</a>. The question was a proposal for her a WordPress theme and FSE <a href=\"https://twitter.com/i/spaces/1ZkJzbaDPVgJv/peek\">chat she held yesterday</a> via Twitter Spaces. I could not attend and see if Bauer touched on the subject, but the question is something I have given a lot of thought to not that long ago.</p>\n\n\n\n<p>Over the summer, I <a href=\"https://twitter.com/justintadlock/status/1407208677795373056\">tweeted out a screenshot</a> of an experiment around post formats. A part of me was trying to figure out if we could revive a dying feature, one I continue to use today.</p>\n\n\n\n<img />Aside post format archive.\n\n\n\n<p>I have been using post formats since before they were a thing. &ldquo;Asides&rdquo; were one of the precursors to the feature landing in WordPress. I wrote my first on my personal blog back in 2006. I had borrowed some code that WordPress cofounder Matt Mullenweg had <a href=\"https://ma.tt/2004/05/asides/\">posted two years earlier</a>. It was a concept he had borrowed from others.</p>\n\n\n\n<p>For me, it was a way to give a unique layout to quick posts and links without all the beefiness of a long-form article.</p>\n\n\n\n<p>In 2011, WordPress 3.1 launched with a new taxonomy. Users could choose between nine different formats for their posts, assuming their theme supported one or more of them. The goal was to allow theme authors to design custom layouts around each one.</p>\n\n\n\n<p>For much of the community, it felt like WordPress was chasing Tumblr&rsquo;s post content feature. The allure quickly wore off after it seemed to have hit a standstill beyond its initial release. Besides a few fixes and trivial enhancements under the hood, post formats never amounted to much.</p>\n\n\n\n<p>They have remained a niche feature over the years. A few theme authors still add in support. Some of us old-school bloggers who have been using them in some form or fashion are still hanging on. But, post formats have been dead for a long time.</p>\n\n\n\n<p>Therefore, I decided to try to make them work for block themes.</p>\n\n\n\n<p>One of the most frustrating things I encountered with post formats in this block-based theme project was how powerless I felt over making them work &ldquo;the old way.&rdquo; The dynamic nature of classic theming meant that I could switch post content templates out on pages that listed multiple posts. Query Loop and its inner Post Template block do not allow me to show a different template for a quote or gallery-formatted post, for example.</p>\n\n\n\n<p>This was frustrating because that part of the design process was out of my hands. If I wanted to do something as simple as show an entirely different design for an aside post within a mix of normal posts, I could not do so as the theme designer, at least not without doing some hacky workarounds.</p>\n\n\n\n<p>My &ldquo;light bulb&rdquo; moment was when I realized that it was OK to not have that control. I needed to get outside of the mindset that the design was mine and mine alone. That is viewing creation through a classic theming lens. My approach was wrong. Instead, I had to start thinking about how to hand over these design tools to the user.</p>\n\n\n\n<p>The question became: Can I create something that utilizes that original post format concept while giving users the freedom to do what they want?</p>\n\n\n\n<p>Then, it dawned on me. The following is the response I tweeted to Jeff Chandler, who had <a href=\"https://twitter.com/jeffr0/status/1407211205685661700\">asked if I thought post formats</a> would work as patterns:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>I think of blocks themselves as an evolution of post formats. Video, audio, embeds (basically cool links), quotes, etc. Most of the elements are already there. Patterns just give users an easy way to insert various designs, which could build off those blocks.</p></blockquote>\n\n\n\n<p>Maybe post formats as they currently exist are dead. However, the idea of designing a layout around specific types of posts is very much alive.</p>\n\n\n\n<p>If users want to embed a single video into a post, it is just a matter of copying and pasting a link. To share a quote they found from their favorite author, they merely need to drop it into a Quote block. Other than chat posts (let&rsquo;s just gloss over those entirely), the concept of post formats has simply been replaced with blocks.</p>\n\n\n\n<p>However, theme authors still have a role to play. If all the elements for post formats have been essentially replaced by blocks themselves, that means designers can have a field day building patterns around them.</p>\n\n\n\n<img />Patterns built for post formats.\n\n\n\n<p>That led me to build off my original idea for asides, my favorite post format. Instead of offering a single design, I built three different patterns for users to choose from. End-users could mix and match how they appeared on the front end.</p>\n\n\n\n<p>I also built a custom <code>taxonomy-post_format-aside.html</code> template to showcase them on their archive page. It merely displayed the published date and the post content, which the user controls.</p>\n\n\n\n<p>I went back to the drawing board and built a quote pattern that I liked. Again, it would be up to the user whether they wanted that particular design. They could always go in a different direction.</p>\n\n\n\n<img />Quote block pattern and custom style.\n\n\n\n<p>In some ways, post formats were always limiting. The feature was never fleshed out, and there were only nine allowed formats. At the end of the day, each was merely a term within a taxonomy. There were never any rules about how it all was supposed to work. Maybe that is not such a bad thing. Now, posts can be anything users want them to be.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Nov 2021 23:57:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WordPress.org blog: Join us for State of the Word 2021, in person or online!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11611\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wordpress.org/news/2021/11/join-us-for-state-of-the-word-2021-in-person-or-online/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1704:\"<p>As <a href=\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\">previously announced</a>, State of the Word will be livestreamed from New York City. That means that you can join the fun either online or in person, on <a href=\"https://www.worldtimebuddy.com/?qm=1&lid=5128581,100&h=5128581&date=2021-12-14&sln=17-19&hf=0\">December 14, 2021, between 5 and 7 pm EST</a>!</p>\n\n\n\n<p>To join State of the Word 2021 online, check your Meetup chapter for a local watch party, or simply visit <a href=\"https://wordpress.org/news/\">wordpress.org/news</a>, where the livestream will be embedded.&nbsp;</p>\n\n\n\n<p>If you would like to participate in person in New York City, please request a seat by filling out the registration form by Sunday, November 28. Not all requests will receive a seat due to venue capacity, but everyone who requests one will receive further notification on Tuesday, November 30.&nbsp;</p>\n\n\n\n<p>In person attendees will be asked to show their COVID vaccination card at the venue entrance, and are expected to follow the safety measures in place. Because of these safety measures, there is a maximum of 50 attendees.&nbsp;</p>\n\n\n\n<div class=\"wp-container-61a081661ea97 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://wordcampcentral.survey.fm/request-a-seat-sotw-2021\">Request a seat</a></div>\n</div>\n\n\n\n<p>Whether you participate in person or online, we are so excited to see you on December 14! Don’t forget, State of the Word will be followed by a Question &amp; Answer session. If you have a question for Matt, you can send your question ahead of time to ask-matt@wordcamp.org, or ask during the event in the YouTube chat.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Nov 2021 21:08:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Gutenberg Times: Creating a Poll Block for Gutenberg, Skins Are Back in Style, WordPress 5.9 in 2022 – Weekend Edition 193\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=19604\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"https://gutenbergtimes.com/creating-a-poll-block-for-gutenberg-skins-are-back-in-style-wordpress-5-9-in-2022-weekend-edition-193/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20455:\"<p>Howdy!</p>\n\n\n\n<p>I am back from our trip to Chicago. It is a fun city even when it&#8217;s cold. I took it as a  training run for our Christmas travels to Canada in about four weeks. One afternoon, we walked Michigan Avenue, The Bean and the sculpture and botanical garden in Millennium Park. Another afternoon, we visited the Shedd Aquarium. It is definitely worth a visit should you ever get to Chicago. Their exhibition space is vast and wonderful.  My favorite section was the <a href=\"https://www.instagram.com/p/CWJxgUnAS7j/\">Caribbean Reef </a>with the most colorful corals, algae and fish. The greatest joy was however to spend some quality time with my coworkers at Automattic, Tara King and Ryan Welcher. Turns out we all like beer and scuba diving. </p>\n\n\n\n<p>Now back to Gutenberg News, WordPress release and State of the Word. I had fun catching up on all the good vibe from the community. </p>\n\n\n\n<p>Stay warm, stay calm, be brave and wait for the signs.<sup>1</sup></p>\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n<p class=\"has-small-font-size\"><sup>1</sup> <em>Canadian Cree</em></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Monday, November 22nd, 2021 at 7pm ET / 00:00 UTC </strong> join us for WordPress Meetup organized by the group in Montclair, NJ. I will talk about <a href=\"https://www.meetup.com/WordPress-Montclair-Meetup/events/281915481/\"><strong>What is Full-Site Editing?</strong></a> and answer questions from participants. I am looking forward to seeing friends there and make new ones. </p>\n\n\n\n<a href=\"https://www.meetup.com/WordPress-Montclair-Meetup/events/281915481/\"><img /></a><a href=\"https://www.meetup.com/WordPress-Montclair-Meetup/events/281915481/\"><em>RSVP and get the Zoom Link</em></a>\n\n\n\n\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#the-gutenberg-minute\">The Gutenberg Minute</a></li><li><a href=\"https://gutenbergtimes.com/feed/#gutenberg-team-and-core-wordpress-updates\">Gutenberg Team and Core WordPress updates</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#gutenberg-11-9-and-11-9-1-has-been-released\">Gutenberg 11.9 and 11.9.1 has been released. </a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#theme-builders-and-block-themes\">Theme Builders and Block Themes</a></li><li><a href=\"https://gutenbergtimes.com/feed/#developing-for-gutenberg-and-building-custom-blocks\">Developing for Gutenberg and Building Custom Blocks </a></li><li><a href=\"https://gutenbergtimes.com/feed/#gutenberg-for-site-builders-and-content-creators\">Gutenberg for Site Builders and Content Creators</a></li><li><a href=\"https://gutenbergtimes.com/feed/#wordpress-events\">WordPress Events</a></li></ul></div>\n\n\n\n\n<h2 id=\"the-gutenberg-minute\">The Gutenberg Minute</h2>\n\n\n\n<p>As part of the WP Minute podcast, we record a minute of Gutenberg updates to be added to the show. Here is this week&#8217;s content. </p>\n\n\n\nGutenberg Minute November 2021  for this week&#8217;s <a href=\"https://thewpminute.com/pagedaddy/\">WPMinute </a>episode\n\n\n\n<ul><li><a href=\"https://wordpress.org/themes/tags/full-site-editing/\">WordPress Theme Repository &#8211; List of Block Themes </a></li><li><a href=\"https://github.com/WordPress/gutenberg/pull/36332\">Update theme.json schema to refer to wp.org URL </a></li><li><a href=\"https://github.com/WordPress/gutenberg/pull/34843\">Add API to access global settings, styles and stylesheet </a></li><li><a href=\"https://make.wordpress.org/test/2021/11/08/fse-program-testing-call-11-site-editing-safari/\">Call for Testing: Site Editing Safari</a></li></ul>\n\n\n\n<p>Big Thank You to Matt Medeiros for including the segment every month. </p>\n\n\n\n<p><em>Updates: The Full-Site Editing will come to WordPress 5.9, however not on December 14th. There are now 28 block themes in the WordPress repository. </em></p>\n\n\n\n<h2 id=\"gutenberg-team-and-core-wordpress-updates\">Gutenberg Team and Core WordPress updates</h2>\n\n\n\n<p>The Beta 1 for WordPress 5.9 release has been moved to November 30th, 2021, due to not enough time to fix FSE interface issues for users. This also moves the date for the final release to January 2021. The new proposed schedule has January 25th, 2021 as release date. </p>\n\n\n\n<ul><li><strong>Tonya Mork</strong>, Core Tech Release lead posted <a href=\"https://make.wordpress.org/core/2021/11/17/wordpress-5-9-beta-1-delayed/\">more details on the Make Core blog.</a></li><li><strong>Robert Anderson</strong>, Editor Tech Release lead, posted <a href=\"https://github.com/WordPress/gutenberg/issues/36556\">the list of pending issues and blockers</a>. </li><li><strong>Sarah Gooding</strong> posted <a href=\"https://wptavern.com/wordpress-5-9-delayed-until-january-2022\"><strong>WordPress 5.9 Delayed Until January 2022</strong></a></li></ul>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>If you want to assist in testing Beta and release candidate versions, <strong><a href=\"https://twitter.com/courtneyr_dev\">Courtney Robertson</a></strong>, held a panel discussion  with Core Contributors George Mamadashvili, Andy Fragen and yours truly on the various options to test upcoming versions. The recording is available now <a href=\"https://www.godaddy.com/garage/gutenberg-how-to-test-the-latest-updates/\"><strong>Testing the latest features in WordPress</strong></a> with resources and links. </p>\n\n\n\n<p>After the Beta 1 release, you only need to install the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester plugin</a> and set it to c<em>hannel</em> <strong>Bleeding Edge</strong> and <em>stream </em><strong>Beta/RC Only</strong>. </p>\n\n\n\n<img />Setting <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester Plugin</a> for testing Beta and Release Candidates during the release cycle of an new WordPress version. \n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total\" /></p>\n\n\n\n\n<h3 id=\"gutenberg-11-9-and-11-9-1-has-been-released\">Gutenberg 11.9 and 11.9.1 has been released. </h3>\n\n\n\n<p>Just before the <em>Feature Freeze</em> of the WordPress 5.9 release cycle, Gutenberg 11.9 was released. <a href=\"https://twitter.com/andrewserong\"><strong>Andrew Serong</strong></a> published the release notes in <strong><a href=\"https://make.wordpress.org/core/2021/11/12/whats-new-in-gutenberg-11-9-0-10-november/\">What’s new in Gutenberg 11.9.0 (10 November)</a></strong>.</p>\n\n\n\n<p><strong><a href=\"https://twitter.com/justintadlock\">Justin Tadlock</a></strong> posted the details as well: <a href=\"https://wptavern.com/gutenberg-11-9-focuses-on-navigation-menus-and-block-theming\"><strong>Gutenberg 11.9 Focuses on Navigation Menus and Block Theming</strong></a></p>\n\n\n\n<p>In&nbsp;<strong><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-55-gutenberg-11-9-wordpress-5-9-navigation-block/\">Gutenberg Changelog newest episode (#55)</a></strong>,&nbsp;<strong><a href=\"https://twitter.com/gziolo\">Grzegorz (Greg) Ziolkowski</a> </strong>and I discuss Gutenberg 11.9, WordPress 5.9 and Navigation Block. Surprise guest: <strong><a href=\"https://twitter.com/riadbenguella\">Riad Benguella.</a></strong> Listen in and <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><em><strong>write us a review.</strong></em></a></p>\n\n\n\n\n<p><strong>Subscribe to the&nbsp;<a href=\"https://gutenbergtimes.com/podcast/\">Gutenberg Changelog</a>&nbsp;podcast </strong><br />🎙️&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg?mc_cid=4b6c9f88fe\">Spotify</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\">Google</a>&nbsp;|&nbsp;<a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\">iTunes</a>&nbsp;|&nbsp;<a href=\"https://pca.st/podcast/f8445ec0-7508-0137-f267-1d245fc5f9cf\">PocketCasts</a>&nbsp;|&nbsp;<a href=\"https://www.stitcher.com/show/gutenberg-changelog\">Stitcher</a>&nbsp;|<br />🎙️&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\">Pod Bean</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast\">RSS Feed</a>&nbsp;</p>\n\n\n\n<img />\n\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  </p>\n\n\n\n\n<h2 id=\"theme-builders-and-block-themes\">Theme Builders and Block Themes</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/ellenbauer\">Ellen Bauer</a> </strong>wrote an <strong><a href=\"https://www.elmastudio.de/en/theme-json-for-wordpress-block-themes-explained/\">Introduction to Theme.json</a></strong> and explained how the  configuration choices work together to manage a build a block theme, like Aino and can be used in Classic themes as well. Bauer also invites you to a Twitter Spaces conversation on November 21, 2021 at 2pm to the <strong><a href=\"https://twitter.com/i/spaces/1ZkJzbaDPVgJv?s=20\">WordPress FSE &amp; block theme chat</a></strong></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In his article <a href=\"https://wptavern.com/skins-are-back-in-style-proposal-for-themes-to-bundle-user-selectable-design-variations\"><strong>“Skins” Are Back in Style, Proposal for Themes To Bundle User-Selectable Design Variations</strong></a>, Justin Tadlock commented on a Proof of Concept by Riad Benguella, who explored &#8220;a way for extenders to offer multiple global styles variations and the user would be able to pick up one of the variation for its site.&#8221; (<a href=\"https://github.com/WordPress/gutenberg/pull/35619\"><em>on Github</em></a>). </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/critterverse\">Channing Ritter</a></strong> also experimented and explored the possibility of <a href=\"https://critterverse.blog/2021/11/10/a-global-styles-switcher/\">switching out different style settings within the Global Styles panel</a>. In the comments, Ritter mentioned that a feature like that could make it fairly quickly into the Gutenberg plugin for users to test. </p>\n\n\n\n<h2 id=\"developing-for-gutenberg-and-building-custom-blocks\">Developing for Gutenberg and Building Custom Blocks </h2>\n\n\n\n<p>The latest Decode Podcast episode is titled <strong><a href=\"https://developers.wpengine.com/podcast/9511712\">Gutenberg with Jason Bahl</a>.</strong>  <strong>Kellen Mace</strong> and <strong>Will Johnston</strong>, talked to <strong><a href=\"https://twitter.com/jasonbahl\">Jason Bahl</a></strong>, creator and maintainer of <a href=\"https://www.wpgraphql.com/\">WPGraphQL</a> plugin and ecosystem,  about the benefits of Gutenberg, what&#8217;s lacking in Gutenberg&#8217;s current implementation, and what implementations exist for rendering Gutenberg in headless WordPress.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/mattwatsoncodes\">Matt Watson</a></strong> shared his experience in <a href=\"https://wpowls.co/articles/creating-a-custom-block-for-wp-owls/\"><strong>Creating a Custom Block for WPOwl</strong></a>. The task was a Link block displaying and image a text blurb and a URL. Watson then described his implementation journey and covers these steps: </p>\n\n\n\n<ul><li>Building a Reusable Block, </li><li>Convert it to a Block Pattern</li><li>Why use a Block instead of a Pattern</li><li>Create a Block WordPress Script</li><li>Write the edit.js and save.js functions </li><li>Create Block Styles and Variations. </li></ul>\n\n\n\n<p>The final block is now used on the <a href=\"https://wpowls.co/wpowls-60/\"><em>WPOwls newsletter.</em></a> You can study the <a href=\"https://github.com/wholesomecode/wp-owls-owl-link\">code via the public GitHub repository</a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>Editor <strong><a href=\"https://twitter.com/palmiak_fp\">Maciek Palmowski</a></strong> announced the <a href=\"https://wpowls.co/the-owl-link-challenge/\"><strong>WPOwls Challenge </strong></a>for the WordPress community to build a similar block with different tools. Besides the version built as Block Patterns and Native Custom Blocks (ReactJS) they already have versions built with ACF Blocks, and via Block Builder plugin. There are other tools available, for instance you could us <a href=\"https://wordpress.org/plugins/genesis-custom-blocks/\">Genesis Custom Blocks</a> or <a href=\"https://wordpress.org/plugins/lazy-blocks/\">Lazy Blocks</a> or a <a href=\"https://developer.wordpress.org/block-editor/how-to-guides/block-tutorial/creating-dynamic-blocks/\">Dynamic Block</a>. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/ryanwelcher\">Ryan Welcher</a></strong> live-coded again this week. He walked us through the first part of <a href=\"https://www.youtube.com/watch?v=G6sxo9tpRvA\">Creating a Poll Block for Gutenberg</a> using <a href=\"https://react-google-charts.com/\"><em>React Google Charts</em></a> and the native <em><a href=\"https://developer.wordpress.org/block-editor/getting-started/create-block/\">WordPress Create Block</a></em> script. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/joe_hoyle\">Joe Hoyle</a></strong>, co-founder and CTO of HumanMade, published an experimental library to render custom Gutenberg blocks built in React (front-end) on the server (using PHP V8JS).  Hoyle wrote in the Readme file of the <a href=\"https://github.com/humanmade/block-editor-ssr\"><strong>repository Block Editor SSR</strong></a> &#8220;Building blocks that will render as a React-app on the front end has many possible architectures and solutions. Block Editor SSR expects blocks to be built in a&nbsp;<em>certain</em>&nbsp;way (the way that made most sense to me). Before detailing how Block Editor SSR will server-render and hydrate your custom React block, first let&#8217;s go over how building custom blocks in React (front end) is expected to go.&#8221;</p>\n\n\n\n<h2 id=\"gutenberg-for-site-builders-and-content-creators\">Gutenberg for Site Builders and Content Creators</h2>\n\n\n\n<p><a href=\"https://twitter.com/kathyzant\"><strong>Kathy Zant,</strong></a> new product marketing manager for KadenceWP, <a href=\"https://www.kadencewp.com/blog/introducing-kadence-conversions/\"><strong>introduced the new premium plugin, Kadence Conversation</strong></a>, as a no-code interface to create lightweight and performant popups, modals, slide-ins, and banners for your site. At the time of this post, the plugin is available via Black Friday sale at 40% off. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In his tutorial, <strong><a href=\"https://twitter.com/scruffian\">Ben Dwyer</a></strong> explains how to use the plugin <strong><a href=\"https://themeshaper.com/2021/11/17/create-a-blockbase-child-theme/\">Create A Blockbase Child&nbsp;Theme</a></strong>  and employ the existing tools to modify a Blockbase theme, and then export a bundle of templates and theme.json as a new child theme. <a href=\"https://wptavern.com/automattic-theme-team-releases-a-plugin-to-build-blockbase-child-themes\"><em>Justin Tadlock wrote about it, too.</em></a> </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><em>Block Theme No 28 </em>was added to the WordPress Theme repository. <strong><a href=\"https://twitter.com/justintadlock\">Justin Tadlock</a></strong> took it out for a spin and shared his findings: <a href=\"https://wptavern.com/wowmall-a-free-experimental-woocommerce-block-theme\"><strong>Wowmall: A Free Experimental WooCommerce Block Theme</strong></a>. Tadlock wrote: &#8220;For an eCommerce theme, it is much cleaner than others I have seen, and it leverages almost every piece of the block system. It ships over 30 block patterns.&#8221;</p>\n\n\n\n<h2 id=\"wordpress-events\">WordPress Events</h2>\n\n\n\n<p><strong>November 22, 2021 &#8211; 7pm ET / 22:00 UTC</strong><br /><strong><a href=\"https://www.meetup.com/WordPress-Montclair-Meetup/events/\" rel=\"nofollow\">Meetup Montclair, New Jersey</a></strong><br /><strong>What is Full-Site Editing?</strong> w/ Birgit Pauli-Haack</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>November 23, 2021 &#8211; 10:00 am EST / 15:00 UTC</strong><br /><strong><a href=\"https://www.meetup.com/wordpress-social-learning/events/282149151/\">WordPress Social Learning</a></strong><br /><strong>Discussion: Discovering theme.json for WordPress themes</strong> with Daisy Olson</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>November 27th, 2021</strong><br /><strong><a href=\"https://saopaulo.wordcamp.org/2021/\">WordCamp São Paulo</a></strong></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>December 11 + 12, 2021</strong><br /><a href=\"https://taiwan.wordcamp.org/2021/\"><strong>WordCamp Taiwan</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>December 14th, 2021 &#8211; 5:00 pm ET / 22:00 UTC</strong><br /><strong><a href=\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\">WordPress News</a></strong><br /><strong>State of The Word w/ Matt Mullenweg</strong> + Q &amp; A</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>February 4+5, 2022<br /><a href=\"https://birmingham.wordcamp.org/2022/\">WordCamp Birmingham, AL</a></strong><br />Call for Sponsors and Speakers are open now. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>March 4th, 2022 all day<br /><a href=\"https://www.wordfest.live/2022/march/\">WordFest 2022</a></strong><br />a 24-hour festival of WordPress. <a href=\"https://www.wordfest.live/2022/march/call-for-speakers/\">Call for Speakers is open</a>. Deadline Dec 6th, 2021. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-drop-cap\">On the<a href=\"https://wpcalendar.io/online/\">&nbsp;<strong>Calendar for WordPress Online Events</strong>&nbsp;</a>site, you can browse a list of the upcoming WordPress Events, around the world, including WordCamps,  WooCommerce, Elementor, Divi Builder and Beaver Builder meetups.</p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n\n\n<p><a href=\"https://www.flickr.com/photos/13998657@N02/18526571462\" target=\"_blank\" rel=\"noreferrer noopener\"></a><a href=\"https://www.flickr.com/photos/51035555243@N01/38744499\" target=\"_blank\" rel=\"noreferrer noopener\"></a>Featured image: <a href=\"https://americanart.si.edu/artwork/baby-blocks-112064\">&#8220;Baby Blocks&#8221;&nbsp;by&nbsp;Bessie Ely&nbsp;is licensed under&nbsp;CC0 1.0</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 20 Nov 2021 06:42:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Automattic Theme Team Releases a Plugin To Build Blockbase Child Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125905\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:207:\"https://wptavern.com/automattic-theme-team-releases-a-plugin-to-build-blockbase-child-themes?utm_source=rss&utm_medium=rss&utm_campaign=automattic-theme-team-releases-a-plugin-to-build-blockbase-child-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4388:\"<p class=\"has-drop-cap\">On Wednesday, Ben Dwyer <a href=\"https://themeshaper.com/2021/11/17/create-a-blockbase-child-theme/\">announced a new block-based plugin</a> on the Theme Shaper blog. The Automattic Theme Team had built a <a href=\"https://github.com/Automattic/create-blockbase-theme\">child theme creator</a> for its Blockbase WordPress parent theme.</p>\n\n\n\n<p><a href=\"https://wordpress.org/themes/blockbase/\">Blockbase</a> has quickly started filling the role of Underscores, a starter that many developers used to create custom themes in the classic era. For block templating and global styles, something fresh was needed. It is both a launchpad and educational tool for theme authors who want to test the block theme waters.</p>\n\n\n\n<p>The approach is different now than in the past. Instead of using Blockbase as a customizable starting point, which is still a valid use case, the Automattic Theme Team is leaning far more heavily into child theming. It is a single parent to raise a legion of children, and the family has grown at a rapid pace. Since releasing Blockbase on WordPress.org, the team has already launched five child themes for it. Their <a href=\"https://github.com/Automattic/themes\">themes repo on GitHub</a> shows several others in progress.</p>\n\n\n\n<p>With the talent in the team&rsquo;s arsenal and the Create Blockbase Theme plugin at hand, they could spit out design after design after design. Of course, the child themes might begin to lose some of their flavor if the team moved too fast.</p>\n\n\n\n<p>Dwyer created a custom theme called Typewriter, which is downloadable via the announcement post. For my test, I did not go quite as far with customization and relied on one of the pre-existing color schemes from Blockbase.</p>\n\n\n\n<img />\n\n\n\n<p>I primarily wanted to get a feel for how the tool worked. After a bit of tinkering, I had something that still felt much like its parent with some simple changes.</p>\n\n\n\n<p>To use the plugin, users must install and activate the Blockbase theme. Until WordPress 5.9 is released, the Gutenberg plugin is necessary too. Currently, there are two places to make stylistic changes. The first is in the site editor. I made some adjustments to the header template part and index template. I also changed a few global styles.</p>\n\n\n\n<img />Customizing the index template and global styles.\n\n\n\n<p>The second place to modify the theme&rsquo;s design is via the customizer, which Blockbase enables (it is not accessible by default with block themes). The long-term goal should move all of these extra customizations to the site editor when it handles all the necessary use cases, such as a <a href=\"https://wptavern.com/proposed-web-fonts-api-not-coming-to-wordpress-5-9-possibly-landing-in-gutenberg-first\">web fonts API</a>.</p>\n\n\n\n<p>After switching the color scheme and selecting a couple of custom fonts, I had everything in place.</p>\n\n\n\n<img />Selecting a custom font.\n\n\n\n<p>After I had all the customizations I wanted, I headed over to Appearance &gt; Create Blockbase Theme in the admin. The page has a handful of fields to fill in &mdash; just basic theme info. Once I was finished, clicking the &ldquo;Create Blockbase Theme&rdquo; created a downloadable ZIP file.</p>\n\n\n\n<img />Generating a Blockbase child theme.\n\n\n\n<p>Everything worked. The only issue I ran into was with the theme folder slug when using a multi-word theme name. <code>Tavern Test</code> became <code>tavern_test.zip</code>. It is standard practice to hyphenate theme folders instead of using an underscore to separate multiple words.</p>\n\n\n\n<p>The plugin does add a blank <code>screenshot.png</code> file. Creators will want to change that if they intend to publicly release their custom child theme.</p>\n\n\n\n<p>This is the sort of future I have long imagined for the WordPress theme space, one that can empower anyone to create designs of their own. It is a future where an end-user, even a non-coder, can tinker around for a while, export whatever they have built, and share it with others.</p>\n\n\n\n<p>We are not at that point with WordPress itself. The site editor currently allows users to export their templates. However, I hope that this same functionality is extended to exporting a fully-installable parent or child theme in the future. The basis of democratizing design means that everyone can give it a go without learning to code.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Nov 2021 23:42:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: WordPress 5.9 Delayed Until January 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125857\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"https://wptavern.com/wordpress-5-9-delayed-until-january-2022?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-5-9-delayed-until-january-2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6511:\"<img />photo credit: <a href=\"https://flickr.com/photos/bionicteaching/5948497535/in/photolist-a4DB5k-ddR7m6-2hY62pS-2j1SNKo-2gVgBDF-2iQKbJz-2mpRzg5-o5uNv-2kZXTrc-2kaA4cG-2ipXyyx-2i1FMBL-2hczLX3-2gVikgB-2kHAzjL-2gNm6zQ-4FqcGi-7GRAo8-2gNkmv2-2gNkms1-2m7Fjzj-2hy98BL-2iABt8S-2jcVFsu-R46BYR-atjfJF-cJjJXb-2jNysNx-2kRrhRt-RaqGFB-2hzjuNi-2hxXktV-2hzoRjj-2hy7SMX-2hYCngf-2g5DqMg-2eq7vbd-Fi1aN3-Q9DhTa-2hzp4eS-2hxJzsN-j1RYuM-RNKgg5-2kNMrwW-TAdgqb-rPgJLf-2cw8mMR-2gNm6Dc-2j4c5D2-2hdmx5p\">Tom Woodward</a>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/11/17/wordpress-5-9-beta-1-delayed/\">WordPress 5.9 has been delayed</a> due to significant blockers that could not be resolved in time for Beta 1, which was previously <a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">scheduled</a> to be released November 16. The 5.9 release team came to the decision after a lengthy deliberation on the impact a delay will have on users and contributors. </p>\n\n\n\n<p>Robert Anderson, Editor Tech Lead for 5.9, published <a href=\"https://github.com/WordPress/gutenberg/issues/36556\">a summary of the blockers</a> that were found while testing full-site editing in&nbsp;core&nbsp;this week. They are identified as either blockers for beta 1 or blockers for 5.9.</p>\n\n\n\n<p>&ldquo;Historically (and even in the linked post), &lsquo;<a href=\"https://make.wordpress.org/core/2010/04/20/deadlines-are-not-arbritrary-theyre-a/\">deadlines are not arbitrary</a>&lsquo; has referred to the ability to cut features that aren&rsquo;t quite ready yet, and include them in a future release,&rdquo; Gary Pendergast commented on the post announcing 5.9 beta 1 as delayed. &ldquo;Are there particular reasons for why this philosophy has been re-interpreted?&rdquo;</p>\n\n\n\n<p>Tonya Mork, Core Tech Lead for the 5.9 release, responded with an explanation that FSE is going to have to be a package deal. </p>\n\n\n\n<p>&ldquo;Removing those areas that need fixing were ruled out as they are too intertwined into FSE and would make it unstable,&rdquo; Mork said. &ldquo;Punting fixes was ruled out as these meant delivering a &lsquo;half-baked&rsquo; experience.</p>\n\n\n\n<p>&ldquo;The choice is between shipping these major features in 5.9 with a delay or moving these major features to 6.0 to ship in the spring.</p>\n\n\n\n<p>&ldquo;Impacts were assessed. Shipping these major features sooner than later were determined to be more beneficial with less impact.&rdquo;</p>\n\n\n\n<p>Others commenting on the post shared concerns about the features possibly being rushed after seeing the list of blockers.</p>\n\n\n\n<p>&ldquo;My initial reaction when reading the&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues/36556\">Overview of WP 5.9 pending issues and blockers</a>&nbsp;-issue on&nbsp;Gutenberg&nbsp;repository was &lsquo;holy smokes, there are so many open issues and blockers,\'&rdquo; Timi Wahalahti said.</p>\n\n\n\n<p>&ldquo;Nevertheless, from the viewpoint of a developer working in an agency and having 150+ client sites to look after, I do have similar concerns that Gary and Addison (in the Gutenberg repo issue) have already shared about rushing features out. After seeing the&nbsp;blocker&nbsp;list and reading how new major features are still under works, I&rsquo;d be very uncomfortable on updating to 5.9 after releasing it, knowing that some features were probably finished in a hurry.&rdquo;</p>\n\n\n\n<p>Contributors on GitHub cautioned that the new flows for FSE features have not been adequately tested and should not be shipped just days after landing major changes. </p>\n\n\n\n<p>&ldquo;I think there are some large red flags here that some things are not ready for 5.9,&rdquo; Gutenberg contributor Addison Stavlo said. &ldquo;Overall, it seems like right now we are rushing things in a dangerous way. We targeted 5.9 as the release for these items in core but too many things are just not ready, hence the rushing to change so many things at the last minute. Wouldn&rsquo;t it be better to miss the expected target date than to rush potentially regrettable decisions and brand new flows into core WP at the last minute?&rdquo;</p>\n\n\n\n<p>The new proposed schedule, which has not yet been officially confirmed, is as follows:</p>\n\n\n\n<ul><li>Nov 30 &ndash; Beta 1 (2 weeks from now)</li><li>Dec 7 &ndash; Beta 2</li><li>Dec 14 &ndash; Beta 3</li><li>Dec 21 &ndash; Beta 4 (optional)</li><li>Jan 4 &ndash; RC 1 (5 weeks from Beta)</li><li>Jan 11 &ndash; RC2</li><li>Jan 18 &ndash; RC 3</li><li>Jan 25 &ndash; Release date</li></ul>\n\n\n\n<p>At the time of publishing, all 18 contributors who weighed in on <a href=\"https://wordpress.slack.com/archives/C02JUSF02TT/p1637262875087500\">a poll in the 5.9 release leads slack channel</a> are in favor of the proposed new schedule. More blockers are being resolved and should continue throughout the weekend, but the delay to Beta 1 makes it inevitable that the stable release will be pushed back to January.</p>\n\n\n\n<p>The remaining consideration is whether or not FSE will be on track for inclusion in 5.9 or if it will need to be shipped in 6.0.</p>\n\n\n\n<p>&ldquo;If for some reason progress does not advance on track or something unknown / unexpected happens to cause further delays, then FSE features and TT2 theme are at risk to be punted to 6.0,&rdquo; Mork told the Tavern. The team is working to put safeguards in place to protect the release from further delays.</p>\n\n\n\n<p>&ldquo;FSE is a collection of features with some that are interconnected,&rdquo; WordPress 5.9 Testing Co-Lead Anne McCarthy said. &ldquo;This release includes a selection that are interconnected including Styles, Block theme flows, Navigation Block, etc. In order for them to really shine, it makes the most sense for them to be released together, making it hard to just delay shipping one. They need more time to be refined in order to be shipped&nbsp;<em>together</em>.&rdquo;</p>\n\n\n\n<p>The release team plans to publish an update on Monday with confirmation of the schedule moving forward. McCarthy noted that contributions have been lower this year, which has contributed to the delay.</p>\n\n\n\n<p>&ldquo;We need to recognize the very Human situation we&rsquo;re in right now both in terms of larger cultural moments coming up with various holidays/celebrations and the reality of still being in the midst of a pandemic,&rdquo; McCarthy said. &ldquo;Delaying provides sustainability to get this release right without potentially burning out the remaining contributor base.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Nov 2021 23:07:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: BuddyPress 10.0.0 Beta 1 Delayed, Stable Release Rescheduled for December 24\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125869\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:215:\"https://wptavern.com/buddypress-10-0-0-beta-1-delayed-stable-release-rescheduled-for-december-24?utm_source=rss&utm_medium=rss&utm_campaign=buddypress-10-0-0-beta-1-delayed-stable-release-rescheduled-for-december-24\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2662:\"<p>The upcoming BuddyPress 10.0.0 beta 1 release was scheduled for November 20, but contributors have decided to <a href=\"https://bpdevel.wordpress.com/2021/11/18/bp-dev-chat-summary-november-17-2021/\">postpone the beta</a> by two weeks, due to lack of time for adequately testing recent improvements to the planned features. The stable release has been rescheduled for December 24. This version will <a href=\"https://buddypress.trac.wordpress.org/ticket/8318\">require WordPress &gt;=&nbsp;5.4</a>. </p>\n\n\n\n<p>The delayed beta gives BuddyPress plugin developers more time to update the way they add custom tabs in admin screens, as version 10 will make changes to&nbsp;the layout of the Settings and Tools Administration screens. A short tutorial for <a href=\"https://bpdevel.wordpress.com/2021/11/17/buddypress-admin-tabs-will-look-different-in-10-0-0/\">how to update custom tabs</a> was published in a recent BP dev note.</p>\n\n\n\n<p>Version 10 will add a new <a href=\"https://buddypress.trac.wordpress.org/ticket/8582\">site membership requests</a> feature, which changes the registration process so that a site admin must manually approve requests. Approval sends an email to the user with a link to activate their account. Administrators can turn the feature on by disabling &ldquo;Anyone can register&rdquo; and enabling membership requests. Improvements to site membership requests are still under review and need more testing, which was one factor in the decision to postpone beta 1.</p>\n\n\n\n<p>Contributors are also still working on <a href=\"https://buddypress.trac.wordpress.org/ticket/8581\">extending no content activities with images and call of actions</a>, a feature that needs some refinement to the initial approach.</p>\n\n\n\n<p>Unrelated to the postponed beta schedule, BuddyPress contributors are now discussing a proposal regarding the core BP blocks.</p>\n\n\n\n<p>&ldquo;I was thinking we should probably stop adding blocks to BP Core and instead create standalone blocks into the WordPress plugins directory,&rdquo; BuddyPress core developer Mathieu Viet said during the most recent dev chat. </p>\n\n\n\n<p>One advantage of not packaging them with BuddyPress is that they can be updated independently of core updates, which happen less frequently. One contributor, Varun Dubey, noted that this will increase the number of active plugins on sites and suggested the team consider bundling them in a block collection plugin instead. Anyone with a strong opinion on the matter is encouraged to share it as a comment on the most recent <a href=\"https://bpdevel.wordpress.com/2021/11/18/bp-dev-chat-summary-november-17-2021/\">BP Dev Chat summary post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Nov 2021 05:03:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Post Status: The Open Web Manifesto\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/?post_type=mn_rocks_news&p=89816\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://poststatus.com/news/the-open-web-manifesto/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:693:\"<p>Accessibility, Creatibility, and Connectibility — these are the three things that define the Open Web in its ideal state. It can be accessed by everyone, anyone can freely create on it, and the communities that form there can sustain themselves and grow. WordPress is critical to the Open Web as an indicator of its health, an ecosystem for business growth, and a path for people to contribute to the health, growth, and future of the Open Web. We want to guide, connect, and elevate our members — WordPress businesses and professionals — as they grow. And we want to make sure we share, nurture, and replenish the common resource we have in the Open Web. <strong><br />\n</strong></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Nov 2021 00:44:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jonathan Wold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"WPTavern: Donate to Big Orange Heart, Become a Self-Proclaimed Winner in the WP Builds WordPress Awards 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:259:\"https://wptavern.com/donate-to-big-orange-heart-become-a-self-proclaimed-winner-in-the-wp-builds-wordpress-awards-2021?utm_source=rss&utm_medium=rss&utm_campaign=donate-to-big-orange-heart-become-a-self-proclaimed-winner-in-the-wp-builds-wordpress-awards-2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5730:\"<p class=\"has-drop-cap\">Flipping the usual <del>popularity contests</del> <em>WordPress-related award systems</em> on their heads, Nathan Wrigley has created something where we can all be a winner. What started as a joke to crown his WP Builds podcast as the best quickly took a positive turn that has seen several charitable donations in the past week or so.</p>\n\n\n\n<p>The awards &ldquo;contest&rdquo; is simple. Anyone can donate the minimum amount of $10 to <a href=\"https://www.bigorangeheart.org/\">Big Orange Heart</a> and show their receipt via the submission form.  They can then create a new award category for the <a href=\"https://wpbuilds.com/wp-builds-wordpress-awards-2021/\">WP Builds awards page</a> and claim themselves as the sole winner. There are 27 days remaining to enter.</p>\n\n\n\n<img />Awards page and submission form.\n\n\n\n<p>While I certainly want to be charitable, I saw this as an opportunity to crown myself as the Best WordPress Halo Player in 2021. I have already won, so no one can dispute it.</p>\n\n\n\n<p>In all seriousness, Big Orange Heart is a worthy cause in which to donate, regardless of whether you claim your award. The charity organization focuses on mental and physical health for remote workers. It offers coaching, mentoring, workshops, and other resources to over 14,500 members.</p>\n\n\n\n<p>&ldquo;So I really did not come up with this,&rdquo; said Wrigley. &ldquo;It was an accident. I saw a few posts about a variety of awards polls (both inside WordPress and outside too), and I thought that it would be funny to create an Awards poll of my own. It had only one question, which was &lsquo;Best Podcast called WP Builds&rsquo; and there was only one option to choose from, which was, <em>erm</em>&hellip;WP Builds. I thought that this was enormously funny because somewhat humorless dad jokes are the level that I&rsquo;m on.&rdquo;</p>\n\n\n\n<p>He then <a href=\"https://twitter.com/wpbuilds/status/1458387183283458056\">posted on Twitter</a> and got 30 votes for the joke award poll in which his podcast could be the only winner.</p>\n\n\n\n<p>&ldquo;A day later, I got a <a href=\"https://twitter.com/pootlepress/status/1458431706243997702\">tweet from Jamie Marsland</a> of PootlePress who said (jokingly, I expect) that he&rsquo;d give me &pound;10 if I would add a new question of &lsquo;Best WordPress Tennis Player&rsquo; and him as the only possible winner. Now, I know nothing about tennis (or WordPress, if the truth be known), and so I thought about this for a moment. I imagined all of the things that I would do with Jamie&rsquo;s &pound;10. The new Bond film at the cinema, some new tennis balls, a billionth of a Bitcoin&hellip;Then I remembered Big Orange Heart.&rdquo;</p>\n\n\n\n<p>Thus, a new fundraiser and faux awards contest had been born. Wrigley described Big Orange Heart as a charity that&rsquo;s really close to his heart. He told Marsland <a href=\"https://twitter.com/wpbuilds/status/1458432722955902977\">to donate to the organization</a> to earn his spot. A $25 contribution and a <a href=\"https://twitter.com/pootlepress/status/1458433464559091713\">screenshot of a receipt</a> later, and he had become the unofficial best WordPress tennis player.</p>\n\n\n\n<p>Not to be outdone, Nigel M Rodgers later won the &ldquo;Bestest Best WordPress Tennis Player&rdquo; award. It is all in good fun.</p>\n\n\n\n<p>&ldquo;So this silliness had taken a new turn,&rdquo; said Wrigley. &rdquo; A silly idea had generated $25 for Big Orange Heart. My heart was racing; this could be huge. I went to bed. In the morning, I woke up and sent out a new tweet.&rdquo;</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">If you donate $10 to <a href=\"https://twitter.com/aBigOrangeHeart?ref_src=twsrc%5Etfw\">@aBigOrangeHeart</a> I will make you a 100% certain winner of a category of your choosing in \"The WP Builds WordPress Awards 2021\". It\'s money well spent. You\'ll feel like a winner! <a href=\"https://t.co/L8i8O4Ayog\">https://t.co/L8i8O4Ayog</a></p>&mdash; Nathan Wrigley (@wpbuilds) <a href=\"https://twitter.com/wpbuilds/status/1458433750027718658?ref_src=twsrc%5Etfw\">November 10, 2021</a></blockquote>\n</div>\n\n\n\n<p>&ldquo;I had set a new low for Awards,&rdquo; he said. &ldquo;I will allow you to donate/buy your way into winning whatever category you choose for yourself in exchange for a guarantee that you&rsquo;ll win!&rdquo;</p>\n\n\n\n<p>The WP Builds WordPress Awards 2021 is, without a doubt, unique. Now that we are just ahead of the holidays, it is always a welcome time to donate.</p>\n\n\n\n<p>Michelle Frechette &ldquo;is actually triplets masquerading as one person&rdquo; reads one award. Leanne Mitton is the &ldquo;Best Gnome Collector in the WordPress community.&rdquo; Isaac Coleman is &ldquo;The Most Awesome 13 Year Old in the World&rdquo; &mdash; <em>there could be a proud parent involved in that one</em>. And, there are many others to read through just for laughs.</p>\n\n\n\n<p>Wrigley does not yet know if he will run it in 2022. He is waiting to see how this one turns out. With enough support from the WordPress community, it could be fun to keep up with every year.</p>\n\n\n\n<p>For now, Big Orange Heart is the only accepted charitable organization. However, I asked if Wrigley would be open to others in our space in the future, assuming he keeps it up next year.</p>\n\n\n\n<p>&ldquo;I&rsquo;m sure that there would be ways to allow the person making the donation to choose alternative charities,&rdquo; he said. &ldquo;This seems like a great idea! I&rsquo;m open to suggestions about which charities we could include.&rdquo;</p>\n\n\n\n<p><strong>Note: </strong><em>Nathan Wrigley runs the WP Jukebox podcast for WP Tavern.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Nov 2021 19:12:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Post Status: Post Status Excerpt (No. 33) — The Next Chapter For In-Person WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=89029\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://poststatus.com/excerpt/33/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3940:\"<h2>&#8220;I expect the hallway track to be pretty busy during this event.&#8221; —Nathan Ingram</h2>\n\n\n\n<p class=\"has-drop-cap\">In this episode of Post Status Excerpt, David talks with special guests <strong>Nathan Ingram</strong> and <strong>Ryan Marks</strong> about <strong>WordCamp Birmingham 2022</strong> — one of the first in-person WordCamps after almost two years of no live events anywhere in the world. With 200+ people expected to attend, Nathan and Ryan talk about the safeguards that will be in place, how they are managing expectations, how their sponsorships are being handled, the role of hybrid events, and how WordCamp Birmingham\'s reboot is being received in the WordPress community.</p>\n\n\n\n<p><strong>Also don\'t forget: </strong>We\'re encouraging listeners to check out the &#8220;<a href=\"https://poststatus.com/make-wordpress/\">Week at WordPress.org</a>&#8221; — get the feed <a href=\"https://poststatus.com/make-wordpress/feed/\">here</a> — and <a href=\"https://poststatus.com/submit-2021-black-friday-cyber-monday-deals/\">submit your Black Friday / Cyber Monday deals</a> to us at Post Status for us to share.</p>\n\n\n\n\n\n\n\n<p class=\"has-background\">Every week <strong><a href=\"https://poststatus.com/podcast/the-excerpt/\">Post Status Excerpt</a></strong> will brief you on important WordPress news — in about 15 minutes or less! Learn what\'s new in WordPress in a flash. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/26a1.png\" alt=\"⚡\" class=\"wp-smiley\" /><br /><br />You can listen to <a href=\"https://poststatus.com/podcast/the-excerpt/\">past episodes</a> of <strong>The Excerpt</strong>, <a href=\"https://poststatus.com/category/post-status-podcasts/\">browse all our podcasts</a>, and don’t forget to subscribe on <a href=\"https://open.spotify.com/show/1m3xwXbe0MG5BzFVPtB0A7\">Spotify</a>, Amazon Music, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://castro.fm/podcast/c53552c6-1ee0-4fc4-9de4-08ed6bf1ee4d\">Castro</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://player.fm/series/wordpress-post-status-podcasts\">Player.fm</a>, <a href=\"https://pca.st/05rR\">Pocket Casts</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or by <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h3 id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul><li><a href=\"https://birmingham.wordcamp.org/2022/\">WordCamp Birmingham / WP\'Yall</a></li><li><a href=\"https://twitter.com/dimensionmedia\" target=\"_blank\" rel=\"noreferrer noopener\">David Bisset (Twitter)</a></li><li><a href=\"http://twitter.com/nathaningram\">Nathan Ingram (Twitter)</a></li><li><a href=\"http://twitter.com/cdrmarks\">Ryan Marks (Twitter)</a></li><li><a href=\"https://twitter.com/post_status\" target=\"_blank\" rel=\"noreferrer noopener\">Post Status (Twitter)</a></li></ul>\n\n\n\n<h3><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/sandhills\" target=\"_blank\" rel=\"noreferrer noopener sponsored nofollow\">SpinupWP</a></h3>\n\n\n\n<p>Spin up your own extremely fast WordPress server in minutes with <strong>SpinupWP</strong>. Use any cloud hosting provider you want, and manage your servers remotely with a simple but powerful control panel. Get the security and performance of managed hosting without losing the independence of hosting your projects and your clients yourself.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Nov 2021 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"WPTavern: New Core Web Vitals Technology Report Shows Overall Pass Rate for WordPress Sites Decreases with Newer Versions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125594\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:287:\"https://wptavern.com/new-core-web-vitals-technology-report-shows-overall-pass-rate-for-wordpress-sites-decreases-with-newer-versions?utm_source=rss&utm_medium=rss&utm_campaign=new-core-web-vitals-technology-report-shows-overall-pass-rate-for-wordpress-sites-decreases-with-newer-versions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5696:\"<p>Some new data from a recent <a href=\"https://discuss.httparchive.org/t/new-dashboard-the-core-web-vitals-technology-report/2178\">Core Web Vitals (CWV) technology report</a> produced by the HTTP Archive shows WordPress sites running newer versions have lower CWV pass rates. </p>\n\n\n\n<p>The original report was published in July by Rick Viscomi, one of the maintainers of the HTTP Archive. The site provides a permanent repository of web performance information, giving researchers a common set of data for researching and understanding trends. Contributors&rsquo; efforts are sponsored by Google, Mozilla, New Relic, Etsy, and other companies.</p>\n\n\n\n<p>One of the most notable findings in Viscomi&rsquo;s report showed that just 22% of WordPress-powered origins pass the Core Web Vitals &ldquo;Good&rdquo; threshold.</p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>WordPress core committer Adam Silverstein wanted to dig a little deeper into this data set to see if he could extract more information about WordPress sites&rsquo; CWV performance that wasn&rsquo;t represented in the initial published graphs. He proposed an analysis that would <a href=\"https://discuss.httparchive.org/t/comparing-core-web-vital-performance-across-wordpress-versions/2256\">compare Core Web Vital performance across WordPress versions</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>How have CWV scores changed over WordPress versions? Are there measurable improvements in the wild after recent changes like adding native&nbsp;<a href=\"https://make.wordpress.org/core/2020/07/14/lazy-loading-images-in-5-5/\">image</a>&nbsp;(version 5.5) and&nbsp;<a href=\"https://make.wordpress.org/core/2021/02/19/lazy-loading-iframes-in-5-7/\">iframe</a>&nbsp;(version 5.7) lazy loading and&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/07/wordpress-5-8-adds-webp-support/\">WebP image support</a>&nbsp;(version 5.8)?</p></blockquote>\n\n\n\n<p>Silverstein worked with Viscomi to create a query that would extract performance data grouped by WordPress version. He found that core additions like native image and iframe lazy loading, and WebP image support have had no measurable improvement on CWV scores in the wild. </p>\n\n\n\n<div class=\"wp-block-image\"><img /><a href=\"https://datastudio.google.com/u/0/reporting/ab251873-b787-4a8e-b4c8-efccf4b9a911/page/HUaeC?s=vvFHFeV3n_Q\">WordPress Versions Core Web Vitals report</a></div>\n\n\n\n<p>&ldquo;Lazy loading may be too aggressive as it is applied to all images,&rdquo; Silverstein said, noting that <a href=\"https://web.dev/lcp-lazy-loading/\">lazy loading can be detrimental</a> if over used. This should be remedied soon. Google-sponsored WordPress core committer Felix Arntz opened <a href=\"https://core.trac.wordpress.org/ticket/53675\">a ticket to improve lazy loading</a>, which will be included in WordPress 5.9. </p>\n\n\n\n<p>&ldquo;WebP adoption in WordPress has been growing since the 5.8 release, however users need to manually convert their images to WebP before uploading to take advantage of the format,&rdquo; Silverstein said. &ldquo;Landing WebP as the default format for sub-sized images which was started in&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/52867\">this ticket</a>&nbsp;will have a much bigger impact by automatically converting uploaded images to WebP.&#8203;&#8203;&rdquo;</p>\n\n\n\n<p>A few highlights of Silverstein&rsquo;s observations from the analysis include: </p>\n\n\n\n<ul><li>70% of origins are on the latest version of WordPress and 88% are on one of the last two versions, meaning changes we make to core reach the majority of sites relatively quickly.</li><li>The number of origins is quite low for older versions of WordPress, with fewer than 5k origins for most versions before 4.7</li><li>Overall CWV pass rates have generally decreased over WordPress versions. Although it might also be the case that &ldquo;leading-edge&rdquo; websites that update to the latest version are generally slower than those that linger on older versions.</li></ul>\n\n\n\n<p>Silverstein anticipates this analysis will provide the basis for tracking major improvements in the future. The Google-sponsored WordPress contributors on his team are active in certain core projects and are leading <a href=\"https://wptavern.com/yoast-and-google-sponsored-core-contributors-propose-new-wordpress-performance-team\">WordPress&rsquo; new performance team</a> with the goal of improving core performance as measured by&nbsp;<a href=\"https://web.dev/vitals/\">Google&rsquo;s Core Web Vitals</a>&nbsp;metrics.</p>\n\n\n\n<p>&ldquo;Basically I wanted to create a way to measure the impact of core WordPress improvements on WordPress sites (at scale),&rdquo; Silverstein told the Tavern. &ldquo;My team at Google is focused on helping improve the performance of the web at scale, and WordPress is a huge part of that! You may have noticed us working on features like lazy loaded images and iframes, WebP image support and now helping start the performance group. I wanted to find a way to see if our work is having a measurable impact &ndash; and not just on a vanilla WordPress site you might set up for testing, but in the wild, or real world websites that upgrade to the latest version of WordPress. That is the goal of the dashboard.&rdquo;</p>\n\n\n\n<p>The new <a href=\"https://datastudio.google.com/u/0/reporting/ab251873-b787-4a8e-b4c8-efccf4b9a911/page/HUaeC?s=vvFHFeV3n_Q\">dashboard</a>, which tracks WordPress CWV performance by version, is available to the performance team for monitoring their progress with each new WordPress release. Google-sponsored contributors are using it to measure the impact of their efforts across various performance initiatives.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Nov 2021 03:15:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: Rank Math SEO Launches a Content AI Feature\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125464\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:151:\"https://wptavern.com/rank-math-seo-launches-a-content-ai-feature?utm_source=rss&utm_medium=rss&utm_campaign=rank-math-seo-launches-a-content-ai-feature\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8496:\"<p class=\"has-drop-cap\">Last week, the popular <a href=\"https://wordpress.org/plugins/seo-by-rank-math/\">Rank Math SEO</a> plugin received a major update that includes a new artificial intelligence system. The Content AI feature is a SaaS product that behaves like a personal writing assistant to boost search rankings.</p>\n\n\n\n<p>&ldquo;We built Rank Math&rsquo;s Content AI feature to revolutionize the content production and optimization process with proprietary AI that gives SEOs and content marketers a competitive edge,&rdquo; said Bhanu Ahluwalia, Rank Math&rsquo;s CMO.</p>\n\n\n\n<p>The system allows users to research what their content should look like based on a keyword. Each keyword analysis costs one credit. This data is stored on the user&rsquo;s server, so the same keyword used on multiple posts does not cost extra. Users get five free credits after signing up for a user account with Rank Math. However, they must upgrade to one of the three commercial plans, ranging from $59 to $499 per year, for more.</p>\n\n\n\n<p>Each of the <a href=\"https://rankmath.com/offer/\">commercial plans</a> comes with a specific number of credits. They are marketed as free extras, but they are not &ldquo;free&rdquo; for users who want to upgrade for credits alone. The team says they are working on a pricing solution to address this.</p>\n\n\n\n<p>Users should see a new Content AI module that they can enable from the plugin&rsquo;s Dashboard screen. Turning this on creates a new tab under the plugin&rsquo;s General Settings page for further configuration.</p>\n\n\n\n<img />Content AI general settings.\n\n\n\n<p>The Content AI feature works with the WordPress editor, the classic editor, Elementor, and Divi. However, the team plans to extend this support to other page builders in the future</p>\n\n\n\n<p>Users can then enter a focus keyword from the post-editing screen and click the Content AI button. From there, they can research their chosen keyword, and Rank Math pulls up suggestions from their system.</p>\n\n\n\n<img />Example post with Content AI score.\n\n\n\n<p>The scoring system is easy to understand. Above 80 (in the green) is considered &ldquo;good.&rdquo; Anything below might need some work based on the plugin&rsquo;s recommendations.</p>\n\n\n\n<p>The primary suggestions from the Content AI center on total words, links, headings, and media. When asked how the numbers were figured, Ahluwalia said, &ldquo;This is a computation performed based on the top-ranking content in search engine results pages (i.e., characteristics of content that ranks).&rdquo; It is a proprietary system, so maybe the team is not ready to give away the exact details.</p>\n\n\n\n<p>The feature also lets users copy related keywords to use in their posts, offers questions that the content should answer, and lists potential links to use.</p>\n\n\n\n<p>The following video explains how Content AI works:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<h2 id=\"are-content-scores-a-good-thing\">Are Content Scores a Good Thing?</h2>\n\n\n\n<p class=\"has-drop-cap\">I am admittedly skeptical of any claims from SEO tools. There is value in most of the plugins in the space, and Rank Math is no different. However, I also want end-users to take SEO or content scores with a grain of salt. Hitting a specific word, link, heading, or media count is not going to make or break you. These should be guidelines, not goalposts.</p>\n\n\n\n<p>When asked how the score was calculated, I was pointed to a <a href=\"https://rankmath.com/kb/seo-score-vs-content-ai-score/\">knowledgebase article</a> on the Rank Math website. Nothing in the Content AI section explicitly explains the &ldquo;math&rdquo; behind the score. Essentially, the documentation references how the AI analyzes search results for various factors and describes how the tool works. There is some generally solid advice throughout, but it does not answer how those scores are calculated.</p>\n\n\n\n<p>One particular area of concern was the recommended media count for each post. I had access to a full demo of the feature with a few dozen posts to check. Nearly all that I ran through the Content AI had a recommendation of using 18 media. The number felt off. While I cannot claim to be an SEO guru, I do not see why a typical 1,000 or 2,000-word post should need that many images or videos. Even with web-optimized media, that could bring page-loading speed to a crawl for many site visitors.</p>\n\n\n\n<p>&ldquo;That entirely depends on the focus keyword that you had set for your post,&rdquo; said Ahluwalia on how the recommended count is determined. &ldquo;Page speed is a ranking factor, but the media count and its associated guideline there is a super simple way to quickly see and consider whether that&rsquo;s something that you need to do to rank as well. If we&rsquo;re, for example, looking at the keyword &lsquo;SEO tools,&rsquo; the recommendation is as high as 26, which is unsurprising because the majority of ranking content hasn&rsquo;t just covered essential SEO tools, they&rsquo;ve covered the 15, 20, or even 109 &lsquo;best SEO tools.&rsquo;</p>\n\n\n\n<p>&ldquo;This concern with using media in content as it relates to page speed is surprisingly common, but the reality is that content without design doesn&rsquo;t typically perform particularly well (even if it ends up ranking, then not from a conversion/social sharing perspective because people leave with the impression of encountering a wall of text). A lot of the content on our site wouldn&rsquo;t be the same without the images in the posts to paint the full picture and distill what are complex SEO processes/ideas into something that&rsquo;s super simple for people to understand.&rdquo;</p>\n\n\n\n<p>I generally agree that sites should use media alongside text. Looking over one of the demo posts I had access to, the content did not seem to warrant the recommended count.</p>\n\n\n\n<p>This particular post had 1,199 words and 32 paragraphs. It also had six images, which presumably played a significant role in the 20/100 score. Content AI recommended 18 instances of media.</p>\n\n\n\n<img />\n\n\n\n<p>Had the post met the recommended media count, there would have been one image for at least every two paragraphs. Even with half that number, visitors would unlikely think they are just &ldquo;encountering a wall of text.&rdquo;</p>\n\n\n\n<p>Maybe the analysis is correct. Perhaps it will help sites rank. But, that much media mixed in with text strikes me as a sub-optimal reading experience.</p>\n\n\n\n<p>My primary concern with tools like Content AI &mdash; this applies to SEO plugins in general &mdash; is that site owners are trying to make sure they are <em>in the green</em>. Instead of writing for readers, they are writing to rank. The two things are not mutually exclusive, but when end-users take recommendations as gospel, it can lead to stunted prose.</p>\n\n\n\n<p>&ldquo;We completely agree, and while AI content has come a long way, we&rsquo;re very much also still fans of well-researched content that&rsquo;s put together by humans like you and I (as is all of the content on our own blog),&rdquo; said Ahluwalia. &ldquo;The goal with Rank Math&rsquo;s Content AI is assisted content production and optimization (streamlined by software).</p>\n\n\n\n<p>&ldquo;Broadly speaking, as you say, traffic-light style scores or numerical scores don&rsquo;t paint a full picture for most content. This was a very big motivation for the new content optimization suggestions that go beyond typical scoring (that is the same no matter what you&rsquo;re writing about). When writing something that isn&rsquo;t search-driven at all (i.e. targeting a keyword and search intent that has little demand and no competition with a thought leadership piece, for example) you&rsquo;re not writing for searchers, you&rsquo;re writing for a specific set of people you have in mind. This content is still incredibly valuable though.&rdquo;</p>\n\n\n\n<p>He went on to say that for what the Rank Math team calls &ldquo;search-driven&rdquo; content, there are specific elements that well-ranking competing content has in common.</p>\n\n\n\n<p>&ldquo;It goes without saying that when using content optimization tools the consideration for still writing good content that&rsquo;s helpful has to be there for the end result to be truly exceptional,&rdquo; he said. &ldquo;With the aim here being to aid the creation of content, ensuring it addresses search intent, and meets what search engines deem valuable and useful content.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Nov 2021 01:11:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Gutenberg Times: Gutenberg Changelog #55 – Gutenberg 11.9, WordPress 5.9, Navigation Block\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=19591\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-55-gutenberg-11-9-wordpress-5-9-navigation-block/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:56225:\"<p>Birgit Pauli-Haack, Grzegorz Ziolkowski discuss Gutenberg 11.9, WordPress 5.9 and Navigation Block. Surprise Guest: Riad Benguella</p>\n\n\n\n<ul><li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li><li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li><li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li><li>Production:&nbsp;<a href=\"https://paulisystems.net/wordpress-consulting\">Pauli Systems</a></li></ul>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/changelog-54-gutenberg-11-8#shownotes\">Show Notes </a>/ <a href=\"https://gutenbergtimes.com/podcast/changelog-54-gutenberg-11-8#transcript\">Transcript</a></p>\n\n\n\n<span id=\"more-19591\"></span>\n\n\n\n<p><strong>Subscribe to the&nbsp;<a href=\"https://gutenbergtimes.com/podcast/\">Gutenberg Changelog</a>&nbsp;podcast via your favorite podcast apps!</strong><br />🎙️&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg?mc_cid=4b6c9f88fe\">Spotify</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\">Google</a>&nbsp;|&nbsp;<a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\">iTunes</a>&nbsp;|&nbsp;<a href=\"https://pca.st/podcast/f8445ec0-7508-0137-f267-1d245fc5f9cf\">PocketCasts</a>&nbsp;|&nbsp;<a href=\"https://www.stitcher.com/show/gutenberg-changelog\">Stitcher</a>&nbsp;|<br />🎙️&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\">Pod Bean</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast\">RSS Feed</a>&nbsp;</p>\n\n\n\n<p class=\"has-large-font-size\" id=\"shownotes\"><strong>Show Notes </strong></p>\n\n\n\n<h2 id=\"announcements\">Announcements</h2>\n\n\n\n<p id=\"jerseypress-what-is-full-site-editing\">Nov 22, 2021 7pm EST / 0:00 UTC <br /><a href=\"https://www.meetup.com/WordPress-Montclair-Meetup/events/281915481/\"><strong>JerseyPress: What is Full-Site Editing?</strong></a><br />WordPress Meetup in Montclair, New Jersey </p>\n\n\n\n<p><a href=\"https://wordpress.org/themes/tags/full-site-editing/\">𝗕𝗹𝗼𝗰𝗸 𝗕𝗮𝘀𝗲𝗱 (𝗙𝗦𝗘 𝗰𝗼𝗺𝗽𝗮𝘁𝗶𝗯𝗹𝗲) Theme in the WordPress Directory</a></p>\n\n\n\n<h2 id=\"what-s-released\">What&#8217;s released: </h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2021/11/wordpress-5-8-2-security-and-maintenance-release/\">WordPress 5.8.2</a></p>\n\n\n\n<h3 id=\"gutenberg-11-9\">Gutenberg 11.9</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/11/12/whats-new-in-gutenberg-11-9-0-10-november/\">What’s new in Gutenberg 11.9.0 (10 November)</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/gutenberg-11-9-focuses-on-navigation-menus-and-block-theming\">Gutenberg 11.9 Focuses on Navigation Menus and Block Theming</a></p>\n\n\n\n<p></p>\n\n\n\n<h2 id=\"what-s-in-active-development-or-discussed\">What&#8217;s in active development or discussed</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2021/11/08/fse-program-testing-call-11-site-editing-safari/\">FSE Program Testing Call #11: Site Editing Safari</a></p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-container-61a377cb33118 wp-block-group\"><div class=\"wp-block-group__inner-container\">\n<ul><li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li><li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gziolo\">@gziolo </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li><li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li><li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li></ul>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\">Transcription</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, hello and welcome to our 55th episode of the Gutenberg Changelog podcast, recording on November 15th, 2021. In today&#8217;s episode, we will talk about Gutenberg 11.9, WordPress 5.9 coming up to a WordPress instance near you and then about navigation area block on Full-Site Editing and all the good things that come to WordPress.</p>\n\n\n\n<p>I&#8217;m Birgit Pauli-Haack, curator of the Gutenberg Times and WordPress developer advocate. And today, I have two co-hosts. You all know Grzegorz Ziolkowski, JavaScript developer at Automattic and WordPress core contributor. And our surprise guest today is Riad Benguella, one of the lead developers on Gutenberg and also code wrangler at Automattic. I am delighted you are here with us Riad, thanks for joining us.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Hi, Birgit. Thanks for having me. It&#8217;s an honor for me to join you and Grzegorz on the show, and help spread the Gutenberg love to the community.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, yeah. It&#8217;s good. Yeah. Well, your passion for it is really contagious when I saw you before at WordCamp US and so when we met, it&#8217;s always nice and yeah patiently explaining things to me. So are you both on a team retreat? Where are you right now in the world and how are you doing?</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Hola, qué tal? That means greetings from Spain. So I&#8217;m so happy that Riad joins us today to discuss the latest 11.9 Gutenberg plugin release and the upcoming COR press 5.9 release.</p>\n\n\n\n<p><em>Riad Benguella</em>: Yeah. It&#8217;s so great to be able to meet colleagues again, we are kind of learning to travel again. Right?</p>\n\n\n\n<p>And yeah, I&#8217;m also, so looking forward to be able to join the community in upcoming word camps in-person events. We miss these a lot.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, yeah.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: The one is happening in Seville in December. That&#8217;s going to be fun.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: You&#8217;re going to be there in December in Seville.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: I&#8217;m not it&#8217;s the connection to Seville is bad for me, but I know that some of my colleagues from Spain, which will be there from Automattic.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p>Riad Benguella: Personally I&#8217;m so looking forward to word camp Europe in Porto in June, hopefully.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, me too. Me too. And I&#8217;m so excited. I was excited two years ago when it was supposed to happen and now I&#8217;m even more excited to come to Portugal and to see everybody from Europe again, it&#8217;s going to be such a great event. And I hope that all the people that are still hesitant about vaccinations, that they get their shots, also the booster shots so we can all be together. Because I found that in-person meetings are so much richer than even though an online meeting like this, it&#8217;s good to help out and kind of bridge the gap. But the in-person meeting, even with family, we visited the family for five weeks in August and September. And there was such a relief to finally be together in one room again, and just hang out and go out and eat and just sit and chat. Yeah. But back to here.</p>\n\n\n\n<h3 id=\"announcements-1\"><strong>Announcements</strong></h3>\n\n\n\n<p>So I just wanted to let you know that November 22 is a WordPress meetup in Montclair, New Jersey, which is a virtual meetup and anybody can join. And I will demo the concept of full-site editing. And I will also take questions, AMA style, ask me anything style and it will take place on 7:00 PM eastern 12:00 AM. I was just going to think, is this am or PM because, it&#8217;s 12:00 AM UTC. And if you go to meetup.com, look for WordPress Montclair in New Jersey to sign up for it. Well, of course we will have the link in the show notes but it would be great if you want to learn more about what&#8217;s coming to WordPress 5.9 and Full Site editing to join us there.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: And speaking of that, I would like to thank props to Munir Kamal for reminding us on Twitter about the new tag that is in the WordPress teams directory, which called Full-Site editing. And it allows you to see all the block teams that are already there and it looks that we have 27 teams that are marked with this tag.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>:&nbsp; Yeah. That&#8217;s great that, tweeting that out Munir. I&#8217;m also seeing that&#8217;s also a link that I will share in the show notes, of course, and also in the meeting at Montclair and some of the themes that are in there are actually universal themes. They work for a classic theme or a block theme. So it&#8217;s quite interesting to see how you can switch it over. But don&#8217;t use them on production caveat it&#8217;s still a beta kind of feature.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Yeah, it&#8217;s like in one month, everything could change.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Right. Everything, the whole Internet&#8217;s going to change. But only if you want it. Yeah, we don&#8217;t want to scare anybody to upgrade to 5.9 because it&#8217;s all opt in. And it&#8217;s only when you have a block theme available, the Full-Site Editing is actually available to you.&nbsp;</p>\n\n\n\n<h3 id=\"what-s-released-wordpress-5-8-2-and-gutenberg-11-9\"><strong>What’s Released &#8211; WordPress 5.8.2 and Gutenberg 11.9&nbsp;</strong></h3>\n\n\n\n<p>So what&#8217;s released in last week, we had the WordPress 5.8.2 release, that&#8217;s a maintenance and security fix. And if you haven&#8217;t updated yet, you definitely should do so now. Most WordPress managed hostings automatically update to a point release, but not everybody is comfortable doing that, but update it. And the other release was of course the Gutenberg 11.9 plugin release with 223 PRs, yes I counted them and they made it into the release.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: The largest ever.</p>\n\n\n\n<p><em>Riad Benguella</em>: I also counted the PRs for WordPress 5.9, and it&#8217;s actually 600 feature PRs and like 400 bug fixes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Wow.</p>\n\n\n\n<p><em>Riad Benguella</em>: So it&#8217;s like 1000 PRs that are coming to WordPress 5.9.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Whoa.</p>\n\n\n\n<p><em>Riad Benguella</em>: In a couple of weeks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, that&#8217;s huge. Yeah. So the&#8230;</p>\n\n\n\n<p><em>Riad Benguella</em>: I don&#8217;t know how the community managed to do that, but yeah. It&#8217;s very impressive.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Wow. Yeah. Well, thank you for the data. So 600 features and 400 bug fixes. That&#8217;s a thousand, wow. Yeah and how many contributors, you don&#8217;t know, but we will know in December.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Yeah. That&#8217;s important. Someone will run the script that will calculate everything for us.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: So stay tuned.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Stay tuned. Right. Okay. So what&#8217;s in Gutenberg 11.9.&nbsp;</p>\n\n\n\n<h3 id=\"enhancements\"><strong>Enhancements</strong></h3>\n\n\n\n<p><em>Grzegorz Ziolkowski:</em> So first we start with new blocks, but they are not part of WordPress 5.9&#8217;s release. They are still experimental and they are related to comments block, we already have one that is going to be in 5.9, this which is called post comments and is basically everything you see when you go to the comments section under the post. And this one is something brand new. So we are doing it in a way that is more granular and similar to the way how the query loop block works. So the new blocks are comment replying, comment edit link, comment outer avatar, and the comments query loop. There is also comment templates. So the idea is you can combine everything, decide what you want to display and so on.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Riad Benguella</em>: I was going to mention the navigation block and the work that has been performed during this release, which is an important work that was actually answering some feedback from the user testing that happened on FSE. So users were finding it a bit hard to actually reuse navigation across teams and across templates for FSE teams. So an important work went into the navigation block during this release. So now the blocks are actually saved into their own custom post type. They work like template parts so you should be able to reuse navigation menus more easily across templates, and when you switch teams.</p>\n\n\n\n<p>Also the same features will allow classic themes to migrate more seamlessly into a block theme. So when you switch from a classic theme to a block theme, all your navigation should probably be retained. And yeah, these are some important change that are coming and actually was important before the beta of WordPress 5.9, which is I think coming tomorrow.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Right. Yeah. It needed to be within the feature freeze. So it makes it in 5.9 and bug fixes will come probably with the next plugin release that will be back porting some of the issues.</p>\n\n\n\n<p>Yeah. Thank you for mentioning the navigation block I have, in the last few days before I went to Chicago, tested some of the navigation items, and I&#8217;m glad that some made it in there. One is the single placeholder for the block. Where you can actually select the menu when you already have one or add all the pages or start an empty navigation block. And that is really helpful for users to get it all set up. But I also like, and I don&#8217;t think it&#8217;s in the release note now, but what also helps is that you can add the site title to the navigation or a site logo to the navigation block.</p>\n\n\n\n<p>So it&#8217;s all kind of one unit that is on the header. That definitely spruces up the FSE, as Riad mentioned, FSE means Full-Site Editing and listeners will know, that referred to the Full Site Editing outreach program, that is run by Anne McCarthy. Do we have anything else? Oh, what I also like is the responsive navigation, there is a way to get the hamburger menu out of the box with a little feature there. And you can decide if you want the hamburger menu by default, also for your desktop site or just for the mobile site. And another tool is there that you can have the menu, have a navigation, an orientation horizontal or vertical. So you could if you wanted to put it in a column block on the left hand side, and it kind of goes down the left hand side, like one of the default themes, I think it was 15 that had a navigation block on the left hand side, yeah. All right and then we had these post comments, but it was interesting to hear that will not come into 5.9. Thanks for pointing that out.&nbsp;</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: There, are two things it&#8217;s quite confusing because we had a post comments like plural, a post comment, but also post comment, singular block. So the, the one that has that got deprecated was the more or less what we are trying to replicate now with comment template block. But the old one, it was just very limited. And it worked more like a format you had to provide a comment ID, which was very hard to use for you. You don&#8217;t know the comment ID of your comments. So yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I don&#8217;t even know the post ID. Yeah. Okay.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Otherwise there was enhancement to the post comments blocks that will be included also in Twenty Twenty-Two default theme. And there was some features missing, there was some issues with the marking inside the block, and also in some cases is when the outer of the site decides to close the comments. So we should show proper messaging or you can also on your website decide that after a certain amount of time, you can no longer comment on posts anymore. So these cases are sorted it out and it should work pretty good in those situations.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I also see that the post comment form that&#8217;s now available for block based theme on the post template, I would think. Yeah. Excellent. Excellent.&nbsp;</p>\n\n\n\n<p>Then there were some enhancements for accessibility with announcing the formatting change to screen readers also communicate to the screen reader the post title is a text area and some other smaller fixes or enhancements there, which is in all the little things that kind of make a user experience so much richer.</p>\n\n\n\n<p>On the block editor we have the enable rich previews in the link UI for the site editor. That is something that had been in the block editor for, I think two versions of the plugin and now it also comes to the site editor. That&#8217;s a feature that when you put a link text in a paragraph or in a navigation or wherever you need it and you save it and then come back to it, you come back to update the post or you just kind of continue editing it, and you hover over the link, you get a rich preview with a title, a description as well as if it&#8217;s available, a feature image. So, you know exactly if the link is still working or if you need to update it in your content.</p>\n\n\n\n<p><em>Riad Benguella</em>: Yeah. As we get closer to 5.9 the contributors worked more on parity between site editor and post editor. So they brought these features, the link preview, the save keyboard. Now you can press command S and it triggers the saving. And there were some discussions also about the menu item of site editor and where we place it exactly and where it makes most sense. So for the moment, this decision has been to use editor and move it in their appearance. And it&#8217;s now worked that way across WordPress trunk. And also the Gutenberg plugin.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Now the controversy is that under appearance, we have editor and a theme editor, so that&#8217;s a confusing thing that probably needs to be further discussed among the contributors.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. I hear you there. There is a lot of editing going on. Yeah. And the theme editor it&#8217;s really hazard because it gets you to the files of your PHP theme. And if you change a code and leave a quote out or something like that, you can actually create fatal error messages on your site. And it&#8217;s very hard to get to them to fix it. So I would always suggest to take away the theme editor instead of the site editor, because the site editor is a much safer place to be for someone who is not particularly technical.</p>\n\n\n\n<p><em>Riad Benguella</em>: Makes me wonder if it&#8217;s basically the ancestor of the site editor. In classic themes, you cannot edit the theme directly, you have to edit the code. So you go to the theme editor, or you edit the files manually. So now that you have the site editor, maybe we could consider removing the theme editor&#8217;s UI entirely. I don&#8217;t know if it makes sense anymore to have it there. Maybe some people still would still need it from time to time, but is it something that the user should be exposed then by default? That&#8217;s I think a question that could be discussed.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah I think so. You&#8217;re right.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Could be left somewhere, but probably you need to know what to do and finding in one place or when you know the link. And the other things that maybe the only reason why we should keep that exposed is for the CSS code. Maybe at this time, when not everything is covert with global styles. There are some reasons for people to use that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. It&#8217;s a similar case with the customizer. Yeah. When you have a Full Site Editing theme, a block by theme, the customizer itself, link in the appearance menu disappears, but the customizer is still available through the theme card on the theme screen. So you could still use the customizer if there&#8217;s something in there that a plugin put in there that the theme doesn&#8217;t have a control yet for it. And that could be a similar way to do, okay a Full-Site Editing theme is a block theme, is active. Yeah. Let&#8217;s remove the theme editor for that part and see what happens and just let the functionality be in there, but not have it in the menu. I think that will be valid to have that discussion. Yes. All right.&nbsp;</p>\n\n\n\n<p>Yeah, and then the next one of Full-Site Editing Enhancement is the Search. Control Component that you can have inside the navigation menu. I really like that. It could use a few more controls to adjust the size of it a bit in relation to the other items in the navigation menu. But that is certainly fixable in a later version, but just having it there, it really helpful.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Yeah. This navigation block becomes so powerful, there are so many options. And I really like how it evolves over time also, how it becomes easier to use with every release. It came a really long way from the beginning.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Riad Benguella</em>: And the challenge always with these powerful features is to find the balance between the good user experience, and also continue adding features without deteriorating the simplicity of the block. So, yeah I think we will continue to iterate on these things until we find the right balance there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. I think the other balance is also to strike, what do we want as feature parity to the previous version or the previous way of doing menus? Because there were quite a few extenders who extended the menu controls through plugins and themes and all that. I&#8217;m not sure that they all have been tested and kind of migrated over. I think there&#8217;s still some experience and some learning to be done, but is there a way to do it differently?</p>\n\n\n\n<p>Yeah. Well, and then we have duo tone component there was only one change in the description that the underlying image that is to which the duo tone is applied is not changed. I think that&#8217;s a very important distinction because people always fear that something changes that they don&#8217;t have any control over and there was something else in duo tone.</p>\n\n\n\n<p>Oh yeah. The duo tone now is using transparency as well. So you could have a background and a duo tone and transparency and have the background shine through. So it&#8217;s multiple layers of features that you can put on top of it, and I will share in the show notes, a video that Anne McCarthy did to kind of show you how this all works together. And she has some very neat representation of some of her photos now with the different duo tones there. Yeah, you have to see it to actually appreciate it really and not get confused about things, but I really love it. Duo tone. It&#8217;s almost like gradients and I love gradients. You could do now gradients in duo tone with transparency, background on cover. So yeah, what else can you need?</p>\n\n\n\n<p><em>Riad Benguella</em>: There&#8217;s so many customization control now available on the plugin and the contributors keep adding more and more. And I think it&#8217;s an infinite work. You can open your imagination and just make it happen.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Riad in 10 years we will still talk about gradients and where we can apply it. Yeah, no, absolutely. Yeah.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: And there is now also a change to the tools panel, which is related mostly to the setting sidebar. So the thing that change is the type of section. So in the past, you would have a list of controls displayed at once. Now, you have better control over what&#8217;s displayed by default and you can enable more controls or hide some of them when you stop using them. It&#8217;s very similar to the dimension panel. That&#8217;s already in the plugin for quite a while. And the direction is just to give the same capabilities to all sections. So they work the same way. Yeah.&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: This change also use a, a little bit that you can actually have multiple columns in the theme, in the typography controls, when they&#8217;re just small controls, you get two next to each other, and that certainly saves you some real estate or some spool on up and down on that. And, and I like it. It has a more harmonious layout there. So like that. Yeah.&nbsp;</p>\n\n\n\n<p><em>Riad Benguella</em>: The idea with these tools panels is that we should unify how blocks show their different customization option on the sidebar. So typography uses the tools panel color U could use the tools panel. I think there is another one dimensions could use the tools panel. So that way, no matter the block you are using, you could SU similar things on the, on this side. And if you find it too overwhelming, you could show and hide the controls you want.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s awesome. Yeah. Yeah. It kind of goes a little bit towards what, what we have been discussing on the developer advocacy relations team that can we have some best practices on yeah. If somebody builds a custom block yeah. Best practices on how to distinguish between the side settings and the toolbar settings and all that. I think it&#8217;s, it&#8217;s time to kind of put some of those best practices in writing. So of people can look it up and I will going to work that&#8217;s part of our 2022 kind of plan to figure that out and work with the developers on that. So consistency goes a long way in not having to figure out this for every single block or for every single type of block. How is a car applied cred and applied and all that. Yeah.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: In this case, we are following what Riad did for the block toolbar. So he created groups like for block, for formatting controls and so on. And here we will have also those extension points for dimension colors, typographic easy. You know, it&#8217;s not still setting stone, how it&#8217;ll end up. So we don&#8217;t want to spoil the game and like introduce any hustle to the community. But once everything is ready, then we&#8217;ll definitely come up with some recommendations that we share with the community. Awesome.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So the template editor has as a template part focus mode. Now that means that you can separately change the header or the footer in your site editor. There&#8217;s also a post available on the make blog/core about those editor improvements and the template part focus mode that you now can use to, when you look in the site editor, you have always the full page, but if you just want to isolate the header and just look at that, you can switch over to the template part focus mode.</p>\n\n\n\n<p><em>Riad Benguella</em>: The next thing is, if you are building a theme, whether it&#8217;s classic or block theme and using theme JSON, there is a small change that you could apply to your theme JSON. So for consistency, we removed some custom prefixes from some settings like custom line height, custom margin and custom filing, I think. So you could move to theme JSON version two and remove these prefixes that way you&#8217;re on the last version.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: So to do that, you need in your team, JSON, at a new field called, version. Oh, it&#8217;s not in new field, but you need to set version to number two. And that basically enables this new updated APIs.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I know that there were quite a few efforts around the development team to put actually a schema up on schema store and have also the link via.webpress.org. And are those schema already updated to the version two? Do we know?</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Oh, thank you for reminding about that yet. It&#8217;s done. It&#8217;s ready for both block JSON and theme JSON it&#8217;s now in WordPress domain and the new member, the URL, we will show that later in the show notes. And yes, it&#8217;s already the old one that you could use will still work because the schema in the schema store it has a very interesting configuration. So it&#8217;s now referencing the new URL, so whatever use it will work anyway. And as we found out, someone pointed that out, I don&#8217;t remember but anyway, even if you don&#8217;t provide the dollar schema field, most of the editors will be able to recognize that based on the name of the file and they will show you hints anyway. So you only need probably to do that for visual studio code explicitly.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mm. Yeah. That&#8217;s interesting to know there&#8217;s some learning to be on the editor. So, oh you use it once I know where that was. See here. Yeah, I excellent. Speaking of gradients, now you can show all the colors on the gradient origin in the different panels. So there&#8217;s a new panel when you do site editing and color configuration, and it has the core color palette, the themed color palette. And if a user creates their own color palette, it will show there too.</p>\n\n\n\n<p>It&#8217;s a little bit crowded and I know there&#8217;s also an issue posted to find a way to actually remove the core color palette because it has so many colors and when people use it some team developers or agencies definitely would want to remove that. But it&#8217;s a nicer interface, but it has the text color 1, 2, 3 core theme and user. And then it has the background color in core theme and user colors. And then it has the link colors as well. If it, theme JSON says, please use the link color scheme as well, and then it will go in there as well. And it&#8217;s interesting to see. So I&#8217;m looking forward to the user feedback that we are going to get there to adjust an next iteration now.</p>\n\n\n\n<p><em>Riad Benguella</em>: So one of the original reasons for this feature, why do we introduce these different pallets core theme and user is, if you think about patterns, we have now a directory for patterns and theme could provide patterns and we wanted to have some color in these patterns, right? And so how can we make sure that these patterns work across themes, if teams change their own palette, it becomes harder. So the idea is to allow themes to still rely on core palettes, and pattern to still rely on core palettes. So for example, when you build a palette, you should probably only use core colors that way it works across themes, if you want to publish it to the pattern directory. And yeah, in terms of UI, it&#8217;s kind of crowded right now, especially in the post editor.</p>\n\n\n\n<p>But I think the idea is that it should get closer and closer to how it looks in the global style bar, which is kind of nested navigation. So the idea is that it should look like the global styles view of colors. So you will see at the high level button to go to the link color, another one to go to the button background and another one to go to the text color. And they are not shown every time, all the colors at the same time. So that way it&#8217;s less crowded and it allows you to navigate more efficiently. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I can and see, that&#8217;s a very good reason to have the block parents be consistent, not so much depending on the theme color scheme, but so it shows up as you see it in the preview. And I can also see to just switch off the core colors in the user interface, so the pattern comes over, but the user can only use the theme and their own color to modify it and not have the core colors as well. Because the core colors always show up on other places when it&#8217;s not a pattern from the repository and using those core colors on other things that might not be wanted by the site owner or the theme author. Yeah.</p>\n\n\n\n<p><em>Riad Benguella</em>: Yeah. Theme authors and agencies also want to control these things more strictly. So yeah there is, they is some work in progress to allow actually to remove the core powers entirely. And yeah it&#8217;s going to be sitting in team JSON and you just enable it and it&#8217;s gone.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>:&nbsp; Awesome. It&#8217;s all so well thought through. Excellent.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: And there is now also change for the typographic block support. So because we had this change, we discussed about the block tools feature. So now most of the typography controls were added to the existing text blocks, like heading, paragraph and so on. And there are also some default controls enabled for them. So you just go and check those blocks and see how many new options are there now.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. It&#8217;s a great variety there. Yes, indeed.&nbsp;</p>\n\n\n\n<p><em>Riad Benguella</em>: The next change is another change that is meant to be for WordPress 5.9. So now that global styles are actually the landing in WordPress 5.9, and even the UI, some plugin developers and then some team developers need some API to access these settings and access these styles. If they want to adapt their code. For example, to check whether there&#8217;s a global layout or to retrieve whether I don&#8217;t know, there&#8217;s a color palette or anything, basically any settings in or style in the global style. So a new idea has been introduced, it allows you to retrieve these settings pretty easily in just a function call. You don&#8217;t have to go check directly in the theme JSON file or the user settings or anything, you just get the current value. That&#8217;s pretty handy, another also global style related API that landed pretty recently is actually arrest API to retrieve modified global styles and also the base global styles for the active team. So this could be pretty handy for plug-in and team authors.</p>\n\n\n\n<h3 id=\"apis\"><strong>APIs</strong></h3>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: And regarding the API functions that were introduced, they are called get_global_settings, get global_styles and get global_style sheet. So pretty easy to remember and expect a dev note published in a few weeks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Excellent. Yeah, I think that was the missing piece that we got quite a few questions about in the community. So having that public API available is now so much better. So believe it or not, we&#8217;re still talking about enhancements and new features.&nbsp;</p>\n\n\n\n<h3 id=\"bug-fixes\"><strong>Bug Fixes</strong></h3>\n\n\n\n<p>Now we, I think there were about 80 or so in them, 73 and we didn&#8217;t talk about all of them, but the bug fixes also are 73 bug fixes in this release. And some of them are very granular and in the back end of it. But the one that stood out for me was that for the blocks, it fixes the relative URLs for the inline styles. So if you had a style sheet with a background color or a background image and the URL if it wasn&#8217;t an absolute URL but only relative like ../ it wouldn&#8217;t find that anymore, and that has been fixed. So quite a few developers will say finally!</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: They should still exist in WordPress 5.8. And yeah, this is something we missed because it only happens for the custom blocks and only when you opt in for the option to use those in line styles.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Good. So wasn&#8217;t all that big. Okay. So are there any other bug fixes that you wanted to mention here, Grzegorz or Riad?</p>\n\n\n\n<p><em>Grzegorz Ziolkowski:</em> No, it&#8217;s like bugs you wanted to forget about them. You don&#8217;t want to speak.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, sometimes I find it interesting to, oh yeah that&#8217;s a bug from 2018, we finally fixed it. But I haven&#8217;t seen any of those here. So yeah, do you want to go to the next section and talk about performance Riad?</p>\n\n\n\n<h3 id=\"performance\"><strong>Performance</strong></h3>\n\n\n\n<p><em>Riad Benguella</em>: Let&#8217;s speak about performance actually. Pretty interesting subject and I enjoy working on performance a lot. So on the editor theme, we have this metrics we keep track of over time, the loading time, the typing time and we keep adding new metrics every time. And the interesting one that was worked on during this release was the list view. We added a new metric to measure how the editor performs while the list view is open. And the list view is pretty powerful to navigate the editor, but since it shows a long list of blocks, it can create some performance issues sometimes. So a new technique has been used during this release. It&#8217;s called windowing techniques for the technical folks listening to us. Basically it means the list that is currently visible is rendered, but all the remaining items on the list are actually hidden and not rendered at all. Unless you scroll the list and show them. Historically we&#8217;ve been avoiding this kind of solutions because they could have some accessibility issues and also it is very hard to get right. But thanks to the work of contributors, I think Carrie worked this a lot, we now have a solution that we think works pretty well and doesn&#8217;t introduce any accessibility problems. So now they invite you to test this and if there are any issues, please let us know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So well, thank you. And yes, indeed. The list view is one of the most powerful tools that would come revamped WordPress 5.9, but going back to performance, I know that you all also had this check and we talked about it on the show before, where you had, 30,000 blocks in a post to kind of see the performance of it and measure it from between the different versions. How many blocks do you have in the list view to test this?</p>\n\n\n\n<p><em>Riad Benguella</em>: Oh, we use the exact same post, which I think it&#8217;s a thousand blocks or something like that. It&#8217;s a very long post. You can find it on the Gutenberg repository. You can search for large post @HTML. And it&#8217;s actually executed automatically in the CI. And every time we check the numbers. And on each release post, you can go to the bottom of the post and you see there&#8217;s a table that is there that compares the current release with the previous release and also the current release with the previous WordPress release, so that&#8217;s how we keep track of these things. We also have a separate website, which I think at the moment is not working, but I promise I&#8217;ll fix it very soon where you see the evolution of the different metrics over time for each actual comment. So that way we can pretty easily find the exact comments, the introduced performance regressions.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Yeah, I saw yesterday that was going back in time and checking the performance for WordPress 5.6 and other major releases, and maybe do you have those results? Because I was pretty excited hearing how it changes.</p>\n\n\n\n<p><em>Riad Benguella</em>: Yeah I do have results. I think loading time improved quite a bit from WordPress 5.7 And to WordPress 5.8, and in WordPress 5.9, it improved a little bit as well, 200 milliseconds or 300 milliseconds out of 3.5 seconds. The typing time also improved, by 20% or something from WordPress 5.8 and WordPress 5.9.</p>\n\n\n\n<p>The other metric that improved a lot between these two versions is inserter opening. We did a lot of work there. And now when you opened the inserter, it is actually quite snappy compared to how it was in the previous version. There is also another one, so the only metric that I think we need to work on a little bit more for this release is block selection. We lost 10% time on it, but I think we can improve this one and do better there. And for the inserter it&#8217;s actually quite impressive because at some point in the inserter, we had collapsible panels. So we didn&#8217;t show a lot of things at the same time when you open the inserter and there&#8217;s collapsible panels, it should open quick, right? And now we show everything at once. So there&#8217;s a lot of things, but we still manage to make it fast. So I&#8217;m pretty proud of about it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: That&#8217;s impressive. Yes. Yeah, because now we have the inserter we don&#8217;t only have the core blocks, but we also have the theme blocks in there. And then also block patterns, a tab and then another reusable block tab. Yeah. Your website, Riad, I think you shared the link at one point maybe two or three months ago. And you also did performance testing with plugins. Is that a different project or is that pretty much the same kind of performance?</p>\n\n\n\n<p><em>Riad Benguella</em>: Yeah. So what I did is I was curious to check actually if I enable plugin or not, how it impacts the editor&#8217;s performance. So I actually use the exact same metrics. We have these coded up in the plugin, so I can just run the test, enable the plugin, change the plugin and run the test again, right? And then compare the numbers.</p>\n\n\n\n<p>Actually, I also spend some time with some plugin authors, because in the initial run I had some issues there and I saw some plugins impacted a lot, and I was very happy to see that they were all pretty receptive and we did some work together. And in the end, I will say the major plugins right now are doing good enough. I think that we can always do better, but we are doing good enough. And I actually encourage plugin authors to check the post if they didn&#8217;t see it, because there are their instructions to check their own plugins, to see how their own plugin impacts the editor performance. Because sometimes we get reports that the editor is very slow and I cannot choose the editor or whatever when I type it&#8217;s very slow. And sometimes we cannot do anything about it. So we have to check all the possible reasons that could cause this and plug ins can be a reason. So it&#8217;s important for both plug in authors and users to be aware of it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Wow. That&#8217;s good to know. I think I will come back to you and kind of talk about this, or at least get all the information for the show notes, but also maybe have a block post about it. That&#8217;s a little bit more prominent, because now more and more people are going to use or come on board with adopting Gutenberg and having that resource available is really, really helpful. All right. Well, thank you, Riad, for that little excursion into performance.</p>\n\n\n\n<p><em>Riad Benguella</em>: Thanks I&#8217;m always happy to dive there. It&#8217;s my personal favorite feature or favorite topic.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Aspect, yeah.</p>\n\n\n\n<p><em>Riad Benguella</em>: &#8230;Topic, I would say favorite topic.</p>\n\n\n\n<h3 id=\"documentation\"><strong>Documentation</strong></h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. So now we are at the documentation section of the changelog and there were two things that stood out amongst typo changes and improving landing pages and all that one was the block schema and documentation has changed or not has changed particularly, but it&#8217;s better documented in terms of the block JSON. And that&#8217;s the follows the same process as the theme JSON does. Right. Is that what I&#8217;m saying, Grzegorz?</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Yeah. So the view is a new API option in block, JSON, that will allow authors to provide Java script code. That&#8217;s going to be executed only in the front and only when the block is rendered there, so it&#8217;s pretty handy thing. And the other change is, because we are preparing to WordPress 5.9. So both features are for the upcoming major WordPress release is that there will be possibility to define more than one style sheet. And the reason for that is twofold. First, sometimes there are some styles that block author would like to apply to more than one block. So this is a way to share them through using style handle. And the other reason is that plugging out, they also want to add their own styles in a batch mode. So instead of doing their own magic, they can just use the existing APIs and inject that to all the blocks they want.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I like that instead your own magic, use core magic. Yeah, excellent. Well, thanks for letting us know. So there are some features, of course, the theme JSON documentation has been updated with missing settings and styles that is also in preparation of 5.9 and the version change there.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: I think that there was link added for ways to keep up with Gutenberg and Full-Site Editing. I suspect that the link is to your resources that you keep up to date.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Keeping up with Gutenberg, yeah.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Yes. So that&#8217;s great to see it finally happening because it&#8217;s the best page to look at.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And if you are listening to the show and don&#8217;t know what Grzegorz is talking about, in the handbook on core on the make block on the references, there is a page called Keeping up with Gutenberg and it&#8217;s an index page with all the block posts from the teams that work on Gutenberg in chronological order. So it starts from the newest to the oldest, but it&#8217;s per year. So we started that 2020 in June.</p>\n\n\n\n<p>So the last half of 2020 is in the 2020 page. And this year, November, we are coming up to the end of the year, so we have all the editor meetings, what the theme team does, the design team also, publishers, the tests and the summary of the tests from the FSE program and all the other related posts. I started that because the core make block, within a day or two, you have to scroll to the third or fourth page to find something that was published yesterday. And it was really interesting to do that. So keeping up with Gutenberg index, you can actually Google that now, keeping up with Gutenberg and it comes up first. All right, so is there anything else in the changelog? Oh yeah, we have on the tool sections, we have some FSE backboard and core.</p>\n\n\n\n<h3 id=\"tools\"><strong>Tools</strong></h3>\n\n\n\n<p><em>Riad Benguella</em>: Yeah. That another kind of magic. Basically on each WordPress release, we need to backboard all the changes that are on the Gutenberg plugin and include them into core. Maybe a lot of people don&#8217;t know that&#8217;s a lot of work and that&#8217;s a lot of invisible work. We do that in two separate ways. Basically the JavaScript changes are more automatic. So we do a package NP and package release, and then we include them in core, but we also need to check all the PHP changes that happened in the work Gutenberg plugin and move them into core. And sometimes when we do that, some problems happen. For example, a function that exists in the Gutenberg plugin can exist at the same time on core. So at, on this small period of time, we need to make some adaptation, both code based, to ensure they work together. So a lot of changes on this Gutenberg release are related to that. Yeah I want to send kudos to Robert, the editor tech lead for this release. He did an awesome job to make sure everyone is on the same page and works to make sure all the changes are on WordPress trunk at the right moment.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Excellent. Yeah. All right. So I think unless…</p>\n\n\n\n<h3 id=\"code-quality\"><strong>Code Quality</strong></h3>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Something, yeah. I have something in the code quality section, it has 25 items. So that&#8217;s great that we still remember about that aspect of work in the lights of the upcoming release and all the work caused by that. So there is new API endpoint it looks like is going to be included in the WordPress core, is it right? So this one is called the WP block V1 URL/details. This one is for the link previews. So this one is getting stable, also plugin authors will be able use to do whatever they need with that.</p>\n\n\n\n<p><em>Riad Benguella</em>: Indeed, that could be useful to show previews or get more information about URLs and exploit that in very different ways for plugin authors.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. That feature is such a small feature when you think about it, but it has so much power that it could definitely be explored quite a bit for plugin authors and even do a list of all this week&#8217;s links and then collect them all, might be a good use case.&nbsp;</p>\n\n\n\n<h3 id=\"what-s-in-active-development-or-discussed-1\"><strong>What’s in Active Development or Discussed</strong></h3>\n\n\n\n<p>All right yeah, so that&#8217;s pretty much it with our Gutenberg changelog this week. Thank you Riad and Grzegorz who get us through it. I think I have only one thing&#8230; So where is WordPress 5.9 now headed? What are the next steps?</p>\n\n\n\n<p><em>Riad Benguella</em>: I think as we mentioned to tomorrow is November 16. So it&#8217;s the release of WordPress 5.9 beta 1. I think that&#8217;s the best time for people to test. So I&#8217;m asking everyone just code, download WordPress 5.9. It is the start of a new with Full Site Editing and block teams and all global styles and all navigation on all these features. So go grab your coffee and start a block team and just try things and try to break it and just tell us what goes wrong. And we have a number of weeks to fix all the bug fixes, and we&#8217;re looking forward to your feedback on that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Excellent. Yeah. I just also want to point out there is a WordPress beta test plugin in the repository, so you don&#8217;t have to install all that. So you just make it a normal WordPress install and then install the plugin for WordPress beta tester plugin, and the stream would be the point release instead of the daily trunk. But if you are brave, you could also do the daily trunk. There are core committers who actually have run trunk on their personal blogs. They&#8217;re quite brave in doing that. So yeah, beta 1 is tomorrow, November 16th, and then a week later, supposedly beta 2, the first release candidate is scheduled. And of course, that all depends on what the test was bringing all back to us or to the team.</p>\n\n\n\n<p>Release candidate, we know sometimes there&#8217;s beta 3 and beta 4, depending on how that all works, but then there&#8217;s a release candidate. One is scheduled for November 30th, and that&#8217;s also the date where the field guide with the dev notes come out and where the about page is done, and also the release post is draft and there&#8217;s a hard string freeze, means there is no bug fixing anymore. And there&#8217;s not a whole lot that can go in there in a release candidate after release candidate is available. And then there will be a dry run for the releasing workers, 5.9 in the 24 hour code freeze December 13th. But if you want to be part of the release party, that&#8217;s going to happen December 14th in the slack channel of core.</p>\n\n\n\n<p><em>Riad Benguella</em>: And it&#8217;s something else I wanted to mention about WordPress 5.9 Is the dev notes. So after beta one, you can expect a list of dev notes on the make core and if you are a plugin author or an agency or WordPress developer app, update your code accordingly, if there are changes and also use the new APIs.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Wonderful, thank you for a reminder of that.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: You can also subscribe to the Gutenberg changelog newsletter and get the list with all the links directly from Birgit.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Thank you for making a pitch on the Gutenberg Times again. That&#8217;s awesome. And if you need instructions on how to test Full-Site Editing, so Anne McCarthy published a test call for the Full-Site Editing outreach program. That&#8217;s for the non-techy people who are using site builder or page builders to build sites for others. And it&#8217;s called the site editing safari, and you get different scenarios that you can follow along with instructions on how to test this because&#8230;</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Also with zebras, giraffes and elephants.</p>\n\n\n\n<p><em>Riad Benguella</em>: What about Chrome and Firefox? Is this just a safari?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Good point? No, safari is like the African safari with the giraffes and the rhinos and everything. So one scenario is personalize your homepage and setting your styles. Add some button patterns and use some of the layout controls for that, one set of instructions also is how to add a dual filter and the single post template. Those test instructions are actually also quite nicely to use for exploring the new interface on a more scripted schedule. So you don&#8217;t have to come up with ideas on how to test it. So you just use those and it really helps if you would comment on that post on the test block by November 30th. And then what normally happens is after a week or so, the feedback comes in and then Anne writes a summary for the developers working on it so they can see what else then to be changed, or she also puts issues together for the GitHub repository of a box coming out.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: I also want to mention one more thing. So the release date, December 14, it reminded me that it&#8217;s also the day when the state of the word 2021 will be by the WordPress projects co-founder Matt Mullenweg.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Excellent. Yes, yes. And that is scheduled for, I think it&#8217;s noon Eastern, which is dinner time in central Europe.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Yeah. So it&#8217;s 10:00 AM between 10:00 AM and 2:12 PM Eastern time and 5:00 PM UTC, which means at my place, it would be 6:00 PM Central European Time.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Excellent. I&#8217;m glad we got it all in. Yes. And so on the webpress.org/news, there is actually a call for of questions because the state of the word is normally about 45 minutes when Matt Mullenweg walks us through the last year and what&#8217;s coming up in the next year and then the next 30 minutes or so will be answering questions from the community. And there is some instructions on the webpress.org/newspost instructions, you can send them via a video and how to get them to the people who help prepare for the state of the word.</p>\n\n\n\n<p>All right, with that, that&#8217;s a very good time to end it. If you like our shows, help us spreading the word by adding a review to your favorite podcast directory. If you have news or suggestions or questions sent them to <a href=\"mailto:changelog@Gutenbergtimes.com\">changelog@Gutenbergtimes.com</a> via email <a href=\"mailto:changelog@Gutenbergtimes.com\">changelog@Gutenbergtimes.com</a> and you can always also reach us via Twitter. So my Twitter handle is at B-P-H. Grzegorz is G-Z-I-O-L-O. And then Riad&#8217;s Twitter handle is Riad Benguella. And we will of course share that all in the show notes. So it was wonderful to have you both here. Thank you, Riad for joining us. How do you feel about it?</p>\n\n\n\n<p><em>Riad Benguella</em>: Thank you. I really enjoyed the show and thank you for having me and please do continue to spread the Gutenberg word.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right. Will do. Will Do.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: That was fun. Yeah, to have fun to have Riad on the shows like.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Grzegorz Ziolkowski</em>: Probably that was the best I show ever. We had so much fun together.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, we did. All right. Okay. Well, let&#8217;s just get out of here for more fun. Thank you all for listening. Thank you for joining us. And I say goodbye until the next time.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Nov 2021 13:47:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"HeroPress: Finding My Global Family – Samun iyali na duniya\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=4265\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"https://heropress.com/essays/finding-my-global-family/#utm_source=rss&utm_medium=rss&utm_campaign=finding-my-global-family\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:17563:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2021/11/111621-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I get to make an impact for good.\" /><p><a href=\"https://heropress.com/feed/#hausa\">Wannan makala akwai shi a cikin harshen Hausa.</a></p>\n<h2>Introduction</h2>\n<p>As I sit down typing this, I’m wondering what the heck do I write about (am I allowed to say that?)!</p>\n<p>Topher says I can.</p>\n<p>So back in May this year, I got a DM from this guy called Topher.</p>\n<blockquote><p>Hello there! Could I convince you to do a HeroPress essay?</p></blockquote>\n<p>It is now October and I&#8217;m finally writing this essay. Thank you for being so patient with me and giving me a topic to write about.</p>\n<h2>How I got into the WordPress</h2>\n<p>It&#8217;s 2017 and I&#8217;m bored with work. I&#8217;d been working in project management for over 15 years and I was no longer excited about the projects I was working on. My repeat clients could tell this, I did not challenge them on certain processes. Some might say I&#8217;d become wiser in picking my battles, but I just no longer wanted to invest my energy. When that happens, you know you need to do something. You don&#8217;t want your action, or in my case inaction, to be to the detriment of the client. I knew I still loved working with and in tech but I needed to do something different.</p>\n<p>On 29 December 2017, I enrolled on a course covering web development. After covering HTML, CSS, and a bit of JavaScript, I decided to try one of the course options: WordPress. My course instructor encouraged me to go to a WordCamp. She found one was scheduled for the following weekend in Brighton. So I booked my ticket and found an Airbnb. Worst case scenario I get to spend some time on the beach (even if it was a bit chilly). But I couldn&#8217;t go to a WordCamp with no knowledge of WordPress &#8211; I thought I&#8217;d look like an idiot. So I spent that week going through the introductory course, now I was ready. Don&#8217;t ask me how much I managed to take in, just know that at least I now knew what WordPress was.</p>\n<p>I attended my first WordCamp, a 2-hour drive, in October 2018. WordCamp Brighton (WCBTN) will always hold a special place in my heart. All the people I met (sponsors, attendees, organising team, and volunteers) were amazing. I walked in there all by my lonesome and they were friendly, took time to talk to me, explain things, and Jenny Wong encouraged me to join my local Meetup. I&#8217;m not sure if it&#8217;s being in a room with like-minded people or being able to geek out (or not for some) on tech but I was excited and had a lot of fun. When I got back to London, I joined my local (well what I like to call London local) Meetup.</p>\n<p>At the time that I joined, the team was starting to look for organisers for WordCamp London (WCLDN) 2019. I&#8217;m very much a believer in learning by doing and project management involves a lot of organisation. I spoke to Gary Jones told him I was a newbie and offered to help. I was in charge of Sponsors, eek! How the hell do I do that? Don&#8217;t be afraid to ask a lot of questions. We were a fairly new team so big thanks to Dan Maby and Barbara Saul for being patient with us and our endless questions. Big thanks to the outgoing team who were available to offer advice when asked. I learnt a lot about the community whilst working on the WCLDN and I had a great time doing it.</p>\n<p>Abha Thakor encouraged me to volunteer for WordCamp Europe (WCEU) 2019 and once again it was an amazing experience. I got to visit Berlin, contribute to the Marketing team desk and met even more people. I also got to rock my big yellow exclamation mark fluorescent earrings that scream the 80s at an 80s after party. It was during WCEU Contributor day that I was introduced to Jesse Owens and the Training team. When you contribute, you get to learn more about all the different teams that make up WordPress the project and WordPress itself. It&#8217;s a great way to learn and I would encourage you to join one of the<a href=\"https://make.wordpress.org/\"> Make teams</a> (you don&#8217;t need to be a developer) there are teams like Training, Accessibility, Documentation, Marketing, and Polyglots. If you want to test the waters before joining, find a virtual Contributor day (some companies are running them) or join one at a WordCamp when we are able to meet in person. I joined the Marketing and Training team at WCEU and I&#8217;m still there today.</p>\n<p>In November 2019 Josepha Haden Chomphosy sent out a call for an all-women release squad. I wanted to know more about accessibility so I was assigned to be the 5.8 Accessibility team cohort. The support our release squad got was amazing. The beauty of the WordPress community is that though we are all at different levels on our journey, someone is always quick to help you navigate that journey. Thank you to everyone who takes the time to make us feel welcome, explain things, are patient with us, and offer cake and chocolate when we need it. I’m still part of the Accessibility team and I’m still learning, it’s a big topic. We are a small team so if you’re an expert in that area and have time to spare, you want to teach others or want to learn, I encourage you to come and join us.</p>\n<p>Summer of 2020 was the soft launch of <a href=\"http://learn.wordpress.org\">Learn.WordPress.org</a>. Shortly afterwards, Courtney Robertson asked for help in preparing for the official launch of Learn. Learn WordPress is a learning resource for anyone who wants to learn how to use, build for and contribute to WordPress. It is an open-source platform that offers a range of materials and opportunities for you to use at your own pace and at a time that works for you. Once again, I put my hand up. Do you see a pattern here? When people have ideas that are of great value to those around them, I can’t help but say yes. Someone always has a great idea and I would love to say yes to everyone but I don’t know how to clone myself yet. Mind you, Michelle Frechette tells me cloning isn’t what I think it is, I need to do more research.</p>\n<h2>The life it now gives me and why I stay</h2>\n<p>Since discovering WordPress, I’ve been a part of a lot of different projects within Make and in the community.</p>\n<p>I am one of the Training Team Reps. I get to work with folks that I like and be involved in shaping Learn. As Courtney Robertson, my good friend and fellow Training Team Rep, puts it:</p>\n<blockquote><p>We want to democratise Learning and make Learn WordPress the primary open-source resource for anyone who wants to get started or level up their skills in WordPress.</p></blockquote>\n<p>I am proud to be involved in a project that is a cross-team initiative, props to marketing, community, meta, polyglots, accessibility, design, training, and<a href=\"http://wordpress.tv\"> WordPress.tv</a> who help shape Learn. Individuals can learn alongside other community members, connecting with the global network of WordPress users, developers and contributors. Check out<a href=\"https://make.wordpress.org/training/2021/08/08/who-can-learn-help/\"> this post on who learn can help</a>, by Courtney Robertson. If you&#8217;re a training provider, business owner, or hiring manager, have a look at<a href=\"https://make.wordpress.org/training/2021/05/03/high-level-roadmap-to-learning-wordpress-development/\"> our high-level roadmap to learning WordPress development</a>. Join us in:</p>\n<ul>\n<li>Educating about WordPress</li>\n<li>Appreciating the power of WordPress and how it is made</li>\n<li>Celebrating everything that people are doing with WordPress</li>\n</ul>\n<p>Come take a seat at the table.</p>\n<p>I am a volunteer and Board member at the charity <a href=\"https://www.bigorangeheart.org/\">Big Orange Heart (BOH)</a>. I get to be a part of<a href=\"https://www.wordfest.live/\"> WordFest</a>, a unique 24-hour global online event that is a celebration of WordPress. BOH’s mission:</p>\n<blockquote><p>To support and promote positive well-being and mental health within remote working communities.</p></blockquote>\n<p>I get to talk to people from all walks of life, support and help build a community that cares for each other. I get to make an impact for good. If we don&#8217;t look out for each other, who will?</p>\n<p>I get to enjoy having a global family, learning, meeting new people, developing lifelong friendships and connections, and the extra bonus is that it doesn&#8217;t feel like work. I get to stay in the background churning the wheels and come out when needed. I get to have fun doing it!</p>\n<p>Photo by <a href=\"https://www.flickr.com/photos/globallandscapesforum/43847733385\" target=\"_blank\" rel=\"noopener\">Hamza Shaibu</a></p>\n<h1 id=\"hausa\">Samun iyali na duniya</h1>\n<h2>Gabatarwa</h2>\n<p>A yayin da nake zaune ina wannan rubutun, ina nazari akan wai shin akan wani batu zan ma yi rubutun (amma yarda in fadi hakan ma tukuna?)</p>\n<p>Topher yace zan iya fadin hakan.</p>\n<p>Toh akwanakin baya a watan Mayu na wannan shekarar, na samu wata sako daga wurin wani dan taliki da ake kira Topher.</p>\n<blockquote><p>&#8220;Barka kadai! Zan iya jan ra&#8217;ayin ka ka yi rubutu akan HeroPress, wato rubuce-rubuce akan mutane da suka yi rawar gani a fannin wallafa labarai ta hanyar yanar gizo-gizo?”</p></blockquote>\n<p>Yanzu dai muna watar Oktoba kuma har na kai ga yin wannan rubutu. Ina gode maka saboda hakuri da kayi da ni da kuma bani batu da zanyi rubutu akai.</p>\n<h2>Yadda na samu kaina a cikin WordPress</h2>\n<p>Ana shekarar alib dubu biyu da goma sha bakwai, 2017 kuma ba na marmarin aiki. A wannan lokacin na riga na samu shekaru goma-sha-biyar ina aiki a fannin project management. Ko masu kasuwanchi da ne sun ga chanji a hali na. Wasu za su ce na zama mai hikima kuma na kara wayo a hali. Idan abubuwa haka suka fara faruwa a rayuwar ka, toh dole ka tashi sa’ye kayi wani abu a kai kafin ya kashe ma kasuwa. Ba ni da damuwa wajen yin aiki am’ma ina so in yi wani abu daban.</p>\n<p>A ranan ashirin da tara a watan Disamba ta shekaran alib dubu biyu da goma sha bakwai na fara wata sabuwar ilimi na web development. Bayan na kalmala Shashi na HTML, CSS da JavaScript, da na za’bi in gwada daya daga chikin shashin ilimin wato WordPress. Malami na ya bani shawara in shiga WordCamp. Ta sami labari akwai daya da za’a yi a sati mai zuwa a Brighton. Sai na siya tikati nawa kuma na biya wajen kwana. Saboda kada in ba kaina kunya, sai na shiga binciken da karatu a kan ma’anar Kalmar WordPress. A wannan lokachi ina iya bogun kirji na cewa a shirye na ke.</p>\n<p>Na shiga shashin WordPress na farko a watan Oktoba na alin dubu biyu da goma sha takwas, na yi tukin mota zuwa kusan awa biyu. WordPress a Brighton (WCBTN) za ta dade a chikin zuchiya ta da abobin ban sha’awa. Duk mutanen da na sadu da su (abokan fatan alheri, dalubai da masu bada umarni) sun bani farin chiki. Na shiga gurin ni kadai amma na hadu da jamma’a da suka yi mun maraba da zuwa, suka yi mun magana, suka bayyana mun abubuwa daban daban sannan wata mata Jenny Wong ta bani shawara in shiga wata kungiyar unguwa na haduwa. Da na koma London sai na shiga kungiyar da tafi kusa da ni.</p>\n<p>A lokachin da na shiga kungiyar, suna neman wakilai da zasu taimaka wajen tsara WordCamp London (WCLDN) 2019. Ni na yadda da kara samin ilimi ta wajen hanyar yin project management, domin tana bukatan tsari sosai wajen ambata komai. Na yi magana da wani mutum da ake kira Gary Jones na bayyana mishi cewa ni sabowar zuwa ce kuma ina so in taimaka. Sai na tambayi kaina da yaya zan iya kalmala wannan aikin? Ta wajen tambayoyi. Mun kasance sabuwar ƙungiya mai girma don haka godiya ga Dan Maby da Barbara Saul don haƙuri tare da mu da tambayoyin mu marasa iyaka. Babban godiya ga tawagar masu fita da suka samu ba da shawara idan aka tambaye shi. Na koyi abubuwa da yawa game da al&#8217;umma yayin aiki akan WCLDN kuma na yi farin ciki da yin shi.</p>\n<p>Abha Thakor ya ƙarfafa ni in yi aikin sa kai don WordCamp Europe (WCEU) 2019 kuma sau ɗaya sake abu ne mai ban mamaki. Na ziyarci Berlin, na ba da gudummawa ga ƙungiyar Talla tebur kuma sun sadu da ƙarin mutane. Na kuma yi jijjiga babban alamar motsin raina &#8216;yan kunne masu kyalli waɗanda ke kururuwa na 80s a cikin 80s bayan biki. Ya kasance a lokacin WCEU ranar mai ba da gudummawa da aka gabatar da ni ga Jesse Owens da ƙungiyar horo. Lokacin da kuke ba da gudummawa, kuna samun ƙarin koyo game da duk ƙungiyoyi daban-daban waɗanda suka haɗa WordPress ɗin aikin da WordPress kanta. Hanya ce mai kyau don koyo kuma zan ƙarfafa ku ku shiga ɗaya na <a href=\"https://make.wordpress.org/\">Ƙungiyoyin Yi</a> (ba kwa buƙatar zama mai haɓakawa) akwai ƙungiyoyi kamar Horarwa, Samun dama, Takaddun bayanai, Talla, da Polyglots. Idan kuna son gwada ruwa a baya shiga, nemo ranar mai ba da gudummawa ta kama-da-wane (wasu kamfanoni suna gudanar da su) ko shiga ɗaya a a WordCamp lokacin da muka sami damar saduwa da mutum. Na shiga kungiyar Tallace-tallace da Horarwa a WCEU kuma ina nan har yau.</p>\n<p>A watan Nuwamba 2019 Josepha Haden Chomphosy ya aika kiran a saki mata duka tawagar. Ina son ƙarin sani game da samun dama don haka aka sanya ni zama 5.8 Ƙungiyar haɗin kai. Taimakon da tawagarmu ta saki ya kasance mai ban mamaki. Kyawun al&#8217;ummar WordPress shine duk da cewa duk muna a matakai daban-daban akan tafiyarmu, wani yana gaggawar taimaka muku wajen tafiyar da wannan tafiya. Godiya ga duk wanda yana ɗaukar lokaci don sa mu ji maraba, bayyana abubuwa, haƙuri da mu, da ba da kek da cakulan lokacin da muke bukata. Har yanzu ina cikin tawagar Accessibility kuma har yanzu ina koyo, babban batu ne. Mu ƙananan ƙungiya ne don haka idan kun kasance gwani a wannan yanki kuma kuna da lokaci don spare, kana so ka koya wa wasu ko kuma kana son koyo, ina ƙarfafa ka ka zo mu shiga.</p>\n<p>Lokacin bazara na 2020 shine ƙaddamar da laushi na <a href=\"https://learn.wordpress.org/\">Learn.WordPress.org</a>. Jim kadan bayan haka, Courtney Robertson ya nemi taimako a shirya don ƙaddamar da Koyi a hukumance. Koyi WordPress hanya ce ta koyo ga duk wanda ke son koyon yadda ake amfani da shi, ginawa da kuma ba da gudummawa ga WordPress. Yana da dandamali mai buɗewa wanda ke ba da kewayon kayan aiki da damar da za ku yi amfani da su a cikin saurin ku kuma a lokacin da ke aiki a gare ku. Har yanzu, sanya hannuna sama. Kuna ganin tsari a nan? Lokacin da mutane suna da ra&#8217;ayoyin da suke da daraja sosai ga wadanda ke kusa da su, ba zan iya ba sai dai in ce eh. Wani ko da yaushe yana da babban ra&#8217;ayi kuma ni zan so in ce eh ga kowa amma ban san yadda zan clone kaina ba tukuna. Ka kula, Michelle Frechette ta gaya mani cloning ba shine abin da nake tsammani ba, ina buƙatar yin ƙarin bincike.</p>\n<h2>Rayuwar da take bani yanzu da dalilin da yasa na zauna</h2>\n<p>Tun da gano WordPress, na kasance wani ɓangare na mai yawa daban-daban ayyuka a cikin Make da cikin al&#8217;umma.</p>\n<p>Ni ɗaya ne daga cikin Wakilan Ƙungiyar horo. Ina samun aiki tare da mutanen da nake so da kuma shiga ciki tsara Koyi. A matsayina na Courtney Robertson, abokina na kwarai kuma ƙwanƙwaran horo Rep, yana cewa:</p>\n<blockquote><p>Muna so mu inganta Ilimi kuma mu sanya Koyi WordPress ya zama na farko tushen tushen albarkatu ga duk wanda ke son farawa ko haɓaka ƙwarewarsa a cikin WordPress.</p></blockquote>\n<p>Ina alfaharin shiga cikin wani aiki wanda ke da yunƙurin ƙugiya, mai tallata tallace-tallace, al&#8217;umma, meta, polyglots, samun dama, ƙira, horo, da <a href=\"https://wordpress.tv/\">WordPress.tv</a> waɗanda ke taimakawa siffa Koyi. Mutane na iya koyo tare da sauran membobin al&#8217;umma, dangane da duniya hanyar sadarwa na masu amfani da WordPress, masu haɓakawa da masu ba da gudummawa. Duba wannan <a href=\"https://make.wordpress.org/training/2021/08/08/who-can-learn-help/\">post akan wanda ya koya zai iya taimakawa</a>, ta Courtney Robertson. Idan kai mai bada horo ne, mai kasuwanci, ko ɗaukar aiki manaja, dubi <a href=\"https://make.wordpress.org/training/2021/05/03/high-level-roadmap-to-learning-wordpress-development/\">babban taswirar hanyarmu don koyon ci gaban WordPress</a>. Shiga mu cikin:</p>\n<ul>\n<li>Ilimi game da WordPress</li>\n<li>Godiya ga ikon WordPress da yadda ake yin shi</li>\n<li>Bikin duk abin da mutane ke yi tare da WordPress</li>\n</ul>\n<p>Zo ku zauna a teburin.</p>\n<p>Ni mai sa kai ne kuma memba na hukumar a kungiyar agaji ta <a href=\"https://www.bigorangeheart.org/\">Big Orange Heart</a> (BOH). Zan iya zama bangare na <a href=\"https://www.wordfest.live\">WordFest</a>, wani taron kan layi na sa&#8217;o&#8217;i 24 na musamman na duniya wanda shine bikin WordPress. BOH ta manufa:</p>\n<blockquote><p>Don tallafawa da haɓaka ingantaccen jin daɗin rayuwa da lafiyar hankali a cikin nesa al&#8217;ummomin aiki.</p></blockquote>\n<p>Ina yin magana da mutane daga kowane fanni na rayuwa, tallafi da kuma taimaka wa al&#8217;ummar da ta damu juna. San iya yin tasiri sosai. Idan ba mu lura da juna ba, wa zai yi?</p>\n<p>Ina jin daɗin samun iyali na duniya, koyo, saduwa da sababbin mutane, haɓaka abokantaka dahadi na rayuwa kuma karin kari shine cewa baya jin kaman aiki. Ina samun zama a bango ina karkata da kafafun kuma in fito lokacin da ake bukata na. Ina jin daɗin wanan aiki.</p>\n<p>Photo by <a href=\"https://www.flickr.com/photos/globallandscapesforum/43847733385\" target=\"_blank\" rel=\"noopener\">Hamza Shaibu</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Nov 2021 08:00:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hauwa Abashiya\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Wowmall: A Free Experimental WooCommerce Block Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125449\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"https://wptavern.com/wowmall-a-free-experimental-woocommerce-block-theme?utm_source=rss&utm_medium=rss&utm_campaign=wowmall-a-free-experimental-woocommerce-block-theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4922:\"<img />\n\n\n\n<p class=\"has-drop-cap\">The Wowmall theme was <a href=\"https://wordpress.org/themes/wowmall/\">released to the public today</a>. It is the second 100% block theme that integrates with WooCommerce to land in the WordPress directory. <a href=\"https://wordpress.org/themes/responsive-fse/\">Responsive FSE</a> was the first.</p>\n\n\n\n<p>Two weeks ago, a reader sent in a question for the Ask the Bartender column. He wanted to know <a href=\"https://wptavern.com/ask-the-bartender-where-are-the-woocommerce-block-themes\">where the WooCommerce block themes were</a>. Literally one day after publishing that post, Wowmall was submitted to the WordPress theme review system. Maybe it was fate or just luck, but I had no choice but to give it a test run.</p>\n\n\n\n<p>The theme adds an admin-side welcome and notice page. The author makes it clear that the project is not currently intended for use on production sites. It is in an experimental state at the moment.  It is unclear who is actually behind the Wowmall project. The associated Twitter account has been suspended, and its other social profiles are devoid of information. And, the <a href=\"https://wowmall.store/\">Wowmall website</a> currently offers scant details.</p>\n\n\n\n<p>I will not pretend that Wowmall is one of my favorite themes. The design is far too busy for my tastes. I prefer something scaled back that focuses on content, but I do not fit into this theme&rsquo;s primary audience.</p>\n\n\n\n<p>For an eCommerce theme, it is much cleaner than others I have seen, and it leverages almost every piece of the block system. It ships over 30 block patterns. Six of those are headers, and another three are footers. However, the rest are for general use in the content, including call-to-action layouts and hero sections.</p>\n\n\n\n<img />A call-to-action pattern.\n\n\n\n<p>It also ships several custom block styles. Some of them offer design variations that make up for things like missing border controls for some blocks. Others, such as the Social Icon&rsquo;s &ldquo;Dark&rdquo; style, would be better left to the existing color options.</p>\n\n\n\n<p>The question most people likely want to be answered is how well it works with WooCommerce. From what I have seen, it works like any other run-of-the-mill WooCommerce theme. You know the look, the default design as seen by 90% of the themes built for the eCommerce plugin. Maybe there is a custom color palette or simple stylistic changes. However, at the end of the day, you know it is a WooCommerce shop.</p>\n\n\n\n<img />Wowmall <a href=\"https://wowmall.store/demo/shop/\">shop page</a>.\n\n\n\n<p>If it works, do not mess with the formula. The most egregious issue I saw with the WooCommerce part of the theme was the output of a comments section on the main Shop page and product category archives. I did not see specific block templates for these pages, so I am taking a wild stab and assuming everything is falling back to a single product or page template that would normally output comments.</p>\n\n\n\n<p>Wowmall does not work well as a pure blogging theme. It handles the basics well enough, but it has far too many characters per line for comfortably reading long-form content. A strict 18px font size, a variable-width content area (989px at full-width on my laptop), and a medium-gray text color make it hard to read anything other than short blurbs.</p>\n\n\n\n<p>However, this theme is not touted as a blogging theme. It is hyper-focused on presenting an online shop.</p>\n\n\n\n<p>Where the theme flexes the most is its selection of block patterns. They are designed primarily for building out a unique storefront. Users can get a lot of mileage out of them.</p>\n\n\n\n<p>The breadcrumb trail in the theme is not really a breadcrumb trail at all. It just masquerades as one. Under the hood, it is a Navigation block with a homepage link followed by the current post/page title. At no point does it show the crumbs (e.g., parent pages) that lead back to the site root. Themes have notoriously offered sub-par breadcrumb navigation in the classic era. Perhaps, developers will leave this to plugin authors in their block themes.</p>\n\n\n\n<p>As far as I know, there are no breadcrumb navigation plugins on WordPress.org to integrate with. However, there is a <a href=\"https://github.com/WordPress/gutenberg/issues/21943\">proposal to add a block</a> for it in core. And, for transparency, I have such a plugin under development and intend to release it on .ORG.</p>\n\n\n\n<p>Wowmall is not claiming this is a finished, production-ready WordPress theme. It is an ongoing project that is expected to improve over time. Plus, we are still waiting for WooCommerce to expand its support of the block system.</p>\n\n\n\n<p>What I like more than anything is seeing theme shops push the envelope with blocks. What I see from Wowmall and recent block themes is that many of the limitations of the past year or so are simply no longer there.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Nov 2021 23:35:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: State of the Word 2021 Will Be Broadcast Live from New York City on December 14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125723\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:223:\"https://wptavern.com/state-of-the-word-2021-will-be-broadcast-live-from-new-york-city-on-december-14?utm_source=rss&utm_medium=rss&utm_campaign=state-of-the-word-2021-will-be-broadcast-live-from-new-york-city-on-december-14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4517:\"<p>WordPress executive director Josepha Haden Chomphosy <a href=\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\">announced</a> today that the 2021 State of the Word will be held on December 14, <a href=\"https://calendar.google.com/calendar/u/0/r/eventedit/copy/XzY0czNjZGhuNjhyNDJiYTE4NTMzMmI5azZ0MmsyYmEyNjBwNGFiYTE2c3IzZ2NhMjhvbzQ0Z3BrNm8gdHVhOWpudTg4ZHRiZnIzNGpzZGI5a3U1bGNAZw\">between 10 am and 12 pm ET/3 pm and 5 pm UTC</a>. For those who are new to the WordPress community, this event is where Matt Mullenweg reviews the milestones and progress of the past year and shares his vision for the open source WordPress project.</p>\n\n\n\n<p>Ordinarily, the State of the Word is delivered as the capstone to WordCamp US in the latter part of the year, with a live Q&amp;A session following the address. This year, <a href=\"https://wptavern.com/wordcamp-us-2021-kicks-off-online-in-48-hours\">WordCamp US was held online</a> in early October and concluded with Haden Chomphosy discussing trends she observed in 2020 and growth opportunities she sees for the WordPress community. In her most recent <a href=\"https://wordpress.org/news/2021/11/episode-20-wordpressblogging/\">podcast</a>, Haden Chomphosy confirmed that the State of the Word 2021 will be an in-person event.</p>\n\n\n\n<p>&ldquo;It&rsquo;s going to join the growing list of in-person events that are on the calendar,&rdquo; she said. &ldquo;It will be in New York City but will also be live-streamed across the world as usual.&rdquo;</p>\n\n\n\n<p>When asked about live event, Haden Chomphosy further clarified that it will be more like a mid-sized meetup. Mullenweg will be delivering the State of the Word at Automattic&rsquo;s New York office with approximately 30 people in-person, which is the capacity for the space.</p>\n\n\n\n<p>&ldquo;We&rsquo;ll start with NYC community folks, but will try to keep the invitation process as open as possible,&rdquo; she said. &ldquo;Vaccinations will be required and more information will be available about that later this week.&rdquo;</p>\n\n\n\n<p>Today&rsquo;s announcement said that attendees and viewers can expect to hear about WordPress 5.9, Openverse (WordPress&rsquo; search engine project for openly-licensed media), and Web3 and non-fungible tokens (NFTs). The last topic drew some early responses on Twitter from those who are keenly interested in Web3 and NFTs, as well as those who don&rsquo;t see any value in the WordPress project promoting or participating in these technologies. As WordPress is <a href=\"https://w3techs.com/technologies/details/cm-wordpress\">closing in on 43% of the web</a>, it will be interesting to see what Mullenweg has to say about what the project&rsquo;s role is in this potentially polarizing issue.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">\'Expect to hear about a range of topics, from WordPress 5.9 and Openverse to Web3 and non-fungible tokens (NFTs).\'<br /><br />All I want to hear about Web3 and NFTs is \'The WP project itself will do nothing to encourage these questionable technologies.\' <a href=\"https://t.co/T3LnU21HuZ\">https://t.co/T3LnU21HuZ</a></p>&mdash; Simon Dickson (@simond) <a href=\"https://twitter.com/simond/status/1459430909325807617?ref_src=twsrc%5Etfw\">November 13, 2021</a></blockquote>\n</div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Annual State of the Word 2021 &ndash; an event to reflect on the WordPress project&rsquo;s progress and the future of open source. Expect to hear about a range of topics including <a href=\"https://twitter.com/hashtag/Web3?src=hash&ref_src=twsrc%5Etfw\">#Web3</a> and non-fungible tokens (<a href=\"https://twitter.com/hashtag/NFTs?src=hash&ref_src=twsrc%5Etfw\">#NFTs</a>). <br /><br />Software powering 42%+ of the entire internet + NFTs. Probably nothing. <a href=\"https://t.co/KfB9UtIBao\">https://t.co/KfB9UtIBao</a></p>&mdash; Brad Williams (@williamsba) <a href=\"https://twitter.com/williamsba/status/1460277517093425152?ref_src=twsrc%5Etfw\">November 15, 2021</a></blockquote>\n</div>\n\n\n\n<p>Viewers will be able participate in the Question &amp; Answer session following the State of the Word by emailing&nbsp;<a href=\"mailto:ask-matt@wordcamp.org\">ask-matt@wordcamp.org</a>, or asking during the event in the livestream chat on YouTube. Add the event to your calendar and watch for the livestream to be embedded on <a href=\"http://wordpress.org/news\">wordpress.org/news</a> on December 14.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Nov 2021 00:49:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WPTavern: “Skins” Are Back in Style, Proposal for Themes To Bundle User-Selectable Design Variations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125725\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"https://wptavern.com/skins-are-back-in-style-proposal-for-themes-to-bundle-user-selectable-design-variations?utm_source=rss&utm_medium=rss&utm_campaign=skins-are-back-in-style-proposal-for-themes-to-bundle-user-selectable-design-variations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4774:\"<img />Twenty Twenty-Two color and font variations.\n\n\n\n<p class=\"has-drop-cap\">A current proposal could spell the death of at least one form of child theming. The feature would allow themes to <a href=\"https://github.com/WordPress/gutenberg/pull/35619\">ship multiple <code>theme.json</code> files</a>, housing variations on a site&rsquo;s default styles. Essentially, it is the old-school concept of &ldquo;skins.&rdquo;</p>\n\n\n\n<p>How the feature would work is not yet defined. However, theme authors would presumably be allowed to bundle separate JSON files that create user-selectable &ldquo;global style variations&rdquo; or &ldquo;active styles&rdquo; via the site editor.</p>\n\n\n\n<p>It is almost as if we have come full circle. The original implementation of child themes allowed developers to create custom <code>style.css</code> files. The goal was to design skins that changed a site&rsquo;s look and feel without changing its markup. Child themes have become much more flexible since then and can overwrite anything from their parents.</p>\n\n\n\n<p>Many themers still build on top of that original concept. Their child themes are nothing more than a custom stylesheet with design modifications. The ability to bundle multiple style variations from a single theme could change how they approach design, perhaps even offering a better user experience.</p>\n\n\n\n<p>Kjell Reigstad first teased this feature last month when <a href=\"https://make.wordpress.org/core/2021/10/06/introducing-twenty-twenty-two/\">announcing the upcoming new default theme</a>. &ldquo;Twenty Twenty-Two will ship with a range of alternate color schemes so that folks can drastically change the appearance of their site,&rdquo; he wrote in the post.  The following is a video of what this concept might look like:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>The UI in the video appears to be a mockup for the site editor. In the right sidebar panel, users can switch between alternate styles and find something that works well for them.</p>\n\n\n\n<p>The proposal would allow for more than color palette variations. Theme authors would be able to adjust typography, layout, and anything else controllable via <code>theme.json</code> &mdash; essentially, the entire theme design.</p>\n\n\n\n<p>Because the feature is not yet in the Gutenberg plugin or in the development version of WordPress, the only way to explore multiple <code>theme.json</code> files is through child theming. Yes, child themes are being used to test the very concept that could make them, at least partially, obsolete. Reigstad has an <a href=\"https://github.com/WordPress/theme-experiments/pull/292\">open pull request</a> in the Theme Experiments repository to flesh out the idea.</p>\n\n\n\n<p>Channing Ritter, an Automattic-sponsored WordPress contributor, <a href=\"https://critterverse.blog/2021/11/10/a-global-styles-switcher/\">shared three variations</a> of what the user experience may look like on her blog. My preferred option is the first. It is a drill-down panel that shows &ldquo;active styles&rdquo; that users can switch between.</p>\n\n\n\n<img />Selecting active theme style from sidebar panel.\n\n\n\n<p>Building an active-style switcher into the global styles interface could offer that ideal user experience that child themes have never achieved. Users had to first understand how they worked, know if any existed for their active theme, install one, and activate it. Under this proposal, they could see all the styles available upfront and simply select one.</p>\n\n\n\n<p>It also gives end-users who are not as design-savvy some variety without forcing them to hand-pick an entire color palette.</p>\n\n\n\n<p>For a while now, I have been imagining a future where theme shops narrow their focus to one, two, or just a handful of core themes. They would then upsell access to support and a library of block patterns. Now, I envision a future where global style variations could play a part in the commercial market, offering value-adds on top of that core product.</p>\n\n\n\n<p>There is also a second ticket that calls for themes to <a href=\"https://github.com/WordPress/gutenberg/issues/36304\">provide alternate color palettes</a>. This would likely be much easier to implement as a separate feature because it is much more scaled back. With only a month to get WordPress 5.9 and Twenty Twenty-Two out of the door with user-selectable color schemes, this may be the more reasonable of the two routes.</p>\n\n\n\n<p>Whatever the case may be, I keep finding new pet features I want to see land in WordPress. Yesterday, it was block patterns. Today, it is &ldquo;active styles,&rdquo; or whatever it gets called. Tomorrow, who knows? New ideas around the block system continue to keep me impatiently awaiting what comes next.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Nov 2021 00:04:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WordPress.org blog: WP Briefing: Episode 20: WordPress=Blogging+\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=11556\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/news/2021/11/episode-20-wordpressblogging/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10273:\"<p>In this episode, WordPress&#8217;s Executive Director, Josepha Haden Chomphosy, answers two recently asked questions. Tune in to hear what those questions were and her response, in addition to this week&#8217;s small list of big things.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2 id=\"references\">References </h2>\n\n\n\n<ul><li><a href=\"https://w3techs.com/technologies/details/cm-wordpress\">W3Techs WordPress Usage Statistics </a></li><li><a href=\"https://make.wordpress.org/core/5-9/\">WordPress 5.9 Development Cycle </a></li><li><a href=\"https://make.wordpress.org/updates/2021/10/22/team-rep-nominations/\">Call for Team Rep Nomination</a></li></ul>\n\n\n\n<h2 id=\"transcript\">Transcript</h2>\n\n\n\n<span id=\"more-11556\"></span>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:10</p>\n\n\n\n<p>Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:40</p>\n\n\n\n<p>So I was in a meeting recently, which I realize isn&#8217;t saying much for me since I spend a quarter of my time in meetings. But in this particular meeting, I was asked a couple of questions that I absolutely loved. The first question was, “if there were one thing you could change in people&#8217;s minds about WordPress, what would it be?” And my answer, predictable though it may be, was that I want to change the idea that WordPress is just a blogging platform.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:06</p>\n\n\n\n<p>WordPress has grown into a lot more than that. But the idea of a content management system, even now, sometimes gets a mental shorthand where content is a stand-in for the word writing or words. If you&#8217;re using WordPress today in an enterprise context, or as part of a governmental agency, or if you use it in a classroom setting, you know that your content cannot be confined that way. And if you&#8217;re supporting or building anything to hand off to clients, you know that timely, easy-to-ship changes on a site are considered a vital part of any overarching brand and marketing strategy. And when was the last time that any marketing strategy was literally only about the words?&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:51</p>\n\n\n\n<p>So that was the first question. And also my first answer. There is also this kind of annual, not fear, necessarily, but this annual question that is sort of related that is raised to me and has been asked of me recently, that I&#8217;m just going to give you a small answer to. One annual worry that I get every year around November and December is, &#8220;What are we going to do about the fact that the term blog and blogging are declining in search popularity?&#8221; And I was gonna say it&#8217;s been a while since I answered that in any sort of public format. But I think maybe I&#8217;ve never answered it in a public format at all. And so I&#8217;m just going to answer it here. Because I think maybe a lot of people have that same question.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>02:36</p>\n\n\n\n<p>So number one, I think that the way that people search now is different. There&#8217;s a lot more semantic cognition. This is not the way to answer this &#8212;  search engines are smarter now. So like, it used to be the case with early search engines that yeah, there was a lot of just like, individual search terms that were looked for. But now, people are asking full questions; they have, essentially, an entire sentence that they are searching for. And then, search engines are able to parse that information better and get more high-quality answers and information for them. So like, that&#8217;s one thing that I&#8217;m already not worried about. If people are searching for individual words anymore, it&#8217;s so that they can get a definition of that word. So I&#8217;m not specifically worried about a decline in search volume for the word blog or blogging for that reason. But the answer to my first question, if there is probably the real reason that I&#8217;m not actually super worried about any decline in search volume for the word blog, or blogging, is that WordPress has really moved beyond that. And since we have moved beyond that, then it doesn&#8217;t necessarily make sense for WordPress as an entity for WordPress as a project to get overly hung up on the idea that the term blog has gone out of fashion.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:52</p>\n\n\n\n<p>Okay, now that I did my first question, and the answer, and then an additional question that only ever gets asked in private and is being answered by me for the first time in public, I will tell you now, the second question that I loved, someone asking of me, and that question is this: &#8220;What is one thing you&#8217;d like people to see or experience, right when they first land on wordpress.org?&#8221; Now, I often don&#8217;t get asked questions about the wordpress.org website, like administrative tasks, things that we need to update, move around where they should go. Sure. But like, “Josepha, what&#8217;s the point and purpose of this site?” Never. I&#8217;ve never been asked that, and so I was really excited that someone asked me, and I&#8217;m going to give you a heads up. I think some of you might disagree with my answer.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>04:40</p>\n\n\n\n<p>So the primary thing that I want people to see or experience when they first get to wordpress.org, the website is the depth of WordPress. Not which audience segment they should belong to or that we believe they should belong to or raw data about the CMS or even how much we care about the freedoms of open source. Now the first thing I want people to see on that site is that WordPress has not only 18 years of learned knowledge that every single new user benefits from, but that it also has 1,000s of really smart people making sure it works and gets better every day, now.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:19</p>\n\n\n\n<p>WordPress is a Goliath in its field. I know that we cite this bit of context. Frequently, we say that we are 42% of the web. And that is true that is the percentage by usage. But in its field, which is websites that are using a content management system, we actually have a 65% market share. This is very easy to find. It&#8217;s on the W3Techs website: I can put a link in the show notes, but you could find it just by searching for it.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:46</p>\n\n\n\n<p>So WordPress is a Goliath in its field of websites that are run using a CMS. Because we have always brought our learnings forward with us with the understanding that knowledge, when shared grows rather than diminishes. But open source, the heart of what defines this project, open source is not a Goliath; it&#8217;s barely even David somedays. Even though the web is built on scads of open source software, there&#8217;s a pervasive public perception that it is built by and for hobbyists or that it is inherently risky, and that if there were if it were worth something, then people would pay something. And I just know that if the first impression of WordPress, we&#8217;re, &#8220;we&#8217;ve got 18 years of experience and learning that brought us to today,&#8221; the rest of the sale to adopt software that protects other people&#8217;s freedoms would take care of itself. And I guess, to quote John Oliver, at this point, &#8220;And now this.&#8221;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:59</p>\n\n\n\n<p>Alright, that brings us now to our small list of big things. There are actually quite a few big things on this small list today. So number one, we have reached the beta phase for the year&#8217;s final release, which means that WordPress 5.9 beta one is happening tomorrow, Tuesday, November 16. And then seven days later, I believe on the 23rd, if I recall correctly, comes beta two.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:24</p>\n\n\n\n<p>The second thing on my list is that team rep nominations are happening all over the project right now. I&#8217;ve got a post that I will share in the notes below that I believe all the team reps have put their team&#8217;s nomination posts on. So if you have had an interest in learning more about that and what it means to help keep teams kind of running in the WordPress project, then this is a great opportunity to check those out.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>07:49</p>\n\n\n\n<p>And the third thing, this last thing actually isn&#8217;t in the next two weeks, but it is very important, nonetheless. Matt&#8217;s annual State of the Word is coming up on December 14. So basically a month from today. It&#8217;s going to join the growing list of in-person events that are on the calendar. It will be in New York City but will also be live-streamed across the world as usual. Keep an eye out for additional updates about that for anyone who, like me, really looks forward to this particular presentation from our project co-founder every year.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:25</p>\n\n\n\n<p>And that is your small list of big things. Thank you for tuning in today for the WordPress briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Nov 2021 17:15:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: Gutenberg 11.9 Focuses on Navigation Menus and Block Theming\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125689\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:185:\"https://wptavern.com/gutenberg-11-9-focuses-on-navigation-menus-and-block-theming?utm_source=rss&utm_medium=rss&utm_campaign=gutenberg-11-9-focuses-on-navigation-menus-and-block-theming\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9521:\"<p class=\"has-drop-cap\">Gutenberg 11.9 <a href=\"https://make.wordpress.org/core/2021/11/12/whats-new-in-gutenberg-11-9-0-10-november/\">landed on Wednesday</a>, and it is packed with dozens of enhancements. Contributors are speeding forward, getting in some of the final features before the release of WordPress 5.9, expected on December 14.</p>\n\n\n\n<p>Version 11.9 is the last plugin release to include new features for the upcoming WordPress update. Bug fixes will continue to be ported over in the coming weeks.</p>\n\n\n\n<p>Site editing and theme-related blocks take up most of the spotlight. WordPress 5.9 will ship with its first default block theme, <a href=\"https://wptavern.com/first-look-at-wordpress-upcoming-twenty-twenty-two-default-theme-the-most-flexible-default-theme-ever-created-for-wordpress\">Twenty Twenty-Two</a>. For many users, this will be their first experience with template editing and global styles.</p>\n\n\n\n<p>The Navigation block received a lot of attention, and rightly so. Developers solved some vital data portability issues and created a more well-rounded user experience.</p>\n\n\n\n<p>There is still a lot of room for improvement on the whole, but Gutenberg has come a long way in the past few months. I am excited about what the new features will look like once they land in the general WordPress release.</p>\n\n\n\n<h2 id=\"site-editor-scaled-back-its-menu-moved-and-renamed\">Site Editor Scaled Back, Its Menu Moved and Renamed</h2>\n\n\n\n<img />Site editor with Twenty Twenty-Two active.\n\n\n\n<p class=\"has-drop-cap\">The site editor has been scaled back to the point where it is no longer the feature that Gutenberg plugin users have grown accustomed to in these last few months. It is essentially a pathway to the global styles feature.</p>\n\n\n\n<p>When it comes to templates, only the site&rsquo;s homepage is accessible through the interface. Clicking the &ldquo;W&rdquo; icon in the top left of the editor <a href=\"https://github.com/WordPress/gutenberg/pull/36194\">no longer opens the familiar templates panel</a>, which formerly allowed users to navigate, select, and customize individual templates.</p>\n\n\n\n<p>Clicking the &ldquo;Browse All Templates&rdquo; button carts users away from the site editor to a templates screen. It looks like a posts list and includes no instructions on how to, for example, overwrite an author archive or other theme templates. I know the system well enough to understand what is happening, but I can only imagine this would be shocking for the average user.</p>\n\n\n\n<p>Users can jump to the Header and Footer areas in the site editor by clicking those in the dropdown. The editor simply focuses on those template parts without switching screens.</p>\n\n\n\n<p>However, I see no way of editing specific templates from within the site editor.  The result is a watered-down index template editor with global styles, the one redeeming feature.</p>\n\n\n\n<p>The site editor menu item has also now been <a href=\"https://github.com/WordPress/gutenberg/issues/29630\">moved beneath the Appearance menu</a> in the WordPress admin. It is now simply named &ldquo;Editor.&rdquo; Of course, the &ldquo;Theme Editor&rdquo; submenu is still there.</p>\n\n\n\n<img />Two types of Appearance editors.\n\n\n\n<p><em>I do not expect this to be confusing to users at all&hellip;</em></p>\n\n\n\n<p>Sarcasm aside, this is the appropriate place for the new site editor, which will only appear if a user has a block theme active. However, the two submenu names clearly conflict. Could there be a better place to move the Theme Editor? One proposal would see it <a href=\"https://github.com/WordPress/gutenberg/issues/36354\">dropped under Tools</a> in the admin menu.</p>\n\n\n\n<p>One must wonder how much use there will be for directly editing theme files in a block world. Templates can be overwritten via the UI. <code>theme.json</code> settings are handled through the global styles interface. That mostly just leaves <code>functions.php</code> as the lone holdout. It might just be time to disable file editing by default in WordPress, at least for block themes.</p>\n\n\n\n<h2 id=\"pattern-explorer\">Pattern Explorer</h2>\n\n\n\n<img />Block pattern explorer.\n\n\n\n<p class=\"has-drop-cap\">Users on desktops and tablets can now enjoy a <a href=\"https://github.com/WordPress/gutenberg/pull/35773\">full-screen pattern overlay</a>. Instead of endlessly scrolling through dozens or even hundreds of patterns in the narrow inserter, they can click a new &ldquo;Explore&rdquo; button to <em>explore</em> patterns in an interface with a bit more breathing room.</p>\n\n\n\n<p>I covered this new feature in a full <a href=\"https://wptavern.com/block-pattern-modal-explorer-coming-to-wordpress-5-9\">review earlier this week</a>. There are still a few kinks to work out with the design, but it works well thus far. It also lays the groundwork for a more extensive set of features down the line.</p>\n\n\n\n<h2 id=\"navigation-data-saving-and-navigation-area-block\">Navigation Data Saving and Navigation Area Block</h2>\n\n\n\n<p class=\"has-drop-cap\">Navigation block <a href=\"https://github.com/WordPress/gutenberg/pull/35746\">data is now stored</a> in a dedicated <code>wp_navigation</code> post type. By saving it separately, contributors have now corrected one of the longstanding issues with block-based nav menus: portability.</p>\n\n\n\n<p>In previous iterations of the block, users lost their carefully-crafted menus whenever they switched to a new block theme. They would have to recreate content that typically does not change often.</p>\n\n\n\n<p>Alongside this improvement is a new <a href=\"https://github.com/WordPress/gutenberg/pull/36178\">Navigation Area block</a>, which serves as a wrapper for Navigation. Theme authors will be able to define custom areas in their block theme templates with the following code:</p>\n\n\n\n<pre class=\"wp-block-code\"><code>&lt;!-- wp:navigation-area {\"area\":\"primary\"} --&gt;\n&lt;!-- wp:navigation /--&gt;\n&lt;!-- /wp:navigation-area --&gt;</code></pre>\n\n\n\n<p>The nested Navigation block is associated with a <code>wp_navigation</code> <em>post</em>. This will be the preferred format for theme authors going forward.</p>\n\n\n\n<p>When a user switches themes and the &ldquo;area&rdquo; name matches their previous theme, the menu simply carries over and automatically appears. If they do not match, the user can assign a saved menu. The menu/area relationship is stored in the database.</p>\n\n\n\n<p>One of the issues with the Navigation Area block is that it has no alignment controls. Technically, it does not output any HTML itself. However, its existence in the editor prohibits a user from selecting wide or full alignment for its inner Navigation block.</p>\n\n\n\n<h2 id=\"duotone-filter-transparency\">Duotone Filter Transparency</h2>\n\n\n\n<p class=\"has-drop-cap\">Duotone filters on blocks such as Image and Cover <a href=\"https://github.com/WordPress/gutenberg/pull/34130\">now support transparency</a>. Users will now see a slider control beneath the color picker when adjusting either shadows or highlights.</p>\n\n\n\n<p>The feature opens the door for a double exposure effect or image mask by layering an Image block over a Cover. Alex Lende showed a few examples of how this could work in the ticket.</p>\n\n\n\n<img />Image with transparent duotone layered over Cover block.\n\n\n\n<p>Developers also noted possibilities for a tritone option and <a href=\"https://github.com/WordPress/gutenberg/pull/35359\">other filter types</a>.</p>\n\n\n\n<h2 id=\"api-for-accessing-global-styles\">API For Accessing Global Styles</h2>\n\n\n\n<p class=\"has-drop-cap\">Theme and plugin authors should have fun with this new <a href=\"https://github.com/WordPress/gutenberg/pull/34843\">API for interacting</a> with the global styles system. Previously, developers had to use the <code>WP_Theme_JSON_Resolver</code> class to pull data that they needed on the server side. Now, they have three new functions:</p>\n\n\n\n<ul><li><code>gutenberg_get_global_settings()</code> &ndash; Returns settings.</li><li><code>gutenberg_get_global_styles()</code> &ndash; Returns style settings.</li><li><code>gutenberg_get_global_stylesheet()</code> &ndash; Returns the global stylesheet.</li></ul>\n\n\n\n<p>Presumably, these functions will be renamed before landing in WordPress 5.9 and not have the <code>gutenberg_</code> prefix. Theme authors should wrap any usage of these in <code>function_exist()</code> checks to be on the safe side.</p>\n\n\n\n<h2 id=\"new-comment-blocks\">New Comment Blocks</h2>\n\n\n\n<p class=\"has-drop-cap\">Several new comment blocks have landed in the latest plugin update. The <a href=\"https://github.com/WordPress/gutenberg/pull/35231\">Comments Query Loop and Comment Template</a> blocks work similarly to their post counterparts. However, the current result is a bare-bones feature that is not ready for production use. Nested comments are not shown, and there are not many options for customizing the output.</p>\n\n\n\n<p>It is a step toward block theme authors and users (via the site editor) controlling post comments output. Gutenberg 11.9 also includes new comment helper blocks that will be necessary for templating:</p>\n\n\n\n<ul><li><a href=\"https://github.com/WordPress/gutenberg/pull/35774\">Comment Reply Link</a></li><li><a href=\"https://github.com/WordPress/gutenberg/pull/35965\">Comment Link</a></li><li><a href=\"https://github.com/WordPress/gutenberg/pull/35396\">Comment Avatar</a></li></ul>\n\n\n\n<p>For a while, comments have felt like an afterthought. Any movement toward rounding out these missing theme-related blocks is welcome.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 13 Nov 2021 01:34:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WordPress.org blog: State of the Word 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11567\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4429:\"<div class=\"wp-block-image\"><img width=\"632\" height=\"430\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/11/SOTW-Post-e1636763589410-1024x696.png?resize=632%2C430&ssl=1\" alt=\"State of the Word 2021\" class=\"wp-image-11568\" />State of the Word 2021 is happening on Dec 14!</div>\n\n\n\n<p>Howdy, World!&nbsp;</p>\n\n\n\n<p><a href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2021+livestream&dates=20211214T220000Z/20211215T000000Z&details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%27s+co-founder,+Matt+Mullenweg.%0AJoin+Matt+as+he+provides+a+retrospective+of+2021,+celebrates+the+community%27s+amazing+wins,+discusses+the+latest+trends+he%27s+seeing,+and+explores+the+future+of+open+source.%0AState+of+the+Word+will+be+live+streamed+from+New+York+City,+and+is+free+for+all+to+watch.%0Ahttps://wordpress.org/news/2021/11/state-of-the-word-2021/\">Mark your calendars</a>; it’s almost time for State of the Word 2021!</p>\n\n\n\n<p>State of the Word is the annual keynote address delivered by the WordPress project’s co-founder, Matt Mullenweg. Every year, the event allows us to reflect on the project’s progress and the future of open source. This year will include that and more.</p>\n\n\n\n<p>Due to the pandemic, we moved the State of the World online for the first time ever in 2020. This year, the event will be livestreamed from New York City. That will enable us to take as many folks as possible along for the ride!</p>\n\n\n\n<p>Join Matt as he provides a retrospective of 2021, discusses the latest trends he’s seeing, celebrates the community’s amazing wins, and explores the future. Expect to hear about a range of topics, from WordPress 5.9 and Openverse to Web3 and non-fungible tokens (NFTs).</p>\n\n\n\n<p><strong>What:</strong> State of the Word 2021</p>\n\n\n\n<p><strong>When:</strong> <a href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2021+livestream&dates=20211214T220000Z/20211215T000000Z&details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%27s+co-founder,+Matt+Mullenweg.%0AJoin+Matt+as+he+provides+a+retrospective+of+2021,+celebrates+the+community%27s+amazing+wins,+discusses+the+latest+trends+he%27s+seeing,+and+explores+the+future+of+open+source.%0AState+of+the+Word+will+be+live+streamed+from+New+York+City,+and+is+free+for+all+to+watch.%0Ahttps://wordpress.org/news/2021/11/state-of-the-word-2021/\">December 14, 2021, between 5 and 7 pm ET/10 &#8211; 12 am (December 15) UTC</a></p>\n\n\n\n<p><strong>How:</strong> If you’re watching from the comfort of your home or <a href=\"https://wordpress.org/news/2021/11/watch-state-of-the-word-at-a-watch-party-with-your-wordpress-friends/\">local watch party</a>, the livestream will be embedded on wordpress.org/news.</p>\n\n\n\n<p><strong>Have a question for Matt?</strong></p>\n\n\n\n<p>State of the Word will be followed by a Question &amp; Answer session. If you want to participate, you can either send your question ahead of time to <a href=\"mailto:ask-matt@wordcamp.org\">ask-matt@wordcamp.org</a>, or ask during the event in the livestream chat on YouTube.</p>\n\n\n\n<p>If you’re new to State of the Word, the previous years’ recordings (below) will help you get a sense of what the event is about. Check them out:</p>\n\n\n\n<ul><li><a href=\"https://wordpress.org/news/2020/12/state-of-the-word-2020/\">State of the Word 2020 (online)</a></li><li><a href=\"https://wordpress.tv/2019/11/03/2019-state-of-the-word/\">State of the Word 2019 – WordCamp US, St. Louis</a></li><li><a href=\"https://wordpress.tv/2018/12/27/state-of-the-word-2018/\">State of the Word 2018 – WordCamp US, Nashville</a></li><li><a href=\"https://wordpress.tv/tag/state-of-the-word/\">All recordings</a></li></ul>\n\n\n\n<p>We hope to see you online on December 14th!</p>\n\n\n\n<p><em>Thanks to <a href=\"https://profiles.wordpress.org/anjanavasan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>anjanavasan</a> <a href=\"https://profiles.wordpress.org/eidolonnight/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>eidolonnight</a> <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a> for their work on this post. The featured image was created by <a href=\"https://profiles.wordpress.org/beafialho/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>beafialho</a></em>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 13 Nov 2021 00:38:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: GoDaddy Acquires Pagely to Deploy New WooCommerce SaaS Product\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125660\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:189:\"https://wptavern.com/godaddy-acquires-pagely-to-deploy-new-woocommerce-saas-product?utm_source=rss&utm_medium=rss&utm_campaign=godaddy-acquires-pagely-to-deploy-new-woocommerce-saas-product\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3259:\"<p>GoDaddy has <a href=\"https://aboutus.godaddy.net/newsroom/press-releases/press-release-details/2021/Pagely-joins-GoDaddy/default.aspx\">acquired</a> managed WordPress hosting company Pagely to expand the company&rsquo;s expertise in hosting WooCommerce stores. Pagely, co-founded by Joshua and Sally Strebel, has been in business for 18 years, offering hosting for businesses and enterprises at the higher end of the managed hosting market.</p>\n\n\n\n<p>&ldquo;We will be working closely with the amazing team of WooCommerce experts from SkyVerge (previous GoDaddy acquisition) on the GoDaddy commerce team to deploy a world-class WooCommerce SaaS aimed at powersellers,&rdquo; Pagely co-founder and CEO Joshua Strebel said in a post titled &ldquo;<a href=\"https://pagely.com/blog/we-did-it/\">We Did It</a>.&rdquo;</p>\n\n\n\n<p>Strebel said Pagely received more than a dozen offers to buy the company over the years and was given the &ldquo;choice of every suitor in the space.&rdquo; This particular offer was the third from GoDaddy.</p>\n\n\n\n<p>&ldquo;We poured our heart and soul into Pagely, and PressNomics, and the market responded,&rdquo; Strebel said. &ldquo;First, shown by our own success and then that of all the followers that came along after.&nbsp;We built a company with industry-leading&nbsp;<em>everything &ndash;&nbsp;</em>that our employees and customers love and respect, and despite our diminutive size in comparison to the VC fueled giants, those same entities could not ignore us. And that pushed the entire channel to improve and do better, benefiting every WordPress user on the planet.&rdquo;</p>\n\n\n\n<p>The companies did not disclose the terms of the deal. I spoke with both Pagely and GoDaddy representatives who would not elaborate on how the new WooCommerce Saas will be different from GoDaddy&rsquo;s current WordPress e-commerce hosting offering. WooCommerce stores at GoDaddy start at $15.99/month and include 75 extensions and daily back-ups, among other features. </p>\n\n\n\n<p>During an <a href=\"https://www.youtube.com/watch?v=2uE2s3Of_AU\">interview</a> with Post Status last night, GoDaddy product manager Beka Rice said Pagely will be involved in deploying the new WooCommerce product, which she described as a &ldquo;curated experience&rdquo; for merchants. GoDaddy will be relying on Pagely&rsquo;s infrastructure expertise to improve the company&rsquo;s ability to keep WooCommerce stores running smoothly. </p>\n\n\n\n<p>When asked about a potential launch date for the new WooCommerce SaaS product, Rice said the project is still in the the planning stages. They have identified the teams and are interested in learning more about scaling WooCommerce from Pagely&rsquo;s enterprise customers.</p>\n\n\n\n<p>Pagely co-founder and COO Sally Strebel confirmed that the company will continue sponsoring and hosting its annual Pressnomics conference, which has held six events since it began.</p>\n\n\n\n<p>&ldquo;Our beloved conference,&nbsp;<a rel=\"noreferrer noopener\" href=\"https://pressnomics.com/\" target=\"_blank\">Pressnomics</a>, may look a little different going forward, and will remain a Pagely hosted event with the same mission as always: to elevate and connect business owners in the WordPress ecosystem,&rdquo; Strebel said.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 12 Nov 2021 19:29:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1: